
local FarmRestock = select(2, ...)
AceGUI = LibStub("AceGUI-3.0")


-- frames
local FRV4 = CreateFrame("Frame")
FRV4:RegisterEvent("VARIABLES_LOADED")
FRV4:Hide()

local f = AceGUI:Create("Frame")
f:Hide()



-- Variables
local miningReagents = {2770,2771,2772,2775,2776,3858,7911,10620,11370,12363,12360,17771,
23424,23425,23426,23427,23448,23573,35128,
36909,36910,36912,37663,
53038,52183,52185,53039,58480,
72092,72094,72103,72095,
109118,109119,
123918,123919,124461,
152512,152579,152513,168185,
171828,171829,171830,171831,171832,171833,187700}
local miningReagentsQph = {300,250,400,55,55,350,55,400,100,10,12,2,
200,100,5,20,5,20,1,
200,25,300,5,
200,20,150,10,5,
500,5,5,1,
250,250,
300,120,75,
200,120,20,200,
300,150,150,150,150,50,100}
	
local miningReagentsDF = {190395,190396,190394,189143,188658,190311,190312,190313,190314}
local miningReagentsDFQph = {100,100,100,25,25,25,10,10,10}
local qualityMiningReagentsDF= {1,2,3,1,2,3,1,2,3}
local plantsReagents = {765,785,2447,2449,2450,2452,2453,3355,3356,3357,3358,3369,3818,3819,3820,3821,4625,8153,8831,8838,8839,8845,8846,13463,13464,13465,13466,13467,13468,
22785,22786,22787,22788,22789,22790,22791,22792,22793,22794,
36901,36903,36904,36905,36906,36907,36908,37921,
52983,52984,52985,52986,52987,52988,
72234,72235,72237,72238,79010,79011,
109124,109125,109126,109127,109128,109129,
124101,124102,124103,124104,124105,124106,128304,151565,
152505,152506,152507,152508,152509,152510,152511,168487,
168583,168586,168589,169701,170554,171315,187699,
197755}
local plantsReagentsQph = {100,100,200,100,300,100,250,120,300,300,300,20,225,220,50,100,225,3,100,200,100,150,250,300,225,150,200,150,1,
100,100,50,100,150,150,200,150,75,10,
50,300,50,50,100,25,15,10,
200,250,250,250,150,150,
300,300,300,25,300,300,
220,150,200,150,150,150,
250,250,250,250,100,1,350,250,
100,150,250,250,250,50,250,250,
200,200,200,200,200,30,100,
100}
local plantsReagentsDF = {191460,191461,191462,191467,191468,191469,191464,191465,191466,191470,191471,191472}
local qualityPlantsReagentsDF ={1,2,3,1,2,3,1,2,3,1,2,3,1,2,3}
local plantsReagentsDFQph = {100,100,100,15,15,15,30,30,30,15,15,15}


local skinReagents = {783,2318,2319,4231,4232,4233,4234,4235,4236,4304,4461,5784,5785,6470,6471,7286,7392,8154,8165,8167,8169,8170,8171,8172,15407,15408,15410,15412,15414,15415,15416,15417,15419,17012,19767,19768,
21887,23793,25699,25700,25707,25708,29539,29547,29548,
33568,38425,38557,38558,38561,44128,
52976,52979,52980,52982,56516,
72120,72163,79101,
110609,
124113,124115,124116,151566,
152541,152542,153050,153051,154164,154165,154722,168649,168650,
172089,172094,172096,172097,187701,
193251,193252,193253,193254,193255,193256}

local skinReagentsQph = {10,200,200,10,10,10,200,10,10,250,50,50,50,50,50,50,50,250,20,300,10,250,10,10,10,50,3,10,3,1,25,100,40,10,30,20,
250,25,50,50,100,100,15,50,50,
300,30,100,100,100,5,
250,150,10,150,25,
300,10,150,
500,
500,500,10,250,
500,25,500,500,500,150,150,500,500,
500,50,25,5,150,
30,50,150,30,30,10}

local skinReagentsDF = {193208,193210,193211,193213,193214,193215,193216,193217,193218,193222,193223,193224}
local qualitySkinReagentsDF = {1,2,3,1,2,3,1,2,3,1,2,3}
local skinReagentsDFQph = {200,200,200,200,200,200,10,10,10,10,10,10}
				
local elemReagents = {7067,7068,7069,7070,7075,7076,7077,7078,7079,7080,7081,7082,12803,
21884,21885,21886,22451,22452,22456,22457,22572,22573,22574,22575,22576,22577,22578,
35622,35623,35624,35625,35627,36860,37700,37701,37702,37703,37704,37705,
52325,52326,52327,52328,52329,
76061,89112,
113261,113262,113263,113264,
187707,
190322,190324,190326,190327,190328,190329,190330,190331}

local elemReagentsQph = {45,45,45,45,15,15,15,15,15,45,30,20,30,
15,20,15,15,10,25,45,150,150,150,150,450,250,200,
35,20,20,35,20,20,200,150,200,200,350,350,
150,150,150,150,150,
10,100,
100,100,100,100,
10,
100,10,100,10,100,10,100,10}

function maxSizeToUse()
	local fb = (getn(plantsReagents) + getn(plantsReagentsDF))
	if(getn(miningReagents) + getn(miningReagentsDF)) > fb then
		fb = (getn(miningReagents) + getn(miningReagentsDF))
	end
	if(getn(skinReagents) + getn(skinReagentsDF)) > fb then
		fb = (getn(skinReagents) + getn(skinReagentsDF))
	end
	if(getn(elemReagents) > fb) then
		fb = getn(elemReagents)
	end
	return fb
end


local totalSizeOfReagent = maxSizeToUse()

itemToPrint = {}
valueToPrint = {}
stockToPrint = {}
gphToPrint = {}
timeToPrint = {}
for i=1, totalSizeOfReagent do
	itemToPrint[i] = AceGUI:Create("InteractiveLabel")
	valueToPrint[i] = AceGUI:Create("Label")
	stockToPrint[i] = AceGUI:Create("Label")
	gphToPrint[i] = AceGUI:Create("Label")
	timeToPrint[i] = AceGUI:Create("Label")
end
local open=false
local alop=false
local farmedSessionMining = {}
local farmedSessionMiningDF = {}
local farmedSessionPlants = {}
local farmedSessionPlantsDF ={}
local farmedSessionSkin = {}
local farmedSessionSkinDF ={}
local farmedSessionElem ={}
 
-- EVENTS
FRV4:SetScript("OnEvent",
	function(self, event, ...)
		if event == "VARIABLES_LOADED" then
			FarmRestock:Initialize()
			for i=1,getn(miningReagents)  do
				farmedSessionMining[i] = GetQuantity(miningReagents[i])
			end
			for i=1,getn(miningReagentsDF) do 				
				farmedSessionMiningDF[i] = GetQuantity(miningReagentsDF[i])
			end
			for i=1,getn(plantsReagents)  do
				farmedSessionPlants[i] = GetQuantity(plantsReagents[i])
			end
			for i=1,getn(plantsReagentsDF)  do
				farmedSessionPlantsDF[i] = GetQuantity(plantsReagentsDF[i])
			end
			for i=1,getn(skinReagents)  do
				farmedSessionSkin[i] = GetQuantity(skinReagents[i])
			end
			for i=1,getn(skinReagentsDF)  do
				farmedSessionSkinDF[i] = GetQuantity(skinReagentsDF[i])
			end
			for i=1,getn(elemReagents)  do
				farmedSessionElem[i] = GetQuantity(elemReagents[i])
			end
		end
	end
)
function FarmRestock.Initialize()
		if not FarmRestockV4Config then
		FarmRestockV4Config = {
			prixMini = 5,
			gphMini= 1000,
			quantiteMax = 10000,
			rarityEnabled = false,
			craftCostEnabled = false,
			rarityIndex=false,
			priceSource = "dbhistorical",
			stockGoal = "dbregionsoldperday",
			timeGoal=10,
			quantityFarmed={},
			listCustom={},
			choiceMinPrice = 1,
			choiceGoal = 1;
			}
		end
end



SLASH_FARMRESTOCK1 = "/fr"

SlashCmdList["FARMRESTOCK"] = function(msg)
	if msg=="" and open==false and alop==false then
		open=true
		alop=true
	 	FarmRestock:CreateFrameFarmRestock()
	elseif msg=="" and open==false and alop==true then
		open=true
		f:Show()
	end
end

-- TSM FUNCTIONS

function GetItemPrice(item)
local itemId = type(item) == "number" and "i:" .. item or item
	return TSM_API.GetCustomPriceValue(tostring(GetPriceSouce()), "i:" .. tostring(item))
end


function GetItemQuantityToStock(item)
   return TSM_API.GetCustomPriceValue(tostring(GetStockGoal()), "i:" .. tostring(item))
end

function GetItemName(item)
    local id = type(item) == "number" and "i:" .. item or item

   return TSM_API.GetItemName(id)
end

function GetQuantity(item)
	local u,d,t,q= TSM_API.GetPlayerTotals("i:" .. tostring(item))

	local tt=u+d+t+q;
	if(t==q) then
		tt=u+d+t
	end
	
	return tt
end	




function FarmRestock.CreateFrameFarmRestock()

		f:SetTitle("FarmRestockV4")
		f:SetCallback("OnClose", function(widget)open=false;f:Hide(); end)
		f:SetLayout("Fill")
		f:SetHeight(550)
		f:SetWidth(750)
		f:EnableResize(false)
			
		leftMenu = AceGUI:Create("InlineGroup")
		leftMenu:SetWidth(120)
		leftMenu:SetHeight(550)
		leftMenu:SetLayout("List")

		local restockMining = AceGUI:Create("Button")
		restockMining:SetText("Mining")
		restockMining:SetWidth(100)
		restockMining:SetCallback("OnClick", function() FarmRestock:showMining(); end)


		leftMenu:AddChild(restockMining)

		local restockHerbal = AceGUI:Create("Button")
		restockHerbal:SetText("Gathering")
		restockHerbal:SetWidth(100)
		restockHerbal:SetCallback("OnClick", function() FarmRestock:showHerbal(); end)

		leftMenu:AddChild(restockHerbal)

		local restockSkinning = AceGUI:Create("Button")
		restockSkinning:SetText("Skinning")
		restockSkinning:SetWidth(100)
		restockSkinning:SetCallback("OnClick", function() FarmRestock:showSkinning(); end)

		leftMenu:AddChild(restockSkinning)

		local restockElem = AceGUI:Create("Button")
		restockElem:SetText("Elements")
		restockElem:SetWidth(100)
		restockElem:SetCallback("OnClick", function() FarmRestock:showElem(); end)

		leftMenu:AddChild(restockElem)
		
		
		local options = AceGUI:Create("Button")
		options:SetText("Options")
		options:SetWidth(100)
		options:SetCallback("OnClick", function() FarmRestock:openOpt(); end)

		leftMenu:AddChild(options)
		

		f:AddChild(leftMenu)
		
		topListing = AceGUI:Create("InlineGroup")
		topListing:SetLayout("Flow")
		topListing:SetWidth(600)
		
		topListingName =AceGUI:Create("InteractiveLabel")
		topListingName:SetWidth(175)
		topListingName:SetText("Name")
		topListingStock =AceGUI:Create("InteractiveLabel")
		topListingStock:SetWidth(100)
		topListingStock:SetText("Stock")
		topListingValue =AceGUI:Create("InteractiveLabel")
		topListingValue:SetWidth(75)
		topListingValue:SetText("Value")
		topListingGPH =AceGUI:Create("InteractiveLabel")
		topListingGPH:SetWidth(50)
		topListingGPH:SetText("GPH")
		topListingTime =AceGUI:Create("InteractiveLabel")
		topListingTime:SetWidth(50)
		topListingTime:SetText("Time")
		
		topListing:AddChild(topListingName)
		topListing:AddChild(topListingStock)
		topListing:AddChild(topListingValue)
		topListing:AddChild(topListingGPH)
		topListing:AddChild(topListingTime)
		
		f:AddChild(topListing)
		topListing:SetPoint("TOPRIGHT")
					
		mainShowPanel = AceGUI:Create("ScrollFrame")		
		
		InteractiveShowPanel = AceGUI:Create("SimpleGroup")
		InteractiveShowPanel:SetLayout("List")
		InteractiveShowPanel:SetWidth(175)		
		InteractiveShowPanel:SetFullHeight(false)
		
		stockBlock = AceGUI:Create("SimpleGroup")
		stockBlock:SetLayout("List")
		stockBlock:SetWidth(100)	
		stockBlock:SetFullHeight(false)
		
		valueBlock = AceGUI:Create("SimpleGroup")
		valueBlock:SetLayout("List")
		valueBlock:SetWidth(75)	
		valueBlock:SetFullHeight(false)
		
		gphBlock= AceGUI:Create("SimpleGroup")
		gphBlock:SetLayout("List")
		gphBlock:SetWidth(50)	
		gphBlock:SetFullHeight(false)
		
		timeBlock= AceGUI:Create("SimpleGroup")
		timeBlock:SetLayout("List")
		timeBlock:SetWidth(50)	
		timeBlock:SetFullHeight(false)
		
		
		scrollBlock =AceGUI:Create("Label")
		scrollBlock:SetHeight(1000)
		
		
		for i=1, totalSizeOfReagent  do
			InteractiveShowPanel:AddChild(itemToPrint[i])
			stockBlock:AddChild(stockToPrint[i])
			valueBlock:AddChild(valueToPrint[i])
			gphBlock:AddChild(gphToPrint[i])
			timeBlock:AddChild(timeToPrint[i])
		end
		mainShowPanel:AddChild(InteractiveShowPanel)
		mainShowPanel:AddChild(stockBlock)
		mainShowPanel:AddChild(valueBlock)
		mainShowPanel:AddChild(gphBlock)
		mainShowPanel:AddChild(timeBlock)
				
		mainShowPanel:AddChild(scrollBlock)
		f:AddChild(mainShowPanel)
		mainShowPanel:SetWidth(600)
		mainShowPanel:SetHeight(400)
		mainShowPanel:SetLayout("Flow")
		mainShowPanel:SetPoint("TOPRIGHT",10,-50)		
		
		f:Show()
end

function showLinesGlobal(index, reagent,quality, farmedthisSession, quantityPerHour)
	
	local sName, sLink, iRarity, iLevel, iMinLevel, sType, sSubType, iStackCount = GetItemInfo(reagent);
	if(iRarity == nil)then
		iRarity = 1
	end
	r,g,b, hex = GetItemQualityColor(iRarity)
	
	itemName = "\124c"..hex..GetItemName(reagent).."\124r"
	textureMarkup =""
	if quality~= 0 then
		if(quality == 1)then
				textureMarkup = "\124cFF964B00 *\124r"
		elseif(quality == 2)then
				textureMarkup =  "\124cFFC0C0C0 **\124r"	
		elseif(quality == 3)then
			textureMarkup =  "\124cFFFFD700 ***\124r"
		end
	end
	
	local inventory = GetQuantity(reagent)
	
	local stock = GetItemQuantityToStock(reagent)
	if(GetChoiceGoal()==2)then
		stock = quantityPerHour*GetTimeGoal()
	end
	local value = math.floor((GetItemPrice(reagent)/10000000)*stock)
	
	local gph =  math.floor(quantityPerHour * GetItemPrice(reagent)/10000000)
	local timeFarming = math.floor(stock/quantityPerHour)
	
	local startline= "\124r"
	
	if((math.floor(tonumber((inventory/stock)*100)))>89)then
		startline = '\124cFF00FF00'
	end
	if((math.floor(tonumber((inventory/stock)*100)))<90)then
		startline = '\124cFFFF7F00'
	end
	if((math.floor(tonumber((inventory/stock)*100)))<10)then
		startline = '\124cFFFF0000'
	end
	
	if(farmedthisSession>0)then
		stock = stock.." \124cFF00FF00+"..farmedthisSession.."\124r"
	end
	
	itemToPrint[index]:SetText("["..itemName..textureMarkup.."]")
	
	itemToPrint[index]:SetCallback("OnEnter", function(self) GameTooltip:SetOwner(WorldFrame, "ANCHOR_LEFT");GameTooltip:SetItemByID(reagent) end)
	itemToPrint[index]:SetCallback("OnLeave", function(self) GameTooltip:Hide(); end)
	
	stockToPrint[index]:SetText(startline..inventory.."/"..stock)
	valueToPrint[index]:SetText(value.."k")
	gphToPrint[index]:SetText(gph.."k")
	timeToPrint[index]:SetText(timeFarming.."h")
end

-- OPTIONS

function GroupGlobal(container)	

	local mainOptionContainer = AceGUI:Create("SimpleGroup")
	mainOptionContainer:SetLayout("List")
	local groupChoicePrice = AceGUI:Create("InlineGroup")
	groupChoicePrice:SetLayout("Flow")
	groupChoicePrice:SetWidth(500)
	local butMinPrice = AceGUI:Create("CheckBox")
	local butMinPriceGPH = AceGUI:Create("CheckBox")
	
	local optPrice = AceGUI:Create("EditBox")
	local optPriceGPH = AceGUI:Create("EditBox")
	
	local optPriceSource = AceGUI:Create("EditBox")	
	
	local groupGoals = AceGUI:Create("InlineGroup")
	
	groupGoals:SetLayout("Flow")
	groupGoals:SetWidth(500)
	local butStockGoal = AceGUI:Create("CheckBox")
	local butTimeGoal = AceGUI:Create("CheckBox")
		
	local optStockGoal= AceGUI:Create("EditBox")
	
	local optTimeGoal= AceGUI:Create("EditBox")
	groupChoicePrice:AddChild(butMinPrice)
	groupChoicePrice:AddChild(optPrice)
	groupChoicePrice:AddChild(butMinPriceGPH)
	groupChoicePrice:AddChild(optPriceGPH)
	
	groupGoals:AddChild(butStockGoal)
	groupGoals:AddChild(optStockGoal)
	groupGoals:AddChild(butTimeGoal)
	groupGoals:AddChild(optTimeGoal)
	
	mainOptionContainer:AddChild(groupChoicePrice)
	mainOptionContainer:AddChild(optPriceSource)
	mainOptionContainer:AddChild(groupGoals)
	
	container:AddChild(mainOptionContainer)
	
	
	
	
	if(GetChoiceMinPrice()==1) then
		butMinPrice:SetValue(true)
	elseif (GetChoiceMinPrice()==2) then
		butMinPriceGPH:SetValue(true)
	end
	
	butMinPrice:SetLabel("gold per item")
	butMinPrice:SetDescription("The minimum price is the price of the item");
	butMinPrice:SetCallback("OnValueChanged", function(widget, event, val) SetChoiceMinPrice(1);butMinPriceGPH:SetValue(false) end)

	optPrice:SetLabel("Minimum Price")
	optPrice:SetText(GetMinPrice())
	optPrice:SetWidth(200)
	optPrice:SetCallback("OnEnterPressed", function(widget, event, text) SetMinPrice(text) end)

	butMinPriceGPH:SetLabel("gold per hour")
	butMinPriceGPH:SetDescription("The minimum price is the price of 1 hour of farm");
	butMinPriceGPH:SetCallback("OnValueChanged", function(widget, event, val) SetChoiceMinPrice(2);butMinPrice:SetValue(false) end)
	
	
	optPriceGPH:SetLabel("Minimum GPH")
	optPriceGPH:SetText(GetGphMini())
	optPriceGPH:SetWidth(200)
	optPriceGPH:SetCallback("OnEnterPressed", function(widget, event, text) SetGphMini(text) end)

	
	optPriceSource:SetLabel("price Source ( TSM )")
	optPriceSource:SetText(GetPriceSouce());
	optPriceSource:SetWidth(200)
	optPriceSource:SetCallback("OnEnterPressed", function(widget, event, text) SetPriceSouce(text) end)
	optPriceSource:SetFullWidth(true);
	
	
	if (GetChoiceGoal()==1) then
		butStockGoal:SetValue(true)
	elseif (GetChoiceGoal()==2) then
		butTimeGoal:SetValue(true)
	end
	

	butStockGoal:SetLabel("Stock Goal")
	butStockGoal:SetDescription("TSM operation usable");
	butStockGoal:SetCallback("OnValueChanged", function(widget, event, val) SetChoiceGoal(1);butTimeGoal:SetValue(false); end)

		
	optStockGoal:SetLabel("stock goal")
	optStockGoal:SetText(GetStockGoal())
	optStockGoal:SetWidth(200)
	optStockGoal:SetCallback("OnEnterPressed", function(widget, event, text) SetStockGoal(text) end)

		
	butTimeGoal:SetLabel("Time Goal")
	butTimeGoal:SetDescription("Goal set in hours of farm");
	butTimeGoal:SetCallback("OnValueChanged", function(widget, event, val) SetChoiceGoal(2);butStockGoal:SetValue(false); end)
	
	
	optTimeGoal:SetLabel("time goal")
	optTimeGoal:SetText(GetTimeGoal())
	optTimeGoal:SetWidth(200)
	optTimeGoal:SetCallback("OnEnterPressed", function(widget, event, text) SetTimeGoal(text) end)
	
end

function GroupCustom(container)	
	print("Work in progress")
end

local function SelectGroup(container, event, group)
   container:ReleaseChildren()
   if group == "tab1" then
      GroupGlobal(container)
	 elseif group == "tab2" then
      GroupCustom(container)
   end
end

function FarmRestock.openOpt()
		local o = AceGUI:Create("Frame")
		o:SetTitle("Options")
		o:SetCallback("OnClose", function(widget)optOpen=false;o:Hide(); end)
		o:SetLayout("Fill")
		o:SetHeight(550)
		o:SetWidth(750)
		o:EnableResize(false)
		
		-- Create the TabGroup
		local tab =  AceGUI:Create("TabGroup")
		tab:SetLayout("Flow")
		-- Setup which tabs to show
		tab:SetTabs({{text="Global", value="tab1"}, {text="Custom", value="tab2"}})
		-- Register callback
		tab:SetCallback("OnGroupSelected", SelectGroup)
		-- Set initial Tab (this will fire the OnGroupSelected callback)
		tab:SelectTab("tab1")
		
		o:AddChild(tab);

		o:Show()
end

-- SHOW FUNCTIONS	

function FarmRestock.showMining()
	FarmRestock:cleanLines()
	idx =0	
	local minprice = tonumber(GetMinPrice())
	local minGPH = tonumber(GetGphMini())
	for i=1, getn(miningReagents) do
		farmed = GetQuantity(miningReagents[i])-farmedSessionMining[i]
		if(GetChoiceMinPrice()==1)then
			if(GetItemPrice(miningReagents[i])/10000>minprice)then
				idx=idx+1
				showLinesGlobal(idx,miningReagents[i],0,farmed, miningReagentsQph[i])
			end
		end
		if(GetChoiceMinPrice()==2)then
			if(((GetItemPrice(miningReagents[i])/10000)*miningReagentsQph[i])>minGPH)then
				idx=idx+1
				showLinesGlobal(idx,miningReagents[i],0,farmed, miningReagentsQph[i])
			end
		end
	end
	for i=1, getn(miningReagentsDF) do	
		farmed = GetQuantity(miningReagentsDF[i])-farmedSessionMiningDF[i]
		if(GetChoiceMinPrice()==1)then
			if(GetItemPrice(miningReagentsDF[i])/10000>minprice)then
				idx=idx+1				
				showLinesGlobal(idx,miningReagentsDF[i],qualityMiningReagentsDF[i],farmed,miningReagentsDFQph[i])
			end
		end	
		if(GetChoiceMinPrice()==2)then
			if(((GetItemPrice(miningReagentsDF[i])/10000)*miningReagentsDFQph[i])>minGPH)then
				idx=idx+1
				showLinesGlobal(idx,miningReagentsDF[i],qualityMiningReagentsDF[i],farmed,miningReagentsDFQph[i])
			end
		end
	end
end

function FarmRestock.showHerbal()
	FarmRestock:cleanLines()
	idx =0	
	local minprice = tonumber(GetMinPrice())
	local minGPH = tonumber(GetGphMini())
	for i=1, getn(plantsReagents) do
		farmed = GetQuantity(plantsReagents[i])-farmedSessionPlants[i]
		if(GetChoiceMinPrice()==1)then
			if(GetItemPrice(plantsReagents[i])/10000>minprice)then
				idx=idx+1
				showLinesGlobal(idx,plantsReagents[i],0,farmed, plantsReagentsQph[i])
			end
		end
		if(GetChoiceMinPrice()==2)then
			if(((GetItemPrice(plantsReagents[i])/10000)*plantsReagentsQph[i])>minGPH)then
				idx=idx+1
				showLinesGlobal(idx,plantsReagents[i],0,farmed, plantsReagentsQph[i])
			end
		end
	end
	for i=1, getn(plantsReagentsDF) do		
		farmed = GetQuantity(plantsReagentsDF[i])-farmedSessionPlantsDF[i]
		if(GetChoiceMinPrice()==1)then
			if(GetItemPrice(plantsReagentsDF[i])/10000>minprice)then
				idx=idx+1				
				showLinesGlobal(idx,plantsReagentsDF[i],qualityPlantsReagentsDF[i],farmed,plantsReagentsDFQph[i])
			end
		end	
		if(GetChoiceMinPrice()==2)then
			if(((GetItemPrice(plantsReagentsDF[i])/10000)*plantsReagentsDFQph[i])>minGPH)then
				idx=idx+1
				showLinesGlobal(idx,plantsReagentsDF[i],qualityPlantsReagentsDF[i],farmed,plantsReagentsDFQph[i])
			end
		end
	end
end

function FarmRestock.showSkinning()
	FarmRestock:cleanLines()
	idx =0	
	local minprice = tonumber(GetMinPrice())
	local minGPH = tonumber(GetGphMini())
	for i=1, getn(skinReagents) do
		farmed = GetQuantity(skinReagents[i])-farmedSessionSkin[i]
		if(GetChoiceMinPrice()==1)then
			if(GetItemPrice(skinReagents[i])/10000>minprice)then
				idx=idx+1
				showLinesGlobal(idx,skinReagents[i],0,farmed, skinReagentsQph[i])
			end
		end
		if(GetChoiceMinPrice()==2)then
			if(((GetItemPrice(skinReagents[i])/10000)*skinReagentsQph[i])>minGPH)then
				idx=idx+1
				showLinesGlobal(idx,skinReagents[i],0,farmed, skinReagentsQph[i])
			end
		end
	end
	for i=1, getn(skinReagentsDF) do		
		farmed = GetQuantity(skinReagentsDF[i])-farmedSessionSkinDF[i]
		if(GetChoiceMinPrice()==1)then
			if(GetItemPrice(skinReagentsDF[i])/10000>minprice)then
				idx=idx+1				
				showLinesGlobal(idx,skinReagentsDF[i],qualitySkinReagentsDF[i],farmed,skinReagentsDFQph[i])
			end
		end	
		if(GetChoiceMinPrice()==2)then
			if(((GetItemPrice(skinReagentsDF[i])/10000)*skinReagentsDFQph[i])>minGPH)then
				idx=idx+1
				showLinesGlobal(idx,skinReagentsDF[i],qualitySkinReagentsDF[i],farmed,skinReagentsDFQph[i])
			end
		end
	end
end

function FarmRestock.showElem()
	FarmRestock:cleanLines()
	idx =0	
	local minprice = tonumber(GetMinPrice())
	local minGPH = tonumber(GetGphMini())
	for i=1, getn(elemReagents) do
		farmed = GetQuantity(elemReagents[i])-farmedSessionElem[i]
		if(GetChoiceMinPrice()==1)then
			if(GetItemPrice(elemReagents[i])/10000>minprice)then
				idx=idx+1
				showLinesGlobal(idx,elemReagents[i],0,farmed, elemReagentsQph[i])
			end
		end
		if(GetChoiceMinPrice()==2)then
			if(((GetItemPrice(elemReagents[i])/10000)*elemReagentsQph[i])>minGPH)then
				idx=idx+1
				showLinesGlobal(idx,elemReagents[i],0,farmed, elemReagentsQph[i])
			end
		end
	end
end


function FarmRestock.cleanLines()
	for i=1,totalSizeOfReagent do
		itemToPrint[i]:SetText("")
	
		stockToPrint[i]:SetText("")
		valueToPrint[i]:SetText("")
		gphToPrint[i]:SetText("")
		timeToPrint[i]:SetText("")
	end
end

-- GET AND SET 

function SetMinPrice(value)
	FarmRestockV4Config.prixMini = value
end
function SetPriceSouce(value)
	FarmRestockV4Config.priceSource=value
end
function SetStockGoal(value)
	FarmRestockV4Config.stockGoal=value
end
function SetGphMini(value)
	FarmRestockV4Config.gphMini=value
end
function SetTimeGoal(value)
	FarmRestockV4Config.timeGoal=value
end
function SetChoiceMinPrice(value)
	FarmRestockV4Config.choiceMinPrice=value
end
function SetChoiceGoal(value)
	FarmRestockV4Config.choiceGoal=value
end




function GetMinPrice()
	return FarmRestockV4Config.prixMini
end
function GetPriceSouce()
	return FarmRestockV4Config.priceSource
end
function GetStockGoal()
	return FarmRestockV4Config.stockGoal
end
function GetGphMini()
	return FarmRestockV4Config.gphMini
end
function GetTimeGoal()
	return FarmRestockV4Config.timeGoal
end
function GetChoiceMinPrice()
	return FarmRestockV4Config.choiceMinPrice
end
function GetChoiceGoal()
	return FarmRestockV4Config.choiceGoal
end