local addonName, addonTable = ...;
local _, _, _, tocversion = GetBuildInfo()
local _G = _G
local CreateFrame = CreateFrame
local CreateTexture=CreateTexture
---------------------------
-- local Create=addonTable.Create
-- local PIGFrame=Create.PIGFrame
-- local PIGLine=Create.PIGLine
-- local PIGEnter=Create.PIGEnter
-- local PIGButton = Create.PIGButton
-- local PIGCloseBut = Create.PIGCloseBut
-- local PIGDownMenu=Create.PIGDownMenu
-- local PIGSlider = Create.PIGSlider
-- local PIGCheckbutton=Create.PIGCheckbutton
-- local PIGCheckbutton_R=Create.PIGCheckbutton_R
-- local PIGOptionsList=Create.PIGOptionsList
-- local PIGOptionsList_RF=Create.PIGOptionsList_RF
-- local PIGOptionsList_R=Create.PIGOptionsList_R
-- local PIGFontString=Create.PIGFontString
-- local PIGFontStringBG=Create.PIGFontStringBG
-- local PIGQuickBut=Create.PIGQuickBut
-- local PIGSetFont=Create.PIGSetFont
-- local Show_TabBut_R=Create.Show_TabBut_R

local Create = {}
local FontUrl = "Fonts/ARHei.ttf"
Create.FontUrl=FontUrl
function Create.PIGSetFont(fuji,zihao,Miaobian)
	local zihao = zihao or 14
	fuji:SetFont(FontUrl,zihao,Miaobian)
end
-- Create.edgeFile = "Interface/Buttons/WHITE8X8"
Create.bgFile = "interface/chatframe/chatframebackground.blp"
Create.edgeFile = "Interface/AddOns/"..addonName.."/Libs/Pig_Border.blp"
Create.Backdropinfo={bgFile = Create.bgFile,
	edgeFile = Create.edgeFile, edgeSize = 8,}
Create.BackdropColor={0.08, 0.08, 0.08, 0.5}
Create.BackdropBorderColor={0, 0, 0, 1}
function Create.PIGLine(Parent,Point,Y,H,LR,Color,UIName)
	local Y = Y or 0
	local H = H or 1
	local LR = LR or {0,0}
	local Color = Color or Create.BackdropBorderColor
	frameX = Parent:CreateLine(UIName)
	frameX:SetColorTexture(Color[1], Color[2], Color[3], Color[4])
	frameX:SetThickness(H);
	-- local frameX = Parent:CreateTexture(UIName, "BORDER");
	-- frameX:SetTexture("Interface/AddOns/"..addonName.."/Libs/line.blp");
	-- frameX:SetColorTexture(Color[1], Color[2], Color[3], Color[4])
	-- frameX:SetHeight(H);
	if Point=="TOP" then
		frameX:SetStartPoint("TOPLEFT",LR[1],Y)
		frameX:SetEndPoint("TOPRIGHT",LR[2],Y)
		-- frameX:SetPoint("TOPLEFT",Parent,"TOPLEFT",LR[1],Y);
		-- frameX:SetPoint("TOPRIGHT",Parent,"TOPRIGHT",LR[2],Y);
	elseif Point=="BOT" then
		frameX:SetStartPoint("BOTTOMLEFT",LR[1],Y)
		frameX:SetEndPoint("BOTTOMRIGHT",LR[2],Y)
		-- frameX:SetPoint("BOTTOMLEFT",Parent,"BOTTOMLEFT",LR[1],Y);
		-- frameX:SetPoint("BOTTOMRIGHT",Parent,"BOTTOMRIGHT",LR[2],Y);
	elseif Point=="L" then
		frameX:SetStartPoint("TOPLEFT",Y,LR[1])
		frameX:SetEndPoint("BOTTOMLEFT",Y,LR[2])
		-- frameX:SetPoint("TOPLEFT",Parent,"TOPLEFT",Y,LR[1]);
		-- frameX:SetPoint("BOTTOMLEFT",Parent,"BOTTOMLEFT",Y,LR[2]);
	elseif Point=="R" then
		frameX:SetStartPoint("TOPRIGHT",Y,LR[1])
		frameX:SetEndPoint("BOTTOMRIGHT",Y,LR[2])
		-- frameX:SetPoint("TOPRIGHT",Parent,"TOPRIGHT",Y,LR[1]);
		-- frameX:SetPoint("BOTTOMRIGHT",Parent,"BOTTOMRIGHT",Y,LR[2]);
	elseif Point=="C" then
		frameX:SetStartPoint("TOP",Y,LR[1])
		frameX:SetEndPoint("BOTTOM",Y,LR[2])
		-- frameX:SetPoint("TOP",Parent,"TOP",Y,LR[1]);
		-- frameX:SetPoint("BOTTOM",Parent,"BOTTOM",Y,LR[2]);
	end
	return frameX
end
function Create.PIGFrame(Parent,Point,WH,UIName,ESCOFF)
	local frameX = CreateFrame("Frame", UIName, Parent,"BackdropTemplate")
	if WH then
		frameX:SetSize(WH[1],WH[2]);
	end
	if Point then
		frameX:SetPoint(Point[1],Point[2],Point[3],Point[4],Point[5]);
	end
	frameX:EnableMouse(true)
	if ESCOFF then
		frameX:Hide()
		tinsert(UISpecialFrames,UIName);
	end
	function frameX:PIGSetBackdrop(BGAlpha,BorderAlpha,Color,BorderColor)
		self:SetBackdrop(Create.Backdropinfo)
		local BackdropColor=Color or Create.BackdropColor
		local BackdropBorderColor=BorderColor or Create.BackdropBorderColor
		local BGAlpha = BGAlpha or BackdropColor[4]
		self:SetBackdropColor(BackdropColor[1], BackdropColor[2], BackdropColor[3], BGAlpha);
		local BorderAlpha = BorderAlpha or BackdropBorderColor[4]
		self:SetBackdropBorderColor(BackdropBorderColor[1], BackdropBorderColor[2], BackdropBorderColor[3], BorderAlpha);
	end
	function frameX:PIGSetMovable(MovableUI)
		local MovableUI=MovableUI or self
		MovableUI:SetMovable(true)
		MovableUI:SetUserPlaced(true)
		self:RegisterForDrag("LeftButton")
		self:HookScript("OnDragStart",function(self)
			MovableUI:StartMoving()
		end)
		self:HookScript("OnDragStop",function(self)
			MovableUI:StopMovingOrSizing()
		end)
		MovableUI:SetClampedToScreen(true)
	end
	function frameX:PIGClose(Ww,Hh,CloseUI)
		local Ww = Ww or 22
		local Hh = Hh or 22
		local CloseUI=CloseUI or self
		self.Close = CreateFrame("Button",nil,self);
		self.Close:SetHighlightTexture("interface/buttons/ui-common-mousehilight.blp")
		self.Close:SetSize(Ww,Hh);
		self.Close:SetPoint("TOPRIGHT",self,"TOPRIGHT",0,0);
		self.Close.Tex = self.Close:CreateTexture(nil, "BORDER");
		self.Close.Tex:SetTexture("interface/common/voicechat-muted.blp");
		self.Close.Tex:SetSize(self.Close:GetWidth()-8,self.Close:GetHeight()-8);
		self.Close.Tex:SetPoint("CENTER",0,0);
		self.Close:HookScript("OnMouseDown", function (self)
			self.Tex:SetPoint("CENTER",-1.5,-1.5);
		end);
		self.Close:HookScript("OnMouseUp", function (self)
			self.Tex:SetPoint("CENTER");
		end);
		self.Close:HookScript("OnClick", function (self)
			PlaySound(SOUNDKIT.U_CHAT_SCROLL_BUTTON);
			CloseUI:Hide()
		end);
	end
	function frameX:SetObject(object, PointUI,Point)
		local Point=Point or {0,0,0,0}
		local left=Point[1]
	    local right = Point[2]
	    local top = Point[3]
	    local bottom = Point[4]
	    object:SetParent(self)
	    object:ClearAllPoints()
	    object:SetPoint('TOPLEFT', PointUI, 'TOPLEFT', left, top)
	    object:SetPoint('BOTTOMRIGHT', PointUI, 'BOTTOMRIGHT', right, bottom)
	    object:Show()
	    self.Object = object
	end
	return frameX
end
function Create.PIGEnter(Parent,text,text1,text2,Xpianyi,Ypianyi)
	local Xpianyi,Ypianyi=Xpianyi or 0,Ypianyi or 0
	Parent:HookScript("OnEnter", function(self)
		GameTooltip:ClearLines();
		GameTooltip:SetOwner(self, "ANCHOR_TOPLEFT",Xpianyi,Ypianyi);
		GameTooltip:AddLine(text, nil, nil, nil, true)
		if text1 then
			GameTooltip:AddLine(text1, nil, nil, nil, true)
		end
		if text2 then
			GameTooltip:AddLine(text2, nil, nil, nil, true)
		end
		GameTooltip:Show();
	end);
	Parent:HookScript("OnLeave", function()
		GameTooltip:ClearLines();
		GameTooltip:Hide() 
	end);
end
addonTable.Create=Create