local addonName, addonTable = ...;
local wipe, concat = table.wipe, table.concat;
local find = _G.string.find
local sub = _G.string.sub
local match = _G.string.match
local tonumber=tonumber
local tostring=tostring
local strlower=strlower
local strupper=strupper
local strsplit=strsplit
local strchar=strchar
--===============================================
--兼容ALA数据文件，取自TalentEmu插件，版权归原作者
--===============================================
local ALA={}
local __base64, __debase64 = {  }, {  };
for i = 0, 9 do __base64[i] = tostring(i); end
__base64[10] = "-";
__base64[11] = "=";
for i = 0, 25 do __base64[i + 1 + 11] = strchar(i + 65); end
for i = 0, 25 do __base64[i + 1 + 11 + 26] = strchar(i + 97); end
for i = 0, 63 do
	__debase64[__base64[i]] = i;
end
local RepeatedZero = setmetatable(
	{
		[0] = "",
		[1] = "0",
	},
	{
		__index = function(tbl, key)
			local str = strrep("0", key);
			tbl[key] = str;
			return str;
		end,
	}
);
----转换格式
local function EncodeNumber(val, len)
	if val == 0 or val == nil then
		return __base64[0];
	end
	local code = nil;
	if val < 0 then
		code = "^";
		val = -val;
	else
		code = "";
	end
	local num = 0;
	while val > 0 do
		local v = val % 64;
		code = code .. __base64[v];
		num = num + 1;
		val = (val - v) / 64;
	end
	if len ~= nil and num < len then
		return code .. RepeatedZero[len - num];
	end
	return code;
end
local function EncodeItem(item)
	local val = { strsplit(":", item) };
	if val[1] == "item" then
		local code = EncodeNumber(tonumber(val[2]));
		local pos = 2;
		local len = #val;
		for i = 3, len do
			if val[i] ~= "" then
				code = code .. ":" .. __base64[i - pos] .. EncodeNumber(tonumber(val[i]));
				pos = i;
			end
		end
		if pos < len then
			code = code .. ":" .. __base64[len - pos];
		end
		return code;
	end
	return "^";
end
function ALA.EncodeItemList()
	local pos = 0;
	local msg = __base64[0];
	for slot = 0, 19 do
		local item = GetInventoryItemLink('player', slot);
		if item ~= nil then
			item = item:match("\124H(item:[%-0-9:]+)\124h");
			if item ~= nil then
				item = "+" .. EncodeItem(item);
			else
				item = "+^";
			end
		else
			item = "+^";
		end
		msg = msg .. item;
	end
	return "!E"..msg;
end
function ALA.EncodeTalentBlock(data)
	local len = #data;
	local num = 0;
	local raw = 0;
	local magic = 1;
	local mem = {  };
	local pos = 0;
	for index = 1, len do
		local d = tonumber(data:sub(index, index));
		num = num + 1;
		raw = raw + magic * d;
		magic = magic * 6;
		if num >= 11 or index == len then
			num = 0;
			magic = 1;
			local nChar = 0;
			while raw > 0 do
				local v1 = raw % 64;
				pos = pos + 1;
				mem[pos] = __base64[v1];
				raw = (raw - v1) / 64;
				nChar = nChar + 1;
			end
			if nChar < 5 then
				pos = pos + 1;
				mem[pos] = ":";
			end
		end
	end
	return concat(mem)
end
---还原格式
local function DecodeNumber(code)
	local isnegative = false;
	if code:sub(1, 1) == "^" then
		code = code:sub(2);
		isnegative = true;
	end
	local v = nil;
	local n = #code;
	if n == 1 then
		v = __debase64[code];
	else
		v = 0;
		for i = n, 1, -1 do
			v = v * 64 + __debase64[code:sub(i, i)];
		end
	end
	return isnegative and -v or v;
end
local RepeatedColon = setmetatable(
	{
		[0] = "",
		[1] = ":",
	},
	{
		__index = function(tbl, key)
			local str = strrep(":", key);
			tbl[key] = str;
			return str;
		end,
	}
);
local function DecodeItem(code)
	if code ~= "^" then
		local item = "item:";
		local val = { strsplit(":", code) };
		if val[1] ~= nil then
			local id = DecodeNumber(val[1]);
			if id ~= nil then
				item = item .. id;
				for i = 2, #val do
					local v = val[i];
					if #v > 1 then
						item = item .. RepeatedColon[__debase64[v:sub(1, 1)]] .. DecodeNumber(v:sub(2));
					else
						item = item .. RepeatedColon[__debase64[v]];
					end
				end
				return item;
			end
		end
	end
	return nil;
end
local haiyuan_Item = {
	[1] = function(code)
		local DataTable = {}
		local val = { strsplit("+", code) };	--	"", slot, item, slot, item...
		if val[3] ~= nil then
			local num = #val;
			for i = 2, num, 2 do
				local slot = tonumber(val[i]);
				local item = val[i + 1];
				local id = item:match("item:([%-0-9]+)");
				id = tonumber(id);
				if id ~= nil and id > 0 then
					GetItemInfo(id);
					DataTable[slot] = item;
				else
					DataTable[slot] = nil;
				end
			end
			return DataTable;
		end
		return DataTable;
	end,
	[2] = function(code)
		local DataTable = {}
		local val = { strsplit("+", code) };
		if val[2] ~= nil then
			local start = __debase64[val[1]] - 2;
			local num = #val;
			for i = 2, num do
				local item = DecodeItem(val[i]);
				DataTable[start + i] = item;
				if item ~= nil then
					GetItemInfo(item);
				end
			end
			return DataTable;
		end
		return DataTable;
	end,
};
-----还原天赋
local function DecodeTalentBlock(code, len)
	len = len or #code;
	local data = "";
	local raw = 0;
	local magic = 1;
	local nChar = 0;
	for index = 1, len do
		local c = code:sub(index, index);
		if c == ":" then
			--
		elseif __debase64[c] then
			raw = raw + __debase64[c] * magic;
			magic = magic * 64;
			nChar = nChar + 1;
		else

		end
		if c == ":" or nChar == 5 or index == len then
			magic = 1;
			nChar = 0;
			local n = 0;
			while raw > 0 do
				local val = raw % 6;
				data = data .. val;
				raw = (raw - val) / 6;
				n = n + 1;
			end
			if n < 11 then
				data = data .. RepeatedZero[11 - n];
			end
		end
	end
	return data;
end
local ClasseID={
	[9]=1,
	[4]=2,
	[2]=3,
	[6]=4,
	[5]=5,
	[10]=6,
	[7]=7,
	[3]=8,
	[8]=9,
	[11]=10,
	[1]=11,
	[12]=12,
}
local haiyuan_tianfu = {
	[1] = function(code)
		local classIndex = __debase64[code:sub(1, 1)];
		local class = ClasseID[classIndex];
		return class, __debase64[code:sub(-2, -2)] + __debase64[code:sub(-1, -1)] * 64, 1, 1, DecodeTalentBlock(code:sub(2, -3));
	end,
	[2] = function(code)
		local cc = code:sub(1, 1);
		local classIndex = __debase64[cc];
		local class = ClasseID[classIndex];
		local level = __debase64[code:sub(2, 2)] + __debase64[code:sub(3, 3)] * 64;
		local numGroup = tonumber(__debase64[code:sub(4, 4)]);
		local activeGroup = tonumber(__debase64[code:sub(5, 5)]);
		local tianfudata=""
		if numGroup < 2 then
			local lenTal1 = tonumber(__debase64[code:sub(6, 6)]);
			local code1 = code:sub(7, lenTal1 + 6);
			tianfudata=DecodeTalentBlock(code1, lenTal1)
		else
			local shuangtianfu = {}
			local lenTal1 = tonumber(__debase64[code:sub(6, 6)]);
			local code1 = code:sub(7, lenTal1 + 6);
			shuangtianfu[1]=DecodeTalentBlock(code1, lenTal1)
			local lenTal2 = tonumber(__debase64[code:sub(7 + lenTal1, 7 + lenTal1)]);
			local code2 = code:sub(lenTal1 + 8, lenTal1 + lenTal2 + 7);
			shuangtianfu[2]=DecodeTalentBlock(code2, lenTal2)
			tianfudata=shuangtianfu[activeGroup]
		end
		
		return {["class"]=class,["race"]=0,["level"]=level},tianfudata
	end,
};
local haiyuan_Glyph = {
	[2] = function(code)
		local numGroup = tonumber(__debase64[code:sub(1, 1)]);
		local activeGroup = tonumber(__debase64[code:sub(2, 2)]);
		if numGroup < 2 then
			local lenTal1 = tonumber(__debase64[code:sub(3, 3)]);
			local code1 = code:sub(4, lenTal1 + 3);
			return __emulib.DecodeGlyphBlock(code1, lenTal1);
		else
			local lenTal1 = tonumber(__debase64[code:sub(3, 3)]);
			local code1 = code:sub(4, lenTal1 + 3);
			local lenTal2 = tonumber(__debase64[code:sub(4 + lenTal1, 4 + lenTal1)]);
			local code2 = code:sub(lenTal1 + 5, lenTal1 + lenTal2 + 4);
			return __emulib.DecodeGlyphBlock(code1, lenTal1), __emulib.DecodeGlyphBlock(code2, lenTal2);
		end
	end,
};
function ALA.tiquData(data,ly)
	local Data_Heji={{},{},{},{}}
	if ly=="pig" then
		local pinfo,tfinfo,zbinfo = strsplit("@", data);
		Data_Heji[1].class,Data_Heji[1].race,Data_Heji[1].level = strsplit("-", pinfo);
		Data_Heji[3]=DecodeTalentBlock(tfinfo)
		Data_Heji[2]=haiyuan_Item[2](zbinfo:sub(3));	
	elseif ly=="ala" then
		local _;
		local pos = 1;
		local code = nil;
		local v2_ctrl_code = nil;
		local len = #data;
		while pos < len do
			_, pos, code, v2_ctrl_code = data:find("((![^!])[^!]+)", pos);
			if v2_ctrl_code == "!T" then
				local LM = __debase64[code:sub(4, 4)];
				if haiyuan_tianfu[LM] ~= nil then
					Data_Heji[1],Data_Heji[3]=haiyuan_tianfu[LM](code:sub(5));
				end
			elseif v2_ctrl_code == "!G" then
				-- local LM = __debase64[code:sub(4, 4)];
				-- if haiyuan_Glyph[LM] ~= nil then
				-- 	return haiyuan_Glyph[LM](code:sub(5));
				-- end
			elseif v2_ctrl_code == "!E" then	
				local LM = __debase64[code:sub(4, 4)];
				if haiyuan_Item[LM] ~= nil then
					Data_Heji[2]=haiyuan_Item[LM](code:sub(5));
				end
			elseif v2_ctrl_code == "!A" then
				-- print(code)
			end
		end
	end
	return Data_Heji
end
addonTable.ALA=ALA