--[[
    Created by Slothpala 
--]]
local _, addonTable = ...
local HealthBarColor = addonTable.HealthBarColor

local Media = LibStub("LibSharedMedia-3.0")
local statusbars = Media:List("statusbar")
local fonts = Media:List("font")
local L = LibStub("AceLocale-3.0"):GetLocale("HealthBarColor")
local lastEntry = 6
local selectedWidth, colorWidth, statusBarWidth = 1, 0.4, 1.8
local options = {
    name = "HealthBarColor",
    handler = HealthBarColor,
    type = "group",
    args = {
        Version = {
            order = 0,
            name = "2.10.3",
            type = "group",
            disabled = true,
            args = {},
        },
        HealthBars = {
            order = 1,
            name = L["Health Bars"],
            type = "group",
            args = {
                Player = {
                    order = 1,
                    name = L["Player"],
                    type = "group",
                    inline = true,
                    args = {
                        selected = {
                            order = 1,
                            name = L["color_options"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        color = {
                            order = 2,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.HealthBars.Player.selected == 2 then return false end return true end,
                            width = colorWidth,
                        },  
                    },
                },
                Target = {
                    order = 2,
                    name = L["Target"],
                    type = "group",
                    inline = true,
                    args = {
                        selected = {
                            order = 1,
                            name = L["color_options"],
                            desc = "",
                            type = "select",
                            values = {L["targets class color"],L["color_option_2"],L["color_option_3"],L["color_option_4"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        color = {
                            order = 2,
                            name = function() if HealthBarColor.db.profile.HealthBars.Target.selected == 3 then return L["color"] end return L["NPC color"] end,
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if ( HealthBarColor.db.profile.HealthBars.Target.selected == 2 or HealthBarColor.db.profile.HealthBars.Target.selected == 4 ) or ( HealthBarColor.db.profile.HealthBars.Target.selected == 1 and HealthBarColor.db.profile.HealthBars.Target.reaction ) then return true end return false end,
                            width = colorWidth,
                        },  
                        reaction = {
                            order = 3,
                            name = L["NPC color by reaction"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            hidden = function() if HealthBarColor.db.profile.HealthBars.Target.selected == 1 then return false end return true end,
                        },
                    },
                },
                ToT = {
                    order = 3,
                    name = L["Target of Target"],
                    type = "group",
                    inline = true,
                    args = {
                        selected = {
                            order = 1,
                            name = L["color_options"],
                            desc = "",
                            type = "select",
                            values = {L["tot class color"],L["color_option_2"] ,L["color_option_3"], L["color_option_4"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        color = {
                            order = 2,
                            name = function() if HealthBarColor.db.profile.HealthBars.ToT.selected == 3 then return L["color"] end return L["NPC color"]  end,
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if ( HealthBarColor.db.profile.HealthBars.ToT.selected == 2 or HealthBarColor.db.profile.HealthBars.ToT.selected == 4 ) or ( HealthBarColor.db.profile.HealthBars.ToT.selected == 1 and HealthBarColor.db.profile.HealthBars.ToT.reaction ) then return true end return false end,
                            width = colorWidth,
                        },  
                        reaction = {
                            order = 3,
                            name = L["NPC color by reaction"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            hidden = function() if HealthBarColor.db.profile.HealthBars.ToT.selected == 1 then return false end return true end,
                        },
                    },
                },
                Focus = {
                    guiHidden = HealthBarColor.isClassic,
                    order = 4,
                    name = L["Focus"],
                    type = "group",
                    inline = true,
                    args = {
                        selected = {
                            order = 1,
                            name = L["color_options"],
                            desc = "",
                            type = "select",
                            values = {L["focus class color"],L["color_option_2"],L["color_option_3"],L["color_option_4"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        color = {
                            order = 2,
                            name = function() if HealthBarColor.db.profile.HealthBars.Focus.selected == 3 then return L["color"] end return L["NPC color"] end,
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if ( HealthBarColor.db.profile.HealthBars.Focus.selected == 2 or HealthBarColor.db.profile.HealthBars.Focus.selected == 4 ) or ( HealthBarColor.db.profile.HealthBars.Focus.selected == 1 and HealthBarColor.db.profile.HealthBars.Focus.reaction ) then return true end return false end,
                            width = colorWidth,
                        },  
                        reaction = {
                            order = 3,
                            name = L["NPC color by reaction"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            hidden = function() if HealthBarColor.db.profile.HealthBars.Focus.selected == 1 then return false end return true end,
                        },
                    },
                },
                ToF = {
                    guiHidden = HealthBarColor.isClassic,
                    order = 5,
                    name = L["Target of Focus"],
                    type = "group",
                    inline = true,
                    args = {
                        selected = {
                            order = 1,
                            name = L["color_options"],
                            desc = "",
                            type = "select",
                            values = {L["tof class color"],L["color_option_2"],L["color_option_3"],L["color_option_4"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        color = {
                            order = 2,
                            name = function() if HealthBarColor.db.profile.HealthBars.ToF.selected == 3 then return L["color"] end return L["NPC color"] end,
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if ( HealthBarColor.db.profile.HealthBars.ToF.selected == 2 or HealthBarColor.db.profile.HealthBars.ToF.selected == 4 ) or ( HealthBarColor.db.profile.HealthBars.ToF.selected == 1 and HealthBarColor.db.profile.HealthBars.ToF.reaction ) then return true end return false end,
                            width = colorWidth,
                        },  
                        reaction = {
                            order = 3,
                            name = L["NPC color by reaction"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            hidden = function() if HealthBarColor.db.profile.HealthBars.ToF.selected == 1 then return false end return true end,
                        },
                    },
                },
                Pet = {
                    order = 6,
                    name = L["Pet"],
                    type = "group",
                    inline = true,
                    args = {
                        selected = {
                            order = 1,
                            name = L["color_options"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_2"],L["color_option_3"] },
                            sorting = {1,2},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        color = {
                            order = 2,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.HealthBars.Pet.selected == 2 then return false end return true end,
                            width = colorWidth,
                        },  
                    },
                },
                Boss = {
                    guiHidden = not HealthBarColor.isRetail,
                    order = 7,
                    name = L["Boss"],
                    type = "group",
                    inline = true,
                    args = {
                        selected = {
                            order = 1,
                            name = L["color_options"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_2"],L["color_option_3"] },
                            sorting = {1,2},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        color = {
                            order = 2,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.HealthBars.Boss.selected == 2 then return false end return true end,
                            width = colorWidth,
                        },  
                    },
                },
            },
        },
        Fonts = {
            order = 1.1,
            name = L["Fonts"],
            type = "group",
            childGroups = "tab",
            hidden = function() return not HealthBarColor.db.profile.Settings.Modules.Fonts end,
            args = {
                General = {
                    order = 0,
                    name = L["Font Settings"],
                    type = "group",
                    inline = true,
                    args = {
                        name = {
                            order = 1,
                            type = "select",
                            dialogControl = "LSM30_Font", 
                            name = L["Name"],
                            values = Media:HashTable("font"), 
                            get = "GetStatus",
                            set = "SetStatus",
                        },
                        healthbar = {
                            order = 2,
                            type = "select",
                            dialogControl = "LSM30_Font", 
                            name = L["Health Bar"],
                            values = Media:HashTable("font"), 
                            get = "GetStatus",
                            set = "SetStatus",
                        },
                        powerbar = {
                            order = 3,
                            type = "select",
                            dialogControl = "LSM30_Font", 
                            name = L["Power Bar"],
                            values = Media:HashTable("font"), 
                            get = "GetStatus",
                            set = "SetStatus",
                        },
                        newline = {
                            order = 4,
                            type = "description",
                            name = "",
                        },
                        name_outline = {
                            order = 5,
                            name = L["Outline"],
                            type = "select",
                            values = {L["outline_option_1"] , L["outline_option_2"], L["outline_option_3"], L["outline_option_4"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                        },
                        healthbar_outline = {
                            order = 6,
                            name = L["Outline"],
                            type = "select",
                            values = {L["outline_option_1"] , L["outline_option_2"], L["outline_option_3"], L["outline_option_4"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                        },
                        powerbar_outline = {
                            order = 7,
                            name = L["Outline"],
                            type = "select",
                            values = {L["outline_option_1"] , L["outline_option_2"], L["outline_option_3"], L["outline_option_4"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                        },
                        newline2 = {
                            order = 8,
                            type = "description",
                            name = "",
                        },
                        name_size = {
                            order = 9,
                            name = L["Size"],
                            type = "range",
                            get = "GetStatus",
                            set = "SetStatus",
                            min = 1,
                            max = 40,
                            step = 1,
                        },
                        healthbar_size = {
                            order = 10,
                            name = L["Size"],
                            type = "range",
                            get = "GetStatus",
                            set = "SetStatus",
                            min = 1,
                            max = 40,
                            step = 1,
                        },
                        powerbar_size = {
                            order = 11,
                            name = L["Size"],
                            type = "range",
                            get = "GetStatus",
                            set = "SetStatus",
                            min = 1,
                            max = 40,
                            step = 1,
                        },
                    },
                },
                Player = {
                    order = 1,
                    name = L["Player"],
                    type = "group",
                    args = {
                        name_choice = {
                            order = 1,
                            name = L["Name"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        name_color = {
                            order = 2,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Player.name_choice == 2 then return false end return true end,
                            width = colorWidth,
                        },
                        newline = {
                            order = 2.1,
                            type = "description",
                            name = "",
                        },
                        healthbar_choice = {
                            order = 3,
                            name = L["Health Bar"], 
                            desc = "",
                            type = "select",
                            values = {L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        healthbar_color = {
                            order = 4,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Player.healthbar_choice == 2 then return false end return true end,
                            width = colorWidth,
                        },   
                        newline2 = {
                            order = 4.1,
                            type = "description",
                            name = "",
                        },
                        powerbar_choice = {
                            order = 5,
                            name = L["Power Bar"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        powerbar_color = {
                            order = 6,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Player.powerbar_choice == 2 then return false end return true end,
                            width = colorWidth,
                        }, 
                    },
                },
                Target = {
                    order = 2,
                    name = L["Target"],
                    type = "group",
                    args = {
                        name_choice = {
                            order = 1,
                            name = L["Name"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_6"],L["color_option_7"],L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = 1.1,
                        },  
                        name_color = {
                            order = 2,
                            name = function() local text = HealthBarColor.db.profile.Fonts.Target.name_choice == 1 and "NPC color" or "color" return text end,
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Target.name_choice == 1 or HealthBarColor.db.profile.Fonts.Target.name_choice == 4 then return false end return true end,
                            width = 0.35,
                        },
                        newline = {
                            order = 2.1,
                            type = "description",
                            name = "",
                        },
                        healthbar_choice = {
                            guiHidden = HealthBarColor.isClassic,
                            order = 3,
                            name = L["Health Bar"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_6"],L["color_option_7"],L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = 1.1,
                        },  
                        healthbar_color = {
                            guiHidden = HealthBarColor.isClassic,
                            order = 4,
                            name = function() local text = HealthBarColor.db.profile.Fonts.Target.healthbar_choice == 1 and "NPC color" or "color" return text end,
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Target.healthbar_choice == 1 or HealthBarColor.db.profile.Fonts.Target.healthbar_choice == 4 then return false end return true end,
                            width = 0.35,
                        },   
                        newline2 = {
                            order = 4.1,
                            type = "description",
                            name = "",
                        },
                        powerbar_choice = {
                            guiHidden = HealthBarColor.isClassic,
                            order = 5,
                            name = L["Power Bar"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_6"],L["color_option_7"],L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = 1.1,
                        },  
                        powerbar_color = {
                            guiHidden = HealthBarColor.isClassic,
                            order = 6,
                            name = function() local text = HealthBarColor.db.profile.Fonts.Target.powerbar_choice == 1 and "NPC color" or "color" return text end,
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Target.powerbar_choice == 1 or HealthBarColor.db.profile.Fonts.Target.powerbar_choice == 4 then return false end return true end,
                            width = 0.35,
                        }, 
                    },
                },
                Focus = {
                    guiHidden = HealthBarColor.isClassic,
                    order = 4,
                    name = L["Focus"],
                    type = "group",
                    args = {
                        name_choice = {
                            order = 1,
                            name = L["Name"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_6"],L["color_option_7"],L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = 1.1,
                        },  
                        name_color = {
                            order = 2,
                            name = function() local text = HealthBarColor.db.profile.Fonts.Focus.name_choice == 1 and "NPC color" or "color" return text end,
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Focus.name_choice == 1 or HealthBarColor.db.profile.Fonts.Focus.name_choice == 4 then return false end return true end,
                            width = 0.35,
                        },
                        newline = {
                            order = 2.1,
                            type = "description",
                            name = "",
                        },
                        healthbar_choice = {
                            order = 3,
                            name = L["Health Bar"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_6"],L["color_option_7"],L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = 1.1,
                        },  
                        healthbar_color = {
                            order = 4,
                            name = function() local text = HealthBarColor.db.profile.Fonts.Focus.healthbar_choice == 1 and "NPC color" or "color" return text end,
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Focus.healthbar_choice == 1 or HealthBarColor.db.profile.Fonts.Focus.healthbar_choice == 4 then return false end return true end,
                            width = 0.35,
                        },   
                        newline2 = {
                            order = 4.1,
                            type = "description",
                            name = "",
                        },
                        powerbar_choice = {
                            order = 5,
                            name = L["Power Bar"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_6"],L["color_option_7"],L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2,3,4},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = 1.1,
                        },  
                        powerbar_color = {
                            order = 6,
                            name = function() local text = HealthBarColor.db.profile.Fonts.Focus.powerbar_choice == 1 and "NPC color" or "color" return text end,
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Focus.powerbar_choice == 1 or HealthBarColor.db.profile.Fonts.Focus.powerbar_choice == 4 then return false end return true end,
                            width = 0.35,
                        }, 
                    },
                },
                Pet = {
                    order = 6,
                    name = L["Pet"],
                    type = "group",
                    args = {
                        name_choice = {
                            order = 1,
                            name = L["Name"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        name_color = {
                            order = 2,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Pet.name_choice == 2 then return false end return true end,
                            width = colorWidth,
                        },
                        newline = {
                            order = 2.1,
                            type = "description",
                            name = "",
                        },
                        healthbar_choice = {
                            order = 3,
                            name = L["Health Bar"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        healthbar_color = {
                            order = 4,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Pet.healthbar_choice == 2 then return false end return true end,
                            width = colorWidth,
                        },   
                        newline2 = {
                            order = 4.1,
                            type = "description",
                            name = "",
                        },
                        powerbar_choice = {
                            order = 5,
                            name = L["Power Bar"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        powerbar_color = {
                            order = 6,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Pet.powerbar_choice == 2 then return false end return true end,
                            width = colorWidth,
                        }, 
                    },
                },
                Boss = {
                    guiHidden = not HealthBarColor.isRetail,
                    order = 7,
                    name = L["Boss"],
                    type = "group",
                    args = {
                        selected = {
                            order = 1,
                            name = L["color_options"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_2"],L["color_option_3"]},
                            sorting = {1,2},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        color = {
                            order = 2,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            hidden = function() if HealthBarColor.db.profile.Fonts.Boss.selected == 2 then return false end return true end,
                            width = colorWidth,
                        },  
                    },
                },
            },
        },
        Settings = {
            order = 2,
            name = L["Enabled Modules"],
            type = "group",
            args = {
                Modules = {
                    order = 1,
                    name = L["Modules"],
                    type = "group",
                    inline = true,
                    args = {
                        Fonts = {
                            order = 1,
                            name = L["Fonts"],
                            desc = L["fonts_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                        },
                        Textures = {
                            order = 2,
                            name = L["Textures"],
                            desc = L["tex_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            guiHidden  = not HealthBarColor.isRetail,
                        },
                        BackgroundTextures = {
                            order = 3,
                            name = L["Background Texture"],
                            desc = L["bg_tex_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            guiHidden  = not HealthBarColor.isRetail,
                        },
                        DebuffColor = {
                            order = 4,
                            name = L["DebuffColor"],
                            desc = L["debuff_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            guiHidden  = not HealthBarColor.isRetail,
                        },
                        PartyColor = {
                            order = 5,
                            name = L["PartyColor"],
                            desc = L["party_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            guiHidden  = not HealthBarColor.isRetail,
                        },
                        Glow = {
                            order = 6,
                            name = L["Glow"],
                            desc = L["glow_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            guiHidden  = not HealthBarColor.isRetail,
                        },
                        HideClassPowerBar = {
                            order = 7,
                            name = L["HideClassPowerBar"],
                            desc = L["hide_power_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            guiHidden  = not HealthBarColor.isRetail,
                        },
                        BiggerHealthBar = {
                            order = 8,
                            name = L["BiggerHealthBar"],
                            desc = L["bigger_hb_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                           -- guiHidden = not HealthBarColor.isRetail,
                        },
                        Overabsorb = {
                            order = 9,
                            name = L["Overabsorb"],
                            desc = L["overabsorb_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            guiHidden = not HealthBarColor.isRetail,
                        },
                        DarkFrames = {
                            order = 10,
                            name = L["Dark Frames"],
                            desc = L["dark_frames_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                        },
                    },
                },
                ClassColorOverwrites = {
                    order = 2,
                    name = L["Overwrite Class Colors"],
                    type = "group",
                    inline = true,
                    args = {
                        enabled = {
                            order = 1,
                            name = L["Custom Class Colors"],
                            desc = L["custom_class_color_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                        },
                        newline = {
                            order = 1.1,
                            type = "description",
                            name = "",
                        },
                        deathknight = {
                            order = 2,
                            name = L["DK"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            guiHidden  = HealthBarColor.isClassic,
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        demonhunter = {
                            order = 3,
                            name = L["DH"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            guiHidden  = not HealthBarColor.isRetail,
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        druid = {
                            order = 4,
                            name = L["DRUID"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        evoker = {
                            order = 5,
                            name = L["EVO"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            guiHidden  = not HealthBarColor.isRetail,
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        hunter = {
                            order = 6,
                            name = L["HUNT"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        mage = {
                            order = 7,
                            name = L["MAGE"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        monk = {
                            order = 8,
                            name = L["MONK"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            guiHidden  = not HealthBarColor.isRetail,
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        paladin = {
                            order = 9,
                            name = L["PAL"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        priest = {
                            order = 10,
                            name = L["PRST"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        rogue = {
                            order = 11,
                            name = L["ROG"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        shaman = {
                            order = 12,
                            name = L["SHAM"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        warlock = {
                            order = 13,
                            name = L["WL"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        warrior = {
                            order = 14,
                            name = L["WAR"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                        newline2 = {
                            order = 15,
                            type = "description",
                            name = "",
                        },
                        ResetColors = {
                            order = 16,
                            name = L["reset"],
                            desc = L["to default"],
                            type = "execute",
                            width = 0.4,
                            func = 
                            function() 
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.deathknight   = {r=0.77,g=0.12,b=0.23}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.demonhunter   = {r=0.64,g=0.19,b=0.79}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.druid         = {r=1.00,g=0.49,b=0.04}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.evoker        = {r=0.20,g=0.58,b=0.50}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.hunter        = {r=0.67,g=0.83,b=0.45}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.mage          = {r=0.25,g=0.78,b=0.923}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.monk          = {r=0.00,g=1.00,b=0.60}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.paladin       = {r=0.96,g=0.55,b=0.73}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.priest        = {r=1.00,g=1.00,b=1.00}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.rogue         = {r=1.00,g=0.96,b=0.41}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.shaman        = {r=0.00,g=0.44,b=0.87}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.warlock       = {r=0.53,g=0.53,b=0.9}
                                HealthBarColor.db.profile.Settings.ClassColorOverwrites.warrior       = {r=0.78,g=0.61,b=0.43}
                                HealthBarColor:ReloadConfig()
                            end,
                            disabled = function() return not HealthBarColor.db.profile.Settings.ClassColorOverwrites.enabled end,
                        },
                    },
                },
                ReactionColorOverwrites = {
                    order = 3,
                    name = L["Overwrite Reaction Colors"],
                    type = "group",
                    inline = true,
                    args = {
                        enabled = {
                            order = 1,
                            name = L["Custom Reaction Colors"],
                            desc = "",
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            width = 1.2,
                        },
                        newline = {
                            order = 1.1,
                            type = "description",
                            name = "",
                        },
                        hostile = {
                            order = 2,
                            name = L["Hostile"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ReactionColorOverwrites.enabled end,
                            width = 0.6,
                        },
                        neutral = {
                            order = 3,
                            name = L["Neutral"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ReactionColorOverwrites.enabled end,
                            width = 0.6,
                        },
                        friendly = {
                            order = 4,
                            name = L["Friendly"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            disabled = function() return not HealthBarColor.db.profile.Settings.ReactionColorOverwrites.enabled end,
                            width = 0.6,
                        },
                        newline2 = {
                            order = 5,
                            type = "description",
                            name = "",
                        },
                        ResetColors = {
                            order = 6,
                            name = L["reset"],
                            desc = L["to default"],
                            type = "execute",
                            width = 0.4,
                            func = 
                            function() 
                                HealthBarColor.db.profile.Settings.ReactionColorOverwrites.hostile  = {r=1,g=0,b=0}
                                HealthBarColor.db.profile.Settings.ReactionColorOverwrites.neutral  = {r=1,g=1,b=0}
                                HealthBarColor.db.profile.Settings.ReactionColorOverwrites.friendly = {r=0,g=1,b=0}
                                HealthBarColor:ReloadConfig()
                            end,
                            disabled = function() return not HealthBarColor.db.profile.Settings.ReactionColorOverwrites.enabled end,
                        },
                    },
                }
            },
        },
        Modules = {
            order = 3,
            name = L["Module Settings"],
            type = "group",
            hidden  = function() return not ((HealthBarColor.db.profile.Settings.Modules.Textures or HealthBarColor.db.profile.Settings.Modules.BackgroundTextures or HealthBarColor.db.profile.Settings.Modules.DebuffColor or HealthBarColor.db.profile.Settings.Modules.Glow)) or not HealthBarColor.isRetail end,
            args = {
                Textures = {
                    order = 1,
                    name = L["Textures"],
                    type = "group",
                    inline = true,
                    hidden  = (function() return not HealthBarColor.db.profile.Settings.Modules.Textures end) or not HealthBarColor.isRetail,
                    args = {
                        healthbar = {
                            order = 1,
                            type = "select",
                            name = L["Health Bar"],
                            values = statusbars,
                            get = function()
                                for i, v in next, statusbars do
                                    if v == HealthBarColor.db.profile.Modules.Textures.healthbar then return i end
                                end
                            end,
                            set = function(_, value)
                                HealthBarColor.db.profile.Modules.Textures.healthbar  = statusbars[value]
                                HealthBarColor:ReloadConfig()
                            end,
                          itemControl = "DDI-Statusbar",
                          width = statusBarWidth,
                        },
                        powerbar = {
                            order = 2,
                            type = "select",
                            name = L["Power Bar"],
                            values = statusbars,
                            get = function()
                                for i, v in next, statusbars do
                                    if v == HealthBarColor.db.profile.Modules.Textures.powerbar then return i end
                                end
                            end,
                            set = function(_, value)
                                HealthBarColor.db.profile.Modules.Textures.powerbar  = statusbars[value]
                                HealthBarColor:ReloadConfig()
                            end,
                          itemControl = "DDI-Statusbar",
                          width = statusBarWidth,
                          disabled  = function() return HealthBarColor.db.profile.Modules.Textures.excludep end,
                        },
                        excludep = {
                            order = 3,
                            name = "Exclude",
                            desc = L["excludep_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                            width = 0.5,
                        },
                    },
                },
                BackgroundTextures = {
                    order = 2,
                    name = L["Background Texture"],
                    type = "group",
                    inline = true,
                    hidden = (function() return not HealthBarColor.db.profile.Settings.Modules.BackgroundTextures end) or not HealthBarColor.isRetail,
                    args = {
                        texture = {
                            order = 1,
                            type = "select",
                            name = L["Texture"],
                            values = statusbars,
                            get = function()
                                for i, v in next, statusbars do
                                    if v == HealthBarColor.db.profile.Modules.BackgroundTextures.texture then return i end
                                end
                            end,
                            set = function(_, value)
                                HealthBarColor.db.profile.Modules.BackgroundTextures.texture  = statusbars[value]
                                HealthBarColor:ReloadConfig()
                            end,
                          itemControl = "DDI-Statusbar",
                          width = statusBarWidth,
                        },
                        color = {
                            order = 2,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            width = colorWidth,
                        },  
                    },
                },
                DebuffColor = {
                    order = 3,
                    name = L["debuff_color_name"],
                    type = "group",
                    inline = true,
                    hidden  = (function() return not HealthBarColor.db.profile.Settings.Modules.DebuffColor end) or not HealthBarColor.isRetail,
                    args = {
                        Curse = {
                            order = 1,
                            name = L["Curse"],
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            width = 0.5,
                        },
                        Disease = {
                            order = 2,
                            name = L["Disease"],
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            width = 0.5,
                        },
                        Magic = {
                            order = 3,
                            name = L["Magic"],
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            width = 0.5,
                        },
                        Poison = {
                            order = 4,
                            name = L["Poison"],
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            width = 0.5,
                        },
                        ignoreMagic = {
                            order = 5,
                            name = L["ignore_magic_name"],
                            desc = L["ignore_magic_desc"],
                            type = "toggle",
                            get = "GetStatus",
                            set = "SetStatus",
                        },
                        newline2 = {
                            order = 6,
                            type = "description",
                            name = "",
                        },
                        ResetColors = {
                            order = 8,
                            name = L["reset"],
                            desc = L["to default"],
                            type = "execute",
                            width = 0.4,
                            func = 
                            function() 
                                HealthBarColor.db.profile.Modules.DebuffColor.Curse   = {r=0.6,g=0.0,b=1.0}
                                HealthBarColor.db.profile.Modules.DebuffColor.Disease = {r=0.6,g=0.4,b=0.0}
                                HealthBarColor.db.profile.Modules.DebuffColor.Magic   = {r=0.2,g=0.6,b=1.0}
                                HealthBarColor.db.profile.Modules.DebuffColor.Poison  = {r=0.0,g=0.6,b=0.0}
                                HealthBarColor:ReloadConfig()
                            end,
                        },
                    },
                },
                Glow = {
                    order = 4,
                    name = L["Glow"],
                    type = "group",
                    inline = true,
                    hidden  = (function() return not HealthBarColor.db.profile.Settings.Modules.Glow end) or not HealthBarColor.isRetail,
                    args = {
                        player = {
                            order = 1,
                            name = L["Player"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_2"],L["color_option_3"],L["color_option_5"]},
                            sorting = {1,2,3},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },  
                        player_static_color = {
                            order = 1.1,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            width = colorWidth,
                            hidden  = function() if HealthBarColor.db.profile.Modules.Glow.player == 2 then return false end return true end,
                        }, 
                        target = {
                            order = 2,
                            name = L["Target"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_1"],L["color_option_3"],L["color_option_5"]},
                            sorting = {1,2,3},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },
                        target_static_color = {
                            order = 2.1,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            width = colorWidth,
                            hidden  = function() if HealthBarColor.db.profile.Modules.Glow.target == 2 then return false end return true end,
                        }, 
                        focus = {
                            order = 3,
                            name = L["Focus"],
                            desc = "",
                            type = "select",
                            values = {L["color_option_1"],L["color_option_3"],L["color_option_5"]},
                            sorting = {1,2,3},
                            get = "GetStatus",
                            set = "SetStatus",
                            width = selectedWidth,
                        },    
                        focus_static_color = {
                            order = 3.1,
                            name = L["color"],
                            desc = "",
                            type = "color",
                            get = "GetColor",
                            set = "SetColor",
                            width = colorWidth,
                            hidden  = function() if HealthBarColor.db.profile.Modules.Glow.focus == 2 then return false end return true end,
                        }, 
                    },
                },
            },
        },
        ProfileSettings = {
            order = lastEntry,
            name = L["profiles_entry"],
            type = "group",
            childGroups = "tab",
            args = {
                ImportExportPofile = {
                    order = 2,
                    name = L["share_profile_title"],
                    type = "group",
                    args = {
                        Header = {
                            order = 1,
                            name = L["share_profile_header"],
                            type = "header",
                        },
                        Desc = {
                            order = 2,
                            name = L["share_profile_desc_row1"] .. "\n" .. L["share_profile_desc_row2"],
                            fontSize = "medium",
                            type = "description",
                        },
                        Textfield = {
                            order = 3,
                            name = L["share_profile_input_name"],
                            desc = L["share_profile_input_desc"],
                            type = "input",
                            multiline = 20,
                            width = "full",
                            confirm = function() return L["share_profile_input_desc"] end,
                            get = function() return HealthBarColor:ShareProfile() end,
                            set = function(self, input) HealthBarColor:ImportProfile(input); ReloadUI() end, 
                        },
                    },
                },
            },
        },
    },
}

function HealthBarColor:GetOptionsTable()
    return options
end