local MDT = MDT
local L = MDT.L
local dungeonIndex = 48
MDT.dungeonList[dungeonIndex] = L["BrackenhideHollow"]
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides = {
  }
};

local zones = { 2096, 2106 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "BrackenHideHollow",
  [1] = "BrackenHideHollow",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["BrackenhideHollow"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 723, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 78.221439342171,
      ["y"] = -237.35277751127,
      ["graveyardDescription"] = "",
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Vicious Hyena",
    ["id"] = 185691,
    ["count"] = 3,
    ["health"] = 691868,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 10270,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [368091] = {
      },
      [384970] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 108.61163534958,
        ["y"] = -215.72788918496,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 156.4,
        ["y"] = -199.9,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 161.3,
            ["y"] = -210.9,
          },
          [2] = {
            ["x"] = 159.4,
            ["y"] = -211.4,
          },
          [3] = {
            ["x"] = 158,
            ["y"] = -199.7,
          },
          [4] = {
            ["x"] = 146.8,
            ["y"] = -185,
          },
          [5] = {
            ["x"] = 168.8,
            ["y"] = -180.9,
          },
          [6] = {
            ["x"] = 169.2,
            ["y"] = -183.3,
          },
          [7] = {
            ["x"] = 151.7,
            ["y"] = -186.3,
          },
          [8] = {
            ["x"] = 160.9,
            ["y"] = -198.2,
          },
          [9] = {
            ["x"] = 162.2,
            ["y"] = -210,
          },
          [10] = {
            ["x"] = 161.4,
            ["y"] = -210.9,
          },
        },
      },
      [3] = {
        ["x"] = 227.83740416766,
        ["y"] = -237.50432638724,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 260.3208514453,
        ["y"] = -235.89214846462,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 257.94173055489,
        ["y"] = -242.79295661978,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 205.7,
        ["y"] = -130.9,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 176.5,
        ["y"] = -109.7,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 193.85123298096,
        ["y"] = -91.025219328971,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 127.3,
        ["y"] = -173.3,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 134.77561649048,
        ["y"] = -174.33739725159,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 137.50432638724,
        ["y"] = -168.28265295463,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 322,
        ["y"] = -312.7,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 327.3,
        ["y"] = -317.2,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 481,
        ["y"] = -341,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 519.03558466492,
        ["y"] = -265.377981515,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 524.89832990562,
        ["y"] = -261.5220330326,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 527.00848227954,
        ["y"] = -269.51695001147,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 526.2,
        ["y"] = -278.15761857677,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 491.67966615698,
        ["y"] = -242.83897577027,
        ["g"] = 72,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 497,
            ["y"] = -217.2,
          },
          [2] = {
            ["x"] = 500.7,
            ["y"] = -217.4,
          },
          [3] = {
            ["x"] = 497.2,
            ["y"] = -252.2,
          },
          [4] = {
            ["x"] = 493.7,
            ["y"] = -251.8,
          },
          [5] = {
            ["x"] = 496.9,
            ["y"] = -217.1,
          },
        },
      },
      [20] = {
        ["x"] = 492.30167009438,
        ["y"] = -252.05762585057,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 498.92541774341,
        ["y"] = -251.26780731969,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 500.01018146911,
        ["y"] = -241.91186611109,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 451.64236775488,
        ["y"] = -282.38134352515,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 444.64406694446,
        ["y"] = -280.45763951892,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 439.92541774341,
        ["y"] = -286.477981515,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 446.83558466492,
        ["y"] = -289.45932504015,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 390.95819949391,
        ["y"] = -187.280680937,
        ["g"] = 64,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 416.4,
            ["y"] = -190,
          },
          [2] = {
            ["x"] = 396.6,
            ["y"] = -188.8,
          },
          [3] = {
            ["x"] = 376,
            ["y"] = -197.4,
          },
          [4] = {
            ["x"] = 364.5,
            ["y"] = -213.3,
          },
          [5] = {
            ["x"] = 368.3,
            ["y"] = -215.3,
          },
          [6] = {
            ["x"] = 378.5,
            ["y"] = -199.5,
          },
          [7] = {
            ["x"] = 397.3,
            ["y"] = -191.5,
          },
          [8] = {
            ["x"] = 417.5,
            ["y"] = -192.7,
          },
          [9] = {
            ["x"] = 416.4,
            ["y"] = -190,
          },
        },
      },
      [28] = {
        ["x"] = 361.2,
        ["y"] = -199.5,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Bonebolt Hunter",
    ["id"] = 185534,
    ["count"] = 5,
    ["health"] = 790706,
    ["scale"] = 1,
    ["displayId"] = 105689,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Incapacitate"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [367521] = {
      },
      [368287] = {
      },
      [368297] = {
      },
      [368299] = {
      },
      [382620] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 114.24651779582,
        ["y"] = -220.31394981845,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 159.3,
        ["y"] = -198.6,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 223.41085778862,
        ["y"] = -245.58428309709,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 257.67124860681,
        ["y"] = -228.08619885099,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 250.45312107057,
        ["y"] = -240.87209825841,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 222.7,
        ["y"] = -182,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 218.8,
        ["y"] = -185.2,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 208.7,
        ["y"] = -133.9,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 154.8,
        ["y"] = -148.8,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 148.5,
        ["y"] = -137.9,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 169.55312107057,
        ["y"] = -110.36260966449,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 153,
            ["y"] = -112.4,
          },
          [2] = {
            ["x"] = 153.7,
            ["y"] = -114.6,
          },
          [3] = {
            ["x"] = 174,
            ["y"] = -102.3,
          },
          [4] = {
            ["x"] = 173.4,
            ["y"] = -122,
          },
          [5] = {
            ["x"] = 175.8,
            ["y"] = -121.4,
          },
          [6] = {
            ["x"] = 176.6,
            ["y"] = -98.9,
          },
          [7] = {
            ["x"] = 153,
            ["y"] = -112.5,
          },
        },
      },
      [12] = {
        ["x"] = 189.3,
        ["y"] = -86.6,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 130.49131956124,
        ["y"] = -164.98184479947,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 324.2,
        ["y"] = -314.8,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 473.48071338934,
        ["y"] = -339.53284665414,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 491.5,
        ["y"] = -308.8,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 519.18983307849,
        ["y"] = -273.50509117418,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 464.52374764903,
        ["y"] = -248.54068223365,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 458.66101695593,
        ["y"] = -249.99491609962,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 399.49394999706,
        ["y"] = -210.18643995652,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 366.66655923221,
        ["y"] = -195.1669777287,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 359.35964330533,
        ["y"] = -227.88502048435,
        ["g"] = 61,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 353.3,
            ["y"] = -222.6,
          },
          [2] = {
            ["x"] = 362.9,
            ["y"] = -215.5,
          },
          [3] = {
            ["x"] = 365.9,
            ["y"] = -217.3,
          },
          [4] = {
            ["x"] = 356.1,
            ["y"] = -225.5,
          },
          [5] = {
            ["x"] = 353.3,
            ["y"] = -222.7,
          },
        },
      },
    },
  },
  [3] = {
    ["name"] = "Cruel Bonecrusher",
    ["id"] = 186206,
    ["count"] = 5,
    ["health"] = 1087222,
    ["scale"] = 1,
    ["displayId"] = 105688,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [382593] = {
      },
      [382723] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 94.2,
        ["y"] = -211.6,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 128.6,
        ["y"] = -215.1,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 127.8,
            ["y"] = -214.9,
          },
          [2] = {
            ["x"] = 140.4,
            ["y"] = -206.4,
          },
          [3] = {
            ["x"] = 139.1,
            ["y"] = -204.9,
          },
          [4] = {
            ["x"] = 126.6,
            ["y"] = -213.1,
          },
          [5] = {
            ["x"] = 128,
            ["y"] = -214.9,
          },
        },
      },
      [3] = {
        ["x"] = 129.12838409309,
        ["y"] = -189.09875173936,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 104.5,
            ["y"] = -210.3,
          },
          [2] = {
            ["x"] = 107.4,
            ["y"] = -211.4,
          },
          [3] = {
            ["x"] = 169.5,
            ["y"] = -163.5,
          },
          [4] = {
            ["x"] = 162.8,
            ["y"] = -152.7,
          },
          [5] = {
            ["x"] = 161.1,
            ["y"] = -154,
          },
          [6] = {
            ["x"] = 166.9,
            ["y"] = -162.7,
          },
          [7] = {
            ["x"] = 104.7,
            ["y"] = -209.8,
          },
        },
      },
      [4] = {
        ["x"] = 131.77400524506,
        ["y"] = -196.03933729969,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 190.2,
        ["y"] = -220.4,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 224.30079432302,
        ["y"] = -206.14605694213,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 246.4,
        ["y"] = -186.2,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 262.7,
        ["y"] = -197.3,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 266.5,
        ["y"] = -201.8,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 244.3,
        ["y"] = -151,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 244,
            ["y"] = -151.9,
          },
          [2] = {
            ["x"] = 248.5,
            ["y"] = -159,
          },
          [3] = {
            ["x"] = 249.6,
            ["y"] = -158,
          },
          [4] = {
            ["x"] = 245.5,
            ["y"] = -151,
          },
          [5] = {
            ["x"] = 244.1,
            ["y"] = -151.9,
          },
        },
      },
      [11] = {
        ["x"] = 209.1,
        ["y"] = -186.1,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 214.8,
            ["y"] = -185.5,
          },
          [2] = {
            ["x"] = 216.2,
            ["y"] = -187.6,
          },
          [3] = {
            ["x"] = 204.9,
            ["y"] = -187,
          },
          [4] = {
            ["x"] = 198.6,
            ["y"] = -180.7,
          },
          [5] = {
            ["x"] = 200.5,
            ["y"] = -179.7,
          },
          [6] = {
            ["x"] = 206,
            ["y"] = -184.8,
          },
          [7] = {
            ["x"] = 214.3,
            ["y"] = -185.5,
          },
        },
      },
      [12] = {
        ["x"] = 158.8,
        ["y"] = -140,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 171.47561649048,
        ["y"] = -124.85908451634,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 411.7,
        ["y"] = -246.2,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 188.73387884925,
        ["y"] = -197.85676507865,
        ["g"] = 92,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Claw Fighter",
    ["id"] = 185508,
    ["count"] = 5,
    ["health"] = 889545,
    ["scale"] = 1,
    ["displayId"] = 105631,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
      [367484] = {
      },
      [367485] = {
      },
      [384150] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 96.3,
        ["y"] = -186.8,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 102.7,
        ["y"] = -186.4,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 106.2,
        ["y"] = -190.1,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 142.1287237289,
        ["y"] = -213.45826252903,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 142.33387210344,
        ["y"] = -205.85312107057,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 161.8,
        ["y"] = -218.6,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 169.30811371379,
        ["y"] = -222.89905925471,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 192.6,
        ["y"] = -225.9,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 188.9,
        ["y"] = -213.4,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 234.12954571621,
        ["y"] = -243.46692913565,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 274.4,
        ["y"] = -192.2,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 269.4,
        ["y"] = -188.9,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 221.3,
        ["y"] = -157.5,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 207.8,
        ["y"] = -175.1,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 198,
        ["y"] = -177.5,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 169.96611406441,
        ["y"] = -143.98266678677,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 168.4574474578,
        ["y"] = -151.09567361276,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 166.1,
        ["y"] = -119.6,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 178.5,
        ["y"] = -119.4,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 196.80948859392,
        ["y"] = -85.8287237289,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 157,
        ["y"] = -97.1,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 147.9,
            ["y"] = -99.2,
          },
          [2] = {
            ["x"] = 148.4,
            ["y"] = -100.5,
          },
          [3] = {
            ["x"] = 170.6,
            ["y"] = -93.3,
          },
          [4] = {
            ["x"] = 169.7,
            ["y"] = -91.6,
          },
          [5] = {
            ["x"] = 148,
            ["y"] = -99.2,
          },
        },
      },
      [22] = {
        ["x"] = 142.46259583234,
        ["y"] = -101.60351823207,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 340.81371963801,
        ["y"] = -307.97055302884,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 201.27876445493,
        ["y"] = -204.94079589091,
        ["g"] = 93,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 180.19930113681,
        ["y"] = -195.05215298122,
        ["g"] = 92,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Bracken Warscourge",
    ["id"] = 185529,
    ["count"] = 15,
    ["health"] = 1581412,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 105677,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
      [367500] = {
      },
      [367510] = {
      },
      [367511] = {
      },
      [382555] = {
      },
      [382556] = {
      },
      [387796] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 104.5,
        ["y"] = -180.5,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 104.1,
            ["y"] = -180.3,
          },
          [2] = {
            ["x"] = 119.4,
            ["y"] = -198.6,
          },
        },
      },
      [2] = {
        ["x"] = 166.17903190187,
        ["y"] = -212.20272486701,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 195.6,
        ["y"] = -221.2,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 233.5,
        ["y"] = -190,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 268.2,
        ["y"] = -194.8,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 251.7,
        ["y"] = -232,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 225.1,
        ["y"] = -148,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 244.2,
            ["y"] = -157.2,
          },
          [2] = {
            ["x"] = 244.5,
            ["y"] = -159.4,
          },
          [3] = {
            ["x"] = 228.1,
            ["y"] = -158.2,
          },
          [4] = {
            ["x"] = 221.1,
            ["y"] = -134.2,
          },
          [5] = {
            ["x"] = 208.3,
            ["y"] = -123.8,
          },
          [6] = {
            ["x"] = 213.2,
            ["y"] = -117,
          },
          [7] = {
            ["x"] = 215.2,
            ["y"] = -118.6,
          },
          [8] = {
            ["x"] = 211.5,
            ["y"] = -123.6,
          },
          [9] = {
            ["x"] = 223.2,
            ["y"] = -132.2,
          },
          [10] = {
            ["x"] = 230,
            ["y"] = -155.9,
          },
          [11] = {
            ["x"] = 244.1,
            ["y"] = -157.1,
          },
        },
      },
      [9] = {
        ["x"] = 210.40947476178,
        ["y"] = -118.40434021938,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 195.2,
        ["y"] = -187.8,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 176.5,
            ["y"] = -179.6,
          },
          [2] = {
            ["x"] = 197.9,
            ["y"] = -190.5,
          },
          [3] = {
            ["x"] = 219.7,
            ["y"] = -200.6,
          },
          [4] = {
            ["x"] = 238.9,
            ["y"] = -201.8,
          },
          [5] = {
            ["x"] = 239,
            ["y"] = -199.6,
          },
          [6] = {
            ["x"] = 220.6,
            ["y"] = -198.5,
          },
          [7] = {
            ["x"] = 198.8,
            ["y"] = -188.5,
          },
          [8] = {
            ["x"] = 178.3,
            ["y"] = -177.3,
          },
          [9] = {
            ["x"] = 176.6,
            ["y"] = -179.6,
          },
        },
      },
      [11] = {
        ["x"] = 174.2287237289,
        ["y"] = -148.91652505807,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 142.41653889021,
        ["y"] = -121.98429001317,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 136.63658909643,
        ["y"] = -106.58697934186,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 510.82214178116,
        ["y"] = -318.95963519224,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 434.3,
        ["y"] = -254.4,
        ["g"] = 67,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 434.2,
            ["y"] = -236.2,
          },
          [2] = {
            ["x"] = 431.8,
            ["y"] = -269.5,
          },
          [3] = {
            ["x"] = 433.7,
            ["y"] = -269.4,
          },
          [4] = {
            ["x"] = 435.7,
            ["y"] = -236.3,
          },
          [5] = {
            ["x"] = 434.1,
            ["y"] = -236.2,
          },
        },
      },
      [16] = {
        ["x"] = 545,
        ["y"] = -225.3,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 548.3,
            ["y"] = -218.3,
          },
          [2] = {
            ["x"] = 568.6,
            ["y"] = -225.2,
          },
          [3] = {
            ["x"] = 569.3,
            ["y"] = -241.2,
          },
          [4] = {
            ["x"] = 570.4,
            ["y"] = -256.6,
          },
          [5] = {
            ["x"] = 554.4,
            ["y"] = -248.9,
          },
          [6] = {
            ["x"] = 545.6,
            ["y"] = -235.4,
          },
          [7] = {
            ["x"] = 545,
            ["y"] = -222.2,
          },
          [8] = {
            ["x"] = 548.2,
            ["y"] = -218.3,
          },
        },
      },
      [18] = {
        ["x"] = 572.63807702207,
        ["y"] = -280.37479509468,
        ["g"] = 82,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 575.1,
        ["y"] = -405.5,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 597.44746532361,
        ["y"] = -361.9152580957,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 605.58984762609,
        ["y"] = -362.9152580957,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 622.8,
        ["y"] = -312.8,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 622.8,
            ["y"] = -312.8,
          },
          [2] = {
            ["x"] = 606.32116221251,
            ["y"] = -288.20814407903,
          },
          [3] = {
            ["x"] = 602.99410946443,
            ["y"] = -289.99963739977,
          },
          [4] = {
            ["x"] = 618.00853990405,
            ["y"] = -314.22748786219,
          },
        },
      },
      [23] = {
        ["x"] = 619.49989493622,
        ["y"] = -242.13019577323,
        ["g"] = 91,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 614.70327876777,
            ["y"] = -242.54547569033,
          },
          [2] = {
            ["x"] = 589.53344878847,
            ["y"] = -262.28353612152,
          },
          [3] = {
            ["x"] = 594.31388505609,
            ["y"] = -264.36199210206,
          },
          [4] = {
            ["x"] = 617.12,
            ["y"] = -245.15,
          },
        },
      },
      [24] = {
        ["x"] = 123.43122629716,
        ["y"] = -196.43560462157,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Trickclaw Mystic",
    ["id"] = 185528,
    ["count"] = 5,
    ["health"] = 840125,
    ["scale"] = 1,
    ["displayId"] = 105636,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [376800] = {
      },
      [382249] = {
      },
      [382410] = {
      },
      [382412] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 135.71653889021,
        ["y"] = -209.78699317401,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 154.93077117942,
        ["y"] = -222.67871207951,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 208.24194334236,
        ["y"] = -208.44332929182,
        ["g"] = 93,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 230.85736338967,
        ["y"] = -250.35297968093,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 229.33466642646,
        ["y"] = -213.1346802586,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 248.4,
        ["y"] = -177.6,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 244.2,
        ["y"] = -181.3,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 217.5,
        ["y"] = -158.1,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 246.3,
        ["y"] = -161.3,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 251.5,
        ["y"] = -158.5,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 188.5,
        ["y"] = -129.4,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 204.3,
        ["y"] = -135.9,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 183.27563032262,
        ["y"] = -148.65828327725,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 214.8983136678,
        ["y"] = -113.2010055785,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 179.20785845145,
        ["y"] = -171.55473738089,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 186.64173055489,
        ["y"] = -173.14173055489,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 160.3,
        ["y"] = -130.6,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 183.70868043876,
        ["y"] = -104.24605694213,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 181.1,
        ["y"] = -97.6,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 188.32954571621,
        ["y"] = -99.637404167659,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 173.4,
        ["y"] = -91.8,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 140.89133339339,
        ["y"] = -110.57046119987,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 203.1,
        ["y"] = -96.6,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 336.52515824001,
        ["y"] = -315.66163235961,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Bracken Warscourge",
    ["id"] = 195135,
    ["count"] = 15,
    ["health"] = 1580808,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 105677,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["spells"] = {
      [367481] = {
      },
      [367500] = {
      },
      [367510] = {
      },
      [367511] = {
      },
      [382555] = {
      },
      [382556] = {
      },
    },
    ["clones"] = {
      [2] = {
        ["x"] = 431.9,
        ["y"] = -208,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Decay Speaker",
    ["id"] = 186191,
    ["count"] = 15,
    ["health"] = 1186059,
    ["scale"] = 1,
    ["displayId"] = 105637,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["spells"] = {
      [367503] = {
      },
      [367504] = {
      },
      [382435] = {
      },
      [382474] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 161.45870063342,
        ["y"] = -227.15247641138,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 223.53036770351,
        ["y"] = -213.75554553605,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 244.8,
        ["y"] = -177.7,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 228.1,
        ["y"] = -147,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 192.1,
        ["y"] = -141.5,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 183.80784461931,
        ["y"] = -164.2365960125,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 145.99214154855,
        ["y"] = -106.69133339339,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 209.66343165179,
        ["y"] = -99.316525058068,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 331.7817629402,
        ["y"] = -310.4182370598,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Fishface",
    ["id"] = 191926,
    ["count"] = 30,
    ["health"] = 1716607,
    ["scale"] = 1,
    ["displayId"] = 107685,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["clones"] = {
      [1] = {
        ["x"] = 131.1,
        ["y"] = -89.9,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Gashtooth",
    ["id"] = 186124,
    ["count"] = 0,
    ["health"] = 3556818,
    ["scale"] = 1,
    ["displayId"] = 105695,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2471,
    ["instanceID"] = 1196,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [377996] = {
      },
      [378020] = {
      },
      [378029] = {
      },
      [378208] = {
      },
      [378229] = {
      },
      [378230] = {
      },
      [378235] = {
      },
      [381379] = {
      },
      [381387] = {
      },
      [381694] = {
      },
      [389788] = {
      },
      [389808] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 310.89135905405,
        ["y"] = -222.85976753143,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Rira Hackclaw",
    ["id"] = 186122,
    ["count"] = 0,
    ["health"] = 3556818,
    ["scale"] = 1,
    ["displayId"] = 105696,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2471,
    ["instanceID"] = 1196,
    ["spells"] = {
      [377807] = {
      },
      [377830] = {
      },
      [377844] = {
      },
      [381416] = {
      },
      [381419] = {
      },
      [381444] = {
      },
      [381461] = {
      },
      [381834] = {
      },
      [381835] = {
      },
      [389788] = {
      },
      [389808] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 320.59044795502,
        ["y"] = -235.50430709501,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Tricktotem",
    ["id"] = 186125,
    ["count"] = 0,
    ["health"] = 3556818,
    ["scale"] = 1,
    ["displayId"] = 105697,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2471,
    ["instanceID"] = 1196,
    ["spells"] = {
      [377950] = {
      },
      [377965] = {
      },
      [378155] = {
      },
      [381470] = {
      },
      [389788] = {
      },
      [389808] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 305.8334939861,
        ["y"] = -238.21280162506,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Decaying Slime",
    ["id"] = 189299,
    ["count"] = 1,
    ["health"] = 197676,
    ["scale"] = 0.4,
    ["displayId"] = 104893,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [375614] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 366.92950065706,
        ["y"] = -272.45586910657,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 364.6,
        ["y"] = -275,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 366.2,
        ["y"] = -277.7,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 369,
        ["y"] = -275.4,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 404.14292016057,
        ["y"] = -313.32829973538,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 410.48513939047,
        ["y"] = -316.9568396551,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 407.12829973538,
        ["y"] = -316.31391949453,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 415.77121989595,
        ["y"] = -346.85732002377,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 414.1,
        ["y"] = -349.7,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 409.3,
        ["y"] = -351.6,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 404.8,
        ["y"] = -355.3,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 400.9,
        ["y"] = -360,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 450.5,
        ["y"] = -371.1,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 446.57196007131,
        ["y"] = -372.25685927744,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 446.45754058576,
        ["y"] = -368.8717100758,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 340.7,
        ["y"] = -347.1,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 344.9,
        ["y"] = -350.1,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 389.8,
        ["y"] = -350.6,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 394.3,
        ["y"] = -347.3,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 412.9,
        ["y"] = -497.5,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 420.9,
        ["y"] = -499.2,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Brackenhide Shaper",
    ["id"] = 186220,
    ["count"] = 5,
    ["health"] = 632566,
    ["scale"] = 1,
    ["displayId"] = 105700,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Silence"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [372711] = {
      },
      [373024] = {
      },
      [373698] = {
      },
      [373804] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 360.75730040142,
        ["y"] = -279.59930888051,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 356.3287997264,
        ["y"] = -273.65609947974,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 351.39953925367,
        ["y"] = -295.35756020811,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 345.2,
            ["y"] = -283.2,
          },
          [2] = {
            ["x"] = 372.8,
            ["y"] = -311.3,
          },
          [3] = {
            ["x"] = 375.5,
            ["y"] = -309.2,
          },
          [4] = {
            ["x"] = 348.4,
            ["y"] = -281,
          },
          [5] = {
            ["x"] = 345.2,
            ["y"] = -283.2,
          },
        },
      },
      [4] = {
        ["x"] = 383.27071990493,
        ["y"] = -312.67146008028,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 379.97099933396,
        ["y"] = -316.48585994348,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 401.63780449766,
        ["y"] = -338.72164201528,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 406.1143998632,
        ["y"] = -332.87121989595,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 413.51438024085,
        ["y"] = -304.44173886123,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 417.98658049649,
        ["y"] = -310.77073952727,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 342.4,
        ["y"] = -342.8,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 346.6,
        ["y"] = -345.1,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 352.3,
        ["y"] = -392.76211798867,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 403.27075103761,
        ["y"] = -373.93166533885,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 409.7889505746,
        ["y"] = -375.17554778406,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 417.1,
        ["y"] = -483.1,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 425.2,
        ["y"] = -482.8,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 434.4,
        ["y"] = -468.9,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 431.9,
        ["y"] = -475.6,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 472.2,
        ["y"] = -358.1,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 452.8,
        ["y"] = -342.2,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 453.60605000294,
        ["y"] = -335.19106237421,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 461.45070567954,
        ["y"] = -335.27464716023,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Decayed Elder",
    ["id"] = 189531,
    ["count"] = 5,
    ["health"] = 988383,
    ["scale"] = 1,
    ["displayId"] = 107352,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [373024] = {
      },
      [373897] = {
      },
      [373899] = {
      },
      [383062] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 356.55709946178,
        ["y"] = -290.94292997174,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 387.8,
        ["y"] = -300.5,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 397.44171923888,
        ["y"] = -332.74194961205,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 425.37190120426,
        ["y"] = -343.28488939496,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 420.02853991972,
        ["y"] = -349.58536976364,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 429.19212311781,
        ["y"] = -402.78422244564,
        ["g"] = 53,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 431.7,
            ["y"] = -379.2,
          },
          [2] = {
            ["x"] = 433.5,
            ["y"] = -379,
          },
          [3] = {
            ["x"] = 433.5,
            ["y"] = -407.2,
          },
          [4] = {
            ["x"] = 431.8,
            ["y"] = -407.2,
          },
          [5] = {
            ["x"] = 431.7,
            ["y"] = -379.2,
          },
        },
      },
      [7] = {
        ["x"] = 436.26306263746,
        ["y"] = -403.7078530922,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 320,
        ["y"] = -329,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 326,
        ["y"] = -329.5,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 339.84147507036,
        ["y"] = -352.8573122406,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 346.6,
        ["y"] = -388.2,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 355.69879631258,
        ["y"] = -386.06952034534,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 406.80120368742,
        ["y"] = -367.09881431581,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Fetid Rotsinger",
    ["id"] = 186226,
    ["count"] = 15,
    ["health"] = 1383736,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 105699,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [367510] = {
      },
      [367511] = {
      },
      [374544] = {
      },
      [375065] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 379.25659947076,
        ["y"] = -309.94246922542,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 379,
            ["y"] = -310.4,
          },
          [2] = {
            ["x"] = 375.8,
            ["y"] = -314.9,
          },
          [3] = {
            ["x"] = 375.1,
            ["y"] = -316.3,
          },
          [4] = {
            ["x"] = 400.8,
            ["y"] = -333.8,
          },
          [5] = {
            ["x"] = 403.4,
            ["y"] = -329.5,
          },
          [6] = {
            ["x"] = 379,
            ["y"] = -310.4,
          },
        },
      },
      [2] = {
        ["x"] = 434.3,
        ["y"] = -325.1,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 406.8,
            ["y"] = -322.8,
          },
          [2] = {
            ["x"] = 417.1,
            ["y"] = -311.2,
          },
          [3] = {
            ["x"] = 441.6,
            ["y"] = -331.6,
          },
          [4] = {
            ["x"] = 433.4,
            ["y"] = -341.1,
          },
          [5] = {
            ["x"] = 406.9,
            ["y"] = -323.1,
          },
        },
      },
      [3] = {
        ["x"] = 432.8078530922,
        ["y"] = -395.3108477726,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 350.12804527497,
        ["y"] = -379.20861504571,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 340.3,
            ["y"] = -386.6,
          },
          [2] = {
            ["x"] = 347,
            ["y"] = -382.2,
          },
          [3] = {
            ["x"] = 356.7,
            ["y"] = -383.6,
          },
          [4] = {
            ["x"] = 361.8,
            ["y"] = -388.2,
          },
        },
      },
      [5] = {
        ["x"] = 542.4,
        ["y"] = -255,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 585.4,
        ["y"] = -382.6,
        ["g"] = 86,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Wild Lasher",
    ["id"] = 191243,
    ["count"] = 0,
    ["health"] = 197676,
    ["scale"] = 0.4,
    ["displayId"] = 81393,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [372113] = {
      },
      [375416] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 394.08658049649,
        ["y"] = -310.686109939,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 375.28535995246,
        ["y"] = -327.51486060953,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 371.7,
        ["y"] = -328.6,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 399.07073952727,
        ["y"] = -350.15754058576,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 430.35778077009,
        ["y"] = -349.97146989146,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 427.54343977394,
        ["y"] = -352.62829973538,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 430.1143998632,
        ["y"] = -354.89928925816,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 434,
        ["y"] = -351.2,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 449.4,
        ["y"] = -383.8,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 430.6,
        ["y"] = -377.2,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 432.4,
        ["y"] = -381.4,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 346.2,
        ["y"] = -324.8,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 344.1,
        ["y"] = -365,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 343.7,
        ["y"] = -368.4,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 384.9,
        ["y"] = -368.7,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 434.8,
        ["y"] = -414.2,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 439.1,
        ["y"] = -414.1,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 438.8,
        ["y"] = -431.1,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 443.1,
        ["y"] = -329.9,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Wilted Oak",
    ["id"] = 186229,
    ["count"] = 20,
    ["health"] = 1976766,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 54677,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [373936] = {
      },
      [373943] = {
      },
      [375259] = {
      },
      [382712] = {
      },
      [382805] = {
      },
      [383062] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 356.7,
        ["y"] = -329.6,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 356.3,
            ["y"] = -316.8,
          },
          [2] = {
            ["x"] = 358.7,
            ["y"] = -316.7,
          },
          [3] = {
            ["x"] = 357.4,
            ["y"] = -347,
          },
          [4] = {
            ["x"] = 354.9,
            ["y"] = -347,
          },
          [5] = {
            ["x"] = 356.4,
            ["y"] = -316.8,
          },
        },
      },
      [2] = {
        ["x"] = 438.4,
        ["y"] = -362.6,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 431,
            ["y"] = -364.5,
          },
          [2] = {
            ["x"] = 452.9,
            ["y"] = -362.4,
          },
          [3] = {
            ["x"] = 452.7,
            ["y"] = -379.8,
          },
          [4] = {
            ["x"] = 431.1,
            ["y"] = -364.5,
          },
        },
      },
      [3] = {
        ["x"] = 369.8,
        ["y"] = -369.6,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 369.8,
            ["y"] = -369.6,
          },
          [2] = {
            ["x"] = 346.3,
            ["y"] = -363.9,
          },
          [3] = {
            ["x"] = 342.48728627618,
            ["y"] = -367.91005668541,
          },
          [4] = {
            ["x"] = 388.94054093336,
            ["y"] = -376.74345522977,
          },
          [5] = {
            ["x"] = 390.18762533347,
            ["y"] = -371.54734158711,
          },
        },
      },
      [4] = {
        ["x"] = 440.7,
        ["y"] = -436,
        ["g"] = 55,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 440.7,
            ["y"] = -436,
          },
          [2] = {
            ["x"] = 446.65399374243,
            ["y"] = -468.52707869696,
          },
          [3] = {
            ["x"] = 453.05956437285,
            ["y"] = -466.75323704378,
          },
          [4] = {
            ["x"] = 446.55544823701,
            ["y"] = -433.83853073198,
          },
        },
      },
      [5] = {
        ["x"] = 446.8,
        ["y"] = -435.2,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Monstrous Decay",
    ["id"] = 186227,
    ["count"] = 15,
    ["health"] = 1284898,
    ["scale"] = 1,
    ["displayId"] = 71690,
    ["creatureType"] = "Aberration",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [373872] = {
      },
      [374569] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 410.14290053822,
        ["y"] = -344.37121989595,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 415.2,
            ["y"] = -338.9,
          },
          [2] = {
            ["x"] = 416.9,
            ["y"] = -340.2,
          },
          [3] = {
            ["x"] = 394,
            ["y"] = -366.4,
          },
          [4] = {
            ["x"] = 392.6,
            ["y"] = -365.3,
          },
          [5] = {
            ["x"] = 415.2,
            ["y"] = -338.9,
          },
        },
      },
      [2] = {
        ["x"] = 410.0287604817,
        ["y"] = -309.95657984841,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 420.2,
        ["y"] = -491.2,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 427.9,
        ["y"] = -469.7,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 535.4,
        ["y"] = -261,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Infected Lasher",
    ["id"] = 189363,
    ["count"] = 1,
    ["health"] = 138374,
    ["scale"] = 0.5,
    ["displayId"] = 81391,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [372113] = {
      },
      [375416] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 434.7,
        ["y"] = -365.2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 447.7,
        ["y"] = -360.6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 455.8,
        ["y"] = -364.8,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 458.6,
        ["y"] = -381.6,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 454.3,
        ["y"] = -382.9,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 435.6,
        ["y"] = -377.3,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 428.3,
        ["y"] = -381.4,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 436.9,
        ["y"] = -381.1,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 342.3,
        ["y"] = -324.1,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 340.3,
        ["y"] = -327.4,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 343.9,
        ["y"] = -328.5,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 314.94245941424,
        ["y"] = -324.97122970712,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 313.38513939047,
        ["y"] = -328.72854973089,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 315.0568396551,
        ["y"] = -332.44291034939,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 330.48610012782,
        ["y"] = -325.89977943801,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 332.18635993451,
        ["y"] = -329.42827030186,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 329.97196007131,
        ["y"] = -333.68561975915,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 348,
        ["y"] = -365.6,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 347.1,
        ["y"] = -369.2,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 362.41486060953,
        ["y"] = -384.97170026462,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 362.80048036867,
        ["y"] = -390.10024018434,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 359.9153017335,
        ["y"] = -394.34317015608,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 384.2,
        ["y"] = -373.9,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 394.3,
        ["y"] = -378.8,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 395.1,
        ["y"] = -381.9,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 397.7,
        ["y"] = -379.4,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 396.5,
        ["y"] = -371.1,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 399.1,
        ["y"] = -371.4,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 440.2,
        ["y"] = -417.6,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 436.2,
        ["y"] = -417.8,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 432.8,
        ["y"] = -417.7,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 444.6,
        ["y"] = -449.8,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 443.2,
        ["y"] = -452.8,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 445.1,
        ["y"] = -454.7,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 451.5,
        ["y"] = -449.5,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 453,
        ["y"] = -452.9,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 451.9,
        ["y"] = -455.4,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Treemouth",
    ["id"] = 186120,
    ["count"] = 0,
    ["health"] = 6224432,
    ["scale"] = 1.2,
    ["displayId"] = 106294,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2473,
    ["instanceID"] = 1196,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [376231] = {
      },
      [376797] = {
      },
      [376811] = {
      },
      [376933] = {
      },
      [376934] = {
      },
      [377184] = {
      },
      [377242] = {
      },
      [377559] = {
      },
      [377859] = {
      },
      [377864] = {
      },
      [378022] = {
      },
      [378764] = {
      },
      [383875] = {
      },
      [390968] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 490.1,
        ["y"] = -452.8,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Stinkbreath",
    ["id"] = 187033,
    ["count"] = 25,
    ["health"] = 2372119,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 106038,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [385185] = {
      },
      [385186] = {
      },
      [385805] = {
      },
      [388046] = {
      },
      [388060] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 491.8,
        ["y"] = -380.3,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 490.7,
            ["y"] = -354.7,
          },
          [2] = {
            ["x"] = 487.8,
            ["y"] = -401,
          },
          [3] = {
            ["x"] = 491.7,
            ["y"] = -401.3,
          },
          [4] = {
            ["x"] = 495,
            ["y"] = -355.1,
          },
          [5] = {
            ["x"] = 490.8,
            ["y"] = -354.8,
          },
        },
      },
    },
  },
  [23] = {
    ["name"] = "Decaying Slime",
    ["id"] = 199916,
    ["count"] = 0,
    ["health"] = 197676,
    ["scale"] = 0.4,
    ["displayId"] = 104893,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["clones"] = {
      [1] = {
        ["x"] = 473.47001897426,
        ["y"] = -374.12852029737,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 473.07003859661,
        ["y"] = -377.34291034939,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 472.09855889398,
        ["y"] = -380.82878991523,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 472.59879907832,
        ["y"] = -383.41438024085,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 472.19188146069,
        ["y"] = -370.20344036983,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 475.55513874239,
        ["y"] = -370.28536976364,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 476.25541817142,
        ["y"] = -373.18535995246,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 477.41295875718,
        ["y"] = -376.84268978741,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 476.71297837953,
        ["y"] = -379.6282899242,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 476.52735862038,
        ["y"] = -383.65707002826,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 479.82661844502,
        ["y"] = -369.24219960756,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 480.56979841228,
        ["y"] = -372.7851295793,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 481.88441883746,
        ["y"] = -376.37098952278,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 480.42711843604,
        ["y"] = -379.74243979189,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 479.87001897426,
        ["y"] = -383.45685927744,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Skulking Gutstabber",
    ["id"] = 186242,
    ["count"] = 4,
    ["health"] = 889545,
    ["scale"] = 1,
    ["displayId"] = 105704,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
      [384930] = {
      },
      [385039] = {
      },
      [385046] = {
      },
      [385058] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 492.29250618563,
        ["y"] = -350.37463904714,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 500.35502088763,
        ["y"] = -350.31643144015,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 478.47463093406,
        ["y"] = -320.38026154453,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 480.1,
        ["y"] = -327.6,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 373.95626792067,
        ["y"] = -209.46631175972,
        ["g"] = 94,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 507.80433143427,
        ["y"] = -311.51643144015,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 503.92825668878,
        ["y"] = -317.99107860038,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 448.37005039971,
        ["y"] = -257.34013443269,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 448.3180641257,
        ["y"] = -250.44330174795,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 449.08338110104,
        ["y"] = -238.97405658101,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 376.1130560555,
        ["y"] = -216.99633757546,
        ["g"] = 94,
        ["sublevel"] = 1,
      },
    },
  },
  [25] = {
    ["name"] = "Infected Bear",
    ["id"] = 189318,
    ["count"] = 0,
    ["health"] = 1581412,
    ["scale"] = 1,
    ["displayId"] = 68523,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["clones"] = {
      [1] = {
        ["x"] = 476.9,
        ["y"] = -354.7,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
    },
  },
  [26] = {
    ["name"] = "Rageclaw",
    ["id"] = 187192,
    ["count"] = 30,
    ["health"] = 2371212,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 105554,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [385824] = {
      },
      [385827] = {
      },
      [385832] = {
      },
      [385833] = {
      },
      [385834] = {
      },
      [397099] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 473.5,
        ["y"] = -302.8,
        ["sublevel"] = 1,
      },
    },
  },
  [27] = {
    ["name"] = "Rotbow Stalker",
    ["id"] = 186208,
    ["count"] = 15,
    ["health"] = 1284898,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 105690,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [367510] = {
      },
      [367511] = {
      },
      [367521] = {
      },
      [382620] = {
      },
      [384899] = {
      },
      [384961] = {
      },
      [384974] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 493.1,
        ["y"] = -299.6,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 496.01693546387,
        ["y"] = -234.10847412648,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 468.39660162085,
        ["y"] = -264.14237502868,
        ["g"] = 70,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 449.2,
            ["y"] = -270.3,
          },
          [2] = {
            ["x"] = 451.9,
            ["y"] = -273.4,
          },
          [3] = {
            ["x"] = 472.5,
            ["y"] = -263.7,
          },
          [4] = {
            ["x"] = 487.3,
            ["y"] = -249,
          },
          [5] = {
            ["x"] = 484.9,
            ["y"] = -246.3,
          },
          [6] = {
            ["x"] = 470.6,
            ["y"] = -261.3,
          },
          [7] = {
            ["x"] = 449.2,
            ["y"] = -270.3,
          },
        },
      },
      [4] = {
        ["x"] = 417.7,
        ["y"] = -185.9,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 399.40433143427,
        ["y"] = -191.33286288031,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 419.36823346617,
        ["y"] = -271.28302608828,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
    },
  },
  [28] = {
    ["name"] = "Fleshripper Vulture",
    ["id"] = 186246,
    ["count"] = 3,
    ["health"] = 593030,
    ["scale"] = 1,
    ["displayId"] = 10827,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
    },
    ["spells"] = {
      [384970] = {
      },
      [385029] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 459.71863465345,
        ["y"] = -262.87119842504,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 458.07628144617,
        ["y"] = -269.71356617992,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 391.98218965311,
        ["y"] = -194.27465527332,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 395.30892139962,
        ["y"] = -206.25359330238,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 353.7,
        ["y"] = -222.8,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 478.4,
        ["y"] = -197.3,
        ["g"] = 74,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 505.3,
            ["y"] = -204.4,
          },
          [2] = {
            ["x"] = 531.5,
            ["y"] = -199.5,
          },
          [3] = {
            ["x"] = 538.9,
            ["y"] = -187.2,
          },
          [4] = {
            ["x"] = 533.8,
            ["y"] = -174.7,
          },
          [5] = {
            ["x"] = 514.9,
            ["y"] = -172.8,
          },
          [6] = {
            ["x"] = 505.4,
            ["y"] = -181.9,
          },
          [7] = {
            ["x"] = 494.1,
            ["y"] = -198.7,
          },
          [8] = {
            ["x"] = 481.7,
            ["y"] = -202,
          },
          [9] = {
            ["x"] = 474.8,
            ["y"] = -197,
          },
          [10] = {
            ["x"] = 474.7,
            ["y"] = -186.1,
          },
          [11] = {
            ["x"] = 479.6,
            ["y"] = -180.7,
          },
          [12] = {
            ["x"] = 492.7,
            ["y"] = -183.5,
          },
          [13] = {
            ["x"] = 496.3,
            ["y"] = -191.7,
          },
          [14] = {
            ["x"] = 505.3,
            ["y"] = -204.4,
          },
        },
      },
      [7] = {
        ["x"] = 474.71081420312,
        ["y"] = -201.5648220103,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
    },
  },
  [29] = {
    ["name"] = "Gutchewer Bear",
    ["id"] = 186284,
    ["count"] = 6,
    ["health"] = 1087222,
    ["scale"] = 1,
    ["displayId"] = 11908,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
      ["Imprison"] = true,
    },
    ["spells"] = {
      [372151] = {
      },
      [384970] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 465.6,
        ["y"] = -271.13221538097,
        ["g"] = 70,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 410.82031929542,
        ["y"] = -269.70847500574,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 413.81864920105,
        ["y"] = -277.06102422973,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 413,
        ["y"] = -252.2,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 500.7,
        ["y"] = -195.3,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 500.5,
            ["y"] = -184.2,
          },
          [2] = {
            ["x"] = 498.5,
            ["y"] = -215.4,
          },
          [3] = {
            ["x"] = 501.1,
            ["y"] = -215.4,
          },
          [4] = {
            ["x"] = 503.2,
            ["y"] = -184.3,
          },
          [5] = {
            ["x"] = 500.5,
            ["y"] = -184.2,
          },
        },
      },
      [6] = {
        ["x"] = 417.7,
        ["y"] = -178.9,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
    },
  },
  [30] = {
    ["name"] = "Gutshot",
    ["id"] = 186116,
    ["count"] = 0,
    ["health"] = 5532828,
    ["scale"] = 1.2,
    ["displayId"] = 109135,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2472,
    ["instanceID"] = 1196,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [382620] = {
      },
      [383974] = {
      },
      [383979] = {
      },
      [384343] = {
      },
      [384353] = {
      },
      [384416] = {
      },
      [384425] = {
      },
      [384633] = {
      },
      [384638] = {
      },
      [384827] = {
      },
      [385356] = {
      },
      [385359] = {
      },
      [387889] = {
      },
      [387890] = {
      },
      [396124] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 480.79598178261,
        ["y"] = -163.55881192029,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
    },
  },
  [31] = {
    ["name"] = "Rotfang Hyena",
    ["id"] = 194745,
    ["count"] = 0,
    ["health"] = 658922,
    ["scale"] = 1,
    ["displayId"] = 109883,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [384148] = {
      },
      [384529] = {
      },
      [384531] = {
      },
      [384558] = {
      },
      [384575] = {
      },
      [384577] = {
      },
      [384725] = {
      },
      [384764] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 492.01680895208,
        ["y"] = -156.36684064843,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 490.89552039363,
        ["y"] = -170.09377225758,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
    },
  },
  [32] = {
    ["name"] = "Gutstabber",
    ["id"] = 197857,
    ["count"] = 0,
    ["health"] = 988005,
    ["scale"] = 1,
    ["displayId"] = 105704,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Fear"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
      [384930] = {
      },
      [385039] = {
      },
      [385046] = {
      },
      [385058] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 434.3,
        ["y"] = -201.5,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 430,
        ["y"] = -202.1,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 426.3,
        ["y"] = -203.3,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 428.7,
        ["y"] = -213.5,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 433.3,
        ["y"] = -213.4,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 437,
        ["y"] = -212.6,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
    },
  },
  [33] = {
    ["name"] = "Wither Biter",
    ["id"] = 187231,
    ["count"] = 1,
    ["health"] = 296515,
    ["scale"] = 0.8,
    ["displayId"] = 106070,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 524.9,
        ["y"] = -174.3,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 529.2,
        ["y"] = -171.2,
        ["g"] = 76,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 537.7,
        ["y"] = -222.7,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 538.4,
        ["y"] = -227.4,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 538.5,
        ["y"] = -232.6,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 536.8,
        ["y"] = -218,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 574.98939665355,
        ["y"] = -272.70949917812,
        ["g"] = 82,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 582.62333328755,
        ["y"] = -270.35977448218,
        ["g"] = 82,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 581.42961084584,
        ["y"] = -278.32537728733,
        ["g"] = 82,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 545.3,
        ["y"] = -439.3,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 535.7,
        ["y"] = -432.6,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 548.4,
        ["y"] = -425.8,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 543.9,
        ["y"] = -423,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 574.9,
        ["y"] = -412.1,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 569.9,
        ["y"] = -409.4,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 579.6,
        ["y"] = -386,
        ["g"] = 86,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 587.7,
        ["y"] = -388.6,
        ["g"] = 86,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 602.9,
        ["y"] = -355.4,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 563.51296812114,
        ["y"] = -215.70427659176,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 567.88437916566,
        ["y"] = -210.92881778768,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 569.38685730515,
        ["y"] = -219.31811271578,
        ["g"] = 79,
        ["sublevel"] = 1,
      },
    },
  },
  [34] = {
    ["name"] = "Filth Caller",
    ["id"] = 185656,
    ["count"] = 5,
    ["health"] = 889545,
    ["scale"] = 1,
    ["displayId"] = 108447,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [382474] = {
      },
      [383385] = {
      },
      [383392] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 529.98918579688,
        ["y"] = -178.29183952294,
        ["g"] = 76,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 541.70296741779,
            ["y"] = -199.44020213611,
          },
          [2] = {
            ["x"] = 529.98918579688,
            ["y"] = -178.29183952294,
          },
        },
      },
      [2] = {
        ["x"] = 577.7342980276,
        ["y"] = -255.16083827547,
        ["g"] = 81,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 571.33659965495,
        ["y"] = -258.55799462248,
        ["g"] = 81,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 602.82881524331,
        ["y"] = -278.30509844798,
        ["g"] = 89,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 605.9220475802,
        ["y"] = -257.17794426675,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 540.2,
        ["y"] = -436.1,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 550.5,
        ["y"] = -421.1,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 568.7,
        ["y"] = -402.2,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 580.7,
        ["y"] = -409,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
    },
  },
  [35] = {
    ["name"] = "Witherling",
    ["id"] = 187238,
    ["count"] = 1,
    ["health"] = 197676,
    ["scale"] = 0.8,
    ["displayId"] = 106071,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 548.47118387744,
        ["y"] = -200.98643382008,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 541.92033384302,
        ["y"] = -200.10676766311,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 538.80169918958,
        ["y"] = -205.11185156349,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 543.72714602818,
        ["y"] = -209.7372984021,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 549.56948468786,
        ["y"] = -207.57456770899,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 609.63559921252,
        ["y"] = -281.06782186729,
        ["g"] = 89,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 608.9,
        ["y"] = -273.9,
        ["g"] = 89,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 605.19680615902,
        ["y"] = -286.21160680986,
        ["g"] = 89,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 596.18471920365,
        ["y"] = -274.95592578174,
        ["g"] = 89,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 602.36779916663,
        ["y"] = -270.03050076454,
        ["g"] = 89,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 609.93896849647,
        ["y"] = -253.02710150613,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 609.49829993117,
        ["y"] = -263.98304271473,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 617.46101695593,
        ["y"] = -255.60338383155,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 612.85423386597,
        ["y"] = -258.44238142323,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 617.32546138621,
        ["y"] = -264.26102422973,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
    },
  },
  [36] = {
    ["name"] = "Vile Rothexer",
    ["id"] = 187224,
    ["count"] = 15,
    ["health"] = 1383207,
    ["scale"] = 1,
    ["displayId"] = 106068,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["spells"] = {
      [382802] = {
      },
      [383087] = {
      },
    },
    ["clones"] = {
      [2] = {
        ["x"] = 554.6,
        ["y"] = -230.2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 561.3,
        ["y"] = -233.5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 554.1,
        ["y"] = -237.1,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 560.9,
        ["y"] = -241.2,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 620.1,
        ["y"] = -273.3,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 607.6,
            ["y"] = -269.6,
          },
          [2] = {
            ["x"] = 624.4,
            ["y"] = -272.9,
          },
          [3] = {
            ["x"] = 634.5,
            ["y"] = -271.6,
          },
          [4] = {
            ["x"] = 634.7,
            ["y"] = -273.4,
          },
          [5] = {
            ["x"] = 624.2,
            ["y"] = -275,
          },
          [6] = {
            ["x"] = 607.1,
            ["y"] = -271.6,
          },
          [7] = {
            ["x"] = 607.6,
            ["y"] = -269.6,
          },
        },
      },
    },
  },
  [37] = {
    ["name"] = "Disease Slasher",
    ["id"] = 187315,
    ["count"] = 5,
    ["health"] = 889205,
    ["scale"] = 1,
    ["displayId"] = 106099,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["clones"] = {
      [6] = {
        ["x"] = 546,
        ["y"] = -418.2,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 554.8,
        ["y"] = -424.2,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 607.2,
        ["y"] = -356.2,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 599.2,
        ["y"] = -354.7,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 618.33169555216,
        ["y"] = -236.61314460191,
        ["g"] = 91,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 625.82087235229,
        ["y"] = -243.79896029454,
        ["g"] = 91,
        ["sublevel"] = 1,
      },
    },
  },
  [38] = {
    ["name"] = "Vile Rothexer",
    ["id"] = 194241,
    ["count"] = 15,
    ["health"] = 1383207,
    ["scale"] = 1,
    ["displayId"] = 106068,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["spells"] = {
      [382802] = {
      },
      [382883] = {
      },
      [382891] = {
      },
      [383087] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 597.3,
        ["y"] = -330.5,
        ["sublevel"] = 1,
      },
    },
  },
  [39] = {
    ["name"] = "Bloodthirsty Cub",
    ["id"] = 194256,
    ["count"] = 0,
    ["health"] = 12345,
    ["scale"] = 0.8,
    ["displayId"] = 101428,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["clones"] = {
      [1] = {
        ["x"] = 612.7,
        ["y"] = -327.7,
        ["sublevel"] = 1,
      },
    },
  },
  [40] = {
    ["name"] = "Wither Slasher",
    ["id"] = 194469,
    ["count"] = 0,
    ["health"] = 296515,
    ["scale"] = 0.8,
    ["displayId"] = 108586,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Fear"] = true,
      ["Stun"] = true,
    },
    ["spells"] = {
      [367481] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 632.1,
        ["y"] = -295.2,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 635.6,
        ["y"] = -300.6406903867,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 642.92206300706,
        ["y"] = -301.03729928135,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 639.45026366903,
        ["y"] = -295.11917507528,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
    },
  },
  [41] = {
    ["name"] = "Vile Rothexer",
    ["id"] = 194487,
    ["count"] = 15,
    ["health"] = 1383736,
    ["scale"] = 1,
    ["displayId"] = 106068,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["spells"] = {
      [382802] = {
      },
      [382883] = {
      },
      [382891] = {
      },
      [383087] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 635.2,
        ["y"] = -289.5,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
    },
  },
  [42] = {
    ["name"] = "Decatriarch Wratheye",
    ["id"] = 186121,
    ["count"] = 0,
    ["health"] = 7904040,
    ["scale"] = 1.2,
    ["displayId"] = 106069,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2474,
    ["instanceID"] = 1196,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [373896] = {
      },
      [373912] = {
      },
      [373915] = {
      },
      [373917] = {
      },
      [373942] = {
      },
      [373960] = {
      },
      [374186] = {
      },
      [376170] = {
      },
      [385361] = {
      },
      [387264] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 641.6,
        ["y"] = -269.2,
        ["sublevel"] = 1,
      },
    },
  },
};
