local addonName = ...
local MDT = MDT
local L = MDT.L
local dungeonIndex = 104
MDT.dungeonList[dungeonIndex] = L["The Everbloom"]
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides = {
    [1] = {
      zoomScale = 1.8999998569489,
      horizontalPan = 304.20210274759,
      verticalPan = 88.878914962537,
    },
  }
};

local zones = { 620, 621 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'Everbloom' },
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["The Everbloom"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 300, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Everbloom Cultivator",
    ["id"] = 81985,
    ["count"] = 3,
    ["health"] = 789896,
    ["scale"] = 1,
    ["displayId"] = 58429,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [165213] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 585.47786862137,
        ["y"] = -278.49756819624,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 547.19747178369,
        ["y"] = -265.53835272871,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 555.44411171243,
        ["y"] = -298.51945937946,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 571.46489350504,
        ["y"] = -346.88724307205,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 548.99502287444,
        ["y"] = -368.27748803192,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 514.22005803021,
        ["y"] = -344.08194950767,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 482.80068812478,
        ["y"] = -358.97148372769,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 554.44510568591,
        ["y"] = -238.49585692396,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 555.51039273748,
        ["y"] = -210.20869108058,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 587.36945375071,
        ["y"] = -180.36532585709,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 618.13613252132,
        ["y"] = -159.67895145358,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 586.55692509819,
        ["y"] = -110.44440248095,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Everbloom Naturalist",
    ["id"] = 81819,
    ["count"] = 4,
    ["health"] = 888633,
    ["scale"] = 1,
    ["displayId"] = 57021,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [164965] = {
      },
      [164973] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 581.43353824274,
        ["y"] = -286.41447015075,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 548.14266938577,
        ["y"] = -256.99880803868,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 525.10343829841,
        ["y"] = -307.84071585818,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 553.36312392074,
        ["y"] = -290.06785038751,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 553.54095009234,
        ["y"] = -361.54601081743,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 483.06051860396,
        ["y"] = -348.88039340229,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 455.06117846067,
        ["y"] = -336.32718333686,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 455.06117846067,
            ["y"] = -336.32718333686,
          },
          [2] = {
            ["x"] = 445.69901486485,
            ["y"] = -337.4574570947,
          },
          [3] = {
            ["x"] = 437.71528344146,
            ["y"] = -337.16714026798,
          },
          [4] = {
            ["x"] = 431.03802549803,
            ["y"] = -334.84460980724,
          },
          [5] = {
            ["x"] = 437.71528344146,
            ["y"] = -337.16714026798,
          },
          [6] = {
            ["x"] = 445.69901486485,
            ["y"] = -337.4574570947,
          },
          [7] = {
            ["x"] = 455.06117846067,
            ["y"] = -336.32718333686,
          },
          [8] = {
            ["x"] = 462.68257206958,
            ["y"] = -329.90921544696,
          },
          [9] = {
            ["x"] = 466.74698272554,
            ["y"] = -323.08675548347,
          },
          [10] = {
            ["x"] = 466.60185961285,
            ["y"] = -310.89345291425,
          },
          [11] = {
            ["x"] = 461.37613181377,
            ["y"] = -299.28076323337,
          },
          [12] = {
            ["x"] = 451.21503872555,
            ["y"] = -290.57124181969,
          },
          [13] = {
            ["x"] = 461.37613181377,
            ["y"] = -299.28076323337,
          },
          [14] = {
            ["x"] = 466.60185961285,
            ["y"] = -310.89345291425,
          },
          [15] = {
            ["x"] = 466.74698272554,
            ["y"] = -323.08675548347,
          },
          [16] = {
            ["x"] = 462.68257206958,
            ["y"] = -329.90921544696,
          },
        },
      },
      [8] = {
        ["x"] = 456.37158937522,
        ["y"] = -321.09104114535,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 458.24089985107,
        ["y"] = -311.71173082102,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 437.92132664611,
        ["y"] = -300.37921035997,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 430.88290826719,
        ["y"] = -295.61315440462,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 427.1558438918,
        ["y"] = -329.97073085162,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 422.97967450364,
        ["y"] = -321.38001259308,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 573.71976318015,
        ["y"] = -212.50549799112,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 560.07097735,
        ["y"] = -190.73640541463,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 555.94957499163,
        ["y"] = -183.96937720212,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 594.1083689186,
        ["y"] = -194.45378582497,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 594.1083689186,
            ["y"] = -194.45378582497,
          },
          [2] = {
            ["x"] = 591.39087899429,
            ["y"] = -202.72802285332,
          },
          [3] = {
            ["x"] = 589.75882747015,
            ["y"] = -208.03220781679,
          },
          [4] = {
            ["x"] = 589.35082042579,
            ["y"] = -211.90833310496,
          },
          [5] = {
            ["x"] = 587.92277242383,
            ["y"] = -216.19247711083,
          },
          [6] = {
            ["x"] = 589.35082042579,
            ["y"] = -211.90833310496,
          },
          [7] = {
            ["x"] = 589.75882747015,
            ["y"] = -208.03220781679,
          },
          [8] = {
            ["x"] = 591.39087899429,
            ["y"] = -202.72802285332,
          },
          [9] = {
            ["x"] = 594.1083689186,
            ["y"] = -194.45378582497,
          },
          [10] = {
            ["x"] = 596.08303004452,
            ["y"] = -185.7954736987,
          },
          [11] = {
            ["x"] = 596.28708026011,
            ["y"] = -179.67528631987,
          },
          [12] = {
            ["x"] = 596.08303004452,
            ["y"] = -174.98312359628,
          },
          [13] = {
            ["x"] = 597.91908509084,
            ["y"] = -172.12702759236,
          },
          [14] = {
            ["x"] = 596.08303004452,
            ["y"] = -174.98312359628,
          },
          [15] = {
            ["x"] = 596.28708026011,
            ["y"] = -179.67528631987,
          },
          [16] = {
            ["x"] = 596.08303004452,
            ["y"] = -185.7954736987,
          },
        },
      },
    },
  },
  [3] = {
    ["name"] = "Dreadpetal",
    ["id"] = 81864,
    ["count"] = 1,
    ["health"] = 394948,
    ["scale"] = 0.7,
    ["displayId"] = 25328,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [164885] = {
      },
      [164886] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 589.5141750788,
        ["y"] = -285.18597470243,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 540.62042763394,
        ["y"] = -263.01785474725,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 541.55667880608,
        ["y"] = -256.62578472756,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 534.58808558612,
        ["y"] = -263.71853265071,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 537.13251548398,
        ["y"] = -257.3650675772,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 535.89395131353,
        ["y"] = -270.13341708664,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 524.36642149529,
        ["y"] = -291.77424718198,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 518.57823176466,
        ["y"] = -287.03100507815,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 516.31060641672,
        ["y"] = -292.39891663278,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 524.3021629196,
        ["y"] = -285.35284495721,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 520.07713000642,
        ["y"] = -296.84573032488,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 561.28407874168,
        ["y"] = -293.9527104046,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 560.34092537655,
        ["y"] = -307.53942374824,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 560.22151928167,
        ["y"] = -289.56871721824,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 559.32060305304,
        ["y"] = -303.12922245652,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 561.14862614558,
        ["y"] = -299.07307498296,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 550.9849290215,
        ["y"] = -325.58835081522,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 557.00270745529,
        ["y"] = -324.57467058649,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 555.92975653092,
        ["y"] = -330.82732311941,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 549.78503420672,
        ["y"] = -331.0675983908,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 552.9372252509,
        ["y"] = -320.1877529215,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 577.68181848015,
        ["y"] = -338.28544762282,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 579.55325586455,
        ["y"] = -349.56463717823,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 572.38563424114,
        ["y"] = -337.02858196481,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 574.99954362112,
        ["y"] = -354.68547258038,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 578.17411586153,
        ["y"] = -342.79794057191,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 557.06831307441,
        ["y"] = -368.57757775268,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 540.63933911919,
        ["y"] = -368.92325241205,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 556.26814753938,
        ["y"] = -374.42639807837,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 544.08381313008,
        ["y"] = -374.25641535222,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 550.21864420401,
        ["y"] = -376.49576014902,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 520.58568120405,
        ["y"] = -347.93619918942,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 512.71300543328,
        ["y"] = -351.82120571828,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 517.38160299779,
        ["y"] = -352.45986355266,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 507.53329420061,
        ["y"] = -349.56596125405,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 507.19558472299,
        ["y"] = -344.82123069218,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 482.5254109165,
        ["y"] = -323.70409947471,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 487.99599761469,
        ["y"] = -322.19180850197,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 493.45656515121,
        ["y"] = -319.66650378808,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 487.90685635201,
        ["y"] = -315.60365526247,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 498.30691554277,
        ["y"] = -322.64255556427,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 488.06300172176,
        ["y"] = -365.91977974596,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 480.29757299455,
        ["y"] = -368.37537216472,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 487.1960933172,
        ["y"] = -368.82079143642,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 476.70450076074,
        ["y"] = -362.55435695682,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [46] = {
        ["x"] = 488.51042055243,
        ["y"] = -360.82292251663,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [47] = {
        ["x"] = 463.20980385079,
        ["y"] = -246.92004758674,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [48] = {
        ["x"] = 474.6750431094,
        ["y"] = -245.22023239344,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [49] = {
        ["x"] = 470.96162522253,
        ["y"] = -240.29875866057,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [50] = {
        ["x"] = 468.80614788753,
        ["y"] = -246.28787251837,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [51] = {
        ["x"] = 478.82046547031,
        ["y"] = -241.31665947646,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [52] = {
        ["x"] = 499.58099791475,
        ["y"] = -276.39253794448,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [53] = {
        ["x"] = 493.93685657598,
        ["y"] = -274.08633250238,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [54] = {
        ["x"] = 495.03214837187,
        ["y"] = -279.44854536073,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [55] = {
        ["x"] = 488.77777920472,
        ["y"] = -275.5944794335,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [56] = {
        ["x"] = 502.03190820302,
        ["y"] = -281.57562377249,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [57] = {
        ["x"] = 547.85719733089,
        ["y"] = -240.46236414596,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [58] = {
        ["x"] = 547.63742192833,
        ["y"] = -228.39740908025,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [59] = {
        ["x"] = 552.76191923105,
        ["y"] = -231.2375884667,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [60] = {
        ["x"] = 547.19649073416,
        ["y"] = -234.45149352444,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [61] = {
        ["x"] = 551.4315283242,
        ["y"] = -245.1949731123,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [62] = {
        ["x"] = 547.30649988751,
        ["y"] = -209.42193224354,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [63] = {
        ["x"] = 554.1818765195,
        ["y"] = -217.1768526157,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [64] = {
        ["x"] = 546.00681320302,
        ["y"] = -199.4857779881,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [65] = {
        ["x"] = 549.0296803117,
        ["y"] = -214.12088801126,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [66] = {
        ["x"] = 550.89491215262,
        ["y"] = -203.867845655,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [67] = {
        ["x"] = 580.97404404676,
        ["y"] = -175.11676406149,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [68] = {
        ["x"] = 580.49890834478,
        ["y"] = -180.56832600367,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [69] = {
        ["x"] = 583.75142819098,
        ["y"] = -170.06328199458,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [70] = {
        ["x"] = 584.74366326285,
        ["y"] = -185.08323662047,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [71] = {
        ["x"] = 588.30386520769,
        ["y"] = -173.37551571,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [72] = {
        ["x"] = 623.95430699839,
        ["y"] = -155.11191639442,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [73] = {
        ["x"] = 616.26595423301,
        ["y"] = -148.53338722234,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [74] = {
        ["x"] = 621.15576695614,
        ["y"] = -150.8207065959,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [75] = {
        ["x"] = 618.04022143907,
        ["y"] = -153.51058011521,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [76] = {
        ["x"] = 625.42271121304,
        ["y"] = -161.36828146136,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [77] = {
        ["x"] = 594.05507603252,
        ["y"] = -109.57476075493,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [78] = {
        ["x"] = 590.51627182362,
        ["y"] = -105.51441006803,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [79] = {
        ["x"] = 584.26891847579,
        ["y"] = -99.280284267051,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [80] = {
        ["x"] = 589.71545271438,
        ["y"] = -100.98664662155,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [81] = {
        ["x"] = 583.35753831104,
        ["y"] = -104.96971400458,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Rockspine Stinger",
    ["id"] = 82039,
    ["count"] = 3,
    ["health"] = 592422,
    ["scale"] = 0.8,
    ["displayId"] = 56044,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [165123] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 543.03967505764,
        ["y"] = -270.91556361103,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 539.21595917132,
        ["y"] = -298.46167114817,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 539.21595917132,
            ["y"] = -298.46167114817,
          },
          [2] = {
            ["x"] = 544.96650592965,
            ["y"] = -300.04670846814,
          },
          [3] = {
            ["x"] = 547.58528009281,
            ["y"] = -301.27907381722,
          },
          [4] = {
            ["x"] = 544.96650592965,
            ["y"] = -300.04670846814,
          },
          [5] = {
            ["x"] = 539.21595917132,
            ["y"] = -298.46167114817,
          },
          [6] = {
            ["x"] = 531.87261748475,
            ["y"] = -296.19556895591,
          },
          [7] = {
            ["x"] = 526.17292113433,
            ["y"] = -292.80655102408,
          },
          [8] = {
            ["x"] = 531.87261748475,
            ["y"] = -296.19556895591,
          },
        },
      },
      [3] = {
        ["x"] = 530.51997831993,
        ["y"] = -288.39302558974,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 546.97815328797,
        ["y"] = -311.64281644249,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 532.33295660258,
        ["y"] = -340.62277828239,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 534.61600908763,
        ["y"] = -334.65179033919,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 534.61600908763,
            ["y"] = -334.65179033919,
          },
          [2] = {
            ["x"] = 539.36126947,
            ["y"] = -331.19476019925,
          },
          [3] = {
            ["x"] = 544.75289651958,
            ["y"] = -327.49766415201,
          },
          [4] = {
            ["x"] = 539.36126947,
            ["y"] = -331.19476019925,
          },
          [5] = {
            ["x"] = 534.61600908763,
            ["y"] = -334.65179033919,
          },
          [6] = {
            ["x"] = 524.11077251521,
            ["y"] = -340.89965715604,
          },
          [7] = {
            ["x"] = 520.10557190884,
            ["y"] = -342.74820517966,
          },
          [8] = {
            ["x"] = 524.11077251521,
            ["y"] = -340.89965715604,
          },
        },
      },
      [7] = {
        ["x"] = 527.80672991292,
        ["y"] = -335.58636825542,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 566.9082629341,
        ["y"] = -340.96579768803,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 567.45401072709,
        ["y"] = -353.32313975344,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 544.64091585458,
        ["y"] = -361.97204625341,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 453.93658738584,
        ["y"] = -394.89254096031,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 450.88873961626,
        ["y"] = -379.9330662925,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 460.05448115324,
        ["y"] = -371.57606847061,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 474.34219937524,
        ["y"] = -378.85473105538,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 492.67365159818,
        ["y"] = -380.4722107728,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 570.85192278046,
        ["y"] = -379.12431486466,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 584.87009575694,
        ["y"] = -371.30650008684,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 572.79316520626,
        ["y"] = -304.0653684071,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 575.48901872456,
        ["y"] = -317.2748285195,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 587.61997391931,
        ["y"] = -321.85766843698,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 616.3843830474,
        ["y"] = -270.4329981257,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 632.36888865027,
        ["y"] = -261.10867778398,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 623.93264085934,
        ["y"] = -243.57010714608,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 638.92296426625,
        ["y"] = -188.14756906077,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 648.51129385345,
        ["y"] = -201.40800314055,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 659.11961777056,
        ["y"] = -193.85976143669,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 675.23615387497,
        ["y"] = -196.30783888064,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 679.31629462158,
        ["y"] = -185.69950329017,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 642.98653299284,
        ["y"] = -151.70303789408,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 663.18320984386,
        ["y"] = -148.6429381708,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 649.10675578611,
        ["y"] = -133.95445016037,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 618.47362956166,
        ["y"] = -101.66771235119,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 585.16297392961,
        ["y"] = -73.990781743511,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 547.93720989256,
        ["y"] = -66.227790244176,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 523.06984625465,
        ["y"] = -83.847573073733,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Everbloom Mender",
    ["id"] = 81820,
    ["count"] = 4,
    ["health"] = 888633,
    ["scale"] = 1,
    ["displayId"] = 57964,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [164887] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 531.69350296627,
        ["y"] = -356.32262285598,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 457.7758983604,
        ["y"] = -344.59564716831,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 464.58121440484,
        ["y"] = -318.66332668123,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 438.14301862841,
        ["y"] = -292.05512303297,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 418.4199101007,
        ["y"] = -329.0919566359,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 582.0690237827,
        ["y"] = -240.27749932385,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 583.47336729726,
            ["y"] = -241.50628483233,
          },
          [2] = {
            ["x"] = 577.29313936843,
            ["y"] = -246.71286965232,
          },
          [3] = {
            ["x"] = 573.25572709792,
            ["y"] = -250.75029196735,
          },
          [4] = {
            ["x"] = 572.55355534064,
            ["y"] = -254.2611105757,
          },
          [5] = {
            ["x"] = 573.25572709792,
            ["y"] = -250.75029196735,
          },
          [6] = {
            ["x"] = 577.29313936843,
            ["y"] = -246.71286965232,
          },
          [7] = {
            ["x"] = 583.47336729726,
            ["y"] = -241.50628483233,
          },
          [8] = {
            ["x"] = 588.00115319957,
            ["y"] = -234.24948669506,
          },
          [9] = {
            ["x"] = 589.58097436411,
            ["y"] = -224.945826423,
          },
          [10] = {
            ["x"] = 576.06437394899,
            ["y"] = -224.77029855045,
          },
          [11] = {
            ["x"] = 567.11179955556,
            ["y"] = -227.05232160581,
          },
          [12] = {
            ["x"] = 576.06437394899,
            ["y"] = -224.77029855045,
          },
          [13] = {
            ["x"] = 589.58097436411,
            ["y"] = -224.945826423,
          },
          [14] = {
            ["x"] = 588.00115319957,
            ["y"] = -234.24948669506,
          },
        },
      },
      [7] = {
        ["x"] = 565.5721032763,
        ["y"] = -180.27361047841,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 593.39355298951,
        ["y"] = -134.43266514569,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 593.39355298951,
            ["y"] = -134.43266514569,
          },
          [2] = {
            ["x"] = 596.70473166613,
            ["y"] = -142.6910413709,
          },
          [3] = {
            ["x"] = 598.35589831532,
            ["y"] = -147.64458181039,
          },
          [4] = {
            ["x"] = 598.59179083433,
            ["y"] = -153.30576268929,
          },
          [5] = {
            ["x"] = 598.00207978278,
            ["y"] = -160.38223794434,
          },
          [6] = {
            ["x"] = 598.59179083433,
            ["y"] = -153.30576268929,
          },
          [7] = {
            ["x"] = 596.70473166613,
            ["y"] = -142.6910413709,
          },
          [8] = {
            ["x"] = 596.70473166613,
            ["y"] = -142.6910413709,
          },
          [9] = {
            ["x"] = 593.39355298951,
            ["y"] = -134.43266514569,
          },
          [10] = {
            ["x"] = 588.33090492012,
            ["y"] = -127.9483865579,
          },
          [11] = {
            ["x"] = 585.61824218136,
            ["y"] = -122.87689311025,
          },
          [12] = {
            ["x"] = 583.37735098331,
            ["y"] = -118.74896298998,
          },
          [13] = {
            ["x"] = 585.61824218136,
            ["y"] = -122.87689311025,
          },
          [14] = {
            ["x"] = 588.33090492012,
            ["y"] = -127.9483865579,
          },
        },
      },
    },
  },
  [6] = {
    ["name"] = "Gnarlroot",
    ["id"] = 81984,
    ["count"] = 25,
    ["health"] = 2764635,
    ["scale"] = 1,
    ["displayId"] = 58575,
    ["creatureType"] = "Elemental",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["clones"] = {
      [1] = {
        ["x"] = 513.15107052304,
        ["y"] = -333.56445764554,
        ["sublevel"] = 1,
        ["scale"] = 1.3,
        ["patrol"] = {
          [1] = {
            ["x"] = 513.15107052304,
            ["y"] = -333.56445764554,
          },
          [2] = {
            ["x"] = 521.96473466013,
            ["y"] = -327.26681780051,
          },
          [3] = {
            ["x"] = 528.64204243979,
            ["y"] = -322.62174857299,
          },
          [4] = {
            ["x"] = 534.15806630049,
            ["y"] = -314.3477044759,
          },
          [5] = {
            ["x"] = 528.64204243979,
            ["y"] = -322.62174857299,
          },
          [6] = {
            ["x"] = 521.96473466013,
            ["y"] = -327.26681780051,
          },
          [7] = {
            ["x"] = 513.15107052304,
            ["y"] = -333.56445764554,
          },
          [8] = {
            ["x"] = 503.5296140869,
            ["y"] = -341.347198432,
          },
          [9] = {
            ["x"] = 491.33628244654,
            ["y"] = -341.78266744255,
          },
          [10] = {
            ["x"] = 480.01392205144,
            ["y"] = -337.42791088873,
          },
          [11] = {
            ["x"] = 471.01407965802,
            ["y"] = -335.54084528552,
          },
          [12] = {
            ["x"] = 480.01392205144,
            ["y"] = -337.42791088873,
          },
          [13] = {
            ["x"] = 491.33628244654,
            ["y"] = -341.78266744255,
          },
          [14] = {
            ["x"] = 503.5296140869,
            ["y"] = -341.347198432,
          },
        },
      },
    },
  },
  [7] = {
    ["name"] = "Witherbark",
    ["id"] = 81522,
    ["count"] = 0,
    ["health"] = 14784946,
    ["scale"] = 1,
    ["displayId"] = 56613,
    ["creatureType"] = "Elemental",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 1214,
    ["instanceID"] = 556,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [164275] = {
      },
      [164357] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 441.47308226918,
        ["y"] = -320.22184970195,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Melded Berserker",
    ["id"] = 86372,
    ["count"] = 5,
    ["health"] = 987370,
    ["scale"] = 1,
    ["displayId"] = 59535,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [38166] = {
      },
      [172578] = {
      },
      [172579] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 569.39250128251,
        ["y"] = -259.84948050058,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 571.81572167779,
        ["y"] = -239.65203655994,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 578.16822843708,
        ["y"] = -228.49732891429,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 583.46357236951,
        ["y"] = -202.37815613023,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 604.61465375237,
        ["y"] = -217.26361075703,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 611.32583887134,
        ["y"] = -206.97714085657,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 611.61466890305,
        ["y"] = -170.2547920493,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 610.39457784518,
        ["y"] = -153.31204174984,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 564.71076279058,
        ["y"] = -110.44626954216,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 577.65432648534,
        ["y"] = -110.70427665434,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Twisted Abomination",
    ["id"] = 84767,
    ["count"] = 8,
    ["health"] = 1382317,
    ["scale"] = 1.2,
    ["displayId"] = 59768,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [169445] = {
      },
      [169657] = {
      },
      [169658] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 589.70328921657,
        ["y"] = -244.29607898344,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 603.72076684441,
        ["y"] = -195.36925894139,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 601.76190197552,
        ["y"] = -129.86569917158,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 574.72872075683,
        ["y"] = -126.20179873394,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Earthshaper Telu",
    ["id"] = 83893,
    ["count"] = 0,
    ["health"] = 3154122,
    ["scale"] = 1,
    ["displayId"] = 58016,
    ["creatureType"] = "Humanoid",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 1207,
    ["instanceID"] = 556,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [168040] = {
      },
      [427459] = {
      },
      [427508] = {
      },
      [427509] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 534.14169845595,
        ["y"] = -135.08143153492,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Dulhu",
    ["id"] = 83894,
    ["count"] = 0,
    ["health"] = 4731183,
    ["scale"] = 1,
    ["displayId"] = 59767,
    ["creatureType"] = "Elemental",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 1207,
    ["instanceID"] = 556,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [427510] = {
      },
      [427512] = {
      },
      [427513] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 550.68687898407,
        ["y"] = -131.96634854473,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Life Warden Gola",
    ["id"] = 83892,
    ["count"] = 0,
    ["health"] = 3154122,
    ["scale"] = 1,
    ["displayId"] = 57022,
    ["creatureType"] = "Humanoid",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 1207,
    ["instanceID"] = 556,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [168082] = {
      },
      [168092] = {
      },
      [427498] = {
      },
      [427500] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 546.38925729712,
        ["y"] = -147.68921250364,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Hapless Assistant",
    ["id"] = 212981,
    ["count"] = 3,
    ["health"] = 592422,
    ["scale"] = 0.8,
    ["displayId"] = 109997,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427245] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 482.72902169412,
        ["y"] = -143.6320223555,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 472.67031325921,
        ["y"] = -140.58902677436,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 490.52413099501,
        ["y"] = -160.93315164332,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 472.65290725323,
        ["y"] = -162.69106750385,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 481.00684231335,
        ["y"] = -167.20524704504,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 473.26501637697,
        ["y"] = -181.84879752662,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 473.92698418414,
        ["y"] = -175.28969768085,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 496.32547754036,
        ["y"] = -197.16126525609,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 505.39032905947,
        ["y"] = -196.32728906746,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 499.53761915135,
        ["y"] = -204.92146500689,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 500.94954671833,
        ["y"] = -185.37183681134,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 442.17225824641,
        ["y"] = -182.86011841827,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 435.34592613476,
        ["y"] = -177.44390991753,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 428.54327600789,
        ["y"] = -181.5339395221,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 433.80659712433,
        ["y"] = -188.42302812434,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 435.77812235692,
        ["y"] = -205.74550644957,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 429.55568085706,
        ["y"] = -202.40658701628,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Infested Icecaller",
    ["id"] = 84989,
    ["count"] = 5,
    ["health"] = 1579791,
    ["scale"] = 1,
    ["displayId"] = 58602,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [169840] = {
      },
      [426845] = {
      },
      [426849] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 479.23515599221,
        ["y"] = -136.13117044492,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 479.23515599221,
            ["y"] = -136.13117044492,
          },
          [2] = {
            ["x"] = 479.61046347567,
            ["y"] = -129.51900794455,
          },
          [3] = {
            ["x"] = 480.90781159231,
            ["y"] = -122.44252256652,
          },
          [4] = {
            ["x"] = 479.61046347567,
            ["y"] = -129.51900794455,
          },
          [5] = {
            ["x"] = 479.23515599221,
            ["y"] = -136.13117044492,
          },
          [6] = {
            ["x"] = 477.25161926946,
            ["y"] = -145.91284627837,
          },
          [7] = {
            ["x"] = 477.48749829116,
            ["y"] = -149.92285375944,
          },
          [8] = {
            ["x"] = 477.25161926946,
            ["y"] = -145.91284627837,
          },
        },
      },
      [2] = {
        ["x"] = 455.18498375465,
        ["y"] = -201.30825384773,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Putrid Pyromancer",
    ["id"] = 84957,
    ["count"] = 5,
    ["health"] = 1579791,
    ["scale"] = 1,
    ["displayId"] = 58590,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [169839] = {
      },
      [427223] = {
      },
      [427225] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 491.04826982195,
        ["y"] = -172.69006034009,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 469.29161131001,
        ["y"] = -190.58132964525,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Addled Arcanomancer",
    ["id"] = 84990,
    ["count"] = 5,
    ["health"] = 1579791,
    ["scale"] = 1,
    ["displayId"] = 58603,
    ["creatureType"] = "Humanoid",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [169841] = {
      },
      [426974] = {
      },
      [426982] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 479.29075930038,
        ["y"] = -179.09372571571,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 479.29075930038,
            ["y"] = -179.09372571571,
          },
          [2] = {
            ["x"] = 484.33087594569,
            ["y"] = -183.74225421869,
          },
          [3] = {
            ["x"] = 487.75117574953,
            ["y"] = -188.10609035528,
          },
          [4] = {
            ["x"] = 487.98705477123,
            ["y"] = -191.88020869167,
          },
          [5] = {
            ["x"] = 487.75117574953,
            ["y"] = -188.10609035528,
          },
          [6] = {
            ["x"] = 484.33087594569,
            ["y"] = -183.74225421869,
          },
          [7] = {
            ["x"] = 479.29075930038,
            ["y"] = -179.09372571571,
          },
          [8] = {
            ["x"] = 471.59321981174,
            ["y"] = -175.72224600521,
          },
          [9] = {
            ["x"] = 466.5217398614,
            ["y"] = -175.60430649437,
          },
          [10] = {
            ["x"] = 471.59321981174,
            ["y"] = -175.72224600521,
          },
        },
      },
      [2] = {
        ["x"] = 480.68306968018,
        ["y"] = -203.83589970775,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Archmage Sol",
    ["id"] = 82682,
    ["count"] = 0,
    ["health"] = 6899642,
    ["scale"] = 1,
    ["displayId"] = 57193,
    ["creatureType"] = "Humanoid",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 1208,
    ["instanceID"] = 556,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [166475] = {
      },
      [166476] = {
      },
      [166477] = {
      },
      [426991] = {
      },
      [427858] = {
      },
      [427863] = {
      },
      [427885] = {
      },
      [427899] = {
      },
      [427919] = {
      },
      [427922] = {
      },
      [428082] = {
      },
      [428084] = {
      },
      [428139] = {
      },
      [428148] = {
      },
      [428177] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 468.26399886255,
        ["y"] = -204.52991505641,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Yalnu",
    ["id"] = 83846,
    ["count"] = 0,
    ["health"] = 31541219,
    ["scale"] = 1,
    ["displayId"] = 57231,
    ["creatureType"] = "Giant",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 1210,
    ["instanceID"] = 556,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [169179] = {
      },
      [169613] = {
      },
      [428823] = {
      },
      [428834] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 365.77092592772,
        ["y"] = -193.5932634761,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Gnarled Ancient",
    ["id"] = 84400,
    ["count"] = 0,
    ["health"] = 658246,
    ["scale"] = 1.4,
    ["displayId"] = 54675,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [169929] = {
      },
      [169930] = {
      },
      [428948] = {
      },
      [428951] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 347.74834868099,
        ["y"] = -182.3468749244,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Vicious Mandragora",
    ["id"] = 84399,
    ["count"] = 0,
    ["health"] = 790404,
    ["scale"] = 1,
    ["displayId"] = 60380,
    ["creatureType"] = "Elemental",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["clones"] = {
      [1] = {
        ["x"] = 356.3887911946,
        ["y"] = -207.95666319383,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 350.14766565218,
        ["y"] = -201.77161409079,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
    },
  },
};
