local MDT = MDT
local L = MDT.L

local dungeonIndex = 50
MDT.dungeonList[dungeonIndex] = L["Neltharus"]
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides = {
    [1] = {
      zoomScale = 1.2999999523163,
      horizontalPan = 114.97134682804,
      verticalPan = 79.372355302235,
    },
    [2] = {
      zoomScale = 1.2999999523163,
      horizontalPan = 9.6320178171683,
      verticalPan = 94.339982247728,
    },
  }
};

local zones = { 2080, 2081 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "neltharus",
  [1] = "neltharus_A",
  [2] = "neltharus_B",
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["The Burning Cauldron"],
  [2] = L["Chamber of Flames"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 525, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 234.2,
      ["y"] = -278,
      ["target"] = 2,
      ["direction"] = 1,
      ["connectionIndex"] = 1,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 379.6,
      ["y"] = -277.5,
      ["target"] = 2,
      ["direction"] = 1,
      ["connectionIndex"] = 2,
    },
    [3] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 442.23127606642,
      ["y"] = -144.47641811804,
      ["graveyardDescription"] = "",
    },
  },
  [2] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 303.4,
      ["y"] = -187.4,
      ["target"] = 1,
      ["direction"] = -1,
      ["connectionIndex"] = 1,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 481,
      ["y"] = -207.8,
      ["target"] = 1,
      ["direction"] = -1,
      ["connectionIndex"] = 2,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Qalashi Warden",
    ["id"] = 193293,
    ["count"] = 10,
    ["health"] = 1779089,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 111187,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [382708] = {
      },
      [384597] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 448.53919726309,
        ["y"] = -292.08826484079,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 445.2,
        ["y"] = -352.6,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 432.20485469961,
        ["y"] = -291.38138289332,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 447.77754638854,
        ["y"] = -397.29871998611,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 402.3,
        ["y"] = -408.4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 385.8,
        ["y"] = -443.3,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 381.2,
            ["y"] = -449.5,
          },
          [2] = {
            ["x"] = 392.7,
            ["y"] = -430.3,
          },
          [3] = {
            ["x"] = 399.6,
            ["y"] = -421.9,
          },
        },
      },
      [7] = {
        ["x"] = 474.4,
        ["y"] = -409.9,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 492.3,
        ["y"] = -441.7,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 497.7,
            ["y"] = -452.7,
          },
          [2] = {
            ["x"] = 486.8,
            ["y"] = -425.1,
          },
          [3] = {
            ["x"] = 481.7,
            ["y"] = -419.2,
          },
        },
      },
      [9] = {
        ["x"] = 481.4,
        ["y"] = -435.7,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 399,
        ["y"] = -432.5,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 433.7,
        ["y"] = -185.2,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 444.6,
        ["y"] = -185.5,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Apex Blazewing",
    ["id"] = 193291,
    ["count"] = 15,
    ["health"] = 1581412,
    ["scale"] = 1.4,
    ["displayId"] = 104578,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [381662] = {
      },
      [381663] = {
      },
      [381670] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 440.49489651119,
        ["y"] = -285.00511489098,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 439.3,
        ["y"] = -400.70884277409,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 484.1,
        ["y"] = -450,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 393.3,
        ["y"] = -451.9,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Qalashi Lavamancer",
    ["id"] = 193944,
    ["count"] = 15,
    ["health"] = 1383736,
    ["scale"] = 1,
    ["displayId"] = 108666,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [372213] = {
      },
      [382791] = {
      },
      [382795] = {
      },
      [383231] = {
      },
      [383651] = {
      },
      [383660] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 433.2,
        ["y"] = -352.8,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 473.2,
        ["y"] = -393.6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 496.4,
        ["y"] = -426.8,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 389.3,
        ["y"] = -424.2,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 431.56123935897,
        ["y"] = -397.25994679184,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Qalashi Hunter",
    ["id"] = 189227,
    ["count"] = 5,
    ["health"] = 1186059,
    ["scale"] = 1,
    ["displayId"] = 108349,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [372561] = {
      },
      [372566] = {
      },
      [372570] = {
      },
      [372583] = {
      },
      [372824] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 391.2,
        ["y"] = -228.2,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 396.4,
        ["y"] = -213.3,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 366.3,
        ["y"] = -179.29487370684,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 322.7,
        ["y"] = -184.1,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 314.61025258632,
        ["y"] = -212.79266695076,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 332.1,
        ["y"] = -291.1,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 307.5,
        ["y"] = -323.8,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 346.4,
        ["y"] = -362.4,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 352.1,
        ["y"] = -357.9,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 337.6,
        ["y"] = -391.8,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 282.1,
        ["y"] = -360.8,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 238.8,
        ["y"] = -304,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Tamed Phoenix",
    ["id"] = 189247,
    ["count"] = 1,
    ["health"] = 395353,
    ["scale"] = 1,
    ["displayId"] = 109230,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 385.3,
        ["y"] = -249.1,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 389.2,
        ["y"] = -254.9,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 383.5,
        ["y"] = -260.4,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 376.9,
        ["y"] = -233.3,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 370.5,
            ["y"] = -253.2,
          },
          [2] = {
            ["x"] = 378.7,
            ["y"] = -239.9,
          },
          [3] = {
            ["x"] = 393.3,
            ["y"] = -238.9,
          },
          [4] = {
            ["x"] = 396.6,
            ["y"] = -233.9,
          },
          [5] = {
            ["x"] = 384,
            ["y"] = -221,
          },
          [6] = {
            ["x"] = 376.1,
            ["y"] = -237.5,
          },
          [7] = {
            ["x"] = 363,
            ["y"] = -247.5,
          },
          [8] = {
            ["x"] = 369.3,
            ["y"] = -253,
          },
        },
      },
      [5] = {
        ["x"] = 363.29634487756,
        ["y"] = -212.10365512244,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 356.51022978197,
        ["y"] = -215.7,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 356.60367792679,
        ["y"] = -207.91540168383,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 346.1,
        ["y"] = -219,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 339.50514909751,
        ["y"] = -222.3875406576,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 321.5,
        ["y"] = -210.3,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 359.90657465953,
        ["y"] = -179.80731024489,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 345.99340253612,
        ["y"] = -171.80583907417,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 339.5,
        ["y"] = -174.8,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 308.7,
        ["y"] = -240.2,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 301.01832122092,
        ["y"] = -244.10659746388,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 338.99048299904,
        ["y"] = -292.99270115729,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 336.6,
        ["y"] = -285.5,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 314.9,
        ["y"] = -335.4,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 312.2,
        ["y"] = -330,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 317.2,
        ["y"] = -434.9,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 316.1,
        ["y"] = -440.2,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 320.5,
        ["y"] = -438.4,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 274.1,
        ["y"] = -355.6,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 275.5,
        ["y"] = -362.8,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 246.4,
        ["y"] = -322.1,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 242.55946012199,
        ["y"] = -329.19185313199,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 250.90270816225,
        ["y"] = -330.11885703558,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 302.63112031196,
        ["y"] = -229.64693996357,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Overseer Lahar",
    ["id"] = 189235,
    ["count"] = 25,
    ["health"] = 2372119,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 108366,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [372461] = {
      },
      [372472] = {
      },
      [373406] = {
      },
      [376186] = {
      },
      [383928] = {
      },
      [395427] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 324.2,
        ["y"] = -321.7,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 324.6,
            ["y"] = -319.9,
          },
          [2] = {
            ["x"] = 306.4,
            ["y"] = -302.4,
          },
          [3] = {
            ["x"] = 309.5,
            ["y"] = -264.6,
          },
          [4] = {
            ["x"] = 332.9,
            ["y"] = -253.5,
          },
          [5] = {
            ["x"] = 329.6,
            ["y"] = -231.2,
          },
          [6] = {
            ["x"] = 343.1,
            ["y"] = -214.3,
          },
          [7] = {
            ["x"] = 327.9,
            ["y"] = -190.3,
          },
          [8] = {
            ["x"] = 353.9,
            ["y"] = -184.9,
          },
          [9] = {
            ["x"] = 354.1,
            ["y"] = -189.3,
          },
          [10] = {
            ["x"] = 333.5,
            ["y"] = -192.8,
          },
          [11] = {
            ["x"] = 347.3,
            ["y"] = -213.8,
          },
          [12] = {
            ["x"] = 333.8,
            ["y"] = -232,
          },
          [13] = {
            ["x"] = 336.2,
            ["y"] = -255.5,
          },
          [14] = {
            ["x"] = 313.4,
            ["y"] = -267,
          },
          [15] = {
            ["x"] = 311.4,
            ["y"] = -300.1,
          },
          [16] = {
            ["x"] = 328.3,
            ["y"] = -317.2,
          },
          [17] = {
            ["x"] = 324.6,
            ["y"] = -319.9,
          },
        },
      },
    },
  },
  [7] = {
    ["name"] = "Qalashi Trainee",
    ["id"] = 189266,
    ["count"] = 5,
    ["health"] = 988383,
    ["scale"] = 1,
    ["displayId"] = 108344,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [371875] = {
      },
      [372311] = {
      },
      [372372] = {
      },
      [372824] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 360.59777043957,
        ["y"] = -172.81613726919,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 328.69781604827,
        ["y"] = -188.08606948689,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 329.39340253612,
        ["y"] = -180.6956092922,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 334.4,
        ["y"] = -267.21027539067,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 339.68535670588,
        ["y"] = -272.90291953708,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 305.2,
        ["y"] = -259.4,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 329.9,
        ["y"] = -328.2,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 332.2,
        ["y"] = -352.1,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 316.4,
        ["y"] = -422.7,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 252.9,
        ["y"] = -364.8,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 289.7,
        ["y"] = -371.3,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 266.83617786543,
        ["y"] = -397.42199342107,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Qalashi Bonetender",
    ["id"] = 189265,
    ["count"] = 5,
    ["health"] = 1186059,
    ["scale"] = 1,
    ["displayId"] = 108347,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [372223] = {
      },
      [372226] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 300.50586187852,
        ["y"] = -264.19632207321,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 333.4,
        ["y"] = -330.8,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 325,
        ["y"] = -357.7,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 309.5,
        ["y"] = -423.5,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 316.1,
        ["y"] = -429.5,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 279.9,
        ["y"] = -400.5,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Chargath, Bane of Scales",
    ["id"] = 189340,
    ["count"] = 0,
    ["health"] = 7904040,
    ["scale"] = 1.2,
    ["displayId"] = 108248,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2490,
    ["instanceID"] = 1199,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [373424] = {
      },
      [373733] = {
      },
      [373735] = {
      },
      [373742] = {
      },
      [373756] = {
      },
      [373762] = {
      },
      [374655] = {
      },
      [374704] = {
      },
      [375055] = {
      },
      [375056] = {
      },
      [375057] = {
      },
      [375397] = {
      },
      [384019] = {
      },
      [388523] = {
      },
      [389059] = {
      },
      [396332] = {
      },
      [396424] = {
      },
      [396672] = {
      },
      [414585] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 366.6,
        ["y"] = -375.5,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Warlord Sargha",
    ["id"] = 189901,
    ["count"] = 0,
    ["health"] = 7904040,
    ["scale"] = 1.2,
    ["displayId"] = 107029,
    ["creatureType"] = "Humanoid",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2501,
    ["instanceID"] = 1199,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [376780] = {
      },
      [376783] = {
      },
      [376784] = {
      },
      [377014] = {
      },
      [377017] = {
      },
      [377018] = {
      },
      [377204] = {
      },
      [377473] = {
      },
      [377477] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 441.30437392072,
        ["y"] = -464.29360026517,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Qalashi Spinecrusher",
    ["id"] = 192787,
    ["count"] = 5,
    ["health"] = 1383736,
    ["scale"] = 1,
    ["displayId"] = 108029,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Root"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [378847] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 498.3,
        ["y"] = -224.6,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 485.6,
        ["y"] = -234,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 563.20068997666,
        ["y"] = -267.28535670588,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 621.4,
        ["y"] = -280.1,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Ore Elemental",
    ["id"] = 192781,
    ["count"] = 3,
    ["health"] = 790706,
    ["scale"] = 1,
    ["displayId"] = 109407,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [378149] = {
      },
      [378172] = {
      },
      [378202] = {
      },
      [378221] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 493.5,
        ["y"] = -226.4,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 488.8,
        ["y"] = -229.2,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 527.60953980531,
        ["y"] = -190.13665587899,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 499.1,
            ["y"] = -234.9,
          },
          [2] = {
            ["x"] = 504.2,
            ["y"] = -240.6,
          },
          [3] = {
            ["x"] = 532.5,
            ["y"] = -227.9,
          },
          [4] = {
            ["x"] = 547.3,
            ["y"] = -214,
          },
          [5] = {
            ["x"] = 543.3,
            ["y"] = -197.7,
          },
          [6] = {
            ["x"] = 527.9,
            ["y"] = -180.9,
          },
          [7] = {
            ["x"] = 524.3,
            ["y"] = -183.3,
          },
          [8] = {
            ["x"] = 539.5,
            ["y"] = -199.3,
          },
          [9] = {
            ["x"] = 541.9,
            ["y"] = -213.6,
          },
          [10] = {
            ["x"] = 529.8,
            ["y"] = -224.3,
          },
          [11] = {
            ["x"] = 499.8,
            ["y"] = -235.2,
          },
        },
      },
      [4] = {
        ["x"] = 533.5,
        ["y"] = -186.9,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 592.9,
        ["y"] = -239,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 614.8,
            ["y"] = -277.4,
          },
          [2] = {
            ["x"] = 617.5,
            ["y"] = -275.7,
          },
          [3] = {
            ["x"] = 603,
            ["y"] = -249.6,
          },
          [4] = {
            ["x"] = 568.1,
            ["y"] = -209.1,
          },
          [5] = {
            ["x"] = 565.7,
            ["y"] = -210.9,
          },
          [6] = {
            ["x"] = 601,
            ["y"] = -251.2,
          },
          [7] = {
            ["x"] = 613.9,
            ["y"] = -276.6,
          },
        },
      },
      [6] = {
        ["x"] = 592.7,
        ["y"] = -245.7,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 599.5,
        ["y"] = -241.7,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 614.7,
        ["y"] = -290,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 617.1,
        ["y"] = -284.3,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Qalashi Plunderer",
    ["id"] = 192786,
    ["count"] = 5,
    ["health"] = 1284898,
    ["scale"] = 1,
    ["displayId"] = 108663,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [378827] = {
      },
      [378831] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 518.9,
        ["y"] = -255.1,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 503.1,
        ["y"] = -261.9,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 557.6,
        ["y"] = -236.5,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 558.3,
        ["y"] = -229.6,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 563.81613726919,
        ["y"] = -258.21466609847,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 528.4,
        ["y"] = -164.7,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 536.7,
        ["y"] = -168.60296514579,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 551.9,
        ["y"] = -197,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 558.9,
        ["y"] = -199.7,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 612,
        ["y"] = -281.6,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Qalashi Thaumaturge",
    ["id"] = 192788,
    ["count"] = 5,
    ["health"] = 948849,
    ["scale"] = 1,
    ["displayId"] = 107985,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [378281] = {
      },
      [378282] = {
      },
      [378818] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 512.8,
        ["y"] = -260.4,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 535.09924161029,
        ["y"] = -194.0897360115,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 564.9,
        ["y"] = -229.4,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 558.1,
        ["y"] = -262,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 569.60949419661,
        ["y"] = -264.2765638881,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 533.09926441464,
        ["y"] = -163.60951700096,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 539.3,
        ["y"] = -174.20073558536,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 562.9,
        ["y"] = -193.2,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 621.4,
        ["y"] = -292.3,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Magmatusk",
    ["id"] = 181861,
    ["count"] = 0,
    ["health"] = 6916035,
    ["scale"] = 1.2,
    ["displayId"] = 102604,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2494,
    ["instanceID"] = 1199,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [374365] = {
      },
      [374410] = {
      },
      [375251] = {
      },
      [375436] = {
      },
      [375439] = {
      },
      [375449] = {
      },
      [375455] = {
      },
      [375535] = {
      },
      [375890] = {
      },
      [391457] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 560.3,
        ["y"] = -348.2,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Qalashi Lavabearer",
    ["id"] = 189472,
    ["count"] = 15,
    ["health"] = 1779089,
    ["scale"] = 1,
    ["displayId"] = 108665,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [372211] = {
      },
      [372213] = {
      },
      [379404] = {
      },
      [379406] = {
      },
      [379410] = {
      },
      [381329] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 332.6,
        ["y"] = -210.9,
        ["g"] = 30,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 486.3,
        ["y"] = -263.2,
        ["g"] = 34,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 480.3,
        ["y"] = -256.5,
        ["g"] = 34,
        ["sublevel"] = 2,
      },
      [4] = {
        ["x"] = 324.4,
        ["y"] = -397.8,
        ["g"] = 41,
        ["sublevel"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 317.1,
            ["y"] = -408.3,
          },
          [2] = {
            ["x"] = 319.5,
            ["y"] = -411.1,
          },
          [3] = {
            ["x"] = 332.6,
            ["y"] = -397,
          },
          [4] = {
            ["x"] = 336,
            ["y"] = -384.8,
          },
          [5] = {
            ["x"] = 332.2,
            ["y"] = -384,
          },
          [6] = {
            ["x"] = 328.9,
            ["y"] = -395.2,
          },
          [7] = {
            ["x"] = 317.1,
            ["y"] = -408.3,
          },
        },
      },
      [5] = {
        ["x"] = 274.9,
        ["y"] = -318.7,
        ["g"] = 44,
        ["sublevel"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 263.3,
            ["y"] = -315.2,
          },
          [2] = {
            ["x"] = 264.3,
            ["y"] = -320.4,
          },
          [3] = {
            ["x"] = 280.2,
            ["y"] = -316.2,
          },
          [4] = {
            ["x"] = 299.1,
            ["y"] = -319,
          },
          [5] = {
            ["x"] = 298.7,
            ["y"] = -313.8,
          },
          [6] = {
            ["x"] = 279.1,
            ["y"] = -311.4,
          },
          [7] = {
            ["x"] = 263.2,
            ["y"] = -315.2,
          },
        },
      },
    },
  },
  [17] = {
    ["name"] = "Lava Flare",
    ["id"] = 189470,
    ["count"] = 3,
    ["health"] = 790706,
    ["scale"] = 1,
    ["displayId"] = 102505,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [372538] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 324.9,
        ["y"] = -212.9,
        ["g"] = 30,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 322.7,
        ["y"] = -206.3,
        ["g"] = 30,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 405.5,
        ["y"] = -189.2,
        ["g"] = 32,
        ["sublevel"] = 2,
      },
      [4] = {
        ["x"] = 417.3,
        ["y"] = -190.4,
        ["g"] = 32,
        ["sublevel"] = 2,
      },
      [5] = {
        ["x"] = 427,
        ["y"] = -187.9,
        ["g"] = 32,
        ["sublevel"] = 2,
      },
      [6] = {
        ["x"] = 366.9,
        ["y"] = -203.1,
        ["g"] = 31,
        ["sublevel"] = 2,
      },
      [7] = {
        ["x"] = 368.2,
        ["y"] = -216,
        ["g"] = 31,
        ["sublevel"] = 2,
      },
      [8] = {
        ["x"] = 406.6,
        ["y"] = -238.2,
        ["g"] = 33,
        ["sublevel"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 410.3,
            ["y"] = -207.9,
          },
          [2] = {
            ["x"] = 405.3,
            ["y"] = -208.6,
          },
          [3] = {
            ["x"] = 411.1,
            ["y"] = -243.5,
          },
          [4] = {
            ["x"] = 416.7,
            ["y"] = -242,
          },
          [5] = {
            ["x"] = 410.2,
            ["y"] = -207.9,
          },
        },
      },
      [9] = {
        ["x"] = 422.4,
        ["y"] = -233.2,
        ["g"] = 33,
        ["sublevel"] = 2,
      },
      [10] = {
        ["x"] = 460.7,
        ["y"] = -325.5,
        ["g"] = 35,
        ["sublevel"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 465,
            ["y"] = -313.1,
          },
          [2] = {
            ["x"] = 461.1,
            ["y"] = -316.1,
          },
          [3] = {
            ["x"] = 484.7,
            ["y"] = -340.6,
          },
          [4] = {
            ["x"] = 486.8,
            ["y"] = -337.5,
          },
          [5] = {
            ["x"] = 465,
            ["y"] = -313.1,
          },
        },
      },
      [11] = {
        ["x"] = 473,
        ["y"] = -315.3,
        ["g"] = 35,
        ["sublevel"] = 2,
      },
      [12] = {
        ["x"] = 496.2,
        ["y"] = -360.3,
        ["g"] = 36,
        ["sublevel"] = 2,
      },
      [13] = {
        ["x"] = 495.8,
        ["y"] = -366,
        ["g"] = 36,
        ["sublevel"] = 2,
      },
      [14] = {
        ["x"] = 495.9,
        ["y"] = -371.1,
        ["g"] = 36,
        ["sublevel"] = 2,
      },
      [15] = {
        ["x"] = 381.1,
        ["y"] = -334.8,
        ["g"] = 37,
        ["sublevel"] = 2,
      },
      [16] = {
        ["x"] = 374.5,
        ["y"] = -338.7,
        ["g"] = 37,
        ["sublevel"] = 2,
      },
      [17] = {
        ["x"] = 354.8,
        ["y"] = -305.9,
        ["g"] = 38,
        ["sublevel"] = 2,
      },
      [18] = {
        ["x"] = 362.2,
        ["y"] = -302.6,
        ["g"] = 38,
        ["sublevel"] = 2,
      },
      [19] = {
        ["x"] = 290.4,
        ["y"] = -395.1,
        ["g"] = 42,
        ["sublevel"] = 2,
      },
      [20] = {
        ["x"] = 299.9,
        ["y"] = -391.3,
        ["g"] = 42,
        ["sublevel"] = 2,
      },
      [21] = {
        ["x"] = 266.5,
        ["y"] = -350.7,
        ["g"] = 43,
        ["sublevel"] = 2,
      },
      [22] = {
        ["x"] = 272.8,
        ["y"] = -348.5,
        ["g"] = 43,
        ["sublevel"] = 2,
      },
      [23] = {
        ["x"] = 331.3,
        ["y"] = -417.8,
        ["g"] = 40,
        ["sublevel"] = 2,
      },
      [24] = {
        ["x"] = 340.4,
        ["y"] = -407.5,
        ["g"] = 40,
        ["sublevel"] = 2,
      },
      [25] = {
        ["x"] = 265.6,
        ["y"] = -303.2,
        ["sublevel"] = 2,
      },
      [26] = {
        ["x"] = 280.8,
        ["y"] = -301,
        ["sublevel"] = 2,
      },
      [27] = {
        ["x"] = 212.4,
        ["y"] = -471.7,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [28] = {
        ["x"] = 221.7,
        ["y"] = -471.5,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [29] = {
        ["x"] = 217.3,
        ["y"] = -463.5,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [30] = {
        ["x"] = 171.5,
        ["y"] = -381,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
      [31] = {
        ["x"] = 165.2,
        ["y"] = -371.5,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
      [32] = {
        ["x"] = 161.9,
        ["y"] = -380.4,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
    },
  },
  [18] = {
    ["name"] = "Qalashi Bonesplitter",
    ["id"] = 189467,
    ["count"] = 5,
    ["health"] = 1284898,
    ["scale"] = 1,
    ["displayId"] = 111189,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [372224] = {
      },
      [372225] = {
      },
      [372262] = {
      },
      [372266] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 405,
        ["y"] = -180.1,
        ["g"] = 32,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 415.2,
        ["y"] = -180.1,
        ["g"] = 32,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 406.5,
        ["y"] = -228.4,
        ["g"] = 33,
        ["sublevel"] = 2,
      },
      [4] = {
        ["x"] = 414.9,
        ["y"] = -226.1,
        ["g"] = 33,
        ["sublevel"] = 2,
      },
      [5] = {
        ["x"] = 468.1,
        ["y"] = -328.7,
        ["g"] = 35,
        ["sublevel"] = 2,
      },
      [6] = {
        ["x"] = 474.3,
        ["y"] = -323.4,
        ["g"] = 35,
        ["sublevel"] = 2,
      },
      [7] = {
        ["x"] = 503,
        ["y"] = -364.7,
        ["g"] = 36,
        ["sublevel"] = 2,
      },
      [8] = {
        ["x"] = 332.2,
        ["y"] = -401.7,
        ["g"] = 41,
        ["sublevel"] = 2,
      },
      [9] = {
        ["x"] = 273.8,
        ["y"] = -313,
        ["g"] = 44,
        ["sublevel"] = 2,
      },
    },
  },
  [19] = {
    ["name"] = "Qalashi Irontorch",
    ["id"] = 189464,
    ["count"] = 5,
    ["health"] = 1383736,
    ["scale"] = 1,
    ["displayId"] = 101960,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [372201] = {
      },
      [372202] = {
      },
      [372203] = {
      },
      [384161] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 367.9,
        ["y"] = -208.8,
        ["g"] = 31,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 414.4,
        ["y"] = -236.1,
        ["g"] = 33,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 467,
        ["y"] = -320.5,
        ["g"] = 35,
        ["sublevel"] = 2,
      },
      [4] = {
        ["x"] = 337.5,
        ["y"] = -329.3,
        ["g"] = 39,
        ["sublevel"] = 2,
      },
      [5] = {
        ["x"] = 344.2,
        ["y"] = -343.1,
        ["g"] = 39,
        ["sublevel"] = 2,
      },
      [6] = {
        ["x"] = 257.1,
        ["y"] = -419.8,
        ["g"] = 47,
        ["sublevel"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 236.6,
            ["y"] = -406.6,
          },
          [2] = {
            ["x"] = 229.5,
            ["y"] = -410.2,
          },
          [3] = {
            ["x"] = 247.1,
            ["y"] = -431.5,
          },
          [4] = {
            ["x"] = 267,
            ["y"] = -441.4,
          },
          [5] = {
            ["x"] = 284.2,
            ["y"] = -438.9,
          },
          [6] = {
            ["x"] = 280.3,
            ["y"] = -433.1,
          },
          [7] = {
            ["x"] = 266.7,
            ["y"] = -433.3,
          },
          [8] = {
            ["x"] = 252.2,
            ["y"] = -426.4,
          },
          [9] = {
            ["x"] = 236.5,
            ["y"] = -406.5,
          },
        },
      },
      [7] = {
        ["x"] = 246.9,
        ["y"] = -435.5,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [8] = {
        ["x"] = 210.2,
        ["y"] = -370.8,
        ["g"] = 45,
        ["sublevel"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 227.9,
            ["y"] = -391.5,
          },
          [2] = {
            ["x"] = 221.8,
            ["y"] = -394.2,
          },
          [3] = {
            ["x"] = 213.8,
            ["y"] = -377.1,
          },
          [4] = {
            ["x"] = 214.3,
            ["y"] = -354.3,
          },
          [5] = {
            ["x"] = 226.4,
            ["y"] = -339.3,
          },
          [6] = {
            ["x"] = 229.6,
            ["y"] = -343.6,
          },
          [7] = {
            ["x"] = 219.2,
            ["y"] = -356.1,
          },
          [8] = {
            ["x"] = 219.9,
            ["y"] = -376.4,
          },
          [9] = {
            ["x"] = 228,
            ["y"] = -391.5,
          },
        },
      },
      [9] = {
        ["x"] = 229.7,
        ["y"] = -370.4,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
    },
  },
  [20] = {
    ["name"] = "Irontorch Commander",
    ["id"] = 189466,
    ["count"] = 30,
    ["health"] = 2569795,
    ["scale"] = 1,
    ["displayId"] = 111190,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["spells"] = {
      [372293] = {
      },
      [372296] = {
      },
      [372542] = {
      },
      [372543] = {
      },
      [373084] = {
      },
      [373089] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 407.5,
        ["y"] = -297.9,
        ["sublevel"] = 2,
      },
    },
  },
  [21] = {
    ["name"] = "Qalashi Blacksmith",
    ["id"] = 189471,
    ["count"] = 5,
    ["health"] = 1383736,
    ["scale"] = 1,
    ["displayId"] = 109595,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [372971] = {
      },
      [384623] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 502.7,
        ["y"] = -371,
        ["g"] = 36,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 343.5,
        ["y"] = -334.8,
        ["g"] = 39,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 297.3,
        ["y"] = -398.7,
        ["g"] = 42,
        ["sublevel"] = 2,
      },
      [4] = {
        ["x"] = 266,
        ["y"] = -342.5,
        ["g"] = 43,
        ["sublevel"] = 2,
      },
      [5] = {
        ["x"] = 176,
        ["y"] = -387.3,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
    },
  },
  [22] = {
    ["name"] = "Forgemaster Gorek",
    ["id"] = 189478,
    ["count"] = 0,
    ["health"] = 6916035,
    ["scale"] = 1.6,
    ["displayId"] = 107189,
    ["creatureType"] = "Giant",
    ["level"] = 70,
    ["isBoss"] = true,
    ["encounterID"] = 2489,
    ["instanceID"] = 1199,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [374397] = {
      },
      [374517] = {
      },
      [374533] = {
      },
      [374534] = {
      },
      [374535] = {
      },
      [374586] = {
      },
      [374635] = {
      },
      [374641] = {
      },
      [374812] = {
      },
      [374839] = {
      },
      [374842] = {
      },
      [374969] = {
      },
      [375046] = {
      },
      [375061] = {
      },
      [375291] = {
      },
      [375306] = {
      },
      [377995] = {
      },
      [392666] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 279.1,
        ["y"] = -372.4,
        ["sublevel"] = 2,
      },
    },
  },
  [23] = {
    ["name"] = "Forgewrought Monstrosity",
    ["id"] = 194816,
    ["count"] = 15,
    ["health"] = 1581412,
    ["scale"] = 1,
    ["displayId"] = 108693,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["spells"] = {
      [384662] = {
      },
      [384663] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 251.9,
        ["y"] = -427.5,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 219.6,
        ["y"] = -370.5,
        ["g"] = 45,
        ["sublevel"] = 2,
      },
    },
  },
};
