local MDT = MDT
local L = MDT.L
local dungeonIndex = 43
MDT.dungeonList[dungeonIndex] = L["TheNokhudOffensive"]
MDT.mapInfo[dungeonIndex] = {
  tileFormat = {
    [1] = 15,
    [2] = 15
  },
  viewportPositionOverrides = {
    [1] = {
      zoomScale = 1.5999999046326;
      horizontalPan = 190.34651518134;
      verticalPan = 136.03545281987;
    };
  }
};
local zones = { 2093 }
-- add zones to MDT.zoneIdToDungeonIdx
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "CentaurPlanes",
  [1] = "CentaurPlanes",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["TheNokhudOffensive"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 520, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "zoom";
      ["x"] = 584.76644744465;
      ["y"] = -262.88213425998;
      ["index"] = 4;
      ["value1"] = 8.2000017166138;
      ["value2"] = 568.19426018705;
      ["value3"] = 248.71834312246;
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "zoom";
      ["x"] = 503.13067910415;
      ["y"] = -427.26538483192;
      ["index"] = 4;
      ["value1"] = 9.1000022888184;
      ["value2"] = 420.42599273345;
      ["value3"] = 397.30275368747;
    };
    [3] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "zoom";
      ["x"] = 343.3009998415;
      ["y"] = -364.1670206858;
      ["index"] = 4;
      ["value1"] = 7.9000015258789;
      ["value2"] = 243.94547136942;
      ["value3"] = 333.29417946386;
    };
    [4] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "zoom";
      ["x"] = 344.26202230623;
      ["y"] = -249.00150159943;
      ["index"] = 4;
      ["value1"] = 8.5000019073486;
      ["value2"] = 261.85479563384;
      ["value3"] = 192.07595205558;
    };
  };
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Nokhud Warspear";
    ["id"] = 192791;
    ["count"] = 6;
    ["health"] = 717007;
    ["scale"] = 1;
    ["displayId"] = 108672;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [381683] = {
      };
      [381692] = {
      };
      [384134] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 606.57399443154;
        ["y"] = -264.08121961371;
        ["g"] = 1;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 620.15472936646;
        ["y"] = -274.71660555454;
        ["g"] = 2;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
        ["patrol"] = {
          [1] = {
            ["x"] = 620.15472936646;
            ["y"] = -274.71660555454;
          };
          [2] = {
            ["x"] = 623.17792138823;
            ["y"] = -275.2547130524;
          };
          [3] = {
            ["x"] = 627.26575958108;
            ["y"] = -274.05239232345;
          };
          [4] = {
            ["x"] = 631.71434077446;
            ["y"] = -270.32523521398;
          };
          [5] = {
            ["x"] = 627.26575958108;
            ["y"] = -274.05239232345;
          };
          [6] = {
            ["x"] = 623.17792138823;
            ["y"] = -275.2547130524;
          };
          [7] = {
            ["x"] = 620.15472936646;
            ["y"] = -274.71660555454;
          };
          [8] = {
            ["x"] = 615.48312100853;
            ["y"] = -272.72985603284;
          };
          [9] = {
            ["x"] = 612.23688806284;
            ["y"] = -269.84431792989;
          };
          [10] = {
            ["x"] = 615.48312100853;
            ["y"] = -272.72985603284;
          };
        };
      };
      [3] = {
        ["x"] = 617.23984976975;
        ["y"] = -275.60158224402;
        ["g"] = 2;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 592.82198286367;
        ["y"] = -297.60702535042;
        ["g"] = 3;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 611.34232536158;
        ["y"] = -314.55181169677;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 614.02122251157;
        ["y"] = -310.06796448531;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [7] = {
        ["x"] = 608.45258018285;
        ["y"] = -291.92014704644;
        ["g"] = 5;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [8] = {
        ["x"] = 610.99432225376;
        ["y"] = -293.13709167564;
        ["g"] = 5;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [9] = {
        ["x"] = 636.15060415139;
        ["y"] = -290.92272273972;
        ["g"] = 6;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [10] = {
        ["x"] = 627.74381861596;
        ["y"] = -255.75394463591;
        ["g"] = 7;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [11] = {
        ["x"] = 635.09278327778;
        ["y"] = -273.68626665925;
        ["g"] = 8;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [12] = {
        ["x"] = 341.08635444718;
        ["y"] = -226.40965390193;
        ["g"] = 38;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [13] = {
        ["x"] = 341.35834062759;
        ["y"] = -230.13971182839;
        ["g"] = 38;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [14] = {
        ["x"] = 333.65702285112;
        ["y"] = -216.55221866702;
        ["g"] = 39;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [15] = {
        ["x"] = 333.85863573872;
        ["y"] = -220.0804788096;
        ["g"] = 39;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [16] = {
        ["x"] = 309.46308409681;
        ["y"] = -217.17938339854;
        ["g"] = 41;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [17] = {
        ["x"] = 308.65662100988;
        ["y"] = -223.12705010677;
        ["g"] = 41;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [18] = {
        ["x"] = 293.47477392535;
        ["y"] = -238.5421177803;
        ["g"] = 46;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [19] = {
        ["x"] = 285.76824922951;
        ["y"] = -237.89217625144;
        ["g"] = 46;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [20] = {
        ["x"] = 301.70039106068;
        ["y"] = -199.09077713849;
        ["g"] = 43;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [21] = {
        ["x"] = 295.73998676227;
        ["y"] = -198.61120865951;
        ["g"] = 43;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [2] = {
    ["name"] = "Nokhud Longbow";
    ["id"] = 192789;
    ["count"] = 5;
    ["health"] = 645307;
    ["scale"] = 1;
    ["displayId"] = 108667;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Imprison"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [373392] = {
      };
      [384476] = {
      };
      [384479] = {
      };
      [384868] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 608.40686659712;
        ["y"] = -268.9466718941;
        ["g"] = 1;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 605.58577201654;
        ["y"] = -267.40832349918;
        ["g"] = 1;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 618.69600717688;
        ["y"] = -272.31410585197;
        ["g"] = 2;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 595.35959464014;
        ["y"] = -300.2897646982;
        ["g"] = 3;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 593.92795422905;
        ["y"] = -303.85039946272;
        ["g"] = 3;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 604.44255417827;
        ["y"] = -315.09479291803;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [7] = {
        ["x"] = 612.79407123472;
        ["y"] = -303.50809301717;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [8] = {
        ["x"] = 610.42928080362;
        ["y"] = -286.24422090372;
        ["g"] = 5;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [9] = {
        ["x"] = 608.07299221726;
        ["y"] = -288.5903968042;
        ["g"] = 5;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [10] = {
        ["x"] = 630.84104915121;
        ["y"] = -257.97370078832;
        ["g"] = 7;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [11] = {
        ["x"] = 625.54221758521;
        ["y"] = -259.77201101063;
        ["g"] = 7;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [12] = {
        ["x"] = 638.56265506223;
        ["y"] = -276.88246955224;
        ["g"] = 8;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [13] = {
        ["x"] = 630.50478563931;
        ["y"] = -307.34991774959;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [14] = {
        ["x"] = 626.84552184166;
        ["y"] = -307.86373779963;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [3] = {
    ["name"] = "Nokhud Hornsounder";
    ["id"] = 192796;
    ["count"] = 5;
    ["health"] = 573606;
    ["scale"] = 1;
    ["displayId"] = 108597;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Polymorph"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Imprison"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [373392] = {
      };
      [383823] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 608.9709258747;
        ["y"] = -265.65812385594;
        ["g"] = 1;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 591.05779012103;
        ["y"] = -301.82997633547;
        ["g"] = 3;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 613.14397450329;
        ["y"] = -306.8381650359;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 633.91281335604;
        ["y"] = -292.68272527861;
        ["g"] = 6;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 638.33174174873;
        ["y"] = -274.44071514846;
        ["g"] = 8;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 631.32887566205;
        ["y"] = -302.57363962556;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [4] = {
    ["name"] = "Nokhud Beastmaster";
    ["id"] = 192794;
    ["count"] = 5;
    ["health"] = 717007;
    ["scale"] = 1;
    ["displayId"] = 108670;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [383690] = {
      };
      [383693] = {
      };
      [384492] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 607.54409861909;
        ["y"] = -315.88007940592;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 640.57524254368;
        ["y"] = -289.90821832022;
        ["g"] = 6;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 629.11755088915;
        ["y"] = -260.77067701414;
        ["g"] = 7;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 623.01991472909;
        ["y"] = -307.50352400838;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [5] = {
    ["name"] = "Nokhud Plainstomper";
    ["id"] = 191847;
    ["count"] = 8;
    ["health"] = 1290613;
    ["scale"] = 1;
    ["displayId"] = 108673;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [384336] = {
      };
      [384365] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 614.59659485845;
        ["y"] = -313.4167097925;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
        ["patrol"] = {
          [1] = {
            ["x"] = 614.59659485845;
            ["y"] = -313.4167097925;
          };
          [2] = {
            ["x"] = 621.97508569367;
            ["y"] = -316.47218979862;
          };
          [3] = {
            ["x"] = 635.15075736064;
            ["y"] = -316.01278485163;
          };
          [4] = {
            ["x"] = 643.68720426559;
            ["y"] = -309.52030520088;
          };
          [5] = {
            ["x"] = 647.10341280888;
            ["y"] = -301.20281836024;
          };
          [6] = {
            ["x"] = 649.98895779151;
            ["y"] = -289.05947806526;
          };
          [7] = {
            ["x"] = 648.97736318739;
            ["y"] = -274.53303616821;
          };
          [8] = {
            ["x"] = 645.66063343789;
            ["y"] = -266.33579240796;
          };
          [9] = {
            ["x"] = 638.80745206471;
            ["y"] = -254.55313319636;
          };
          [10] = {
            ["x"] = 645.66063343789;
            ["y"] = -266.33579240796;
          };
          [11] = {
            ["x"] = 648.97736318739;
            ["y"] = -274.53303616821;
          };
          [12] = {
            ["x"] = 649.98895779151;
            ["y"] = -289.05947806526;
          };
          [13] = {
            ["x"] = 647.10341280888;
            ["y"] = -301.20281836024;
          };
          [14] = {
            ["x"] = 643.68720426559;
            ["y"] = -309.52030520088;
          };
          [15] = {
            ["x"] = 635.15075736064;
            ["y"] = -316.01278485163;
          };
          [16] = {
            ["x"] = 620.36234448444;
            ["y"] = -315.17115896543;
          };
          [17] = {
            ["x"] = 614.59659485845;
            ["y"] = -313.4167097925;
          };
          [18] = {
            ["x"] = 606.10458140955;
            ["y"] = -307.33461004793;
          };
          [19] = {
            ["x"] = 599.6121017588;
            ["y"] = -298.79819754139;
          };
          [20] = {
            ["x"] = 595.04331876313;
            ["y"] = -287.85717109568;
          };
          [21] = {
            ["x"] = 595.4040067262;
            ["y"] = -280.16237071598;
          };
          [22] = {
            ["x"] = 598.28955170882;
            ["y"] = -271.98665305219;
          };
          [23] = {
            ["x"] = 595.4040067262;
            ["y"] = -280.16237071598;
          };
          [24] = {
            ["x"] = 595.04331876313;
            ["y"] = -287.85717109568;
          };
          [25] = {
            ["x"] = 599.6121017588;
            ["y"] = -298.79819754139;
          };
          [26] = {
            ["x"] = 606.10458140955;
            ["y"] = -307.33461004793;
          };
        };
      };
      [2] = {
        ["x"] = 638.00024235804;
        ["y"] = -288.42345579651;
        ["g"] = 6;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
        ["patrol"] = {
          [1] = {
            ["x"] = 638.00024235804;
            ["y"] = -288.42345579651;
          };
          [2] = {
            ["x"] = 635.44097603863;
            ["y"] = -284.13000710653;
          };
          [3] = {
            ["x"] = 632.31497241396;
            ["y"] = -279.92191207393;
          };
          [4] = {
            ["x"] = 629.06873946826;
            ["y"] = -275.71382392101;
          };
          [5] = {
            ["x"] = 625.58203412116;
            ["y"] = -275.23289287756;
          };
          [6] = {
            ["x"] = 621.37393908856;
            ["y"] = -276.55544292753;
          };
          [7] = {
            ["x"] = 617.40630269801;
            ["y"] = -278.71959134498;
          };
          [8] = {
            ["x"] = 614.76121635743;
            ["y"] = -281.1242259232;
          };
          [9] = {
            ["x"] = 614.16006975231;
            ["y"] = -284.6109312703;
          };
          [10] = {
            ["x"] = 614.03984043129;
            ["y"] = -287.85717109568;
          };
          [11] = {
            ["x"] = 614.76121635743;
            ["y"] = -293.26757997754;
          };
          [12] = {
            ["x"] = 617.16584405596;
            ["y"] = -298.31728713698;
          };
          [13] = {
            ["x"] = 622.09534253342;
            ["y"] = -300.00051827034;
          };
          [14] = {
            ["x"] = 626.90457041177;
            ["y"] = -299.63982342759;
          };
          [15] = {
            ["x"] = 633.39705006252;
            ["y"] = -298.07681473557;
          };
          [16] = {
            ["x"] = 636.7635260886;
            ["y"] = -294.95080423122;
          };
          [17] = {
            ["x"] = 637.4849157741;
            ["y"] = -292.30573165;
          };
        };
      };
    };
  };
  [6] = {
    ["name"] = "War Ohuna";
    ["id"] = 192803;
    ["count"] = 0;
    ["health"] = 286803;
    ["scale"] = 1;
    ["displayId"] = 101437;
    ["creatureType"] = "Beast";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [334610] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 601.63286748556;
        ["y"] = -315.42689958954;
        ["g"] = 4;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 642.94590093773;
        ["y"] = -291.83624442739;
        ["g"] = 6;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 624.64526437331;
        ["y"] = -256.77417062306;
        ["g"] = 7;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 622.10676833137;
        ["y"] = -303.73622091067;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [7] = {
    ["name"] = "Nokhud Lancemaster";
    ["id"] = 192800;
    ["count"] = 10;
    ["health"] = 1290613;
    ["scale"] = 1;
    ["displayId"] = 108528;
    ["iconTexture"] = 135127;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [384336] = {
      };
      [384365] = {
      };
      [384510] = {
      };
      [384512] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 611.57369733675;
        ["y"] = -289.88661056548;
        ["g"] = 5;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [2] = {
        ["x"] = 635.04961737117;
        ["y"] = -277.77232793662;
        ["g"] = 8;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [3] = {
        ["x"] = 626.49513595981;
        ["y"] = -303.62892217;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [8] = {
    ["name"] = "Granyth";
    ["id"] = 186616;
    ["count"] = 0;
    ["health"] = 5437189;
    ["scale"] = 1;
    ["displayId"] = 105823;
    ["creatureType"] = "Dragonkin";
    ["level"] = 72;
    ["isBoss"] = true;
    ["encounterID"] = 2498;
    ["instanceID"] = 1198;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [385916] = {
      };
      [387155] = {
      };
      [388283] = {
      };
      [388817] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 626.53037929075;
        ["y"] = -287.26134154154;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [9] = {
    ["name"] = "Primalist Arcblade";
    ["id"] = 194898;
    ["count"] = 6;
    ["health"] = 860408;
    ["scale"] = 1;
    ["displayId"] = 109038;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Sap"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [387135] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 484.57902857686;
        ["y"] = -416.58695372769;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 479.87332596712;
        ["y"] = -412.94224171926;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 452.89082992336;
        ["y"] = -411.39001377584;
        ["g"] = 11;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 474.13019670798;
        ["y"] = -446.27016416313;
        ["g"] = 16;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 480.77482001458;
        ["y"] = -446.69302744868;
        ["g"] = 16;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [10] = {
    ["name"] = "Stormcaller Boroo";
    ["id"] = 194317;
    ["count"] = 10;
    ["health"] = 1147211;
    ["scale"] = 1;
    ["displayId"] = 108819;
    ["iconTexture"] = 136048;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [386012] = {
      };
      [387145] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 480.70996018888;
        ["y"] = -417.15232176277;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [11] = {
    ["name"] = "Stormsurge Totem";
    ["id"] = 194897;
    ["count"] = 0;
    ["health"] = 344163;
    ["scale"] = 1;
    ["displayId"] = 107517;
    ["creatureType"] = "Not specified";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [382628] = {
      };
      [384881] = {
      };
      [386694] = {
      };
      [387146] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 482.59712927045;
        ["y"] = -413.88379724718;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 454.64490403249;
        ["y"] = -413.87906401781;
        ["g"] = 11;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 457.36879995881;
        ["y"] = -436.58779164254;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 477.48973310548;
        ["y"] = -445.42681391546;
        ["g"] = 16;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [12] = {
    ["name"] = "Primalist Thunderbeast";
    ["id"] = 195696;
    ["count"] = 12;
    ["health"] = 1434014;
    ["scale"] = 1;
    ["displayId"] = 110545;
    ["creatureType"] = "Beast";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [386028] = {
      };
      [387125] = {
      };
      [387127] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 477.41509946319;
        ["y"] = -405.62053246279;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
        ["patrol"] = {
          [1] = {
            ["x"] = 477.41509946319;
            ["y"] = -405.62053246279;
          };
          [2] = {
            ["x"] = 478.40127305443;
            ["y"] = -410.05951905333;
          };
          [3] = {
            ["x"] = 477.41509946319;
            ["y"] = -405.62053246279;
          };
          [4] = {
            ["x"] = 475.22117574324;
            ["y"] = -400.38090801375;
          };
          [5] = {
            ["x"] = 473.70024312665;
            ["y"] = -394.15893755774;
          };
          [6] = {
            ["x"] = 475.22117574324;
            ["y"] = -400.38090801375;
          };
        };
      };
      [2] = {
        ["x"] = 448.45448474;
        ["y"] = -427.13813088249;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
        ["patrol"] = {
          [1] = {
            ["x"] = 448.45448474;
            ["y"] = -427.13813088249;
          };
          [2] = {
            ["x"] = 451.55100703155;
            ["y"] = -428.52049138303;
          };
          [3] = {
            ["x"] = 456.05579287322;
            ["y"] = -428.96651342189;
          };
          [4] = {
            ["x"] = 451.55100703155;
            ["y"] = -428.52049138303;
          };
          [5] = {
            ["x"] = 448.45448474;
            ["y"] = -427.13813088249;
          };
          [6] = {
            ["x"] = 444.10248951495;
            ["y"] = -423.39127621824;
          };
          [7] = {
            ["x"] = 438.97327435016;
            ["y"] = -420.98277405251;
          };
          [8] = {
            ["x"] = 430.14210739893;
            ["y"] = -418.7080830923;
          };
          [9] = {
            ["x"] = 438.97327435016;
            ["y"] = -420.98277405251;
          };
          [10] = {
            ["x"] = 444.10248951495;
            ["y"] = -423.39127621824;
          };
        };
      };
      [3] = {
        ["x"] = 471.5700039096;
        ["y"] = -418.63003596335;
        ["g"] = 19;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
        ["patrol"] = {
          [1] = {
            ["x"] = 471.5700039096;
            ["y"] = -418.63003596335;
          };
          [2] = {
            ["x"] = 476.93437195653;
            ["y"] = -420.37715180502;
          };
          [3] = {
            ["x"] = 478.09800148103;
            ["y"] = -425.52822444455;
          };
          [4] = {
            ["x"] = 477.28098161433;
            ["y"] = -430.80746597568;
          };
          [5] = {
            ["x"] = 474.3899705355;
            ["y"] = -436.58949172954;
          };
          [6] = {
            ["x"] = 469.17357253697;
            ["y"] = -440.29752986747;
          };
          [7] = {
            ["x"] = 462.57452332021;
            ["y"] = -440.046135958;
          };
          [8] = {
            ["x"] = 457.99898996187;
            ["y"] = -436.59408520113;
          };
          [9] = {
            ["x"] = 456.03832482843;
            ["y"] = -433.69848065071;
          };
          [10] = {
            ["x"] = 454.46712143524;
            ["y"] = -429.17341545369;
          };
          [11] = {
            ["x"] = 454.7813606754;
            ["y"] = -424.89974956043;
          };
          [12] = {
            ["x"] = 457.86091673681;
            ["y"] = -419.87190014067;
          };
          [13] = {
            ["x"] = 461.69464913232;
            ["y"] = -417.35797543079;
          };
          [14] = {
            ["x"] = 465.90547868538;
            ["y"] = -417.23228117321;
          };
        };
      };
    };
  };
  [13] = {
    ["name"] = "Primalist Stormspeaker";
    ["id"] = 194894;
    ["count"] = 6;
    ["health"] = 717007;
    ["scale"] = 1;
    ["displayId"] = 108711;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Polymorph"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Imprison"] = true;
      ["Sap"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [386012] = {
      };
      [386015] = {
      };
      [386022] = {
      };
      [386024] = {
      };
      [386025] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 453.10346048896;
        ["y"] = -419.23386832131;
        ["g"] = 11;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 443.17670970307;
        ["y"] = -438.52411134922;
        ["g"] = 12;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 458.45900854924;
        ["y"] = -439.23284108595;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 480.24290734173;
        ["y"] = -443.30912908213;
        ["g"] = 16;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [14] = {
    ["name"] = "Unstable Squall";
    ["id"] = 194895;
    ["count"] = 0;
    ["health"] = 286803;
    ["scale"] = 1;
    ["displayId"] = 101201;
    ["creatureType"] = "Elemental";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Banish"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [386018] = {
      };
      [386019] = {
      };
      [386026] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 456.3195148886;
        ["y"] = -418.51357259389;
        ["g"] = 11;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 444.54614711101;
        ["y"] = -435.45646858286;
        ["g"] = 12;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 477.34194896197;
        ["y"] = -448.73340846156;
        ["g"] = 16;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 456.88637424842;
        ["y"] = -441.98819555725;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [15] = {
    ["name"] = "Stormcaller Arynga";
    ["id"] = 195265;
    ["count"] = 10;
    ["health"] = 1147211;
    ["scale"] = 1;
    ["displayId"] = 108819;
    ["iconTexture"] = 136048;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["spells"] = {
      [386012] = {
      };
      [387145] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 450.77832572724;
        ["y"] = -416.00665492728;
        ["g"] = 11;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [16] = {
    ["name"] = "Primal Stormshield";
    ["id"] = 194896;
    ["count"] = 7;
    ["health"] = 932110;
    ["scale"] = 1;
    ["displayId"] = 108335;
    ["creatureType"] = "Elemental";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [386223] = {
      };
      [386225] = {
      };
      [386227] = {
      };
      [386228] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 441.85989268377;
        ["y"] = -433.99126138404;
        ["g"] = 12;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 454.74219453177;
        ["y"] = -434.3290861754;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 463.90009826236;
        ["y"] = -451.52854765522;
        ["g"] = 15;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 459.55167327144;
        ["y"] = -446.45455220834;
        ["g"] = 15;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 468.53675350404;
        ["y"] = -437.95027344041;
        ["g"] = 17;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 471.51392385402;
        ["y"] = -435.99617446551;
        ["g"] = 17;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [7] = {
        ["x"] = 480.38742563428;
        ["y"] = -432.3235554695;
        ["g"] = 18;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [8] = {
        ["x"] = 483.36400801465;
        ["y"] = -433.19774008829;
        ["g"] = 18;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [9] = {
        ["x"] = 467.9259087605;
        ["y"] = -420.02237820016;
        ["g"] = 19;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [10] = {
        ["x"] = 468.21352163577;
        ["y"] = -415.57313383123;
        ["g"] = 19;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [17] = {
    ["name"] = "Nokhud Neophyte";
    ["id"] = 196263;
    ["count"] = 5;
    ["health"] = 717007;
    ["scale"] = 1;
    ["displayId"] = 108223;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Fear"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [386012] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 439.01417311508;
        ["y"] = -432.05681196463;
        ["g"] = 12;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 441.88666532745;
        ["y"] = -441.05891484396;
        ["g"] = 12;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 459.49701325597;
        ["y"] = -450.32943002071;
        ["g"] = 15;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 462.93733218755;
        ["y"] = -447.57992048458;
        ["g"] = 15;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 480.02060146301;
        ["y"] = -434.71074267838;
        ["g"] = 18;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 482.58355221309;
        ["y"] = -436.14526232604;
        ["g"] = 18;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [18] = {
    ["name"] = "Stormcaller Solongo";
    ["id"] = 194315;
    ["count"] = 10;
    ["health"] = 1147211;
    ["scale"] = 1;
    ["displayId"] = 108818;
    ["iconTexture"] = 136048;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [386012] = {
      };
      [387145] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 453.88774618362;
        ["y"] = -439.07993249052;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [19] = {
    ["name"] = "Primal Gust";
    ["id"] = 195579;
    ["count"] = 0;
    ["health"] = 286803;
    ["scale"] = 1;
    ["displayId"] = 102511;
    ["creatureType"] = "Elemental";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Root"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [386319] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 463.53090215213;
        ["y"] = -433.70079573356;
        ["g"] = 14;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 463.59685500313;
        ["y"] = -431.99734765389;
        ["g"] = 14;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
        ["patrol"] = {
          [1] = {
            ["x"] = 463.80018392071;
            ["y"] = -431.87534797639;
          };
          [2] = {
            ["x"] = 465.17006579343;
            ["y"] = -433.45380719265;
          };
          [3] = {
            ["x"] = 467.88851305104;
            ["y"] = -433.54754929644;
          };
          [4] = {
            ["x"] = 470.56008590436;
            ["y"] = -431.48528067396;
          };
          [5] = {
            ["x"] = 471.91930416934;
            ["y"] = -427.97004631888;
          };
          [6] = {
            ["x"] = 471.87244049269;
            ["y"] = -425.57969039027;
          };
          [7] = {
            ["x"] = 474.07531757753;
            ["y"] = -421.87697719141;
          };
          [8] = {
            ["x"] = 476.93437195653;
            ["y"] = -420.37715180502;
          };
          [9] = {
            ["x"] = 474.07531757753;
            ["y"] = -421.87697719141;
          };
          [10] = {
            ["x"] = 471.87244049269;
            ["y"] = -425.57969039027;
          };
          [11] = {
            ["x"] = 471.91930416934;
            ["y"] = -427.97004631888;
          };
          [12] = {
            ["x"] = 470.56008590436;
            ["y"] = -431.48528067396;
          };
          [13] = {
            ["x"] = 467.88851305104;
            ["y"] = -433.54754929644;
          };
          [14] = {
            ["x"] = 467.88851305104;
            ["y"] = -433.54754929644;
          };
          [15] = {
            ["x"] = 465.17006579343;
            ["y"] = -433.45380719265;
          };
          [16] = {
            ["x"] = 460.0612599253;
            ["y"] = -433.54754929644;
          };
          [17] = {
            ["x"] = 457.99898996187;
            ["y"] = -436.59408520113;
          };
          [18] = {
            ["x"] = 460.0612599253;
            ["y"] = -433.54754929644;
          };
        };
      };
      [3] = {
        ["x"] = 462.02756006112;
        ["y"] = -431.60011635923;
        ["g"] = 14;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 461.9673126599;
        ["y"] = -433.41945608395;
        ["g"] = 14;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [20] = {
    ["name"] = "Stormcaller Zarii";
    ["id"] = 194316;
    ["count"] = 10;
    ["health"] = 1147211;
    ["scale"] = 1;
    ["displayId"] = 108818;
    ["iconTexture"] = 136048;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [386012] = {
      };
      [387145] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 475.52934682158;
        ["y"] = -442.20028488229;
        ["g"] = 16;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [21] = {
    ["name"] = "The Raging Tempest";
    ["id"] = 186615;
    ["count"] = 0;
    ["health"] = 7154196;
    ["scale"] = 1;
    ["displayId"] = 107145;
    ["creatureType"] = "Elemental";
    ["level"] = 72;
    ["isBoss"] = true;
    ["encounterID"] = 2497;
    ["instanceID"] = 1198;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [382628] = {
      };
      [384185] = {
      };
      [384186] = {
      };
      [384316] = {
      };
      [384620] = {
      };
      [384628] = {
      };
      [384686] = {
      };
      [384687] = {
      };
      [384761] = {
      };
      [386914] = {
      };
      [386915] = {
      };
      [386916] = {
      };
      [391967] = {
      };
      [394875] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 462.16491375512;
        ["y"] = -425.73293057611;
        ["sublevel"] = 1;
        ["scale"] = 0.5;
      };
    };
  };
  [22] = {
    ["name"] = "Ukhel Corruptor";
    ["id"] = 195842;
    ["count"] = 5;
    ["health"] = 717007;
    ["scale"] = 1;
    ["displayId"] = 109006;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Imprison"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [387608] = {
      };
      [387611] = {
      };
      [387613] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 319.71875544239;
        ["y"] = -369.28448261558;
        ["g"] = 20;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 320.82851026304;
        ["y"] = -366.53226514813;
        ["g"] = 20;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 291.79151347546;
        ["y"] = -380.91275766852;
        ["g"] = 27;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 281.56546109086;
        ["y"] = -364.08586371529;
        ["g"] = 30;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 279.70630903048;
        ["y"] = -370.70746445626;
        ["g"] = 30;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 283.42808819334;
        ["y"] = -352.20715455451;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [7] = {
        ["x"] = 294.80856435404;
        ["y"] = -368.4714608071;
        ["g"] = 32;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [8] = {
        ["x"] = 298.51466634113;
        ["y"] = -369.38372579136;
        ["g"] = 32;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [9] = {
        ["x"] = 297.73192883736;
        ["y"] = -378.6925517508;
        ["g"] = 27;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [10] = {
        ["x"] = 284.88078958763;
        ["y"] = -354.56198725511;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
        ["patrol"] = {
          [1] = {
            ["x"] = 284.88078958763;
            ["y"] = -354.56198725511;
          };
          [2] = {
            ["x"] = 287.93718325458;
            ["y"] = -353.61595499992;
          };
          [3] = {
            ["x"] = 292.37623376829;
            ["y"] = -353.5431846357;
          };
          [4] = {
            ["x"] = 299.2895266337;
            ["y"] = -353.39764390726;
          };
          [5] = {
            ["x"] = 292.37623376829;
            ["y"] = -353.5431846357;
          };
          [6] = {
            ["x"] = 287.93718325458;
            ["y"] = -353.61595499992;
          };
          [7] = {
            ["x"] = 281.09666075338;
            ["y"] = -355.94464204913;
          };
          [8] = {
            ["x"] = 276.65760191164;
            ["y"] = -359.29212877149;
          };
          [9] = {
            ["x"] = 272.65517358326;
            ["y"] = -361.62081998472;
          };
          [10] = {
            ["x"] = 269.16213780443;
            ["y"] = -364.60445072196;
          };
          [11] = {
            ["x"] = 272.65517358326;
            ["y"] = -361.62081998472;
          };
          [12] = {
            ["x"] = 276.65760191164;
            ["y"] = -359.29212877149;
          };
          [13] = {
            ["x"] = 281.09666075338;
            ["y"] = -355.94464204913;
          };
        };
      };
      [11] = {
        ["x"] = 293.39001685758;
        ["y"] = -363.20128177936;
        ["g"] = 33;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [23] = {
    ["name"] = "Soulharvester Galtmaa";
    ["id"] = 195927;
    ["count"] = 10;
    ["health"] = 1147211;
    ["scale"] = 1;
    ["displayId"] = 109014;
    ["iconTexture"] = 136214;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [387411] = {
      };
      [388318] = {
      };
      [395035] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 316.72848846086;
        ["y"] = -359.0002958742;
        ["g"] = 21;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [24] = {
    ["name"] = "Ukhel Beastcaller";
    ["id"] = 195878;
    ["count"] = 6;
    ["health"] = 1003810;
    ["scale"] = 1;
    ["displayId"] = 109021;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Imprison"] = true;
      ["Sap"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [387440] = {
      };
      [387826] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 317.7569729359;
        ["y"] = -382.18383035505;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 309.49942417088;
        ["y"] = -379.43500664053;
        ["g"] = 25;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 291.85389525707;
        ["y"] = -387.25555832181;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 303.09932229565;
        ["y"] = -344.85158090502;
        ["g"] = 35;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [25] = {
    ["name"] = "Desecrated Ohuna";
    ["id"] = 195876;
    ["count"] = 2;
    ["health"] = 573606;
    ["scale"] = 1;
    ["displayId"] = 109019;
    ["creatureType"] = "Undead";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [387629] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 316.0917829248;
        ["y"] = -354.755489677;
        ["g"] = 21;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 319.39680185715;
        ["y"] = -356.01878611538;
        ["g"] = 21;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 320.72600554534;
        ["y"] = -379.61255452671;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 313.67035358027;
        ["y"] = -373.01889164636;
        ["g"] = 23;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 311.09929471464;
        ["y"] = -371.29102912392;
        ["g"] = 23;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 310.91146157715;
        ["y"] = -374.59351828545;
        ["g"] = 23;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
        ["patrol"] = {
          [1] = {
            ["x"] = 310.91146157715;
            ["y"] = -374.59351828545;
          };
          [2] = {
            ["x"] = 311.37007758218;
            ["y"] = -382.84214019948;
          };
          [3] = {
            ["x"] = 306.05777436979;
            ["y"] = -388.80940583797;
          };
          [4] = {
            ["x"] = 296.23361696734;
            ["y"] = -388.59108849928;
          };
          [5] = {
            ["x"] = 287.35549928386;
            ["y"] = -382.25997312169;
          };
          [6] = {
            ["x"] = 281.89763035892;
            ["y"] = -377.67536314147;
          };
          [7] = {
            ["x"] = 280.44220641844;
            ["y"] = -367.92398443127;
          };
          [8] = {
            ["x"] = 289.8297249795;
            ["y"] = -363.77601537445;
          };
          [9] = {
            ["x"] = 297.17964003024;
            ["y"] = -364.21264172379;
          };
          [10] = {
            ["x"] = 306.27607713442;
            ["y"] = -357.80875806399;
          };
          [11] = {
            ["x"] = 313.84431160586;
            ["y"] = -355.48007309678;
          };
          [12] = {
            ["x"] = 317.04624927174;
            ["y"] = -359.19141164025;
          };
          [13] = {
            ["x"] = 316.53686505023;
            ["y"] = -367.48735808193;
          };
        };
      };
      [7] = {
        ["x"] = 299.98678176762;
        ["y"] = -360.65018960658;
        ["g"] = 33;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [8] = {
        ["x"] = 305.92393017722;
        ["y"] = -347.19945216449;
        ["g"] = 35;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [9] = {
        ["x"] = 299.9331576746;
        ["y"] = -346.84255771288;
        ["g"] = 35;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [10] = {
        ["x"] = 295.87560816529;
        ["y"] = -360.1762113976;
        ["g"] = 33;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [11] = {
        ["x"] = 311.80430429093;
        ["y"] = -381.73663354461;
        ["g"] = 25;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [26] = {
    ["name"] = "Desecrated Bakar";
    ["id"] = 195875;
    ["count"] = 1;
    ["health"] = 286803;
    ["scale"] = 1;
    ["displayId"] = 109018;
    ["creatureType"] = "Undead";
    ["level"] = 70;
    ["characteristics"] = {
      ["Silence"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
    };
    ["clones"] = {
      [1] = {
        ["x"] = 321.24851970468;
        ["y"] = -382.5440640421;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 318.82282949458;
        ["y"] = -384.33458203556;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 291.96342414379;
        ["y"] = -391.80459161423;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 292.79155148917;
        ["y"] = -389.77647471098;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 289.3889542598;
        ["y"] = -388.29473250536;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 289.1260171185;
        ["y"] = -390.70640320492;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [7] = {
        ["x"] = 303.85053977839;
        ["y"] = -349.12148491946;
        ["g"] = 35;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [8] = {
        ["x"] = 300.84153941842;
        ["y"] = -348.70220450932;
        ["g"] = 35;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [27] = {
    ["name"] = "Risen Mystic";
    ["id"] = 195877;
    ["count"] = 5;
    ["health"] = 573606;
    ["scale"] = 1;
    ["displayId"] = 109020;
    ["creatureType"] = "Undead";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [387596] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 309.88642347012;
        ["y"] = -364.95701696046;
        ["g"] = 24;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 303.19677477615;
        ["y"] = -381.08215133933;
        ["g"] = 25;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 308.58972675013;
        ["y"] = -391.61893188921;
        ["g"] = 26;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 297.85196916798;
        ["y"] = -382.01714346202;
        ["g"] = 27;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 283.46707561497;
        ["y"] = -374.5913392931;
        ["g"] = 29;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 288.23362847866;
        ["y"] = -367.79045504528;
        ["g"] = 29;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [7] = {
        ["x"] = 281.07123934196;
        ["y"] = -350.00508683111;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [8] = {
        ["x"] = 278.16445681879;
        ["y"] = -363.94754361684;
        ["g"] = 30;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [28] = {
    ["name"] = "Ukhel Deathspeaker";
    ["id"] = 195851;
    ["count"] = 6;
    ["health"] = 860408;
    ["scale"] = 1;
    ["displayId"] = 109035;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Polymorph"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Imprison"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [387614] = {
      };
      [387615] = {
      };
      [387616] = {
      };
      [396376] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 313.04126801529;
        ["y"] = -364.91585947523;
        ["g"] = 24;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
        ["patrol"] = {
          [1] = {
            ["x"] = 312.02247458816;
            ["y"] = -365.0614085317;
          };
          [2] = {
            ["x"] = 314.06262407189;
            ["y"] = -366.25025645256;
          };
          [3] = {
            ["x"] = 314.64480364172;
            ["y"] = -369.45220661049;
          };
          [4] = {
            ["x"] = 313.40767413783;
            ["y"] = -374.32789388358;
          };
          [5] = {
            ["x"] = 307.87705150475;
            ["y"] = -379.05803834622;
          };
          [6] = {
            ["x"] = 303.21967324231;
            ["y"] = -379.93129520892;
          };
          [7] = {
            ["x"] = 301.54592988113;
            ["y"] = -372.94523406129;
          };
          [8] = {
            ["x"] = 303.80183615607;
            ["y"] = -366.90520222259;
          };
          [9] = {
            ["x"] = 307.22209324266;
            ["y"] = -359.04588421226;
          };
          [10] = {
            ["x"] = 310.49682625686;
            ["y"] = -361.01071735836;
          };
        };
      };
      [2] = {
        ["x"] = 306.31755130728;
        ["y"] = -379.29824702479;
        ["g"] = 25;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 311.04495530833;
        ["y"] = -388.96005984736;
        ["g"] = 26;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 294.57197626683;
        ["y"] = -379.36745177664;
        ["g"] = 27;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
        ["patrol"] = {
          [1] = {
            ["x"] = 294.57197626683;
            ["y"] = -379.36745177664;
          };
          [2] = {
            ["x"] = 291.72177943334;
            ["y"] = -375.1283670816;
          };
          [3] = {
            ["x"] = 290.33912585708;
            ["y"] = -372.36305160104;
          };
          [4] = {
            ["x"] = 291.72177943334;
            ["y"] = -375.1283670816;
          };
          [5] = {
            ["x"] = 294.57197626683;
            ["y"] = -379.36745177664;
          };
          [6] = {
            ["x"] = 296.67023915266;
            ["y"] = -384.87974370979;
          };
          [7] = {
            ["x"] = 298.27121214962;
            ["y"] = -391.5019488723;
          };
          [8] = {
            ["x"] = 296.67023915266;
            ["y"] = -384.87974370979;
          };
        };
      };
      [5] = {
        ["x"] = 288.95599472318;
        ["y"] = -373.22633572503;
        ["g"] = 29;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 301.42060076063;
        ["y"] = -364.18239761947;
        ["g"] = 33;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [7] = {
        ["x"] = 321.4146198492;
        ["y"] = -359.10175138186;
        ["g"] = 21;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [29] = {
    ["name"] = "Risen Warrior";
    ["id"] = 195855;
    ["count"] = 5;
    ["health"] = 717007;
    ["scale"] = 1;
    ["displayId"] = 109017;
    ["creatureType"] = "Undead";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [388801] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 310.8836225156;
        ["y"] = -362.20513717079;
        ["g"] = 24;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 303.55073860646;
        ["y"] = -390.78891719108;
        ["g"] = 26;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 294.97633942187;
        ["y"] = -383.29081305036;
        ["g"] = 27;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 288.74856335241;
        ["y"] = -370.54750975682;
        ["g"] = 29;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 286.19683504955;
        ["y"] = -374.25712171677;
        ["g"] = 29;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 285.43195401108;
        ["y"] = -357.36329180929;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [7] = {
        ["x"] = 276.52252588671;
        ["y"] = -368.0955165449;
        ["g"] = 30;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [8] = {
        ["x"] = 301.49271353194;
        ["y"] = -386.74373223029;
        ["g"] = 26;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [9] = {
        ["x"] = 312.8838047796;
        ["y"] = -357.07592708078;
        ["g"] = 21;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [30] = {
    ["name"] = "Soulharvester Tumen";
    ["id"] = 195929;
    ["count"] = 10;
    ["health"] = 1147211;
    ["scale"] = 1;
    ["displayId"] = 109036;
    ["iconTexture"] = 136214;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["spells"] = {
      [387411] = {
      };
      [388318] = {
      };
      [395035] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 306.83674704999;
        ["y"] = -386.8059965735;
        ["g"] = 26;
        ["sublevel"] = 1;
        ["scale"] = 0.8;
      };
    };
  };
  [31] = {
    ["name"] = "Soulharvester Mandakh";
    ["id"] = 195930;
    ["count"] = 10;
    ["health"] = 1147211;
    ["scale"] = 1;
    ["displayId"] = 109037;
    ["iconTexture"] = 136214;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [387411] = {
      };
      [388318] = {
      };
      [395035] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 281.888551529;
        ["y"] = -367.84261375659;
        ["g"] = 30;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [32] = {
    ["name"] = "Soulharvester Duuren";
    ["id"] = 195928;
    ["count"] = 10;
    ["health"] = 1147211;
    ["scale"] = 1;
    ["displayId"] = 109015;
    ["iconTexture"] = 136214;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [387411] = {
      };
      [388318] = {
      };
      [395035] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 297.41247300367;
        ["y"] = -364.29867388627;
        ["g"] = 33;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [33] = {
    ["name"] = "Teera";
    ["id"] = 186339;
    ["count"] = 0;
    ["health"] = 7154196;
    ["scale"] = 1;
    ["displayId"] = 105721;
    ["creatureType"] = "Undead";
    ["level"] = 72;
    ["isBoss"] = true;
    ["encounterID"] = 2478;
    ["instanceID"] = 537;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [345561] = {
      };
      [382670] = {
      };
      [384808] = {
      };
      [385434] = {
      };
      [386016] = {
      };
      [386411] = {
      };
      [386547] = {
      };
      [392151] = {
      };
      [392198] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 272.37317844225;
        ["y"] = -391.04380300793;
        ["g"] = 36;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [34] = {
    ["name"] = "Maruuk";
    ["id"] = 186338;
    ["count"] = 0;
    ["health"] = 7154196;
    ["scale"] = 1;
    ["displayId"] = 105722;
    ["creatureType"] = "Undead";
    ["level"] = 72;
    ["isBoss"] = true;
    ["encounterID"] = 2478;
    ["instanceID"] = 537;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [345561] = {
      };
      [382836] = {
      };
      [385339] = {
      };
      [386063] = {
      };
      [392198] = {
      };
      [395669] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 267.57206278182;
        ["y"] = -379.95840188332;
        ["g"] = 36;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
  [35] = {
    ["name"] = "Batak";
    ["id"] = 193462;
    ["count"] = 16;
    ["health"] = 1720817;
    ["scale"] = 1;
    ["displayId"] = 108221;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [373395] = {
      };
      [382233] = {
      };
      [383067] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 297.12819297501;
        ["y"] = -214.71256829863;
        ["g"] = 42;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [36] = {
    ["name"] = "Balara";
    ["id"] = 193457;
    ["count"] = 16;
    ["health"] = 1720817;
    ["scale"] = 1;
    ["displayId"] = 108222;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [372147] = {
      };
      [374711] = {
      };
      [382267] = {
      };
      [382274] = {
      };
      [382277] = {
      };
      [383067] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 296.24911069711;
        ["y"] = -220.25822107978;
        ["g"] = 42;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [37] = {
    ["name"] = "Balakar Khan";
    ["id"] = 186151;
    ["count"] = 0;
    ["health"] = 5723357;
    ["scale"] = 1;
    ["displayId"] = 107680;
    ["creatureType"] = "Humanoid";
    ["level"] = 72;
    ["isBoss"] = true;
    ["encounterID"] = 2477;
    ["instanceID"] = 1198;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [375929] = {
      };
      [375937] = {
      };
      [375943] = {
      };
      [376634] = {
      };
      [376644] = {
      };
      [376660] = {
      };
      [376683] = {
      };
      [376685] = {
      };
      [376724] = {
      };
      [376727] = {
      };
      [376827] = {
      };
      [376829] = {
      };
      [376864] = {
      };
      [376865] = {
      };
      [376866] = {
      };
      [376892] = {
      };
      [376894] = {
      };
      [376896] = {
      };
      [393421] = {
      };
      [393425] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 282.88962254967;
        ["y"] = -214.57548309082;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
    };
  };
  [38] = {
    ["name"] = "Nokhud Defender";
    ["id"] = 199717;
    ["count"] = 10;
    ["health"] = 1326463;
    ["scale"] = 1;
    ["stealthDetect"] = true;
    ["displayId"] = 108529;
    ["creatureType"] = "Humanoid";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [373395] = {
      };
      [384336] = {
      };
      [384510] = {
      };
      [384512] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 352.14192864844;
        ["y"] = -226.78255712972;
        ["g"] = 37;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [2] = {
        ["x"] = 353.25399865395;
        ["y"] = -221.85728086906;
        ["g"] = 37;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [3] = {
        ["x"] = 324.45931955362;
        ["y"] = -222.61336509157;
        ["g"] = 40;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [4] = {
        ["x"] = 324.23796824987;
        ["y"] = -217.93926060723;
        ["g"] = 40;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [5] = {
        ["x"] = 311.8325009048;
        ["y"] = -220.64302384799;
        ["g"] = 41;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
        ["patrol"] = {
          [1] = {
            ["x"] = 311.8325009048;
            ["y"] = -220.64302384799;
          };
          [2] = {
            ["x"] = 316.0500044065;
            ["y"] = -221.1768296404;
          };
          [3] = {
            ["x"] = 319.96190910407;
            ["y"] = -220.30002008808;
          };
          [4] = {
            ["x"] = 316.0500044065;
            ["y"] = -221.1768296404;
          };
          [5] = {
            ["x"] = 311.8325009048;
            ["y"] = -220.64302384799;
          };
          [6] = {
            ["x"] = 306.54001388922;
            ["y"] = -219.82789632067;
          };
          [7] = {
            ["x"] = 300.33490132178;
            ["y"] = -218.00683923353;
          };
          [8] = {
            ["x"] = 306.54001388922;
            ["y"] = -219.82789632067;
          };
        };
      };
      [6] = {
        ["x"] = 299.15484415271;
        ["y"] = -196.31186669017;
        ["g"] = 43;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
        ["patrol"] = {
          [1] = {
            ["x"] = 299.15484415271;
            ["y"] = -196.31186669017;
          };
          [2] = {
            ["x"] = 298.07195522897;
            ["y"] = -203.85497190786;
          };
          [3] = {
            ["x"] = 299.15484415271;
            ["y"] = -196.31186669017;
          };
          [4] = {
            ["x"] = 299.19537749217;
            ["y"] = -190.2876283881;
          };
          [5] = {
            ["x"] = 300.31877997628;
            ["y"] = -185.79400856211;
          };
          [6] = {
            ["x"] = 299.19537749217;
            ["y"] = -190.2876283881;
          };
        };
      };
      [7] = {
        ["x"] = 297.73748037787;
        ["y"] = -183.99135755078;
        ["g"] = 44;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [8] = {
        ["x"] = 303.26809009182;
        ["y"] = -185.58672035384;
        ["g"] = 44;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [9] = {
        ["x"] = 287.2082415641;
        ["y"] = -251.14620599673;
        ["g"] = 45;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [10] = {
        ["x"] = 292.73887562154;
        ["y"] = -250.08260239395;
        ["g"] = 45;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [11] = {
        ["x"] = 289.69331849745;
        ["y"] = -240.53739878431;
        ["g"] = 46;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [12] = {
        ["x"] = 290.21263988051;
        ["y"] = -265.07558950342;
        ["g"] = 48;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
      [13] = {
        ["x"] = 295.26642389701;
        ["y"] = -262.58649580492;
        ["g"] = 48;
        ["sublevel"] = 1;
        ["scale"] = 0.6;
      };
    };
  };
  [39] = {
    ["name"] = "Nokhud Thunderfist";
    ["id"] = 193373;
    ["count"] = 5;
    ["health"] = 717007;
    ["scale"] = 1;
    ["displayId"] = 110840;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Imprison"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [381530] = {
      };
      [397394] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 344.37543641092;
        ["y"] = -228.03957742738;
        ["g"] = 38;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [2] = {
        ["x"] = 306.60980594375;
        ["y"] = -224.08634849357;
        ["g"] = 41;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [3] = {
        ["x"] = 307.8387548869;
        ["y"] = -215.59425828139;
        ["g"] = 41;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [4] = {
        ["x"] = 304.31469327969;
        ["y"] = -201.7576522069;
        ["g"] = 43;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [5] = {
        ["x"] = 293.32256016323;
        ["y"] = -201.11187971052;
        ["g"] = 43;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [6] = {
        ["x"] = 295.92963774289;
        ["y"] = -236.46873066785;
        ["g"] = 46;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [7] = {
        ["x"] = 283.80477819698;
        ["y"] = -234.66062401792;
        ["g"] = 46;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [8] = {
        ["x"] = 303.25396560977;
        ["y"] = -209.30571066088;
        ["g"] = 47;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [9] = {
        ["x"] = 304.85168665564;
        ["y"] = -207.97428216985;
        ["g"] = 47;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
      [10] = {
        ["x"] = 336.68123923815;
        ["y"] = -218.56836484781;
        ["g"] = 39;
        ["sublevel"] = 1;
        ["scale"] = 0.4;
      };
    };
  };
};
