local MDT = MDT
local L = MDT.L
local dungeonIndex = 31
MDT.dungeonList[dungeonIndex] = L["Mists of Tirna Scithe"]
MDT.mapInfo[dungeonIndex] = {

};

local zones = { 1669 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonTotalCount[dungeonIndex] = { normal = 260, teeming = 1000, teemingEnabled = true }

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "MistsOfTirneScithe",
  [1] = "MistsOfTirneScithe",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Mists of Tirna Scithe"],
}

MDT.mapPOIs[dungeonIndex] = {
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Drust Spiteclaw",
    ["id"] = 165111,
    ["count"] = 2,
    ["health"] = 98961,
    ["scale"] = 1,
    ["displayId"] = 86207,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [322968] = {
      },
      [323020] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 746.6292752231,
        ["y"] = -110.4360997147,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 752.82497432052,
        ["y"] = -115.30289096882,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 753.74174832058,
        ["y"] = -108.07023358592,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 753.74174832058,
            ["y"] = -108.07023358592,
          },
          [2] = {
            ["x"] = 754.93376039669,
            ["y"] = -101.36266797911,
          },
          [3] = {
            ["x"] = 753.66588424355,
            ["y"] = -96.713810918428,
          },
          [4] = {
            ["x"] = 754.93376039669,
            ["y"] = -101.36266797911,
          },
          [5] = {
            ["x"] = 753.74174832058,
            ["y"] = -108.07023358592,
          },
          [6] = {
            ["x"] = 746.19952797903,
            ["y"] = -116.01363361059,
          },
          [7] = {
            ["x"] = 739.86017139605,
            ["y"] = -119.53550308111,
          },
          [8] = {
            ["x"] = 746.19952797903,
            ["y"] = -116.01363361059,
          },
        },
      },
      [4] = {
        ["x"] = 724.83529105888,
        ["y"] = -135.38039852376,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 730.83027533134,
        ["y"] = -138.55913968659,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 730.83027533134,
            ["y"] = -138.55913968659,
          },
          [2] = {
            ["x"] = 736.88983112085,
            ["y"] = -139.40821456795,
          },
          [3] = {
            ["x"] = 744.21532300511,
            ["y"] = -143.77533077678,
          },
          [4] = {
            ["x"] = 736.88983112085,
            ["y"] = -139.40821456795,
          },
          [5] = {
            ["x"] = 718.43527934972,
            ["y"] = -131.80098787751,
          },
          [6] = {
            ["x"] = 706.88356586529,
            ["y"] = -132.92798755904,
          },
          [7] = {
            ["x"] = 718.43527934972,
            ["y"] = -131.80098787751,
          },
        },
      },
      [6] = {
        ["x"] = 756.64567954867,
        ["y"] = -148.24650872406,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 756.64567954867,
            ["y"] = -148.24650872406,
          },
          [2] = {
            ["x"] = 761.96552869227,
            ["y"] = -155.46792073282,
          },
          [3] = {
            ["x"] = 761.96552869227,
            ["y"] = -163.21602994055,
          },
          [4] = {
            ["x"] = 751.54080279801,
            ["y"] = -174.48599048176,
          },
          [5] = {
            ["x"] = 761.96552869227,
            ["y"] = -163.21602994055,
          },
          [6] = {
            ["x"] = 761.96552869227,
            ["y"] = -155.46792073282,
          },
          [7] = {
            ["x"] = 756.64567954867,
            ["y"] = -148.24650872406,
          },
          [8] = {
            ["x"] = 747.45542139536,
            ["y"] = -139.12646767041,
          },
          [9] = {
            ["x"] = 737.17159615544,
            ["y"] = -139.40821456795,
          },
          [10] = {
            ["x"] = 747.45542139536,
            ["y"] = -139.12646767041,
          },
        },
      },
      [7] = {
        ["x"] = 756.66940619444,
        ["y"] = -141.74359300715,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 750.17920553242,
        ["y"] = -145.39279079793,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 725.28357276715,
        ["y"] = -210.89383578579,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 719.37561487073,
        ["y"] = -208.55700354772,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 724.72843450479,
        ["y"] = -218.86009082913,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [12] = {
        ["x"] = 716.22546209728,
        ["y"] = -216.65184575943,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Tirnenn Villager",
    ["id"] = 164929,
    ["count"] = 7,
    ["health"] = 395844,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 95618,
    ["creatureType"] = "Elemental",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [300155] = {
      },
      [321952] = {
      },
      [321968] = {
      },
      [322486] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 751.39705018208,
        ["y"] = -86.386296821099,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 728.82428115016,
        ["y"] = -124.74370083229,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 776.17157965543,
        ["y"] = -159.74596866134,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 738.93542130382,
        ["y"] = -175.81433131912,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Drust Soulcleaver",
    ["id"] = 164920,
    ["count"] = 4,
    ["health"] = 148442,
    ["scale"] = 1,
    ["displayId"] = 95612,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [322557] = {
      },
      [322569] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 728.70926517572,
        ["y"] = -118.82100102611,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 734.43450479233,
        ["y"] = -122.64924181963,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [3] = {
        ["x"] = 732.77241938394,
        ["y"] = -104.15147490534,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 745.78267259702,
        ["y"] = -180.79637092404,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 732.62282962168,
        ["y"] = -170.0610647765,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 542.95207667732,
        ["y"] = -173.06812222096,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 683.39775098001,
        ["y"] = -192.02095174084,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 539.47603833866,
        ["y"] = -167.38587390263,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 661.2268370607,
        ["y"] = -153.85731387527,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [10] = {
        ["x"] = 682.09130958666,
        ["y"] = -150.59223577699,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Drust Harvester",
    ["id"] = 164921,
    ["count"] = 4,
    ["health"] = 148442,
    ["scale"] = 1,
    ["displayId"] = 95613,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [322938] = {
        ["interruptible"] = true,
      },
      [326319] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 725.24266029541,
        ["y"] = -100.13056583555,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 768.90986859021,
        ["y"] = -154.76217753336,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 769.42138025231,
        ["y"] = -164.40627431903,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 743.91693290735,
        ["y"] = -169.08351920718,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [5] = {
        ["x"] = 693.32268370607,
        ["y"] = -178.29477824649,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 693.62939297125,
        ["y"] = -188.44436210238,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 668.26837060703,
        ["y"] = -156.08465397332,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 674.29085616193,
        ["y"] = -146.57380988805,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Drust Boughbreaker",
    ["id"] = 164926,
    ["count"] = 6,
    ["health"] = 362857,
    ["scale"] = 1,
    ["displayId"] = 95615,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [324909] = {
      },
      [324923] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 735.07530736498,
        ["y"] = -216.12792392894,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 694.4928730274,
        ["y"] = -198.36012830717,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 652.17891373802,
        ["y"] = -118.55523885532,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 647.03514376997,
        ["y"] = -125.19296545434,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Ingra Maloch",
    ["id"] = 164567,
    ["count"] = 0,
    ["health"] = 1784106,
    ["scale"] = 1,
    ["displayId"] = 95497,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2400,
    ["instanceID"] = 1184,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [321005] = {
      },
      [323057] = {
        ["interruptible"] = true,
      },
      [323138] = {
      },
      [323146] = {
      },
      [323149] = {
      },
      [328756] = {
      },
      [331440] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 622.5303514377,
        ["y"] = -101.29968076616,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Droman Oulfarran",
    ["id"] = 164804,
    ["count"] = 0,
    ["health"] = 357359,
    ["scale"] = 1,
    ["displayId"] = 95564,
    ["creatureType"] = "Elemental",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [321772] = {
      },
      [323059] = {
      },
      [323137] = {
      },
      [323177] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 617.3735357427,
        ["y"] = -112.82878382784,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Mistveil Defender",
    ["id"] = 163058,
    ["count"] = 4,
    ["health"] = 189675,
    ["scale"] = 1,
    ["displayId"] = 95256,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [324736] = {
      },
      [324737] = {
      },
      [331718] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 559.09910881697,
        ["y"] = -219.16899584959,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 562.196083724,
        ["y"] = -226.7915197378,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [3] = {
        ["x"] = 563.11412230739,
        ["y"] = -276.15073604898,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 439.49223180286,
        ["y"] = -326.35936085876,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 488.77548858976,
        ["y"] = -304.70853755101,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 517.89579251347,
        ["y"] = -239.10966352872,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 520.53927785804,
        ["y"] = -246.31911182242,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 488.96321871484,
        ["y"] = -200.820112461,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 490.85862653514,
        ["y"] = -210.90529134184,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [10] = {
        ["x"] = 439.73370986939,
        ["y"] = -176.75826703278,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 450.85498487045,
        ["y"] = -238.59980764556,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 435.30424150013,
        ["y"] = -240.18123725758,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 536.51513413168,
        ["y"] = -135.20968965101,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 488.42155126217,
        ["y"] = -149.67273386435,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 490.34408043283,
        ["y"] = -160.24661336331,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 498.65252517213,
        ["y"] = -89.841369945565,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 497.93156899821,
        ["y"] = -98.25240154923,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 410.12858647332,
        ["y"] = -157.40480041127,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Mistveil Stalker",
    ["id"] = 166301,
    ["count"] = 4,
    ["health"] = 148442,
    ["scale"] = 1,
    ["displayId"] = 93762,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [324987] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 568.23677385391,
        ["y"] = -225.96228781311,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 555.36102236422,
        ["y"] = -226.62552730589,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 572.11018887709,
        ["y"] = -268.3615142293,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 452.58101242988,
        ["y"] = -286.81929010477,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 549.28398041673,
        ["y"] = -304.24282141908,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 529.91158436026,
        ["y"] = -246.79976989814,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 407.62914411087,
        ["y"] = -207.49833221622,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 540.36017184656,
        ["y"] = -143.14012505829,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 498.27447458722,
        ["y"] = -148.95177769044,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 404.390983235,
        ["y"] = -146.24390085728,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Mistveil Stinger",
    ["id"] = 166304,
    ["count"] = 4,
    ["health"] = 131948,
    ["scale"] = 1,
    ["displayId"] = 95198,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [325223] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 564.32930713918,
        ["y"] = -267.23052444898,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 537.32855438441,
        ["y"] = -283.70648470696,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 454.87070884858,
        ["y"] = -273.34277691405,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 500.11012195708,
        ["y"] = -159.03621708188,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 508.02485230079,
        ["y"] = -101.136184992,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Mistveil Guardian",
    ["id"] = 166276,
    ["count"] = 4,
    ["health"] = 181429,
    ["scale"] = 1,
    ["displayId"] = 95261,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [331743] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 572.17202638392,
        ["y"] = -276.65363130046,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 530.93091304285,
        ["y"] = -270.68297942853,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 444.62499729072,
        ["y"] = -271.54275638213,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 441.9456866914,
        ["y"] = -282.21356301684,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 560.09813738744,
        ["y"] = -318.18112181009,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 443.57729069452,
        ["y"] = -315.83335530418,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 489.25612603903,
        ["y"] = -295.09595357705,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 440.76662885319,
        ["y"] = -184.92899002372,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 396.55506619545,
        ["y"] = -199.49650611763,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [10] = {
        ["x"] = 398.92724454731,
        ["y"] = -206.34936399929,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 443.47501017776,
        ["y"] = -240.18125988013,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 527.62344445229,
        ["y"] = -138.5741311695,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [13] = {
        ["x"] = 402.27658911033,
        ["y"] = -154.97747951695,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Mistveil Tender",
    ["id"] = 166299,
    ["count"] = 4,
    ["health"] = 156688,
    ["scale"] = 1,
    ["displayId"] = 95908,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [324914] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 528.35583317065,
        ["y"] = -279.90533208434,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 564.28424831822,
        ["y"] = -309.24704777369,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 448.62417832755,
        ["y"] = -323.95612204626,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 496.70588274415,
        ["y"] = -304.46821882638,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 525.70895911857,
        ["y"] = -238.13657766068,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 497.90347527888,
        ["y"] = -198.86770003116,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 500.61600184223,
        ["y"] = -208.91958797934,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 446.46548013244,
        ["y"] = -172.7405387254,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 402.35365652122,
        ["y"] = -193.43434041943,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 436.88567111215,
        ["y"] = -232.01052513634,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [11] = {
        ["x"] = 510.20759364258,
        ["y"] = -91.835675648506,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Mistveil Shaper",
    ["id"] = 166275,
    ["count"] = 4,
    ["health"] = 173182,
    ["scale"] = 1,
    ["displayId"] = 95051,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [324776] = {
        ["interruptible"] = true,
      },
      [324859] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 540.08607896763,
        ["y"] = -273.93324703416,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 448.99483143288,
        ["y"] = -278.79553808876,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 556.25307904612,
        ["y"] = -310.49101544067,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 454.8720851145,
        ["y"] = -319.19777619622,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 496.7058621177,
        ["y"] = -296.05721816238,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 448.79284684852,
        ["y"] = -180.80234269842,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 405.25296299538,
        ["y"] = -200.28720961236,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 445.84709803941,
        ["y"] = -230.95621233534,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 531.66205105747,
        ["y"] = -146.48570804587,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Mistveil Nightblossom",
    ["id"] = 173714,
    ["count"] = 16,
    ["health"] = 494804,
    ["scale"] = 1.4,
    ["displayId"] = 55772,
    ["creatureType"] = "Elemental",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [340279] = {
      },
      [340289] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 487.53105356577,
        ["y"] = -254.56328650313,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Mistcaller",
    ["id"] = 164501,
    ["count"] = 0,
    ["health"] = 1156365,
    ["scale"] = 1,
    ["displayId"] = 96451,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2402,
    ["instanceID"] = 1184,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [321828] = {
        ["interruptible"] = true,
      },
      [321834] = {
      },
      [336499] = {
      },
      [341709] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 399.66159501543,
        ["y"] = -272.25255797372,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Spinemaw Staghorn",
    ["id"] = 167111,
    ["count"] = 5,
    ["health"] = 263896,
    ["scale"] = 1,
    ["displayId"] = 94190,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [326046] = {
        ["interruptible"] = true,
      },
      [340544] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 310.47764028358,
        ["y"] = -319.59184690127,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 275.13076661623,
        ["y"] = -388.09639889923,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 267.27128193492,
        ["y"] = -415.53587064097,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 197.12133386632,
        ["y"] = -315.41224950097,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 243.25947857136,
        ["y"] = -293.98767863151,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 148.71565495208,
        ["y"] = -304.96209098164,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 144.3397185396,
        ["y"] = -341.36035144391,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Spinemaw Acidgullet",
    ["id"] = 167113,
    ["count"] = 4,
    ["health"] = 164935,
    ["scale"] = 1,
    ["displayId"] = 94205,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [325418] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 302.84345047923,
        ["y"] = -314.73834226428,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 305.50159744409,
        ["y"] = -326.03956219359,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 260.26706850301,
        ["y"] = -426.31270243467,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 257.62798659049,
        ["y"] = -416.98717364041,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 223.52398261732,
        ["y"] = -441.19680546797,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 201.34697171875,
        ["y"] = -436.75240452695,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 194.55591054313,
        ["y"] = -443.65197810968,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 242.63865578527,
        ["y"] = -350.41728636588,
        ["g"] = 36,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [9] = {
        ["x"] = 236.35143769968,
        ["y"] = -340.79569034318,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 189.58643556155,
        ["y"] = -320.20896182214,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 193.03586835712,
        ["y"] = -307.65767871394,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 157.41819219165,
        ["y"] = -304.76466875268,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 159.17885816283,
        ["y"] = -296.55577440706,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Spinemaw Gorger",
    ["id"] = 172312,
    ["count"] = 4,
    ["health"] = 164935,
    ["scale"] = 1,
    ["displayId"] = 94197,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [326021] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 277.14384375352,
        ["y"] = -395.89069826462,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 267.63816193518,
        ["y"] = -424.89130218699,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 227.54388692983,
        ["y"] = -433.22213957064,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 193.75876513238,
        ["y"] = -431.02640606762,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 188.19169329073,
        ["y"] = -438.04996771727,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 244.3051326312,
        ["y"] = -342.25681426448,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 233.2805783432,
        ["y"] = -348.74643093427,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 186.09822875263,
        ["y"] = -310.56467754674,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 235.31827330034,
        ["y"] = -292.3562228339,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 152.09405931128,
        ["y"] = -295.63193448003,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 146.97280633109,
        ["y"] = -349.6745321085,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Spinemaw Larva",
    ["id"] = 167117,
    ["count"] = 1,
    ["health"] = 32987,
    ["scale"] = 0.6,
    ["displayId"] = 94208,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [326018] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 283.44226474783,
        ["y"] = -396.19847838936,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 281.283911474,
        ["y"] = -384.73631179379,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 287.3858948267,
        ["y"] = -392.19395176789,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 283.03716561179,
        ["y"] = -390.80271847875,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 284.56331886322,
        ["y"] = -383.05906334768,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 288.10690576578,
        ["y"] = -386.80690446101,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [7] = {
        ["x"] = 238.35901005768,
        ["y"] = -439.79024826278,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 235.02751165078,
        ["y"] = -432.26476657015,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 239.00387011043,
        ["y"] = -434.84200212668,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 235.3340416324,
        ["y"] = -444.77145093579,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 230.28360435414,
        ["y"] = -443.8638755203,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 232.93280185015,
        ["y"] = -438.22422931528,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 238.98033974052,
        ["y"] = -299.70769548024,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [14] = {
        ["x"] = 243.64867580502,
        ["y"] = -301.65904685897,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 235.13277774943,
        ["y"] = -299.10507650975,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 231.39392048825,
        ["y"] = -301.72084532679,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 236.62423502173,
        ["y"] = -304.19219358706,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 241.5326297022,
        ["y"] = -305.26938786253,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 158.10160902999,
        ["y"] = -341.13232948291,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 155.39968287288,
        ["y"] = -336.18895671013,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 152.19753656149,
        ["y"] = -341.48873731284,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [22] = {
        ["x"] = 150.33167359744,
        ["y"] = -335.92225214057,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 158.23215488952,
        ["y"] = -345.51564447796,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 153.48820680892,
        ["y"] = -346.90037788585,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Spinemaw Reaver",
    ["id"] = 167116,
    ["count"] = 4,
    ["health"] = 131948,
    ["scale"] = 1,
    ["displayId"] = 95692,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [326090] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 242.75668302441,
        ["y"] = -383.07677047989,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 246.49360986455,
        ["y"] = -375.27209742022,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["inspiring"] = true,
        ["patrol"] = {
        },
      },
      [3] = {
        ["x"] = 227.95541533445,
        ["y"] = -321.35706954182,
        ["g"] = 37,
        ["sublevel"] = 1,
        ["inspiring"] = true,
        ["patrol"] = {
        },
      },
      [4] = {
        ["x"] = 221.30752204609,
        ["y"] = -325.42986634963,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 175.62498256551,
        ["y"] = -345.93582110403,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 178.56608333349,
        ["y"] = -337.86932981949,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 183.21521745035,
        ["y"] = -333.10328469133,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 160.85623003195,
        ["y"] = -325.24281537865,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 166.95774186652,
        ["y"] = -325.3050006798,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 171.78881552968,
        ["y"] = -320.82945223268,
        ["g"] = 42,
        ["sublevel"] = 1,
        ["patrol"] = {
        },
      },
      [11] = {
        ["x"] = 170.38425258327,
        ["y"] = -462.34155731488,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 186.88671343015,
        ["y"] = -468.24716320437,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 179.80830670927,
        ["y"] = -461.7997377722,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Tred'ova",
    ["id"] = 164517,
    ["count"] = 0,
    ["health"] = 1321560,
    ["scale"] = 1,
    ["displayId"] = 95809,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2405,
    ["instanceID"] = 1184,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [322450] = {
      },
      [322465] = {
      },
      [322527] = {
      },
      [322550] = {
      },
      [322614] = {
      },
      [322709] = {
      },
      [326281] = {
      },
      [337235] = {
      },
      [337249] = {
      },
      [337255] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 125.12460063898,
        ["y"] = -400.49726370995,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Mistveil Gorgegullet",
    ["id"] = 173720,
    ["count"] = 16,
    ["health"] = 494804,
    ["scale"] = 1.4,
    ["displayId"] = 98502,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [340300] = {
      },
      [340304] = {
      },
      [340305] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 498.73635029938,
        ["y"] = -339.28872042569,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Mistveil Stinger",
    ["id"] = 166304,
    ["count"] = 4,
    ["health"] = 131948,
    ["scale"] = 1,
    ["displayId"] = 95198,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [325223] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 448.99161612781,
        ["y"] = -332.00281137005,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 548.80328108812,
        ["y"] = -314.81670091805,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 413.19076191944,
        ["y"] = -150.004790601,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Mistveil Matriarch",
    ["id"] = 173655,
    ["count"] = 16,
    ["health"] = 494804,
    ["scale"] = 1.4,
    ["displayId"] = 98569,
    ["creatureType"] = "Dragonkin",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [340160] = {
      },
      [340189] = {
      },
      [340208] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 453.7124600639,
        ["y"] = -120.11817352639,
        ["sublevel"] = 1,
      },
    },
  },
  [25] = {
    ["name"] = "Soggodon the Breaker",
    ["id"] = 179891,
    ["count"] = 0,
    ["health"] = 358540,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 98535,
    ["iconTexture"] = 2103898,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [356827] = {
        ["dps"] = true,
        ["healer"] = true,
      },
      [356828] = {
        ["dps"] = true,
        ["tank"] = true,
      },
      [357524] = {
        ["dps"] = true,
        ["healer"] = true,
        ["tank"] = true,
      },
      [357556] = {
        ["healer"] = true,
      },
      [357778] = {
        ["tank"] = true,
      },
    },
    ["spells"] = {
      [355719] = {
      },
      [355806] = {
      },
      [358784] = {
      },
      [358968] = {
      },
      [358970] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 329.77738274742,
        ["y"] = -303.39401456739,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 646.86834775473,
        ["y"] = -89.714339544828,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [26] = {
    ["name"] = "Executioner Varruth",
    ["id"] = 179890,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 92418,
    ["iconTexture"] = 237552,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [357575] = {
        ["dps"] = true,
        ["healer"] = true,
        ["tank"] = true,
      },
      [357604] = {
        ["tank"] = true,
      },
      [357609] = {
        ["dps"] = true,
      },
      [357706] = {
        ["dps"] = true,
      },
      [357747] = {
        ["healer"] = true,
      },
      [357847] = {
        ["healer"] = true,
      },
      [357863] = {
        ["tank"] = true,
      },
    },
    ["spells"] = {
      [355714] = {
      },
      [356923] = {
      },
      [356925] = {
      },
      [358971] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 565.77752389867,
        ["y"] = -169.39402663733,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 667.04336516818,
        ["y"] = -179.65580028353,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [27] = {
    ["name"] = "Incinerator Arkolath",
    ["id"] = 179446,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 100718,
    ["iconTexture"] = 236297,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [357575] = {
        ["dps"] = true,
        ["healer"] = true,
        ["tank"] = true,
      },
      [357839] = {
        ["tank"] = true,
      },
      [357848] = {
        ["dps"] = true,
      },
      [357864] = {
        ["dps"] = true,
      },
      [357889] = {
        ["healer"] = true,
      },
      [357897] = {
        ["tank"] = true,
      },
      [357900] = {
        ["healer"] = true,
      },
    },
    ["spells"] = {
      [355707] = {
      },
      [355732] = {
      },
      [355737] = {
      },
      [358967] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 667.04336516818,
        ["y"] = -179.65580028353,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 565.77752389867,
        ["y"] = -169.39402663733,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [28] = {
    ["name"] = "Oros Coldheart",
    ["id"] = 179892,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 97237,
    ["iconTexture"] = 136213,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [357815] = {
        ["dps"] = true,
        ["healer"] = true,
      },
      [357817] = {
        ["tank"] = true,
      },
      [357820] = {
        ["tank"] = true,
      },
      [357825] = {
        ["dps"] = true,
      },
      [357829] = {
        ["healer"] = true,
      },
      [357834] = {
        ["dps"] = true,
        ["tank"] = true,
      },
      [357842] = {
        ["healer"] = true,
      },
    },
    ["spells"] = {
      [355710] = {
      },
      [356414] = {
      },
      [356666] = {
      },
      [358894] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 646.86834775473,
        ["y"] = -89.714339544828,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 329.77738274742,
        ["y"] = -303.39401456739,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [29] = {
    ["name"] = "Wo Relic",
    ["id"] = 185683,
    ["count"] = 0,
    ["health"] = 27489,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 101046,
    ["iconTexture"] = 4335644,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368241,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.6,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366566] = {
      },
      [368078] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 738.10719975946,
        ["y"] = -89.2857143032,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 776.32150820781,
        ["y"] = -145.22619921133,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 680.78578306767,
        ["y"] = -179.51194478036,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 603.57622078908,
        ["y"] = -109.06629869195,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 379.44734499954,
        ["y"] = -275.16587820844,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 307.6202995472,
        ["y"] = -337.44697584186,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 224.35850485726,
        ["y"] = -339.80425972992,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 261.01974045453,
        ["y"] = -437.8662617286,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 140.62123046943,
        ["y"] = -401.26357940812,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 153.69408929814,
        ["y"] = -358.88549941848,
        ["sublevel"] = 1,
      },
    },
  },
  [30] = {
    ["name"] = "Urh Relic",
    ["id"] = 185685,
    ["count"] = 0,
    ["health"] = 27489,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 105134,
    ["iconTexture"] = 4335642,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368239,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.75,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366288] = {
      },
      [366297] = {
      },
      [368243] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 743.64288109816,
        ["y"] = -98.750004501947,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 785.42863542628,
        ["y"] = -154.33337241054,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 671.5000666956,
        ["y"] = -190.76191193827,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 603.25363581008,
        ["y"] = -95.517923385197,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 402.5355497879,
        ["y"] = -291.34237686671,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 292.79893249025,
        ["y"] = -329.94698240968,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 221.32279578443,
        ["y"] = -350.33999288875,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 250.4383530857,
        ["y"] = -430.65693270553,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 136.70231711388,
        ["y"] = -414.37168890555,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 140.94406805979,
        ["y"] = -360.51052126894,
        ["sublevel"] = 1,
      },
    },
  },
  [31] = {
    ["name"] = "Vy Relic",
    ["id"] = 185680,
    ["count"] = 0,
    ["health"] = 27489,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 103111,
    ["iconTexture"] = 4335643,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368240,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.75,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366406] = {
      },
      [366409] = {
      },
      [368103] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 755.78568673565,
        ["y"] = -96.78569240847,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 785.42863542628,
        ["y"] = -166.65478252852,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 676.85722018835,
        ["y"] = -202.36905740335,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 605.67295393427,
        ["y"] = -121.16311081151,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 399.00611583425,
        ["y"] = -252.51881795335,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 290.83463572369,
        ["y"] = -317.08983548475,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 227.3942445839,
        ["y"] = -360.34000456753,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 247.13855083738,
        ["y"] = -419.7958783211,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 123.99963004443,
        ["y"] = -418.69603628781,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 136.19409001991,
        ["y"] = -349.0105061098,
        ["sublevel"] = 1,
      },
    },
  },
};
