local MDT = MDT
local L = MDT.L
local dungeonIndex = 38
MDT.dungeonList[dungeonIndex] = L["TazaveshUpper"]
MDT.mapInfo[dungeonIndex] = {
  tileFormat = {

  },
  viewportPositionOverrides =
  {
    [1] = {
      zoomScale = 1.5999999046326,
      horizontalPan = 82.975681727434,
      verticalPan = 17.675643936011,
    },
    [2] = {
      zoomScale = 1.5999999046326,
      horizontalPan = 85.165726878898,
      verticalPan = 47.594631495329,
    },
    [3] = {
      zoomScale = 1.8999998569489,
      horizontalPan = 300.93987013648,
      verticalPan = 145.075257246,
    },
    [4] = {
      zoomScale = 1.2999999523163,
      horizontalPan = 157.09242693725,
      verticalPan = 69.151104366604,
    },
  },
};

local zones = { 1993, 1995, 1996 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "Brokerdungeonstormheim",
  [1] = "Brokerdungeonstormheim",
  [2] = "Brokerdungeon_aggramar",
  [3] = "Brokerdungeon_borallus",
  [4] = "Brokerdungeon_e",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["TazaveshFloor5"],
  [2] = L["TazaveshFloor6"],
  [3] = L["TazaveshFloor7"],
  [4] = L["TazaveshFloor8"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 346, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 538.2460884279,
      ["y"] = -297.16465402191,
      ["target"] = 2,
      ["direction"] = 2,
      ["connectionIndex"] = 1,
    },
    [2] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 191.11163560234,
      ["y"] = -106.33895309988,
      ["graveyardDescription"] = "",
    },
  },
  [2] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 152.95188346973,
      ["y"] = -133.28719090954,
      ["target"] = 1,
      ["direction"] = -2,
      ["connectionIndex"] = 1,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 534.60425588888,
      ["y"] = -320.47170086583,
      ["target"] = 3,
      ["direction"] = -1,
      ["connectionIndex"] = 2,
    },
  },
  [3] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 660.60781085846,
      ["y"] = -200.29488416438,
      ["target"] = 2,
      ["direction"] = 1,
      ["connectionIndex"] = 2,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 364.90002325125,
      ["y"] = -345.9637472103,
      ["target"] = 4,
      ["direction"] = -2,
      ["connectionIndex"] = 3,
    },
  },
  [4] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 698.48184402983,
      ["y"] = -299.3496847796,
      ["target"] = 3,
      ["direction"] = 2,
      ["connectionIndex"] = 3,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Murkbrine Shorerunner",
    ["id"] = 178163,
    ["count"] = 1,
    ["health"] = 34034,
    ["scale"] = 0.7,
    ["displayId"] = 101786,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 248.64627573484,
        ["y"] = -169.22204291753,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 248.75392348683,
        ["y"] = -161.17369660578,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 243.20657537457,
        ["y"] = -173.90874646384,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 243.14953375066,
        ["y"] = -166.02466781378,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 301.43950924256,
        ["y"] = -191.10905322009,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 305.96667130663,
        ["y"] = -194.94253564698,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 296.64606408385,
        ["y"] = -192.32570039661,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 300.76725224132,
        ["y"] = -203.2391621071,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 300.96130636867,
        ["y"] = -197.49140525933,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 300.96130636867,
            ["y"] = -197.49140525933,
          },
          [2] = {
            ["x"] = 271.98829807798,
            ["y"] = -158.08435956686,
          },
          [3] = {
            ["x"] = 250.35762569518,
            ["y"] = -144.88963530338,
          },
          [4] = {
            ["x"] = 220.45396829854,
            ["y"] = -157.30440787103,
          },
          [5] = {
            ["x"] = 206.74706022995,
            ["y"] = -177.86493804289,
          },
          [6] = {
            ["x"] = 162.68874227424,
            ["y"] = -209.68480866703,
          },
          [7] = {
            ["x"] = 156.84568227875,
            ["y"] = -250.80587951506,
          },
          [8] = {
            ["x"] = 199.40400023446,
            ["y"] = -293.39554240399,
          },
          [9] = {
            ["x"] = 238.56675676502,
            ["y"] = -302.69676724207,
          },
          [10] = {
            ["x"] = 272.83434206583,
            ["y"] = -276.75132255527,
          },
          [11] = {
            ["x"] = 265.00178115225,
            ["y"] = -229.26630384319,
          },
        },
      },
      [10] = {
        ["x"] = 306.16580846455,
        ["y"] = -201.12930789802,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 295.48781849206,
        ["y"] = -199.85623783412,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 292.85684476823,
        ["y"] = -195.85262468798,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 284.29295269664,
        ["y"] = -150.22294535564,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 289.08871833646,
        ["y"] = -156.04042031711,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 295.65376749376,
        ["y"] = -156.72844087138,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 288.52009407887,
        ["y"] = -141.25650244725,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 299.49282850228,
        ["y"] = -103.6359512511,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 283.96032,
        ["y"] = -103.36641862698,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 289.06301162295,
        ["y"] = -109.25786961688,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 294.97770589956,
        ["y"] = -109.45402790979,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 237.7012759344,
        ["y"] = -83.780222447925,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 249.89122754377,
        ["y"] = -77.737941298943,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 244.3365082009,
        ["y"] = -83.4012842827,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 246.6127403394,
        ["y"] = -68.871099471295,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 334.8231640808,
        ["y"] = -89.921462657577,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 333.29735072914,
        ["y"] = -84.691662170916,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 335.46540561195,
        ["y"] = -79.32162487546,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 340.91875535608,
        ["y"] = -78.243266248428,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 340.72506779882,
        ["y"] = -89.993711648286,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 346.28659514586,
        ["y"] = -88.556787127179,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 339.07975570113,
        ["y"] = -84.327966343286,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 339.07975570113,
            ["y"] = -84.327966343286,
          },
          [2] = {
            ["x"] = 305.36560304198,
            ["y"] = -78.104339018435,
          },
          [3] = {
            ["x"] = 260.39066286878,
            ["y"] = -52.257220670826,
          },
          [4] = {
            ["x"] = 255.37166394407,
            ["y"] = -80.197105359474,
          },
          [5] = {
            ["x"] = 287.92585359602,
            ["y"] = -116.23924390271,
          },
          [6] = {
            ["x"] = 312.34149084544,
            ["y"] = -107.40309773028,
          },
          [7] = {
            ["x"] = 351.17394958323,
            ["y"] = -113.91393965231,
          },
          [8] = {
            ["x"] = 374.26237566515,
            ["y"] = -128.31029689456,
          },
          [9] = {
            ["x"] = 381.40286991162,
            ["y"] = -156.6994330792,
          },
          [10] = {
            ["x"] = 415.42014364289,
            ["y"] = -117.14886642992,
          },
          [11] = {
            ["x"] = 385.99304242848,
            ["y"] = -96.898292966201,
          },
          [12] = {
            ["x"] = 358.55453709606,
            ["y"] = -87.8296288426,
          },
        },
      },
      [32] = {
        ["x"] = 344.96920176265,
        ["y"] = -83.253252437626,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 229.37696052396,
        ["y"] = -237.17503893355,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 230.45415724891,
        ["y"] = -223.99587120262,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 235.48823017485,
        ["y"] = -236.89297041808,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 244.05998533628,
        ["y"] = -227.45623207838,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 249.94712759384,
        ["y"] = -268.71818371289,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 231.54932189533,
        ["y"] = -272.88448286786,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 234.94713086471,
        ["y"] = -278.96166852073,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 246.56870586441,
        ["y"] = -263.77464624649,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 193.99249741064,
        ["y"] = -316.11680263316,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 185.87569413976,
        ["y"] = -299.24892956813,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 195.92832,
        ["y"] = -295.56481036966,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 199.70885879871,
        ["y"] = -302.47522060773,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 151.85804569434,
        ["y"] = -241.34737633685,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [46] = {
        ["x"] = 139.0561683756,
        ["y"] = -242.29935891467,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [47] = {
        ["x"] = 149.16305845855,
        ["y"] = -256.02716240142,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [48] = {
        ["x"] = 146.06841086471,
        ["y"] = -260.13856605913,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [49] = {
        ["x"] = 291.90723698761,
        ["y"] = -241.92393059709,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [50] = {
        ["x"] = 288.79684360213,
        ["y"] = -247.46056242472,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [51] = {
        ["x"] = 299.34454378783,
        ["y"] = -250.36822135992,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [52] = {
        ["x"] = 294.3288398762,
        ["y"] = -247.61388914341,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [53] = {
        ["x"] = 283.23104052396,
        ["y"] = -300.21662110361,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [54] = {
        ["x"] = 273.65040051561,
        ["y"] = -306.65230020973,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [55] = {
        ["x"] = 276.64047017903,
        ["y"] = -300.89482554794,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [56] = {
        ["x"] = 274.758028267,
        ["y"] = -312.88952646539,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [57] = {
        ["x"] = 361.66291862445,
        ["y"] = -276.28035052709,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
      [58] = {
        ["x"] = 355.59847345408,
        ["y"] = -275.50725273733,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [59] = {
        ["x"] = 351.6173317163,
        ["y"] = -262.13582646735,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [60] = {
        ["x"] = 356.76529413976,
        ["y"] = -257.27118263315,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [61] = {
        ["x"] = 363.07513712812,
        ["y"] = -135.8100669154,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [62] = {
        ["x"] = 358.5332988254,
        ["y"] = -140.9722230956,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [63] = {
        ["x"] = 363.86181022904,
        ["y"] = -142.94750080307,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [64] = {
        ["x"] = 357.1888068957,
        ["y"] = -147.08840577143,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [65] = {
        ["x"] = 416.70279243548,
        ["y"] = -129.06523670338,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [66] = {
        ["x"] = 420.11307505019,
        ["y"] = -141.04170879321,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [67] = {
        ["x"] = 416.71148926145,
        ["y"] = -136.49001930045,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [68] = {
        ["x"] = 422.68101397228,
        ["y"] = -126.40947069121,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [69] = {
        ["x"] = 483.62993034493,
        ["y"] = -178.58438748905,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [70] = {
        ["x"] = 483.88676137972,
        ["y"] = -191.54423825747,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [71] = {
        ["x"] = 488.69626448887,
        ["y"] = -195.66079706956,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [72] = {
        ["x"] = 484.0455618995,
        ["y"] = -185.50824326348,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [73] = {
        ["x"] = 465.88944071315,
        ["y"] = -246.0225064871,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [74] = {
        ["x"] = 465.68560771542,
        ["y"] = -251.36179165329,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [75] = {
        ["x"] = 471.05856,
        ["y"] = -247.36533845415,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [76] = {
        ["x"] = 475.89391228458,
        ["y"] = -251.6745280159,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [77] = {
        ["x"] = 470.83823928685,
        ["y"] = -252.37786417918,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 470.83823928685,
            ["y"] = -252.37786417918,
          },
          [2] = {
            ["x"] = 502.36976458035,
            ["y"] = -285.28241139768,
          },
          [3] = {
            ["x"] = 515.07593023429,
            ["y"] = -285.20350178479,
          },
          [4] = {
            ["x"] = 523.72820661372,
            ["y"] = -273.73924579322,
          },
          [5] = {
            ["x"] = 505.12583282029,
            ["y"] = -225.07020508328,
          },
          [6] = {
            ["x"] = 467.70475697333,
            ["y"] = -231.34311195638,
          },
          [7] = {
            ["x"] = 471.38198464576,
            ["y"] = -197.38294480462,
          },
          [8] = {
            ["x"] = 437.85439046829,
            ["y"] = -197.59924521608,
          },
          [9] = {
            ["x"] = 417.30526655724,
            ["y"] = -232.64094227384,
          },
          [10] = {
            ["x"] = 427.90429305429,
            ["y"] = -257.29992717033,
          },
          [11] = {
            ["x"] = 448.66974522545,
            ["y"] = -243.88889785394,
          },
        },
      },
      [78] = {
        ["x"] = 475.29943758957,
        ["y"] = -245.96225665637,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [79] = {
        ["x"] = 474.37909937075,
        ["y"] = -256.74597982054,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [80] = {
        ["x"] = 469.09936771542,
        ["y"] = -257.23124759926,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [81] = {
        ["x"] = 426.04497466372,
        ["y"] = -204.00416574357,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [82] = {
        ["x"] = 414.17605551113,
        ["y"] = -204.64861827059,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [83] = {
        ["x"] = 420.95673964612,
        ["y"] = -206.9558887117,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [84] = {
        ["x"] = 428.40640982932,
        ["y"] = -198.1206604936,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [85] = {
        ["x"] = 422.15123704422,
        ["y"] = -288.54297412153,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [86] = {
        ["x"] = 435.33504,
        ["y"] = -271.76295630214,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [87] = {
        ["x"] = 434.97776350113,
        ["y"] = -283.66440360135,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [88] = {
        ["x"] = 413.33532509523,
        ["y"] = -271.25329987472,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [89] = {
        ["x"] = 481.9489218995,
        ["y"] = -292.60827138725,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [90] = {
        ["x"] = 486.55537413976,
        ["y"] = -288.58278917789,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [91] = {
        ["x"] = 493.82830743211,
        ["y"] = -305.33834778076,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [92] = {
        ["x"] = 499.39849793877,
        ["y"] = -299.05153604061,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [93] = {
        ["x"] = 533.89399620934,
        ["y"] = -272.64198795723,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [94] = {
        ["x"] = 535.35844190368,
        ["y"] = -267.52666206934,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [95] = {
        ["x"] = 530.37419862863,
        ["y"] = -263.4476513722,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [96] = {
        ["x"] = 528.3612668998,
        ["y"] = -269.07671990734,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Murkbrine Shellcrusher",
    ["id"] = 178139,
    ["count"] = 3,
    ["health"] = 191443,
    ["scale"] = 1.5,
    ["displayId"] = 101785,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [355048] = {
      },
      [355057] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 259.03683341658,
        ["y"] = -172.22876696806,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 237.39512291903,
        ["y"] = -67.289044399139,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 240.31516413081,
        ["y"] = -270.80019209912,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 186.66568051978,
        ["y"] = -309.26465096839,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 140.61127672495,
        ["y"] = -252.9230742988,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
      [6] = {
        ["x"] = 302.29148384973,
        ["y"] = -240.96016731611,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 283.08174965507,
        ["y"] = -309.64375164109,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 360.10632655427,
        ["y"] = -267.15109061874,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 372.58757879871,
        ["y"] = -261.81624008578,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 353.78893417233,
        ["y"] = -134.02489012563,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 431.98526680686,
        ["y"] = -133.62565248212,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 502.57575948857,
        ["y"] = -184.37711780032,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 419.50963535358,
        ["y"] = -196.97401238471,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 420.85060475963,
        ["y"] = -278.72183698329,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 491.75568602614,
        ["y"] = -296.78562119972,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 542.33183672913,
        ["y"] = -260.00808282312,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Murkbrine Fishmancer",
    ["id"] = 178142,
    ["count"] = 2,
    ["health"] = 148900,
    ["scale"] = 1,
    ["displayId"] = 101789,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [355225] = {
        ["interruptible"] = true,
      },
      [355234] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 249.69831645553,
        ["y"] = -177.66299627614,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [2] = {
        ["x"] = 255.57238033432,
        ["y"] = -161.34438708277,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 299.86895770807,
        ["y"] = -149.4194827289,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 296.18509154503,
        ["y"] = -140.49308953165,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 287.68267527364,
        ["y"] = -94.658562019486,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 298.02378112884,
        ["y"] = -96.448491815644,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 249.26170775974,
        ["y"] = -276.04532581162,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 241.81940673808,
        ["y"] = -282.73539121779,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [9] = {
        ["x"] = 151.00034500865,
        ["y"] = -249.9678446839,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 145.83042121382,
        ["y"] = -242.79354358246,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
      [11] = {
        ["x"] = 307.22255711141,
        ["y"] = -250.46084457025,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 294.30826816798,
        ["y"] = -234.25814248679,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 368.51423896878,
        ["y"] = -273.00780683019,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 427.01464714626,
        ["y"] = -141.39750426835,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 506.21593088141,
        ["y"] = -193.68793887372,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 409.74727672495,
        ["y"] = -198.6911983138,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
      [17] = {
        ["x"] = 423.15490068986,
        ["y"] = -186.38884273604,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 420.19206708617,
        ["y"] = -268.57247559001,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 427.7112984898,
        ["y"] = -269.12515193048,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 486.82861879453,
        ["y"] = -306.56626626504,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 480.45913034076,
        ["y"] = -299.12427810261,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 546.35782638837,
        ["y"] = -268.39491445557,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Coastwalker Goliath",
    ["id"] = 178165,
    ["count"] = 18,
    ["health"] = 425429,
    ["scale"] = 2,
    ["displayId"] = 101790,
    ["creatureType"] = "Giant",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [355429] = {
      },
      [355464] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 263.1284704889,
        ["y"] = -130.93042582177,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 263.1284704889,
            ["y"] = -130.93042582177,
          },
          [2] = {
            ["x"] = 312.16042736923,
            ["y"] = -102.66682392472,
          },
          [3] = {
            ["x"] = 263.1284704889,
            ["y"] = -130.93042582177,
          },
          [4] = {
            ["x"] = 289.18103265478,
            ["y"] = -169.41655689968,
          },
          [5] = {
            ["x"] = 295.74655052154,
            ["y"] = -208.26270979967,
          },
          [6] = {
            ["x"] = 289.18103265478,
            ["y"] = -169.41655689968,
          },
        },
      },
      [2] = {
        ["x"] = 194.11392,
        ["y"] = -206.53300528084,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 194.11392,
            ["y"] = -206.53300528084,
          },
          [2] = {
            ["x"] = 160.26729596452,
            ["y"] = -182.29786432085,
          },
          [3] = {
            ["x"] = 194.11392,
            ["y"] = -206.53300528084,
          },
          [4] = {
            ["x"] = 197.98118275107,
            ["y"] = -261.80955174617,
          },
          [5] = {
            ["x"] = 215.31523582078,
            ["y"] = -312.12054444119,
          },
          [6] = {
            ["x"] = 197.98118275107,
            ["y"] = -261.80955174617,
          },
        },
      },
      [3] = {
        ["x"] = 323.01696,
        ["y"] = -274.86221795487,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 323.01696,
            ["y"] = -274.86221795487,
          },
          [2] = {
            ["x"] = 310.22476796274,
            ["y"] = -218.60160247727,
          },
          [3] = {
            ["x"] = 323.01696,
            ["y"] = -274.86221795487,
          },
          [4] = {
            ["x"] = 423.10743388687,
            ["y"] = -304.84899908608,
          },
          [5] = {
            ["x"] = 457.35275293371,
            ["y"] = -329.37033293854,
          },
          [6] = {
            ["x"] = 423.10743388687,
            ["y"] = -304.84899908608,
          },
        },
      },
      [4] = {
        ["x"] = 464.07759649887,
        ["y"] = -222.41197903666,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 464.07759649887,
            ["y"] = -222.41197903666,
          },
          [2] = {
            ["x"] = 514.22371250835,
            ["y"] = -221.79788653731,
          },
          [3] = {
            ["x"] = 464.07759649887,
            ["y"] = -222.41197903666,
          },
          [4] = {
            ["x"] = 423.32572138459,
            ["y"] = -224.33459094893,
          },
          [5] = {
            ["x"] = 400.91829577927,
            ["y"] = -262.38490310986,
          },
          [6] = {
            ["x"] = 423.32572138459,
            ["y"] = -224.33459094893,
          },
        },
      },
    },
  },
  [5] = {
    ["name"] = "Murkbrine Wavejumper",
    ["id"] = 178133,
    ["count"] = 2,
    ["health"] = 170172,
    ["scale"] = 1,
    ["displayId"] = 101787,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [355118] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 291.23856464879,
        ["y"] = -149.23595337116,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 242.71046143142,
        ["y"] = -75.576521111622,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 233.94326834183,
        ["y"] = -77.477447746006,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
      [4] = {
        ["x"] = 237.9859901832,
        ["y"] = -224.69124680027,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 240.49781931431,
        ["y"] = -233.07561982124,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 197.94480275527,
        ["y"] = -308.75227856553,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 192.00179155875,
        ["y"] = -300.94554093603,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 291.41952,
        ["y"] = -316.90434357981,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 352.18809155215,
        ["y"] = -142.51706505463,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 355.54687157144,
        ["y"] = -123.61280707715,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 429.12873658699,
        ["y"] = -124.54412828296,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 490.34639070299,
        ["y"] = -181.73450040053,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 413.62845172048,
        ["y"] = -189.79708773045,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 428.66351928685,
        ["y"] = -285.78378233087,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 498.89975568538,
        ["y"] = -291.99093981162,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 533.08860465477,
        ["y"] = -256.98406220222,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 540.92903450199,
        ["y"] = -271.53036764937,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["disguised"] = true,
      },
    },
  },
  [6] = {
    ["name"] = "Murkbrine Scalebinder",
    ["id"] = 178141,
    ["count"] = 2,
    ["health"] = 148900,
    ["scale"] = 1,
    ["displayId"] = 101788,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [355132] = {
      },
      [355147] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 291.79938793611,
        ["y"] = -102.74772657247,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 232.98191724473,
        ["y"] = -230.81090907873,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 302.40065068259,
        ["y"] = -229.41584117977,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 290.60316792564,
        ["y"] = -301.41925428156,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 294.09065257206,
        ["y"] = -309.58083394209,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 363.60272327922,
        ["y"] = -255.76090608254,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 362.36827381407,
        ["y"] = -127.18295206698,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 422.06834465104,
        ["y"] = -133.96785839034,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 497.75079070716,
        ["y"] = -196.81869140533,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 492.69790534463,
        ["y"] = -189.43704780382,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 427.88723155875,
        ["y"] = -191.12923797744,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 430.69963595352,
        ["y"] = -278.11605837984,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 493.28480052396,
        ["y"] = -286.35431033477,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 537.37451378588,
        ["y"] = -250.85950286669,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Stormforged Guardian",
    ["id"] = 178171,
    ["count"] = 10,
    ["health"] = 306309,
    ["scale"] = 2,
    ["displayId"] = 67358,
    ["creatureType"] = "Elemental",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [355577] = {
      },
      [355584] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 179.98024071785,
        ["y"] = -146.87810971469,
        ["g"] = 22,
        ["sublevel"] = 2,
        ["scale"] = 1,
      },
      [2] = {
        ["x"] = 154.95923302991,
        ["y"] = -165.95070526927,
        ["g"] = 22,
        ["sublevel"] = 2,
        ["scale"] = 1,
      },
      [3] = {
        ["x"] = 254.78486486487,
        ["y"] = -298.08,
        ["g"] = 23,
        ["sublevel"] = 2,
        ["scale"] = 1,
      },
      [4] = {
        ["x"] = 274.33945945946,
        ["y"] = -286.11,
        ["g"] = 23,
        ["sublevel"] = 2,
        ["scale"] = 1,
        ["disguised"] = true,
      },
    },
  },
  [8] = {
    ["name"] = "Hylbrande",
    ["id"] = 175663,
    ["count"] = 0,
    ["health"] = 1278300,
    ["scale"] = 2,
    ["displayId"] = 100546,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 2448,
    ["instanceID"] = 1194,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [346116] = {
      },
      [346766] = {
      },
      [346960] = {
      },
      [346961] = {
      },
      [347094] = {
      },
      [347097] = {
      },
      [353312] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 473.60056162639,
        ["y"] = -257.48827250141,
        ["sublevel"] = 2,
        ["scale"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Burly Deckhand",
    ["id"] = 180015,
    ["count"] = 5,
    ["health"] = 255257,
    ["scale"] = 1.5,
    ["displayId"] = 101457,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [356133] = {
      },
      [368662] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 569.45466666667,
        ["y"] = -242.572,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [2] = {
        ["x"] = 574.99272120995,
        ["y"] = -263.7459256162,
        ["g"] = 24,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
        ["patrol"] = {
          [1] = {
            ["x"] = 574.99272120995,
            ["y"] = -263.7459256162,
          },
          [2] = {
            ["x"] = 552.43331515599,
            ["y"] = -269.42181080501,
          },
          [3] = {
            ["x"] = 538.72446016358,
            ["y"] = -286.21221426917,
          },
          [4] = {
            ["x"] = 552.43331515599,
            ["y"] = -269.42181080501,
          },
        },
      },
      [3] = {
        ["x"] = 578.2807326888,
        ["y"] = -251.23465837024,
        ["g"] = 24,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [4] = {
        ["x"] = 546.01750687507,
        ["y"] = -277.18383385118,
        ["g"] = 25,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [5] = {
        ["x"] = 426.22197330497,
        ["y"] = -406.32553217682,
        ["g"] = 26,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [6] = {
        ["x"] = 420.58456754282,
        ["y"] = -356.25654417079,
        ["g"] = 27,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [7] = {
        ["x"] = 431.62995704495,
        ["y"] = -346.69309426169,
        ["g"] = 27,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
    },
  },
  [10] = {
    ["name"] = "Hourglass Tidesage",
    ["id"] = 179388,
    ["count"] = 4,
    ["health"] = 191443,
    ["scale"] = 1.5,
    ["displayId"] = 101468,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [356260] = {
        ["interruptible"] = true,
      },
      [356843] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 546.14605134569,
        ["y"] = -253.25472612181,
        ["g"] = 25,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [2] = {
        ["x"] = 534.13325749233,
        ["y"] = -266.40799015255,
        ["g"] = 25,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
        ["disguised"] = true,
      },
      [3] = {
        ["x"] = 442.09306613981,
        ["y"] = -408.90512128957,
        ["g"] = 26,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [4] = {
        ["x"] = 445.91519728639,
        ["y"] = -395.71003696062,
        ["g"] = 26,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [5] = {
        ["x"] = 423.50651263335,
        ["y"] = -372.4530498332,
        ["g"] = 27,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
        ["disguised"] = true,
      },
      [6] = {
        ["x"] = 398.15790712417,
        ["y"] = -340.38113937756,
        ["g"] = 28,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [7] = {
        ["x"] = 396.74059612402,
        ["y"] = -324.44033639399,
        ["g"] = 28,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
    },
  },
  [11] = {
    ["name"] = "Drunk Pirate",
    ["id"] = 179399,
    ["count"] = 0,
    ["health"] = 42543,
    ["scale"] = 1,
    ["displayId"] = 101469,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["clones"] = {
      [1] = {
        ["x"] = 515.27466666667,
        ["y"] = -249.3615,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
        ["disguised"] = true,
      },
      [2] = {
        ["x"] = 525.04666666667,
        ["y"] = -238.40025,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
    },
  },
  [12] = {
    ["name"] = "Corsair Officer",
    ["id"] = 179386,
    ["count"] = 5,
    ["health"] = 212714,
    ["scale"] = 1.5,
    ["displayId"] = 101464,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [368661] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 432.39772311134,
        ["y"] = -392.57133752355,
        ["g"] = 26,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [2] = {
        ["x"] = 439.74829490805,
        ["y"] = -360.99897693225,
        ["g"] = 27,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
        ["inspiring"] = true,
      },
      [3] = {
        ["x"] = 411.42879441707,
        ["y"] = -336.29737198584,
        ["g"] = 28,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [4] = {
        ["x"] = 412.08631062944,
        ["y"] = -322.18541733076,
        ["g"] = 28,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
    },
  },
  [13] = {
    ["name"] = "Timecap'n Hooktail",
    ["id"] = 175546,
    ["count"] = 0,
    ["health"] = 1342215,
    ["scale"] = 1.5,
    ["displayId"] = 100063,
    ["creatureType"] = "Dragonkin",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 2449,
    ["instanceID"] = 1194,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [347149] = {
      },
      [347151] = {
      },
      [350517] = {
      },
      [354334] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 387.3882352453,
        ["y"] = -383.52363729969,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
    },
  },
  [14] = {
    ["name"] = "Adorned Starseer",
    ["id"] = 180429,
    ["count"] = 12,
    ["health"] = 319072,
    ["scale"] = 2.5,
    ["displayId"] = 101668,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [357226] = {
      },
      [357238] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 596.66057253495,
        ["y"] = -296.34263212029,
        ["sublevel"] = 4,
      },
      [2] = {
        ["x"] = 357.80740678764,
        ["y"] = -350.98622421424,
        ["sublevel"] = 4,
      },
      [3] = {
        ["x"] = 357.80740678764,
        ["y"] = -251.09986389649,
        ["sublevel"] = 4,
      },
    },
  },
  [15] = {
    ["name"] = "Devoted Accomplice",
    ["id"] = 180432,
    ["count"] = 5,
    ["health"] = 233986,
    ["scale"] = 2,
    ["displayId"] = 101670,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [357281] = {
      },
      [357284] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 496.20196216496,
        ["y"] = -228.53647395665,
        ["g"] = 31,
        ["sublevel"] = 4,
      },
      [2] = {
        ["x"] = 486.75989684646,
        ["y"] = -250.36106712538,
        ["g"] = 31,
        ["sublevel"] = 4,
      },
      [3] = {
        ["x"] = 492.12059282944,
        ["y"] = -366.38556733213,
        ["g"] = 29,
        ["sublevel"] = 4,
      },
      [4] = {
        ["x"] = 480.47952485113,
        ["y"] = -343.81926627559,
        ["g"] = 29,
        ["sublevel"] = 4,
      },
      [5] = {
        ["x"] = 420.69217397572,
        ["y"] = -290.3200127783,
        ["g"] = 30,
        ["sublevel"] = 4,
        ["patrol"] = {
          [1] = {
            ["x"] = 420.69217397572,
            ["y"] = -290.3200127783,
          },
          [2] = {
            ["x"] = 420.69122016889,
            ["y"] = -261.88124442449,
          },
          [3] = {
            ["x"] = 375.51399641701,
            ["y"] = -200.75913494355,
          },
          [4] = {
            ["x"] = 420.69122016889,
            ["y"] = -261.88124442449,
          },
          [5] = {
            ["x"] = 419.27220263459,
            ["y"] = -338.19497528549,
          },
          [6] = {
            ["x"] = 376.80714096491,
            ["y"] = -400.0440952365,
          },
          [7] = {
            ["x"] = 419.27220263459,
            ["y"] = -338.19497528549,
          },
        },
      },
      [6] = {
        ["x"] = 437.35859284743,
        ["y"] = -290.3200127783,
        ["g"] = 30,
        ["sublevel"] = 4,
      },
      [7] = {
        ["x"] = 403.54542018354,
        ["y"] = -290.3200127783,
        ["g"] = 30,
        ["sublevel"] = 4,
      },
    },
  },
  [16] = {
    ["name"] = "Focused Ritualist",
    ["id"] = 180431,
    ["count"] = 4,
    ["health"] = 212714,
    ["scale"] = 2,
    ["displayId"] = 101669,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [354297] = {
        ["interruptible"] = true,
      },
      [357260] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 480.34756361977,
        ["y"] = -233.42764090258,
        ["g"] = 31,
        ["sublevel"] = 4,
      },
      [2] = {
        ["x"] = 475.99002161812,
        ["y"] = -359.43379694508,
        ["g"] = 29,
        ["sublevel"] = 4,
        ["inspiring"] = true,
      },
      [3] = {
        ["x"] = 429.025383412,
        ["y"] = -309.3225539744,
        ["g"] = 30,
        ["sublevel"] = 4,
        ["disguised"] = true,
      },
      [4] = {
        ["x"] = 412.11879708,
        ["y"] = -309.3225539744,
        ["g"] = 30,
        ["sublevel"] = 4,
      },
    },
  },
  [17] = {
    ["name"] = "So'leah",
    ["id"] = 177269,
    ["count"] = 0,
    ["health"] = 1267648,
    ["scale"] = 2,
    ["displayId"] = 100737,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["isBoss"] = true,
    ["encounterID"] = 2455,
    ["instanceID"] = 1194,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [350796] = {
      },
      [350804] = {
      },
      [350875] = {
      },
      [351057] = {
      },
      [351086] = {
      },
      [351096] = {
      },
      [351124] = {
      },
      [351646] = {
      },
      [353635] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 283.09217391304,
        ["y"] = -295.18760869565,
        ["sublevel"] = 4,
      },
    },
  },
  [18] = {
    ["name"] = "Wo Relic",
    ["id"] = 185683,
    ["count"] = 0,
    ["health"] = 27566,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 101046,
    ["iconTexture"] = 4335644,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368241,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.6,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366566] = {
      },
      [368078] = {
      },
      [368079] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 234.38152043498,
        ["y"] = -178.22634875564,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 481.47669065879,
        ["y"] = -201.35446229359,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 286.60979783526,
        ["y"] = -326.18322834186,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 438.22839277274,
        ["y"] = -250.71941189653,
        ["sublevel"] = 2,
        ["scale"] = 1,
      },
      [5] = {
        ["x"] = 522.46660448237,
        ["y"] = -274.87677396582,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [6] = {
        ["x"] = 456.23858618855,
        ["y"] = -400.61371626969,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [7] = {
        ["x"] = 362.06324976029,
        ["y"] = -384.17526290325,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [8] = {
        ["x"] = 574.16965439583,
        ["y"] = -296.07386895014,
        ["sublevel"] = 4,
      },
      [9] = {
        ["x"] = 463.01567202823,
        ["y"] = -229.99679438382,
        ["sublevel"] = 4,
      },
      [10] = {
        ["x"] = 249.93883946186,
        ["y"] = -293.84294315707,
        ["sublevel"] = 4,
      },
    },
  },
  [19] = {
    ["name"] = "Urh Relic",
    ["id"] = 185685,
    ["count"] = 0,
    ["health"] = 27566,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 105134,
    ["iconTexture"] = 4335642,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368239,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.75,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [366288] = {
      },
      [366297] = {
      },
      [368077] = {
      },
      [368243] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 233.75656567514,
        ["y"] = -165.47633824613,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 493.25089011202,
        ["y"] = -207.16092269729,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 276.86113958691,
        ["y"] = -322.73572053187,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 441.97844297335,
        ["y"] = -271.34439295692,
        ["sublevel"] = 2,
        ["scale"] = 1,
      },
      [5] = {
        ["x"] = 533.78234233289,
        ["y"] = -283.56103312134,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [6] = {
        ["x"] = 457.55432553605,
        ["y"] = -386.40324795435,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [7] = {
        ["x"] = 371.01055740241,
        ["y"] = -391.54369236317,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [8] = {
        ["x"] = 594.55417906869,
        ["y"] = -319.91997834422,
        ["sublevel"] = 4,
      },
      [9] = {
        ["x"] = 468.78501290872,
        ["y"] = -251.15062612944,
        ["sublevel"] = 4,
      },
      [10] = {
        ["x"] = 278.78501567546,
        ["y"] = -262.68914283141,
        ["sublevel"] = 4,
      },
    },
  },
  [20] = {
    ["name"] = "Vy Relic",
    ["id"] = 185680,
    ["count"] = 0,
    ["health"] = 27566,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 103111,
    ["iconTexture"] = 4335643,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368240,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.75,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366406] = {
      },
      [366409] = {
      },
      [368103] = {
      },
      [368104] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 241.38155018701,
        ["y"] = -154.47634053905,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 506.47668043977,
        ["y"] = -203.93511443827,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 267.23651502001,
        ["y"] = -316.26030050283,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 456.04088982685,
        ["y"] = -286.65688336604,
        ["sublevel"] = 2,
        ["scale"] = 1,
      },
      [5] = {
        ["x"] = 547.9928784093,
        ["y"] = -289.35049405097,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [6] = {
        ["x"] = 446.23858768553,
        ["y"] = -377.19273371648,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [7] = {
        ["x"] = 383.11584727915,
        ["y"] = -394.43842282799,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
      },
      [8] = {
        ["x"] = 594.16959155591,
        ["y"] = -274.15076314356,
        ["sublevel"] = 4,
      },
      [9] = {
        ["x"] = 479.9388430625,
        ["y"] = -213.84299644592,
        ["sublevel"] = 4,
      },
      [10] = {
        ["x"] = 279.55422371282,
        ["y"] = -325.7660505555,
        ["sublevel"] = 4,
      },
    },
  },
  [21] = {
    ["name"] = "Nathrezim Infiltrator",
    ["id"] = 189878,
    ["count"] = 6,
    ["health"] = 261167,
    ["scale"] = 1.2,
    ["displayId"] = 101016,
    ["creatureType"] = "Demon",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [373364] = {
      },
      [373370] = {
      },
      [373391] = {
      },
      [373429] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 233.94326834183,
        ["y"] = -77.477447746006,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [2] = {
        ["x"] = 409.74727672495,
        ["y"] = -198.6911983138,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [3] = {
        ["x"] = 361.66291862445,
        ["y"] = -276.28035052709,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [4] = {
        ["x"] = 145.83042121382,
        ["y"] = -242.79354358246,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [5] = {
        ["x"] = 140.61127672495,
        ["y"] = -252.9230742988,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
      [6] = {
        ["x"] = 274.33945945946,
        ["y"] = -286.11,
        ["g"] = 23,
        ["sublevel"] = 2,
        ["scale"] = 1.7,
        ["shrouded"] = true,
      },
      [7] = {
        ["x"] = 538.99158745165,
        ["y"] = -264.28246427986,
        ["g"] = 25,
        ["sublevel"] = 3,
        ["scale"] = 1.4,
        ["shrouded"] = true,
      },
      [8] = {
        ["x"] = 515.27466666667,
        ["y"] = -249.3615,
        ["sublevel"] = 3,
        ["scale"] = 1.2,
        ["shrouded"] = true,
      },
      [9] = {
        ["x"] = 426.84659493392,
        ["y"] = -369.7202631212,
        ["g"] = 27,
        ["sublevel"] = 3,
        ["scale"] = 1.5,
        ["shrouded"] = true,
      },
      [10] = {
        ["x"] = 429.025383412,
        ["y"] = -309.3225539744,
        ["g"] = 30,
        ["sublevel"] = 4,
        ["scale"] = 1.7,
        ["shrouded"] = true,
      },
      [11] = {
        ["x"] = 521.41160171385,
        ["y"] = -133.3525102302,
        ["sublevel"] = 4,
        ["scale"] = 2,
        ["shrouded"] = true,
      },
    },
  },
  [22] = {
    ["name"] = "Zul'gamux",
    ["id"] = 190128,
    ["count"] = 18,
    ["health"] = 639150,
    ["scale"] = 1.8,
    ["displayId"] = 101106,
    ["creatureType"] = "Demon",
    ["level"] = 61,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [373509] = {
      },
      [373513] = {
      },
      [373552] = {
      },
      [373570] = {
      },
      [373607] = {
      },
      [373724] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 542.25309982999,
        ["y"] = -276.07008514377,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["shrouded"] = true,
      },
    },
  },
};
