local MDT = MDT
local L = MDT.L
local dungeonIndex = 35
MDT.dungeonList[dungeonIndex] = L["The Necrotic Wake"]
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides =
  {
    [1] = {
      zoomScale = 1.2999999523163,
      horizontalPan = 56.598399501064,
      verticalPan = 48.945189206469,
    },
    [2] = {
      zoomScale = 1.5999999046326,
      horizontalPan = 168.58704071777,
      verticalPan = 134.75893682504,
    },
    [3] = {
      zoomScale = 2.1999998092651,
      horizontalPan = 227.14468128678,
      verticalPan = 144.59570926349,
    },
  }
};

local zones = { 1666, 1667, 1668 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.scaleMultiplier[dungeonIndex] = 1.3

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "NecroticWake_A",
  [1] = "NecroticWake_Exterior",
  [2] = "NecroticWake_A",
  [3] = "NecroticWake_B",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["TheNecroticWakeFloor1"],
  [2] = L["TheNecroticWakeFloor2"],
  [3] = L["TheNecroticWakeFloor3"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 283, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 228.01889531903,
      ["y"] = -224.85072612286,
      ["target"] = 2,
      ["direction"] = 1,
      ["connectionIndex"] = 1,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Patchwerk Soldier",
    ["id"] = 162729,
    ["count"] = 4,
    ["health"] = 165398,
    ["scale"] = 0.8,
    ["displayId"] = 95222,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [338022] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 634.44943930098,
        ["y"] = -222.57873870954,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 634.03286694412,
        ["y"] = -212.11171969476,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 623.65755414698,
        ["y"] = -221.30744389803,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 622.96773061204,
        ["y"] = -211.08896875701,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [5] = {
        ["x"] = 581.36600361522,
        ["y"] = -208.62104951716,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 536.95778927684,
        ["y"] = -234.33877343481,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 536.36667443524,
        ["y"] = -225.02027482211,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 542.60524207574,
        ["y"] = -279.14335164267,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 525.98715499635,
        ["y"] = -199.14416302564,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 525.98715499635,
            ["y"] = -199.14416302564,
          },
          [2] = {
            ["x"] = 534.52262643769,
            ["y"] = -196.42508486796,
          },
          [3] = {
            ["x"] = 544.99380897718,
            ["y"] = -191.06179464622,
          },
          [4] = {
            ["x"] = 534.52262643769,
            ["y"] = -196.42508486796,
          },
          [5] = {
            ["x"] = 525.98715499635,
            ["y"] = -199.14416302564,
          },
          [6] = {
            ["x"] = 511.53712196815,
            ["y"] = -202.55454688099,
          },
          [7] = {
            ["x"] = 495.19187531962,
            ["y"] = -204.59771915257,
          },
          [8] = {
            ["x"] = 482.62700791643,
            ["y"] = -204.81940842005,
          },
          [9] = {
            ["x"] = 495.19187531962,
            ["y"] = -204.59771915257,
          },
          [10] = {
            ["x"] = 511.53712196815,
            ["y"] = -202.55454688099,
          },
        },
      },
      [10] = {
        ["x"] = 518.53484462284,
        ["y"] = -195.5108985365,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 519.93836706451,
        ["y"] = -204.71259406778,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 499.53908974431,
        ["y"] = -247.69708502653,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 499.53908974431,
            ["y"] = -247.69708502653,
          },
          [2] = {
            ["x"] = 487.32663292418,
            ["y"] = -243.74189768892,
          },
          [3] = {
            ["x"] = 475.06768697744,
            ["y"] = -238.63401633151,
          },
          [4] = {
            ["x"] = 487.83742873216,
            ["y"] = -236.84625292427,
          },
          [5] = {
            ["x"] = 503.67187957271,
            ["y"] = -235.8246613083,
          },
          [6] = {
            ["x"] = 519.25093250927,
            ["y"] = -233.52611305342,
          },
          [7] = {
            ["x"] = 536.36237286977,
            ["y"] = -235.05848951702,
          },
          [8] = {
            ["x"] = 548.11052300852,
            ["y"] = -243.48649978493,
          },
          [9] = {
            ["x"] = 552.4522216143,
            ["y"] = -250.63755341392,
          },
          [10] = {
            ["x"] = 535.59620107848,
            ["y"] = -250.63755341392,
          },
          [11] = {
            ["x"] = 520.01712622124,
            ["y"] = -249.36058581465,
          },
        },
      },
      [13] = {
        ["x"] = 509.30228887343,
        ["y"] = -251.66312146101,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 433.16111647083,
        ["y"] = -251.14684881901,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 427.21063543203,
        ["y"] = -245.5478806901,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 419.71393005741,
        ["y"] = -245.71898136959,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 548.02757692684,
        ["y"] = -158.69534235456,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 528.6110476032,
        ["y"] = -163.75866402156,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 323.21091484491,
        ["y"] = -389.51616313679,
        ["g"] = 26,
        ["sublevel"] = 2,
      },
      [20] = {
        ["x"] = 330.21843444811,
        ["y"] = -403.68421046567,
        ["g"] = 26,
        ["sublevel"] = 2,
      },
      [21] = {
        ["x"] = 472.84000063188,
        ["y"] = -280.23427925741,
        ["g"] = 28,
        ["sublevel"] = 2,
      },
      [22] = {
        ["x"] = 518.88548008154,
        ["y"] = -254.45851236553,
        ["g"] = 30,
        ["sublevel"] = 2,
      },
      [23] = {
        ["x"] = 528.86956076373,
        ["y"] = -258.12964012969,
        ["g"] = 30,
        ["sublevel"] = 2,
      },
      [24] = {
        ["x"] = 332.01681681998,
        ["y"] = -245.37833861688,
        ["g"] = 31,
        ["sublevel"] = 2,
      },
      [25] = {
        ["x"] = 333.99546137051,
        ["y"] = -256.34717010263,
        ["g"] = 31,
        ["sublevel"] = 2,
        ["inspiring"] = true,
      },
    },
  },
  [2] = {
    ["name"] = "Blight Bag",
    ["id"] = 165138,
    ["count"] = 1,
    ["health"] = 66159,
    ["scale"] = 0.7,
    ["displayId"] = 94761,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [335164] = {
      },
      [338022] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 636.00936056606,
        ["y"] = -267.19125178169,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 637.98762612267,
        ["y"] = -260.66134616311,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 644.29789093094,
        ["y"] = -267.43150244214,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 586.54961231973,
        ["y"] = -164.40364637533,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 594.94517222651,
        ["y"] = -166.62872839749,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 587.45596487713,
        ["y"] = -172.44777146502,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 595.50115230256,
        ["y"] = -173.35158979958,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 499.04391223695,
        ["y"] = -217.41514755322,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [9] = {
        ["x"] = 492.81284184647,
        ["y"] = -212.66842554759,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 502.06672987207,
        ["y"] = -212.17147153557,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 492.29038745918,
        ["y"] = -218.84702666366,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 492.29038745918,
            ["y"] = -218.84702666366,
          },
          [2] = {
            ["x"] = 481.26595505651,
            ["y"] = -228.06097137794,
          },
          [3] = {
            ["x"] = 469.77321378208,
            ["y"] = -243.12927234789,
          },
          [4] = {
            ["x"] = 456.49269814007,
            ["y"] = -268.15792168815,
          },
          [5] = {
            ["x"] = 485.60767558297,
            ["y"] = -270.96727123119,
          },
          [6] = {
            ["x"] = 507.06081454925,
            ["y"] = -272.75502915826,
          },
          [7] = {
            ["x"] = 526.7261681876,
            ["y"] = -275.05357741315,
          },
          [8] = {
            ["x"] = 537.96356635975,
            ["y"] = -249.00332549658,
          },
          [9] = {
            ["x"] = 542.81603885282,
            ["y"] = -222.69770307689,
          },
          [10] = {
            ["x"] = 545.88076985934,
            ["y"] = -207.11863917999,
          },
          [11] = {
            ["x"] = 550.47788828979,
            ["y"] = -172.1295866677,
          },
          [12] = {
            ["x"] = 526.7261681876,
            ["y"] = -185.41010230972,
          },
          [13] = {
            ["x"] = 508.08238424453,
            ["y"] = -201.4999620146,
          },
        },
      },
      [12] = {
        ["x"] = 496.21746123639,
        ["y"] = -205.93932806671,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 445.16897739889,
        ["y"] = -235.75250873611,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 449.03872899225,
        ["y"] = -230.64388483857,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 437.3775162589,
        ["y"] = -451.85134508349,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 441.33610776331,
        ["y"] = -460.66432611916,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 445.38780842536,
        ["y"] = -453.75256275402,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Corpse Harvester",
    ["id"] = 166302,
    ["count"] = 4,
    ["health"] = 165398,
    ["scale"] = 1,
    ["displayId"] = 98170,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [334747] = {
      },
      [334749] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 625.33044286157,
        ["y"] = -169.0870825603,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 590.72328038327,
        ["y"] = -205.29184313564,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 528.20950260339,
        ["y"] = -231.97162700879,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 527.25649379052,
        ["y"] = -288.81692623792,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 537.80754924368,
        ["y"] = -152.83270464034,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 528.0121962859,
        ["y"] = -153.09341803332,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 421.41533899291,
        ["y"] = -256.56424975547,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 431.01973551683,
        ["y"] = -261.78750238567,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Stitched Vanguard",
    ["id"] = 163121,
    ["count"] = 5,
    ["health"] = 198477,
    ["scale"] = 1,
    ["displayId"] = 95227,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [320696] = {
      },
      [320703] = {
      },
      [323190] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 582.76627145072,
        ["y"] = -198.97742264054,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 522.22629180923,
        ["y"] = -223.86546602872,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 518.52418985757,
        ["y"] = -238.40785446451,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 539.75227117869,
        ["y"] = -162.19144306596,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Zolramus Gatekeeper",
    ["id"] = 165137,
    ["count"] = 6,
    ["health"] = 297716,
    ["scale"] = 1.3,
    ["displayId"] = 95231,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [320462] = {
        ["interruptible"] = true,
      },
      [322756] = {
      },
      [323347] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 559.61845772685,
        ["y"] = -251.20442949907,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 552.824366159,
        ["y"] = -196.67875988637,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 478.61009600495,
        ["y"] = -271.3991187384,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Flesh Crafter",
    ["id"] = 165872,
    ["count"] = 4,
    ["health"] = 231557,
    ["scale"] = 1.4,
    ["displayId"] = 96480,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [323496] = {
      },
      [327130] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 535.55348561245,
        ["y"] = -282.46182102424,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 558.7518186685,
        ["y"] = -393.52460810338,
        ["g"] = 27,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 344.50042639228,
        ["y"] = -243.8569580374,
        ["g"] = 31,
        ["sublevel"] = 2,
      },
    },
  },
  [7] = {
    ["name"] = "Blightbone",
    ["id"] = 162691,
    ["count"] = 0,
    ["health"] = 1156365,
    ["scale"] = 1,
    ["displayId"] = 95467,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2395,
    ["instanceID"] = 1182,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [320596] = {
      },
      [320637] = {
      },
      [320655] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 474.12550258036,
        ["y"] = -191.93196037298,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Zolramus Sorcerer",
    ["id"] = 163128,
    ["count"] = 4,
    ["health"] = 148858,
    ["scale"] = 1,
    ["displayId"] = 94992,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [320462] = {
        ["interruptible"] = true,
      },
      [320571] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 512.4238930362,
        ["y"] = -422.52237915355,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 371.75572151009,
        ["y"] = -447.04294061339,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 371.75572151009,
            ["y"] = -447.04294061339,
          },
          [2] = {
            ["x"] = 389.29203003494,
            ["y"] = -435.54724983132,
          },
          [3] = {
            ["x"] = 413.04372821644,
            ["y"] = -424.05448663621,
          },
          [4] = {
            ["x"] = 417.13005083892,
            ["y"] = -445.50763656283,
          },
          [5] = {
            ["x"] = 416.36385712695,
            ["y"] = -464.91762517822,
          },
          [6] = {
            ["x"] = 411.00056690521,
            ["y"] = -484.07221040944,
          },
          [7] = {
            ["x"] = 389.54744985961,
            ["y"] = -473.85642029377,
          },
          [8] = {
            ["x"] = 372.4360314198,
            ["y"] = -460.06510884377,
          },
        },
      },
      [3] = {
        ["x"] = 372.19882316507,
        ["y"] = -401.07502319109,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 378.57231340972,
        ["y"] = -419.22321428571,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 323.22179736442,
        ["y"] = -232.03718381974,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 344.36337460144,
        ["y"] = -260.00834952995,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 250.63511156517,
        ["y"] = -160.55690826205,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Zolramus Bonecarver",
    ["id"] = 163619,
    ["count"] = 4,
    ["health"] = 165398,
    ["scale"] = 1,
    ["displayId"] = 93933,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [321807] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 511.91638786622,
        ["y"] = -410.57386363636,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 387.30009290802,
        ["y"] = -410.86989795918,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 322.98923904285,
        ["y"] = -219.61982716442,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 335.28460823784,
        ["y"] = -249.64703153989,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 290.90430473831,
        ["y"] = -167.59403988868,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 285.55837720657,
        ["y"] = -161.30009276438,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 235.7955778904,
        ["y"] = -178.69230114914,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Zolramus Necromancer",
    ["id"] = 163618,
    ["count"] = 8,
    ["health"] = 231557,
    ["scale"] = 1,
    ["displayId"] = 95233,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [320462] = {
        ["interruptible"] = true,
      },
      [321575] = {
      },
      [321780] = {
      },
      [327393] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 473.55032517807,
        ["y"] = -431.54081632653,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [2] = {
        ["x"] = 208.11726399436,
        ["y"] = -315.56699466368,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [3] = {
        ["x"] = 219.23380883062,
        ["y"] = -116.97895008442,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Brittlebone Mage",
    ["id"] = 163126,
    ["count"] = 0,
    ["health"] = 74429,
    ["scale"] = 0.7,
    ["displayId"] = 96112,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [320336] = {
        ["interruptible"] = true,
      },
      [321576] = {
      },
      [328667] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 464.50724570395,
        ["y"] = -425.54362414449,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 207.84858915843,
        ["y"] = -304.53244640151,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 226.85021723566,
        ["y"] = -110.02334659884,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 209.43075603715,
        ["y"] = -117.71565288417,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Brittlebone Warrior",
    ["id"] = 163122,
    ["count"] = 0,
    ["health"] = 165398,
    ["scale"] = 0.7,
    ["displayId"] = 96107,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [321576] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 481.92691235677,
        ["y"] = -430.36955009276,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 472.35841442181,
        ["y"] = -421.05364831842,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 220.53435785599,
        ["y"] = -320.26256426546,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 218.83792198129,
        ["y"] = -312.78875118092,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 215.29869223532,
        ["y"] = -306.80381678265,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 209.73216749461,
        ["y"] = -111.76993397185,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 228.809996812,
        ["y"] = -116.92727631302,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Skeletal Marauder",
    ["id"] = 165919,
    ["count"] = 6,
    ["health"] = 330795,
    ["scale"] = 1.3,
    ["displayId"] = 96115,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [324293] = {
        ["interruptible"] = true,
      },
      [324323] = {
      },
      [343470] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 362.28095389471,
        ["y"] = -445.32431056607,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 275.17751039323,
        ["y"] = -314.6017442549,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 284.73381683861,
        ["y"] = -304.97159288637,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 311.33505893631,
        ["y"] = -226.12420885162,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 301.2010813,
            ["y"] = -203.55959339373,
          },
          [2] = {
            ["x"] = 289.12112004071,
            ["y"] = -234.36347646038,
          },
          [3] = {
            ["x"] = 308.44904768727,
            ["y"] = -247.65139755652,
          },
        },
      },
      [5] = {
        ["x"] = 247.14214466835,
        ["y"] = -173.2824324214,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Zolramus Bonemender",
    ["id"] = 165222,
    ["count"] = 4,
    ["health"] = 165398,
    ["scale"] = 1,
    ["displayId"] = 97668,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [320822] = {
      },
      [335143] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 366.73633416573,
        ["y"] = -454.67116201069,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 238.36587661194,
        ["y"] = -164.28608333693,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Nar'zudah",
    ["id"] = 165824,
    ["count"] = 15,
    ["health"] = 396955,
    ["scale"] = 1.5,
    ["displayId"] = 94780,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [320462] = {
        ["interruptible"] = true,
      },
      [327393] = {
      },
      [335141] = {
      },
      [345623] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 364.96704633944,
        ["y"] = -413.16966503058,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Skeletal Monstrosity",
    ["id"] = 165197,
    ["count"] = 12,
    ["health"] = 396955,
    ["scale"] = 1.5,
    ["displayId"] = 94814,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [324372] = {
      },
      [324381] = {
      },
      [324387] = {
      },
      [324394] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 281.41711248243,
        ["y"] = -229.35824576779,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 281.41711248243,
            ["y"] = -229.35824576779,
          },
          [2] = {
            ["x"] = 282.43999290261,
            ["y"] = -243.7856346922,
          },
          [3] = {
            ["x"] = 269.4845393741,
            ["y"] = -255.66146709334,
          },
          [4] = {
            ["x"] = 254.00993384542,
            ["y"] = -271.85581489223,
          },
          [5] = {
            ["x"] = 238.53535920499,
            ["y"] = -288.76990496132,
          },
          [6] = {
            ["x"] = 227.37923818582,
            ["y"] = -299.56610079097,
          },
          [7] = {
            ["x"] = 238.53535920499,
            ["y"] = -288.76990496132,
          },
          [8] = {
            ["x"] = 254.00993384542,
            ["y"] = -271.85581489223,
          },
          [9] = {
            ["x"] = 269.4845393741,
            ["y"] = -255.66146709334,
          },
          [10] = {
            ["x"] = 282.43999290261,
            ["y"] = -243.7856346922,
          },
          [11] = {
            ["x"] = 281.41711248243,
            ["y"] = -229.35824576779,
          },
          [12] = {
            ["x"] = 275.96229702659,
            ["y"] = -202.75998551954,
          },
          [13] = {
            ["x"] = 264.80617600743,
            ["y"] = -190.52425881712,
          },
          [14] = {
            ["x"] = 253.6500858765,
            ["y"] = -180.44777436944,
          },
          [15] = {
            ["x"] = 229.17863247165,
            ["y"] = -152.73750391482,
          },
          [16] = {
            ["x"] = 208.30593675021,
            ["y"] = -134.3839293053,
          },
          [17] = {
            ["x"] = 229.17863247165,
            ["y"] = -152.73750391482,
          },
          [18] = {
            ["x"] = 253.6500858765,
            ["y"] = -180.44777436944,
          },
          [19] = {
            ["x"] = 264.80617600743,
            ["y"] = -190.52425881712,
          },
          [20] = {
            ["x"] = 275.96229702659,
            ["y"] = -202.75998551954,
          },
        },
      },
    },
  },
  [17] = {
    ["name"] = "Brittlebone Crossbowman",
    ["id"] = 166079,
    ["count"] = 0,
    ["health"] = 82699,
    ["scale"] = 0.7,
    ["displayId"] = 96114,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [321576] = {
      },
      [328687] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 221.1313948641,
        ["y"] = -105.74744064711,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 213.82472624654,
        ["y"] = -107.20151298418,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Shuffling Corpse",
    ["id"] = 171500,
    ["count"] = 1,
    ["health"] = 59543,
    ["scale"] = 0.7,
    ["displayId"] = 96132,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 333.43862142354,
        ["y"] = -181.35558785632,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 325.38271515666,
        ["y"] = -180.0185191661,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 328.27752421441,
        ["y"] = -188.23093803116,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 337.04580823089,
        ["y"] = -188.72695722824,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 322.29092952831,
        ["y"] = -186.56771497349,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 322.29092952831,
        ["y"] = -194.12509375336,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 330.2082334977,
        ["y"] = -196.28436689635,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 335.24647572154,
        ["y"] = -195.92445715095,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Amarth",
    ["id"] = 163157,
    ["count"] = 0,
    ["health"] = 991170,
    ["scale"] = 1,
    ["displayId"] = 94926,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2391,
    ["instanceID"] = 1182,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [320012] = {
      },
      [320171] = {
        ["interruptible"] = true,
      },
      [321226] = {
      },
      [321247] = {
      },
      [333489] = {
      },
      [333492] = {
      },
      [333634] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 169.18397830322,
        ["y"] = -224.0145497704,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Corpse Collector",
    ["id"] = 173016,
    ["count"] = 4,
    ["health"] = 165398,
    ["scale"] = 1.4,
    ["displayId"] = 98170,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [334747] = {
      },
      [334748] = {
        ["interruptible"] = true,
      },
      [338353] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 318.35932575995,
        ["y"] = -401.66043555864,
        ["g"] = 26,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 480.16714313076,
        ["y"] = -267.25639174782,
        ["g"] = 28,
        ["sublevel"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 516.43828133821,
            ["y"] = -340.82042587609,
          },
          [2] = {
            ["x"] = 529.231447794,
            ["y"] = -388.04944749118,
          },
          [3] = {
            ["x"] = 516.43828133821,
            ["y"] = -340.82042587609,
          },
          [4] = {
            ["x"] = 508.3587829608,
            ["y"] = -315.71477018049,
          },
          [5] = {
            ["x"] = 494.32363108431,
            ["y"] = -277.20825756386,
          },
          [6] = {
            ["x"] = 456.53684529378,
            ["y"] = -262.45340974952,
          },
          [7] = {
            ["x"] = 420.90933264624,
            ["y"] = -258.13495612825,
          },
          [8] = {
            ["x"] = 380.24357777486,
            ["y"] = -262.81325771845,
          },
          [9] = {
            ["x"] = 362.9696088486,
            ["y"] = -311.39628567098,
          },
          [10] = {
            ["x"] = 355.41227640109,
            ["y"] = -343.42505607923,
          },
          [11] = {
            ["x"] = 339.21794404632,
            ["y"] = -385.17046296622,
          },
          [12] = {
            ["x"] = 355.41227640109,
            ["y"] = -343.42505607923,
          },
          [13] = {
            ["x"] = 362.9696088486,
            ["y"] = -311.39628567098,
          },
          [14] = {
            ["x"] = 380.24357777486,
            ["y"] = -262.81325771845,
          },
          [15] = {
            ["x"] = 420.90933264624,
            ["y"] = -258.13495612825,
          },
          [16] = {
            ["x"] = 456.53684529378,
            ["y"] = -262.45340974952,
          },
          [17] = {
            ["x"] = 494.32363108431,
            ["y"] = -277.20825756386,
          },
          [18] = {
            ["x"] = 508.3587829608,
            ["y"] = -315.71477018049,
          },
        },
      },
      [3] = {
        ["x"] = 527.40731699655,
        ["y"] = -243.90869965329,
        ["g"] = 30,
        ["sublevel"] = 2,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 346.17264847671,
        ["y"] = -260.94682723462,
        ["g"] = 31,
        ["sublevel"] = 2,
      },
    },
  },
  [21] = {
    ["name"] = "Kyrian Stitchwerk",
    ["id"] = 172981,
    ["count"] = 5,
    ["health"] = 297716,
    ["scale"] = 2,
    ["displayId"] = 98190,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [338357] = {
      },
      [338456] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 489.40347391047,
        ["y"] = -280.4504047721,
        ["g"] = 28,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 507.51241183571,
        ["y"] = -238.26548043315,
        ["g"] = 30,
        ["sublevel"] = 2,
      },
    },
  },
  [22] = {
    ["name"] = "Spare Parts",
    ["id"] = 166264,
    ["count"] = 0,
    ["health"] = 16540,
    ["scale"] = 0.7,
    ["displayId"] = 95577,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [334610] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 496.81948021409,
        ["y"] = -264.92234647225,
        ["g"] = 28,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 503.26332718268,
        ["y"] = -273.81426718665,
        ["g"] = 28,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 504.84498579856,
        ["y"] = -284.30875546354,
        ["g"] = 28,
        ["sublevel"] = 2,
      },
      [4] = {
        ["x"] = 321.91456123486,
        ["y"] = -344.41113256507,
        ["g"] = 29,
        ["sublevel"] = 2,
      },
      [5] = {
        ["x"] = 322.61187990022,
        ["y"] = -334.95803057736,
        ["g"] = 29,
        ["sublevel"] = 2,
      },
      [6] = {
        ["x"] = 331.72958416192,
        ["y"] = -346.16218291332,
        ["g"] = 29,
        ["sublevel"] = 2,
      },
      [7] = {
        ["x"] = 328.66172329585,
        ["y"] = -337.70181792228,
        ["g"] = 29,
        ["sublevel"] = 2,
      },
      [8] = {
        ["x"] = 333.59885436133,
        ["y"] = -338.05096192215,
        ["g"] = 29,
        ["sublevel"] = 2,
      },
      [9] = {
        ["x"] = 327.30340070056,
        ["y"] = -352.08800928078,
        ["g"] = 29,
        ["sublevel"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 327.30340070056,
            ["y"] = -352.08800928078,
          },
          [2] = {
            ["x"] = 325.54570837852,
            ["y"] = -374.81865258765,
          },
          [3] = {
            ["x"] = 431.26401864717,
            ["y"] = -316.1380174959,
          },
          [4] = {
            ["x"] = 325.54570837852,
            ["y"] = -374.81865258765,
          },
          [5] = {
            ["x"] = 327.30340070056,
            ["y"] = -352.08800928078,
          },
          [6] = {
            ["x"] = 326.24429676612,
            ["y"] = -304.72788040391,
          },
          [7] = {
            ["x"] = 438.48266538655,
            ["y"] = -349.90267320038,
          },
          [8] = {
            ["x"] = 545.45870878004,
            ["y"] = -304.80570661162,
          },
          [9] = {
            ["x"] = 449.07051045071,
            ["y"] = -243.5482860266,
          },
          [10] = {
            ["x"] = 335.88549947827,
            ["y"] = -311.51228888137,
          },
          [11] = {
            ["x"] = 336.58408786588,
            ["y"] = -242.3529678811,
          },
          [12] = {
            ["x"] = 436.9466537621,
            ["y"] = -296.14356420564,
          },
          [13] = {
            ["x"] = 538.95488815547,
            ["y"] = -244.13830503854,
          },
          [14] = {
            ["x"] = 532.20192703481,
            ["y"] = -333.32355666562,
          },
          [15] = {
            ["x"] = 538.95488815547,
            ["y"] = -244.13830503854,
          },
          [16] = {
            ["x"] = 438.35973149523,
            ["y"] = -296.50071153449,
          },
          [17] = {
            ["x"] = 336.58408786588,
            ["y"] = -242.3529678811,
          },
          [18] = {
            ["x"] = 335.88549947827,
            ["y"] = -311.51228888137,
          },
          [19] = {
            ["x"] = 449.07051045071,
            ["y"] = -243.5482860266,
          },
          [20] = {
            ["x"] = 545.45870878004,
            ["y"] = -304.80570661162,
          },
          [21] = {
            ["x"] = 438.48266538655,
            ["y"] = -349.90267320038,
          },
          [22] = {
            ["x"] = 326.24429676612,
            ["y"] = -304.72788040391,
          },
        },
      },
    },
  },
  [23] = {
    ["name"] = "Loyal Creation",
    ["id"] = 165911,
    ["count"] = 4,
    ["health"] = 215017,
    ["scale"] = 1.4,
    ["displayId"] = 95226,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [320696] = {
      },
      [327155] = {
      },
      [327240] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 555.92876428203,
        ["y"] = -412.65302221547,
        ["g"] = 27,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 360.30148473588,
        ["y"] = -248.5585823855,
        ["g"] = 31,
        ["sublevel"] = 2,
      },
    },
  },
  [24] = {
    ["name"] = "Separation Assistant",
    ["id"] = 167731,
    ["count"] = 4,
    ["health"] = 330795,
    ["scale"] = 1.6,
    ["displayId"] = 98227,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [323496] = {
      },
      [338606] = {
      },
      [338636] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 462.17634607938,
        ["y"] = -333.18280218782,
        ["g"] = 32,
        ["sublevel"] = 2,
      },
    },
  },
  [25] = {
    ["name"] = "Stitching Assistant",
    ["id"] = 173044,
    ["count"] = 4,
    ["health"] = 330795,
    ["scale"] = 1.6,
    ["displayId"] = 98226,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [323496] = {
      },
      [334748] = {
        ["interruptible"] = true,
      },
      [338653] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 399.20005470089,
        ["y"] = -332.88438845501,
        ["g"] = 32,
        ["sublevel"] = 2,
      },
    },
  },
  [26] = {
    ["name"] = "Goregrind",
    ["id"] = 163621,
    ["count"] = 6,
    ["health"] = 463113,
    ["scale"] = 2,
    ["displayId"] = 99122,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [333477] = {
      },
      [338357] = {
      },
      [338456] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 343.72029006187,
        ["y"] = -211.78069692184,
        ["g"] = 33,
        ["sublevel"] = 2,
      },
    },
  },
  [27] = {
    ["name"] = "Goregrind Bits",
    ["id"] = 163622,
    ["count"] = 0,
    ["health"] = 165398,
    ["scale"] = 1,
    ["displayId"] = 97800,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [338022] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 325.51598642195,
        ["y"] = -200.60122878109,
        ["g"] = 33,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 322.25070980819,
        ["y"] = -210.88792224078,
        ["g"] = 33,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 323.48339247663,
        ["y"] = -221.91578976504,
        ["g"] = 33,
        ["sublevel"] = 2,
      },
    },
  },
  [28] = {
    ["name"] = "Rotspew Leftovers",
    ["id"] = 163623,
    ["count"] = 0,
    ["health"] = 132318,
    ["scale"] = 1,
    ["displayId"] = 97801,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [338022] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 545.73080072511,
        ["y"] = -197.7409049355,
        ["g"] = 34,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 548.94901939488,
        ["y"] = -208.50249195281,
        ["g"] = 34,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 546.96846714015,
        ["y"] = -219.60583613804,
        ["g"] = 34,
        ["sublevel"] = 2,
      },
    },
  },
  [29] = {
    ["name"] = "Rotspew",
    ["id"] = 163620,
    ["count"] = 6,
    ["health"] = 396955,
    ["scale"] = 2,
    ["displayId"] = 99121,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [333479] = {
      },
      [333482] = {
      },
      [338456] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 528.68301290168,
        ["y"] = -207.23853311225,
        ["g"] = 34,
        ["sublevel"] = 2,
      },
    },
  },
  [30] = {
    ["name"] = "Stitchflesh's Creation",
    ["id"] = 164578,
    ["count"] = 0,
    ["health"] = 330795,
    ["scale"] = 2,
    ["displayId"] = 96218,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [320208] = {
      },
      [320376] = {
      },
      [334322] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 468.36784136928,
        ["y"] = -206.14354669664,
        ["g"] = 35,
        ["sublevel"] = 2,
      },
    },
  },
  [31] = {
    ["name"] = "Surgeon Stitchflesh",
    ["id"] = 162689,
    ["count"] = 0,
    ["health"] = 713642,
    ["scale"] = 2,
    ["displayId"] = 96477,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2392,
    ["instanceID"] = 1182,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [320200] = {
      },
      [320358] = {
      },
      [320359] = {
      },
      [326574] = {
      },
      [327664] = {
      },
      [334488] = {
      },
      [343556] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 435.43723023701,
        ["y"] = -207.33818322552,
        ["g"] = 35,
        ["sublevel"] = 2,
      },
    },
  },
  [32] = {
    ["name"] = "Nalthor the Rimebinder",
    ["id"] = 162693,
    ["count"] = 0,
    ["health"] = 1057248,
    ["scale"] = 1,
    ["displayId"] = 96085,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2396,
    ["instanceID"] = 1182,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [320771] = {
      },
      [320772] = {
      },
      [320788] = {
      },
      [321370] = {
      },
      [321755] = {
      },
      [321894] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 427.52861110709,
        ["y"] = -276.58583505829,
        ["sublevel"] = 3,
      },
    },
  },
  [33] = {
    ["name"] = "Incinerator Arkolath",
    ["id"] = 179446,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 100718,
    ["iconTexture"] = 236297,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [357575] = {
        ["dps"] = true,
        ["healer"] = true,
        ["tank"] = true,
      },
      [357839] = {
        ["tank"] = true,
      },
      [357848] = {
        ["dps"] = true,
      },
      [357864] = {
        ["dps"] = true,
      },
      [357889] = {
        ["healer"] = true,
      },
      [357897] = {
        ["tank"] = true,
      },
      [357900] = {
        ["healer"] = true,
      },
    },
    ["spells"] = {
      [355707] = {
      },
      [355732] = {
      },
      [355737] = {
      },
      [358967] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 514.25048922962,
        ["y"] = -275.30696567058,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 133.4112971858,
        ["y"] = -188.89626688555,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [34] = {
    ["name"] = "Oros Coldheart",
    ["id"] = 179892,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 97237,
    ["iconTexture"] = 136213,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [357815] = {
        ["dps"] = true,
        ["healer"] = true,
      },
      [357817] = {
        ["tank"] = true,
      },
      [357820] = {
        ["tank"] = true,
      },
      [357825] = {
        ["dps"] = true,
      },
      [357829] = {
        ["healer"] = true,
      },
      [357834] = {
        ["dps"] = true,
        ["tank"] = true,
      },
      [357842] = {
        ["healer"] = true,
      },
    },
    ["spells"] = {
      [355710] = {
      },
      [356414] = {
      },
      [356666] = {
      },
      [358894] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 230.04277792469,
        ["y"] = -277.26473786964,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 547.17891536817,
        ["y"] = -318.59052389709,
        ["sublevel"] = 2,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [35] = {
    ["name"] = "Soggodon the Breaker",
    ["id"] = 179891,
    ["count"] = 0,
    ["health"] = 358540,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 98535,
    ["iconTexture"] = 2103898,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [356827] = {
        ["dps"] = true,
        ["healer"] = true,
      },
      [356828] = {
        ["dps"] = true,
        ["tank"] = true,
      },
      [357524] = {
        ["dps"] = true,
        ["healer"] = true,
        ["tank"] = true,
      },
      [357556] = {
        ["healer"] = true,
      },
      [357778] = {
        ["tank"] = true,
      },
    },
    ["spells"] = {
      [355719] = {
      },
      [355806] = {
      },
      [358784] = {
      },
      [358968] = {
      },
      [358970] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 547.17891536817,
        ["y"] = -318.59052389709,
        ["sublevel"] = 2,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 230.04277792469,
        ["y"] = -277.26473786964,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [36] = {
    ["name"] = "Executioner Varruth",
    ["id"] = 179890,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 92418,
    ["iconTexture"] = 237552,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [357575] = {
        ["dps"] = true,
        ["healer"] = true,
        ["tank"] = true,
      },
      [357604] = {
        ["tank"] = true,
      },
      [357609] = {
        ["dps"] = true,
      },
      [357706] = {
        ["dps"] = true,
      },
      [357747] = {
        ["healer"] = true,
      },
      [357847] = {
        ["healer"] = true,
      },
      [357863] = {
        ["tank"] = true,
      },
    },
    ["spells"] = {
      [355714] = {
      },
      [356923] = {
      },
      [356925] = {
      },
      [358971] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 133.4112971858,
        ["y"] = -188.89626688555,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 514.25048922962,
        ["y"] = -275.30696567058,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [37] = {
    ["name"] = "Wo Relic",
    ["id"] = 185683,
    ["count"] = 0,
    ["health"] = 27566,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 101046,
    ["iconTexture"] = 4335644,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368241,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.6,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366566] = {
      },
      [368078] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 560.84696436723,
        ["y"] = -267.60706198784,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 451.38273023493,
        ["y"] = -192.58339659725,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 535.81498960719,
        ["y"] = -139.2450911293,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 418.19168025724,
        ["y"] = -271.00854009447,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 356.37694098142,
        ["y"] = -395.74125776219,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 309.88764796598,
        ["y"] = -185.00152154736,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 227.26698263135,
        ["y"] = -132.78227250411,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 144.05053876317,
        ["y"] = -224.67097046901,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 537.3163351434,
        ["y"] = -416.09233960975,
        ["sublevel"] = 2,
      },
      [10] = {
        ["x"] = 543.52855222375,
        ["y"] = -238.04693291209,
        ["sublevel"] = 2,
      },
      [11] = {
        ["x"] = 435.20610169426,
        ["y"] = -167.48420743085,
        ["sublevel"] = 2,
      },
      [12] = {
        ["x"] = 426.82647934989,
        ["y"] = -251.18658523668,
        ["sublevel"] = 3,
      },
    },
  },
  [38] = {
    ["name"] = "Urh Relic",
    ["id"] = 185685,
    ["count"] = 0,
    ["health"] = 27566,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 105134,
    ["iconTexture"] = 4335642,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368239,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.75,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366288] = {
      },
      [366297] = {
      },
      [368243] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 575.68567958998,
        ["y"] = -256.47801864895,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 470.41498096638,
        ["y"] = -211.93821846404,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 520.1698257806,
        ["y"] = -141.34185196182,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 405.77228315868,
        ["y"] = -257.62144343355,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 369.76400995501,
        ["y"] = -384.93482708961,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 315.3714818597,
        ["y"] = -169.67890116879,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 241.32104003719,
        ["y"] = -122.37684320404,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 167.4881111182,
        ["y"] = -198.73344511317,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 539.50394489337,
        ["y"] = -397.34235682757,
        ["sublevel"] = 2,
      },
      [10] = {
        ["x"] = 543.17137391657,
        ["y"] = -253.76119975626,
        ["sublevel"] = 2,
      },
      [11] = {
        ["x"] = 412.16339581807,
        ["y"] = -172.61583809638,
        ["sublevel"] = 2,
      },
      [12] = {
        ["x"] = 400.69005772696,
        ["y"] = -276.18658896621,
        ["sublevel"] = 3,
      },
    },
  },
  [39] = {
    ["name"] = "Vy Relic",
    ["id"] = 185680,
    ["count"] = 0,
    ["health"] = 27566,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 103111,
    ["iconTexture"] = 4335643,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368240,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.75,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366406] = {
      },
      [366409] = {
      },
      [368103] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 572.7824424663,
        ["y"] = -239.38125010418,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 472.35046315306,
        ["y"] = -169.35758266978,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 513.07303930456,
        ["y"] = -155.21281224757,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 406.90134442884,
        ["y"] = -241.81495943014,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 386.6995136976,
        ["y"] = -393.16061946117,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 329.13273420253,
        ["y"] = -161.93215148703,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 239.96969371682,
        ["y"] = -106.43091486817,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 167.80061530159,
        ["y"] = -248.42093971907,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 543.25383416144,
        ["y"] = -378.90490505088,
        ["sublevel"] = 2,
      },
      [10] = {
        ["x"] = 537.99284023123,
        ["y"] = -268.40402364035,
        ["sublevel"] = 2,
      },
      [11] = {
        ["x"] = 456.4560472022,
        ["y"] = -173.24080552417,
        ["sublevel"] = 2,
      },
      [12] = {
        ["x"] = 450.69014321391,
        ["y"] = -276.64114051799,
        ["sublevel"] = 3,
      },
    },
  },
};
