local MDT = MDT
local L = MDT.L
local dungeonIndex = 70
MDT.dungeonList[dungeonIndex] = L["Naxxramas"]
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides = {
    [2] = {
      zoomScale = 1.2999999523163;
      horizontalPan = 113.81931807355;
      verticalPan = 54.722345011423;
    };
    [3] = {
      zoomScale = 1.2999999523163;
      horizontalPan = 77.920785439193;
      verticalPan = 42.963549180727;
    };
    [4] = {
      zoomScale = 1.2999999523163;
      horizontalPan = 119.59507409344;
      verticalPan = 10.899920907182;
    };
    [6] = {
      zoomScale = 1.2999999523163;
      horizontalPan = 102.65277339623;
      verticalPan = 50.546052531288;
    };
  }
};

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "naxxramas",
  [1] = "naxxramas1_",
  [2] = "naxxramas2_",
  [3] = "naxxramas3_",
  [4] = "naxxramas4_",
  [5] = "naxxramas5_",
  [6] = "naxxramas6_",
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["The Construct Quarter"],
  [2] = L["The Arachnid Quarter"],
  [3] = L["The Military Quarter"],
  [4] = L["The Plague Quarter"],
  [5] = L["The Lower Necropolis"],
  [6] = L["The Upper Necropolis"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 300, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 5;
      ["direction"] = -1;
      ["connectionIndex"] = 1;
      ["y"] = -436.5;
      ["x"] = 577.3;
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 5;
      ["direction"] = -1;
      ["connectionIndex"] = 2;
      ["y"] = -59.2;
      ["x"] = 228.3;
    };
    [3] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 2;
      ["direction"] = 2;
      ["connectionIndex"] = 3;
      ["y"] = -123.2;
      ["x"] = 608.7;
    };
    [4] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 3;
      ["direction"] = -1;
      ["connectionIndex"] = 4;
      ["y"] = -469.1;
      ["x"] = 266;
    };
  };
  [2] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 5;
      ["direction"] = -1;
      ["connectionIndex"] = 1;
      ["y"] = -433.5;
      ["x"] = 257.7;
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 4;
      ["direction"] = -1;
      ["connectionIndex"] = 2;
      ["y"] = -465.9;
      ["x"] = 570.1;
    };
    [3] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 5;
      ["direction"] = -1;
      ["connectionIndex"] = 3;
      ["y"] = -104.2;
      ["x"] = 605.8;
    };
    [4] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 1;
      ["direction"] = -2;
      ["connectionIndex"] = 4;
      ["y"] = -123.6;
      ["x"] = 225.3;
    };
  };
  [3] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 5;
      ["direction"] = -1;
      ["connectionIndex"] = 1;
      ["y"] = -451.5;
      ["x"] = 231.9;
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 4;
      ["direction"] = 2;
      ["connectionIndex"] = 2;
      ["y"] = -405;
      ["x"] = 591.3;
    };
    [3] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 1;
      ["direction"] = 1;
      ["connectionIndex"] = 3;
      ["y"] = -93.7;
      ["x"] = 279.7;
    };
    [4] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 5;
      ["direction"] = -1;
      ["connectionIndex"] = 4;
      ["y"] = -119.7;
      ["x"] = 563;
    };
  };
  [4] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 2;
      ["direction"] = 1;
      ["connectionIndex"] = 1;
      ["y"] = -94;
      ["x"] = 557.3;
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 3;
      ["direction"] = -2;
      ["connectionIndex"] = 2;
      ["y"] = -404.9;
      ["x"] = 245.4;
    };
    [3] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 5;
      ["direction"] = -1;
      ["connectionIndex"] = 3;
      ["y"] = -166.2;
      ["x"] = 660.4;
    };
    [4] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 5;
      ["direction"] = -1;
      ["connectionIndex"] = 4;
      ["y"] = -123;
      ["x"] = 274.9;
    };
  };
  [5] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 2;
      ["direction"] = 2;
      ["connectionIndex"] = 1;
      ["y"] = -261;
      ["x"] = 463.4;
    };
    [2] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 1;
      ["direction"] = -2;
      ["connectionIndex"] = 2;
      ["y"] = -261.7;
      ["x"] = 432.5;
    };
    [3] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 3;
      ["direction"] = -2;
      ["connectionIndex"] = 3;
      ["y"] = -292.9;
      ["x"] = 431.6;
    };
    [4] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 4;
      ["direction"] = 2;
      ["connectionIndex"] = 4;
      ["y"] = -292.9;
      ["x"] = 463.7;
    };
    [5] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 6;
      ["direction"] = 1;
      ["connectionIndex"] = 5;
      ["y"] = -277.2;
      ["x"] = 446.9;
    };
  };
  [6] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate";
      ["type"] = "mapLink";
      ["target"] = 5;
      ["direction"] = -1;
      ["connectionIndex"] = 1;
      ["y"] = -406.5;
      ["x"] = 621.7;
    };
  };
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Patchwork Golem";
    ["id"] = 16017;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 9760;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -410.1;
        ["x"] = 560.5;
        ["g"] = 1;
      };
      [2] = {
        ["sublevel"] = 1;
        ["y"] = -417.5;
        ["x"] = 550.6;
        ["g"] = 1;
      };
      [3] = {
        ["sublevel"] = 1;
        ["y"] = -427.2;
        ["x"] = 552.1;
        ["g"] = 1;
      };
      [4] = {
        ["sublevel"] = 1;
        ["y"] = -412.5;
        ["x"] = 569.1;
        ["g"] = 1;
      };
      [5] = {
        ["sublevel"] = 1;
        ["y"] = -409.7;
        ["x"] = 504.6;
        ["g"] = 2;
      };
      [6] = {
        ["sublevel"] = 1;
        ["y"] = -393.2;
        ["x"] = 488.2;
        ["g"] = 2;
      };
      [7] = {
        ["sublevel"] = 1;
        ["y"] = -347.3;
        ["x"] = 532.4;
        ["g"] = 3;
      };
      [8] = {
        ["sublevel"] = 1;
        ["y"] = -364.7;
        ["x"] = 550.8;
        ["g"] = 3;
      };
      [9] = {
        ["sublevel"] = 1;
        ["y"] = -362.8;
        ["x"] = 481.1;
        ["g"] = 4;
      };
      [10] = {
        ["sublevel"] = 1;
        ["y"] = -352.8;
        ["x"] = 484.7;
        ["g"] = 4;
      };
      [11] = {
        ["sublevel"] = 1;
        ["y"] = -344.9;
        ["x"] = 494;
        ["g"] = 4;
      };
      [12] = {
        ["sublevel"] = 1;
        ["y"] = -342.7;
        ["x"] = 504.4;
        ["g"] = 4;
      };
      [13] = {
        ["sublevel"] = 1;
        ["y"] = -451.4;
        ["x"] = 416.4;
        ["g"] = 5;
      };
      [14] = {
        ["sublevel"] = 1;
        ["y"] = -451.4;
        ["x"] = 411;
        ["g"] = 5;
      };
      [15] = {
        ["sublevel"] = 1;
        ["y"] = -455.7;
        ["x"] = 411.2;
        ["g"] = 5;
      };
      [16] = {
        ["sublevel"] = 1;
        ["y"] = -455.6;
        ["x"] = 416.2;
        ["g"] = 5;
      };
    };
  };
  [2] = {
    ["name"] = "Embalming Slime";
    ["id"] = 16024;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 12349;
    ["creatureType"] = "Aberration";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -377.1;
        ["x"] = 437.9;
        ["g"] = 6;
      };
      [2] = {
        ["sublevel"] = 1;
        ["y"] = -362;
        ["x"] = 437.8;
        ["g"] = 6;
      };
      [3] = {
        ["sublevel"] = 1;
        ["y"] = -366;
        ["x"] = 434.4;
        ["g"] = 6;
      };
      [4] = {
        ["sublevel"] = 1;
        ["y"] = -369.8;
        ["x"] = 430.4;
        ["g"] = 6;
      };
      [5] = {
        ["sublevel"] = 1;
        ["y"] = -373.3;
        ["x"] = 434;
        ["g"] = 6;
      };
      [6] = {
        ["sublevel"] = 1;
        ["y"] = -373.4;
        ["x"] = 437.8;
        ["g"] = 6;
      };
      [7] = {
        ["sublevel"] = 1;
        ["y"] = -373.3;
        ["x"] = 445.5;
        ["g"] = 6;
      };
      [8] = {
        ["sublevel"] = 1;
        ["y"] = -369.8;
        ["x"] = 441.9;
        ["g"] = 6;
      };
      [9] = {
        ["sublevel"] = 1;
        ["y"] = -366;
        ["x"] = 445.9;
        ["g"] = 6;
      };
      [10] = {
        ["sublevel"] = 1;
        ["y"] = -366;
        ["x"] = 438.2;
        ["g"] = 6;
      };
      [11] = {
        ["sublevel"] = 1;
        ["y"] = -362;
        ["x"] = 433.9;
        ["g"] = 6;
      };
      [12] = {
        ["sublevel"] = 1;
        ["y"] = -366;
        ["x"] = 430.5;
        ["g"] = 6;
      };
      [13] = {
        ["sublevel"] = 1;
        ["y"] = -373.3;
        ["x"] = 430.2;
        ["g"] = 6;
      };
      [14] = {
        ["sublevel"] = 1;
        ["y"] = -369.9;
        ["x"] = 434.3;
        ["g"] = 6;
      };
      [15] = {
        ["sublevel"] = 1;
        ["y"] = -377.1;
        ["x"] = 433.9;
        ["g"] = 6;
      };
      [16] = {
        ["sublevel"] = 1;
        ["y"] = -377.1;
        ["x"] = 441.6;
        ["g"] = 6;
      };
      [17] = {
        ["sublevel"] = 1;
        ["y"] = -373.4;
        ["x"] = 441.6;
        ["g"] = 6;
      };
      [18] = {
        ["sublevel"] = 1;
        ["y"] = -369.8;
        ["x"] = 445.7;
        ["g"] = 6;
      };
      [19] = {
        ["sublevel"] = 1;
        ["y"] = -366;
        ["x"] = 442.1;
        ["g"] = 6;
      };
      [20] = {
        ["sublevel"] = 1;
        ["y"] = -362;
        ["x"] = 441.6;
        ["g"] = 6;
      };
    };
  };
  [3] = {
    ["name"] = "Bile Retcher";
    ["id"] = 16018;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 15958;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -400.2;
        ["x"] = 496.2;
        ["g"] = 2;
      };
      [2] = {
        ["sublevel"] = 1;
        ["y"] = -390.4;
        ["x"] = 534.3;
        ["patrol"] = {
          [1] = {
            ["y"] = -385.4;
            ["x"] = 538.5;
          };
          [2] = {
            ["y"] = -375.4;
            ["x"] = 549;
          };
          [3] = {
            ["y"] = -349.3;
            ["x"] = 522.9;
          };
          [4] = {
            ["y"] = -376.4;
            ["x"] = 494.3;
          };
          [5] = {
            ["y"] = -403.5;
            ["x"] = 520.6;
          };
          [6] = {
            ["y"] = -390.2;
            ["x"] = 533.3;
          };
          [7] = {
            ["y"] = -408.7;
            ["x"] = 551.4;
          };
        };
      };
      [3] = {
        ["sublevel"] = 1;
        ["y"] = -365;
        ["x"] = 412.5;
        ["patrol"] = {
          [1] = {
            ["y"] = -363.2;
            ["x"] = 461.7;
          };
          [2] = {
            ["y"] = -354.7;
            ["x"] = 457.9;
          };
          [3] = {
            ["y"] = -349.3;
            ["x"] = 454.4;
          };
          [4] = {
            ["y"] = -343.7;
            ["x"] = 443.2;
          };
          [5] = {
            ["y"] = -345.3;
            ["x"] = 426.2;
          };
          [6] = {
            ["y"] = -349;
            ["x"] = 419.9;
          };
          [7] = {
            ["y"] = -355;
            ["x"] = 414.3;
          };
          [8] = {
            ["y"] = -361.3;
            ["x"] = 412.4;
          };
          [9] = {
            ["y"] = -371.9;
            ["x"] = 411.5;
          };
          [10] = {
            ["y"] = -381.7;
            ["x"] = 412.4;
          };
          [11] = {
            ["y"] = -387;
            ["x"] = 417.1;
          };
          [12] = {
            ["y"] = -392.2;
            ["x"] = 421.8;
          };
          [13] = {
            ["y"] = -392.9;
            ["x"] = 424;
          };
          [14] = {
            ["y"] = -393.6;
            ["x"] = 426.2;
          };
          [15] = {
            ["y"] = -394.8;
            ["x"] = 432.8;
          };
          [16] = {
            ["y"] = -394.2;
            ["x"] = 433.7;
          };
        };
      };
      [4] = {
        ["sublevel"] = 1;
        ["y"] = -419.5;
        ["x"] = 448.6;
        ["patrol"] = {
          [1] = {
            ["y"] = -419.6;
            ["x"] = 449;
          };
          [2] = {
            ["y"] = -395.5;
            ["x"] = 441.4;
          };
          [3] = {
            ["y"] = -393.9;
            ["x"] = 448.6;
          };
          [4] = {
            ["y"] = -390.4;
            ["x"] = 454;
          };
          [5] = {
            ["y"] = -386.1;
            ["x"] = 458.1;
          };
          [6] = {
            ["y"] = -379.8;
            ["x"] = 461.5;
          };
          [7] = {
            ["y"] = -373.8;
            ["x"] = 462.5;
          };
          [8] = {
            ["y"] = -370.7;
            ["x"] = 462.5;
          };
          [9] = {
            ["y"] = -370.7;
            ["x"] = 480;
          };
          [10] = {
            ["y"] = -370.2;
            ["x"] = 486.3;
          };
          [11] = {
            ["y"] = -343.5;
            ["x"] = 513.9;
          };
          [12] = {
            ["y"] = -343.2;
            ["x"] = 522.5;
          };
        };
      };
      [5] = {
        ["sublevel"] = 1;
        ["y"] = -449;
        ["x"] = 436;
        ["patrol"] = {
          [1] = {
            ["y"] = -449.6;
            ["x"] = 434.3;
          };
          [2] = {
            ["y"] = -450.3;
            ["x"] = 426.9;
          };
          [3] = {
            ["y"] = -478.2;
            ["x"] = 426.9;
          };
          [4] = {
            ["y"] = -478.4;
            ["x"] = 440.4;
          };
          [5] = {
            ["y"] = -459.1;
            ["x"] = 451.3;
          };
          [6] = {
            ["y"] = -449;
            ["x"] = 450.8;
          };
          [7] = {
            ["y"] = -449;
            ["x"] = 445.1;
          };
          [8] = {
            ["y"] = -449.8;
            ["x"] = 434.2;
          };
        };
      };
      [6] = {
        ["sublevel"] = 1;
        ["y"] = -455.7;
        ["x"] = 362.6;
        ["patrol"] = {
          [1] = {
            ["y"] = -455;
            ["x"] = 363.5;
          };
          [2] = {
            ["y"] = -446.3;
            ["x"] = 367.4;
          };
          [3] = {
            ["y"] = -441.1;
            ["x"] = 372.5;
          };
          [4] = {
            ["y"] = -439.2;
            ["x"] = 379.1;
          };
          [5] = {
            ["y"] = -438.4;
            ["x"] = 387;
          };
          [6] = {
            ["y"] = -440.8;
            ["x"] = 394.4;
          };
          [7] = {
            ["y"] = -446.6;
            ["x"] = 398.8;
          };
          [8] = {
            ["y"] = -452.3;
            ["x"] = 399.9;
          };
          [9] = {
            ["y"] = -462.7;
            ["x"] = 399.6;
          };
          [10] = {
            ["y"] = -469.8;
            ["x"] = 397.1;
          };
          [11] = {
            ["y"] = -472;
            ["x"] = 394.7;
          };
        };
      };
      [7] = {
        ["sublevel"] = 1;
        ["y"] = -413.2;
        ["x"] = 328.6;
        ["patrol"] = {
          [1] = {
            ["y"] = -413.4;
            ["x"] = 328.8;
          };
          [2] = {
            ["y"] = -412.3;
            ["x"] = 335.7;
          };
          [3] = {
            ["y"] = -409.8;
            ["x"] = 343;
          };
          [4] = {
            ["y"] = -404.9;
            ["x"] = 349.9;
          };
          [5] = {
            ["y"] = -398.6;
            ["x"] = 352.6;
          };
          [6] = {
            ["y"] = -389.3;
            ["x"] = 353.4;
          };
          [7] = {
            ["y"] = -381.7;
            ["x"] = 351.5;
          };
          [8] = {
            ["y"] = -377.9;
            ["x"] = 348.2;
          };
          [9] = {
            ["y"] = -375.1;
            ["x"] = 341.1;
          };
        };
      };
      [8] = {
        ["sublevel"] = 1;
        ["y"] = -355;
        ["x"] = 541.5;
        ["g"] = 3;
      };
    };
  };
  [4] = {
    ["name"] = "Sludge Belcher";
    ["id"] = 16029;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 15962;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -421.8;
        ["x"] = 395;
        ["patrol"] = {
          [1] = {
            ["y"] = -374.7;
            ["x"] = 367.8;
          };
          [2] = {
            ["y"] = -383.5;
            ["x"] = 369;
          };
          [3] = {
            ["y"] = -393;
            ["x"] = 371.2;
          };
          [4] = {
            ["y"] = -401.8;
            ["x"] = 375.5;
          };
          [5] = {
            ["y"] = -409.6;
            ["x"] = 381.7;
          };
          [6] = {
            ["y"] = -416.8;
            ["x"] = 387.7;
          };
          [7] = {
            ["y"] = -423.6;
            ["x"] = 396;
          };
          [8] = {
            ["y"] = -428.9;
            ["x"] = 403.7;
          };
          [9] = {
            ["y"] = -433;
            ["x"] = 411.5;
          };
          [10] = {
            ["y"] = -436.3;
            ["x"] = 422.4;
          };
          [11] = {
            ["y"] = -437.9;
            ["x"] = 435.2;
          };
          [12] = {
            ["y"] = -436.7;
            ["x"] = 452;
          };
        };
      };
      [2] = {
        ["sublevel"] = 1;
        ["y"] = -419.2;
        ["x"] = 374.8;
        ["patrol"] = {
          [1] = {
            ["y"] = -375.6;
            ["x"] = 355.3;
          };
          [2] = {
            ["y"] = -382.8;
            ["x"] = 355.7;
          };
          [3] = {
            ["y"] = -389.6;
            ["x"] = 357.6;
          };
          [4] = {
            ["y"] = -396.9;
            ["x"] = 360.3;
          };
          [5] = {
            ["y"] = -405.9;
            ["x"] = 365.2;
          };
          [6] = {
            ["y"] = -413;
            ["x"] = 370.3;
          };
          [7] = {
            ["y"] = -420.1;
            ["x"] = 375.6;
          };
          [8] = {
            ["y"] = -427;
            ["x"] = 383.2;
          };
          [9] = {
            ["y"] = -433.4;
            ["x"] = 392.2;
          };
          [10] = {
            ["y"] = -439.4;
            ["x"] = 401.5;
          };
          [11] = {
            ["y"] = -446.1;
            ["x"] = 402.3;
          };
          [12] = {
            ["y"] = -463.9;
            ["x"] = 403.5;
          };
          [13] = {
            ["y"] = -472.4;
            ["x"] = 403.9;
          };
          [14] = {
            ["y"] = -474.3;
            ["x"] = 418.6;
          };
        };
      };
      [3] = {
        ["sublevel"] = 1;
        ["y"] = -423;
        ["x"] = 334.8;
        ["patrol"] = {
          [1] = {
            ["y"] = -421.3;
            ["x"] = 335.9;
          };
          [2] = {
            ["y"] = -416.7;
            ["x"] = 344.7;
          };
          [3] = {
            ["y"] = -416.7;
            ["x"] = 350.7;
          };
          [4] = {
            ["y"] = -418.6;
            ["x"] = 357.8;
          };
          [5] = {
            ["y"] = -422.9;
            ["x"] = 361.9;
          };
          [6] = {
            ["y"] = -429.2;
            ["x"] = 363.8;
          };
          [7] = {
            ["y"] = -434.8;
            ["x"] = 362.7;
          };
          [8] = {
            ["y"] = -439.5;
            ["x"] = 360.8;
          };
          [9] = {
            ["y"] = -443.8;
            ["x"] = 357.2;
          };
          [10] = {
            ["y"] = -445.7;
            ["x"] = 352.9;
          };
        };
      };
    };
  };
  [5] = {
    ["name"] = "Mad Scientist";
    ["id"] = 16020;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16063;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -469;
        ["x"] = 465.8;
        ["g"] = 7;
      };
      [2] = {
        ["sublevel"] = 1;
        ["y"] = -464.2;
        ["x"] = 458.4;
        ["g"] = 7;
      };
      [3] = {
        ["sublevel"] = 1;
        ["y"] = -469.4;
        ["x"] = 450.5;
        ["g"] = 7;
      };
      [4] = {
        ["sublevel"] = 1;
        ["y"] = -476.9;
        ["x"] = 454.1;
        ["g"] = 7;
      };
      [5] = {
        ["sublevel"] = 1;
        ["y"] = -459.7;
        ["x"] = 393.7;
        ["g"] = 8;
      };
      [6] = {
        ["sublevel"] = 1;
        ["y"] = -451.5;
        ["x"] = 392.7;
        ["g"] = 8;
      };
      [7] = {
        ["sublevel"] = 1;
        ["y"] = -445.5;
        ["x"] = 386.9;
        ["g"] = 8;
      };
      [8] = {
        ["sublevel"] = 1;
        ["y"] = -445.4;
        ["x"] = 378.2;
        ["g"] = 8;
      };
      [9] = {
        ["sublevel"] = 1;
        ["y"] = -403.9;
        ["x"] = 335;
        ["g"] = 9;
      };
      [10] = {
        ["sublevel"] = 1;
        ["y"] = -402.3;
        ["x"] = 343.3;
        ["g"] = 9;
      };
      [11] = {
        ["sublevel"] = 1;
        ["y"] = -394.9;
        ["x"] = 347.6;
        ["g"] = 9;
      };
      [12] = {
        ["sublevel"] = 1;
        ["y"] = -388;
        ["x"] = 347.4;
        ["g"] = 9;
      };
    };
  };
  [6] = {
    ["name"] = "Surgical Assistant";
    ["id"] = 16022;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 836;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -473.5;
        ["x"] = 468.2;
        ["g"] = 7;
      };
      [2] = {
        ["sublevel"] = 1;
        ["y"] = -464.9;
        ["x"] = 462.8;
        ["g"] = 7;
      };
      [3] = {
        ["sublevel"] = 1;
        ["y"] = -465.1;
        ["x"] = 454;
        ["g"] = 7;
      };
      [4] = {
        ["sublevel"] = 1;
        ["y"] = -473.5;
        ["x"] = 450.6;
        ["g"] = 7;
      };
      [5] = {
        ["sublevel"] = 1;
        ["y"] = -478.9;
        ["x"] = 458.4;
        ["g"] = 7;
      };
      [6] = {
        ["sublevel"] = 1;
        ["y"] = -463.7;
        ["x"] = 393.5;
        ["g"] = 8;
      };
      [7] = {
        ["sublevel"] = 1;
        ["y"] = -455.7;
        ["x"] = 393.4;
        ["g"] = 8;
      };
      [8] = {
        ["sublevel"] = 1;
        ["y"] = -447.4;
        ["x"] = 390.9;
        ["g"] = 8;
      };
      [9] = {
        ["sublevel"] = 1;
        ["y"] = -445;
        ["x"] = 382.3;
        ["g"] = 8;
      };
      [10] = {
        ["sublevel"] = 1;
        ["y"] = -446.8;
        ["x"] = 373.9;
        ["g"] = 8;
      };
      [11] = {
        ["sublevel"] = 1;
        ["y"] = -403.2;
        ["x"] = 331.2;
        ["g"] = 9;
      };
      [12] = {
        ["sublevel"] = 1;
        ["y"] = -403.5;
        ["x"] = 338.9;
        ["g"] = 9;
      };
      [13] = {
        ["sublevel"] = 1;
        ["y"] = -399;
        ["x"] = 347;
        ["g"] = 9;
      };
      [14] = {
        ["sublevel"] = 1;
        ["y"] = -391.5;
        ["x"] = 348;
        ["g"] = 9;
      };
      [15] = {
        ["sublevel"] = 1;
        ["y"] = -384.4;
        ["x"] = 346.7;
        ["g"] = 9;
      };
    };
  };
  [7] = {
    ["name"] = "Living Monstrosity";
    ["id"] = 16021;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16175;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -472.4;
        ["x"] = 459;
        ["g"] = 7;
      };
      [2] = {
        ["sublevel"] = 1;
        ["y"] = -451.3;
        ["x"] = 386.2;
        ["g"] = 8;
      };
      [3] = {
        ["sublevel"] = 1;
        ["y"] = -396.7;
        ["x"] = 341.7;
        ["g"] = 9;
      };
    };
  };
  [8] = {
    ["name"] = "Stitched Giant";
    ["id"] = 16025;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 24484;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -227.1;
        ["x"] = 503;
        ["g"] = 10;
      };
      [2] = {
        ["sublevel"] = 1;
        ["y"] = -226.4;
        ["x"] = 524.3;
        ["g"] = 10;
      };
      [3] = {
        ["sublevel"] = 1;
        ["y"] = -245.7;
        ["x"] = 548.3;
        ["g"] = 11;
      };
      [4] = {
        ["sublevel"] = 1;
        ["y"] = -264.7;
        ["x"] = 548.3;
        ["g"] = 11;
      };
      [5] = {
        ["sublevel"] = 1;
        ["y"] = -315.2;
        ["x"] = 509.8;
        ["g"] = 12;
      };
      [6] = {
        ["sublevel"] = 1;
        ["y"] = -315.2;
        ["x"] = 494.9;
        ["g"] = 12;
      };
      [7] = {
        ["sublevel"] = 1;
        ["y"] = -315.2;
        ["x"] = 524.7;
        ["g"] = 12;
      };
    };
  };
  [9] = {
    ["name"] = "Stitched Colossus";
    ["id"] = 30071;
    ["count"] = 0;
    ["health"] = 674050;
    ["scale"] = 1;
    ["displayId"] = 26746;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -156.2;
        ["x"] = 297.4;
      };
      [2] = {
        ["sublevel"] = 1;
        ["y"] = -117.5;
        ["x"] = 363.8;
        ["patrol"] = {
          [1] = {
            ["y"] = -117.2;
            ["x"] = 364.8;
          };
          [2] = {
            ["y"] = -206.6;
            ["x"] = 274;
          };
          [3] = {
            ["y"] = -206.6;
            ["x"] = 259.2;
          };
          [4] = {
            ["y"] = -215.6;
            ["x"] = 245;
          };
          [5] = {
            ["y"] = -232.7;
            ["x"] = 239.3;
          };
          [6] = {
            ["y"] = -250.3;
            ["x"] = 243.5;
          };
          [7] = {
            ["y"] = -259.4;
            ["x"] = 257.3;
          };
          [8] = {
            ["y"] = -259.4;
            ["x"] = 279.2;
          };
          [9] = {
            ["y"] = -243.7;
            ["x"] = 295.8;
          };
          [10] = {
            ["y"] = -228.9;
            ["x"] = 296.3;
          };
          [11] = {
            ["y"] = -216.1;
            ["x"] = 292;
          };
          [12] = {
            ["y"] = -207.5;
            ["x"] = 276.8;
          };
        };
      };
      [3] = {
        ["sublevel"] = 1;
        ["y"] = -232.5;
        ["x"] = 279.9;
        ["patrol"] = {
          [1] = {
            ["y"] = -235.8;
            ["x"] = 279.4;
          };
          [2] = {
            ["y"] = -147.4;
            ["x"] = 360.8;
          };
          [3] = {
            ["y"] = -150.7;
            ["x"] = 371.2;
          };
          [4] = {
            ["y"] = -150.7;
            ["x"] = 381.2;
          };
          [5] = {
            ["y"] = -145.5;
            ["x"] = 392.1;
          };
          [6] = {
            ["y"] = -134.1;
            ["x"] = 400.2;
          };
          [7] = {
            ["y"] = -127;
            ["x"] = 402.1;
          };
          [8] = {
            ["y"] = -117.4;
            ["x"] = 402.1;
          };
          [9] = {
            ["y"] = -105.1;
            ["x"] = 396.9;
          };
          [10] = {
            ["y"] = -96.1;
            ["x"] = 383.6;
          };
          [11] = {
            ["y"] = -97.5;
            ["x"] = 362.7;
          };
          [12] = {
            ["y"] = -112.2;
            ["x"] = 348.9;
          };
          [13] = {
            ["y"] = -127.9;
            ["x"] = 347;
          };
          [14] = {
            ["y"] = -139.3;
            ["x"] = 350.8;
          };
          [15] = {
            ["y"] = -146;
            ["x"] = 357.9;
          };
        };
      };
      [4] = {
        ["sublevel"] = 1;
        ["y"] = -124.7;
        ["x"] = 536.6;
      };
      [5] = {
        ["sublevel"] = 1;
        ["y"] = -119.5;
        ["x"] = 419.7;
        ["patrol"] = {
          [1] = {
            ["y"] = -125.8;
            ["x"] = 511.8;
          };
          [2] = {
            ["y"] = -135.3;
            ["x"] = 513.7;
          };
          [3] = {
            ["y"] = -142.7;
            ["x"] = 516.3;
          };
          [4] = {
            ["y"] = -147.6;
            ["x"] = 524.2;
          };
          [5] = {
            ["y"] = -151;
            ["x"] = 531.3;
          };
          [6] = {
            ["y"] = -150;
            ["x"] = 549.6;
          };
          [7] = {
            ["y"] = -140;
            ["x"] = 559.4;
          };
          [8] = {
            ["y"] = -129.6;
            ["x"] = 563.2;
          };
          [9] = {
            ["y"] = -115.1;
            ["x"] = 562.2;
          };
          [10] = {
            ["y"] = -106.8;
            ["x"] = 558.6;
          };
          [11] = {
            ["y"] = -99.4;
            ["x"] = 547.5;
          };
          [12] = {
            ["y"] = -98;
            ["x"] = 533;
          };
          [13] = {
            ["y"] = -100.8;
            ["x"] = 521.1;
          };
          [14] = {
            ["y"] = -108.9;
            ["x"] = 513.2;
          };
          [15] = {
            ["y"] = -119.4;
            ["x"] = 511.5;
          };
          [16] = {
            ["y"] = -120.5;
            ["x"] = 420;
          };
        };
      };
      [6] = {
        ["sublevel"] = 1;
        ["y"] = -394.7;
        ["x"] = 264.5;
      };
      [7] = {
        ["sublevel"] = 1;
        ["y"] = -279.3;
        ["x"] = 270.1;
        ["patrol"] = {
          [1] = {
            ["y"] = -367.9;
            ["x"] = 262.4;
          };
          [2] = {
            ["y"] = -369.3;
            ["x"] = 253.8;
          };
          [3] = {
            ["y"] = -374.8;
            ["x"] = 243.6;
          };
          [4] = {
            ["y"] = -384.1;
            ["x"] = 238.8;
          };
          [5] = {
            ["y"] = -394.3;
            ["x"] = 237.2;
          };
          [6] = {
            ["y"] = -403.1;
            ["x"] = 238.1;
          };
          [7] = {
            ["y"] = -412.6;
            ["x"] = 243.1;
          };
          [8] = {
            ["y"] = -418.3;
            ["x"] = 251;
          };
          [9] = {
            ["y"] = -420.7;
            ["x"] = 259.3;
          };
          [10] = {
            ["y"] = -420.2;
            ["x"] = 271.2;
          };
          [11] = {
            ["y"] = -417.1;
            ["x"] = 280.4;
          };
          [12] = {
            ["y"] = -411.2;
            ["x"] = 285.2;
          };
          [13] = {
            ["y"] = -403.1;
            ["x"] = 288.5;
          };
          [14] = {
            ["y"] = -392.9;
            ["x"] = 290.4;
          };
          [15] = {
            ["y"] = -384.3;
            ["x"] = 289.2;
          };
          [16] = {
            ["y"] = -375.5;
            ["x"] = 285.4;
          };
          [17] = {
            ["y"] = -368.6;
            ["x"] = 274.5;
          };
          [18] = {
            ["y"] = -366.9;
            ["x"] = 267.4;
          };
          [19] = {
            ["y"] = -279.9;
            ["x"] = 269.3;
          };
        };
      };
    };
  };
  [10] = {
    ["name"] = "Marauding Geist";
    ["id"] = 30083;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 25627;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -180.2;
        ["x"] = 320.5;
        ["g"] = 13;
        ["patrol"] = {
          [1] = {
            ["y"] = -216.9;
            ["x"] = 281.7;
          };
          [2] = {
            ["y"] = -212.5;
            ["x"] = 273.3;
          };
          [3] = {
            ["y"] = -213.3;
            ["x"] = 263.2;
          };
          [4] = {
            ["y"] = -216.6;
            ["x"] = 254.7;
          };
          [5] = {
            ["y"] = -224.2;
            ["x"] = 248.4;
          };
          [6] = {
            ["y"] = -234.1;
            ["x"] = 246.2;
          };
          [7] = {
            ["y"] = -243.9;
            ["x"] = 248.1;
          };
          [8] = {
            ["y"] = -251;
            ["x"] = 253.9;
          };
          [9] = {
            ["y"] = -256.7;
            ["x"] = 264.3;
          };
          [10] = {
            ["y"] = -255.6;
            ["x"] = 275.1;
          };
          [11] = {
            ["y"] = -251.3;
            ["x"] = 283.6;
          };
          [12] = {
            ["y"] = -242;
            ["x"] = 288.3;
          };
          [13] = {
            ["y"] = -231.3;
            ["x"] = 289.9;
          };
          [14] = {
            ["y"] = -221.8;
            ["x"] = 285.8;
          };
          [15] = {
            ["y"] = -218.2;
            ["x"] = 283.4;
          };
          [16] = {
            ["y"] = -139.9;
            ["x"] = 359.3;
          };
          [17] = {
            ["y"] = -143.4;
            ["x"] = 363;
          };
          [18] = {
            ["y"] = -145.8;
            ["x"] = 376.6;
          };
          [19] = {
            ["y"] = -141.2;
            ["x"] = 387.8;
          };
          [20] = {
            ["y"] = -133.8;
            ["x"] = 393.8;
          };
          [21] = {
            ["y"] = -124.3;
            ["x"] = 396.6;
          };
          [22] = {
            ["y"] = -113.9;
            ["x"] = 395.5;
          };
          [23] = {
            ["y"] = -109.7;
            ["x"] = 392.5;
          };
          [24] = {
            ["y"] = -106.4;
            ["x"] = 388.4;
          };
          [25] = {
            ["y"] = -103.5;
            ["x"] = 382.4;
          };
          [26] = {
            ["y"] = -102.7;
            ["x"] = 376.9;
          };
          [27] = {
            ["y"] = -103.7;
            ["x"] = 370.6;
          };
          [28] = {
            ["y"] = -105.7;
            ["x"] = 364.9;
          };
          [29] = {
            ["y"] = -108.7;
            ["x"] = 360.3;
          };
          [30] = {
            ["y"] = -113.9;
            ["x"] = 356.2;
          };
          [31] = {
            ["y"] = -118.3;
            ["x"] = 355.1;
          };
          [32] = {
            ["y"] = -122.6;
            ["x"] = 354;
          };
          [33] = {
            ["y"] = -128;
            ["x"] = 353.8;
          };
          [34] = {
            ["y"] = -133.3;
            ["x"] = 355.9;
          };
          [35] = {
            ["y"] = -137.8;
            ["x"] = 357.8;
          };
        };
      };
      [2] = {
        ["sublevel"] = 1;
        ["y"] = -176.2;
        ["x"] = 316.9;
        ["g"] = 13;
      };
      [3] = {
        ["sublevel"] = 1;
        ["y"] = -184;
        ["x"] = 324.3;
        ["g"] = 13;
      };
      [4] = {
        ["sublevel"] = 1;
        ["y"] = -180.1;
        ["x"] = 313.1;
        ["g"] = 13;
      };
      [5] = {
        ["sublevel"] = 1;
        ["y"] = -183.7;
        ["x"] = 316.8;
        ["g"] = 13;
      };
      [6] = {
        ["sublevel"] = 1;
        ["y"] = -187.6;
        ["x"] = 320.7;
        ["g"] = 13;
      };
      [7] = {
        ["sublevel"] = 1;
        ["y"] = -172.5;
        ["x"] = 320.6;
        ["g"] = 13;
      };
      [8] = {
        ["sublevel"] = 1;
        ["y"] = -176.4;
        ["x"] = 324.3;
        ["g"] = 13;
      };
      [9] = {
        ["sublevel"] = 1;
        ["y"] = -180.5;
        ["x"] = 328;
        ["g"] = 13;
      };
      [10] = {
        ["sublevel"] = 1;
        ["y"] = -172.7;
        ["x"] = 328.1;
        ["g"] = 13;
      };
      [11] = {
        ["sublevel"] = 1;
        ["y"] = -116.9;
        ["x"] = 470.5;
        ["g"] = 14;
        ["patrol"] = {
          [1] = {
            ["y"] = -122.3;
            ["x"] = 513.3;
          };
          [2] = {
            ["y"] = -110.1;
            ["x"] = 515;
          };
          [3] = {
            ["y"] = -103.6;
            ["x"] = 524.3;
          };
          [4] = {
            ["y"] = -101.7;
            ["x"] = 533.8;
          };
          [5] = {
            ["y"] = -102.5;
            ["x"] = 546.4;
          };
          [6] = {
            ["y"] = -108.3;
            ["x"] = 553.5;
          };
          [7] = {
            ["y"] = -117.8;
            ["x"] = 558.1;
          };
          [8] = {
            ["y"] = -128.5;
            ["x"] = 557.9;
          };
          [9] = {
            ["y"] = -139.1;
            ["x"] = 553.2;
          };
          [10] = {
            ["y"] = -145.4;
            ["x"] = 542.3;
          };
          [11] = {
            ["y"] = -145.7;
            ["x"] = 527;
          };
          [12] = {
            ["y"] = -138.8;
            ["x"] = 518.3;
          };
          [13] = {
            ["y"] = -129;
            ["x"] = 513.3;
          };
          [14] = {
            ["y"] = -122.5;
            ["x"] = 513.3;
          };
          [15] = {
            ["y"] = -124.4;
            ["x"] = 396.4;
          };
        };
      };
      [12] = {
        ["sublevel"] = 1;
        ["y"] = -123.1;
        ["x"] = 470.5;
        ["g"] = 14;
      };
      [13] = {
        ["sublevel"] = 1;
        ["y"] = -129.7;
        ["x"] = 470.5;
        ["g"] = 14;
      };
      [14] = {
        ["sublevel"] = 1;
        ["y"] = -116.9;
        ["x"] = 463.9;
        ["g"] = 14;
      };
      [15] = {
        ["sublevel"] = 1;
        ["y"] = -123.1;
        ["x"] = 464.2;
        ["g"] = 14;
      };
      [16] = {
        ["sublevel"] = 1;
        ["y"] = -129.7;
        ["x"] = 464.2;
        ["g"] = 14;
      };
      [17] = {
        ["sublevel"] = 1;
        ["y"] = -117.5;
        ["x"] = 457.3;
        ["g"] = 14;
      };
      [18] = {
        ["sublevel"] = 1;
        ["y"] = -123.1;
        ["x"] = 457.3;
        ["g"] = 14;
      };
      [19] = {
        ["sublevel"] = 1;
        ["y"] = -129.7;
        ["x"] = 457.3;
        ["g"] = 14;
      };
      [20] = {
        ["sublevel"] = 1;
        ["y"] = -123.1;
        ["x"] = 450.7;
        ["g"] = 14;
      };
      [21] = {
        ["sublevel"] = 1;
        ["y"] = -315.7;
        ["x"] = 265.1;
        ["g"] = 15;
        ["patrol"] = {
          [1] = {
            ["y"] = -256.3;
            ["x"] = 265.8;
          };
          [2] = {
            ["y"] = -370.9;
            ["x"] = 264.4;
          };
          [3] = {
            ["y"] = -374.3;
            ["x"] = 251.6;
          };
          [4] = {
            ["y"] = -381.9;
            ["x"] = 244.4;
          };
          [5] = {
            ["y"] = -395.2;
            ["x"] = 242;
          };
          [6] = {
            ["y"] = -406.1;
            ["x"] = 244;
          };
          [7] = {
            ["y"] = -415.6;
            ["x"] = 254.9;
          };
          [8] = {
            ["y"] = -416.1;
            ["x"] = 270.1;
          };
          [9] = {
            ["y"] = -409.9;
            ["x"] = 281.5;
          };
          [10] = {
            ["y"] = -399.9;
            ["x"] = 285.8;
          };
          [11] = {
            ["y"] = -388;
            ["x"] = 285.8;
          };
          [12] = {
            ["y"] = -377.1;
            ["x"] = 280.6;
          };
          [13] = {
            ["y"] = -371.4;
            ["x"] = 272.5;
          };
          [14] = {
            ["y"] = -370.9;
            ["x"] = 267.7;
          };
        };
      };
      [22] = {
        ["sublevel"] = 1;
        ["y"] = -312.3;
        ["x"] = 265.1;
        ["g"] = 15;
      };
      [23] = {
        ["sublevel"] = 1;
        ["y"] = -311.9;
        ["x"] = 268.7;
        ["g"] = 15;
      };
      [24] = {
        ["sublevel"] = 1;
        ["y"] = -311.9;
        ["x"] = 261.2;
        ["g"] = 15;
      };
      [25] = {
        ["sublevel"] = 1;
        ["y"] = -308.6;
        ["x"] = 265.1;
        ["g"] = 15;
      };
      [26] = {
        ["sublevel"] = 1;
        ["y"] = -305.2;
        ["x"] = 265.3;
        ["g"] = 15;
      };
      [27] = {
        ["sublevel"] = 1;
        ["y"] = -308.6;
        ["x"] = 269;
        ["g"] = 15;
      };
      [28] = {
        ["sublevel"] = 1;
        ["y"] = -308.5;
        ["x"] = 261.6;
        ["g"] = 15;
      };
      [29] = {
        ["sublevel"] = 1;
        ["y"] = -305.2;
        ["x"] = 261.6;
        ["g"] = 15;
      };
      [30] = {
        ["sublevel"] = 1;
        ["y"] = -305.2;
        ["x"] = 268.8;
        ["g"] = 15;
      };
    };
  };
  [11] = {
    ["name"] = "Patchwerk";
    ["id"] = 16028;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16174;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -235.6;
        ["x"] = 452.2;
        ["patrol"] = {
          [1] = {
            ["y"] = -235.7;
            ["x"] = 451.7;
          };
          [2] = {
            ["y"] = -268.1;
            ["x"] = 451;
          };
          [3] = {
            ["y"] = -284;
            ["x"] = 445.6;
          };
          [4] = {
            ["y"] = -331.6;
            ["x"] = 399.9;
          };
          [5] = {
            ["y"] = -353.2;
            ["x"] = 385.4;
          };
          [6] = {
            ["y"] = -371.9;
            ["x"] = 380.8;
          };
          [7] = {
            ["y"] = -395;
            ["x"] = 385.1;
          };
          [8] = {
            ["y"] = -402.6;
            ["x"] = 390.5;
          };
        };
      };
    };
  };
  [12] = {
    ["name"] = "Grobbulus";
    ["id"] = 15931;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16035;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -294.7;
        ["x"] = 517.1;
        ["patrol"] = {
          [1] = {
            ["y"] = -293.6;
            ["x"] = 517.4;
          };
          [2] = {
            ["y"] = -295.1;
            ["x"] = 571.6;
          };
          [3] = {
            ["y"] = -314.6;
            ["x"] = 572.1;
          };
          [4] = {
            ["y"] = -314.6;
            ["x"] = 536.4;
          };
          [5] = {
            ["y"] = -319.3;
            ["x"] = 509.3;
          };
          [6] = {
            ["y"] = -329.8;
            ["x"] = 509.8;
          };
        };
      };
    };
  };
  [13] = {
    ["name"] = "Gluth";
    ["id"] = 15932;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16064;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -247.2;
        ["x"] = 385.8;
      };
    };
  };
  [14] = {
    ["name"] = "Thaddius";
    ["id"] = 15928;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16137;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -83;
        ["x"] = 222.8;
      };
    };
  };
  [15] = {
    ["name"] = "Feugen";
    ["id"] = 15930;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 15297;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -85.9;
        ["x"] = 269.6;
      };
    };
  };
  [16] = {
    ["name"] = "Stalagg";
    ["id"] = 15929;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 15297;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 1;
        ["y"] = -128.6;
        ["x"] = 227.5;
      };
    };
  };
  [17] = {
    ["name"] = "Venom Stalker";
    ["id"] = 15976;
    ["count"] = 0;
    ["health"] = 390990;
    ["scale"] = 1;
    ["displayId"] = 75392;
    ["creatureType"] = "Beast";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 2;
        ["y"] = -433.2;
        ["x"] = 307.9;
        ["g"] = 16;
      };
      [2] = {
        ["sublevel"] = 2;
        ["y"] = -344.8;
        ["x"] = 301.3;
        ["g"] = 17;
      };
      [3] = {
        ["sublevel"] = 2;
        ["y"] = -320.6;
        ["x"] = 254.6;
        ["g"] = 18;
      };
      [4] = {
        ["sublevel"] = 2;
        ["y"] = -279.2;
        ["x"] = 447.7;
        ["g"] = 19;
        ["patrol"] = {
          [1] = {
            ["y"] = -301.9;
            ["x"] = 489.7;
          };
          [2] = {
            ["y"] = -288;
            ["x"] = 477.4;
          };
          [3] = {
            ["y"] = -303.3;
            ["x"] = 462.9;
          };
          [4] = {
            ["y"] = -290.2;
            ["x"] = 450.7;
          };
          [5] = {
            ["y"] = -245.4;
            ["x"] = 455.8;
          };
          [6] = {
            ["y"] = -232.5;
            ["x"] = 451.7;
          };
          [7] = {
            ["y"] = -229.3;
            ["x"] = 441.4;
          };
          [8] = {
            ["y"] = -233.4;
            ["x"] = 434.3;
          };
          [9] = {
            ["y"] = -241.3;
            ["x"] = 431.5;
          };
        };
      };
      [5] = {
        ["sublevel"] = 2;
        ["y"] = -279.2;
        ["x"] = 455;
        ["g"] = 19;
      };
      [6] = {
        ["sublevel"] = 2;
        ["y"] = -381.1;
        ["x"] = 551;
        ["g"] = 20;
        ["patrol"] = {
          [1] = {
            ["y"] = -384.9;
            ["x"] = 551.3;
          };
          [2] = {
            ["y"] = -389.2;
            ["x"] = 550.2;
          };
          [3] = {
            ["y"] = -393.2;
            ["x"] = 549.7;
          };
          [4] = {
            ["y"] = -398.9;
            ["x"] = 549.7;
          };
          [5] = {
            ["y"] = -402.9;
            ["x"] = 550.6;
          };
          [6] = {
            ["y"] = -406.9;
            ["x"] = 552.6;
          };
          [7] = {
            ["y"] = -409.8;
            ["x"] = 556.4;
          };
          [8] = {
            ["y"] = -411.9;
            ["x"] = 561.9;
          };
          [9] = {
            ["y"] = -413.7;
            ["x"] = 570.2;
          };
          [10] = {
            ["y"] = -412.3;
            ["x"] = 578.5;
          };
          [11] = {
            ["y"] = -409.6;
            ["x"] = 583.2;
          };
          [12] = {
            ["y"] = -405.4;
            ["x"] = 585.5;
          };
          [13] = {
            ["y"] = -398.8;
            ["x"] = 587.3;
          };
          [14] = {
            ["y"] = -392.6;
            ["x"] = 587.2;
          };
          [15] = {
            ["y"] = -382.9;
            ["x"] = 583.4;
          };
          [16] = {
            ["y"] = -378.2;
            ["x"] = 574.9;
          };
          [17] = {
            ["y"] = -376.8;
            ["x"] = 569.9;
          };
          [18] = {
            ["y"] = -253.1;
            ["x"] = 570.1;
          };
          [19] = {
            ["y"] = -251;
            ["x"] = 578.5;
          };
          [20] = {
            ["y"] = -248;
            ["x"] = 583;
          };
          [21] = {
            ["y"] = -242.6;
            ["x"] = 588.1;
          };
          [22] = {
            ["y"] = -234.8;
            ["x"] = 589.3;
          };
          [23] = {
            ["y"] = -223.6;
            ["x"] = 588.1;
          };
          [24] = {
            ["y"] = -218.2;
            ["x"] = 583.9;
          };
          [25] = {
            ["y"] = -215.3;
            ["x"] = 575.6;
          };
          [26] = {
            ["y"] = -214.1;
            ["x"] = 565.3;
          };
          [27] = {
            ["y"] = -217.1;
            ["x"] = 558;
          };
          [28] = {
            ["y"] = -223.1;
            ["x"] = 553.2;
          };
          [29] = {
            ["y"] = -231;
            ["x"] = 550;
          };
          [30] = {
            ["y"] = -238.9;
            ["x"] = 552;
          };
          [31] = {
            ["y"] = -246.8;
            ["x"] = 554.5;
          };
          [32] = {
            ["y"] = -251.7;
            ["x"] = 560.7;
          };
          [33] = {
            ["y"] = -253;
            ["x"] = 570.3;
          };
          [34] = {
            ["y"] = -377.4;
            ["x"] = 569.9;
          };
          [35] = {
            ["y"] = -380;
            ["x"] = 554.5;
          };
        };
      };
      [7] = {
        ["sublevel"] = 2;
        ["y"] = -383.8;
        ["x"] = 555.6;
        ["g"] = 20;
      };
      [8] = {
        ["sublevel"] = 2;
        ["y"] = -148;
        ["x"] = 537.6;
        ["g"] = 21;
      };
      [9] = {
        ["sublevel"] = 2;
        ["y"] = -185.3;
        ["x"] = 526.3;
        ["g"] = 22;
        ["patrol"] = {
          [1] = {
            ["y"] = -130.7;
            ["x"] = 473.4;
          };
          [2] = {
            ["y"] = -215;
            ["x"] = 561.3;
          };
          [3] = {
            ["y"] = -130.9;
            ["x"] = 473.4;
          };
        };
      };
      [10] = {
        ["sublevel"] = 2;
        ["y"] = -180.2;
        ["x"] = 531;
        ["g"] = 22;
      };
      [11] = {
        ["sublevel"] = 2;
        ["y"] = -107.4;
        ["x"] = 315;
        ["g"] = 23;
        ["patrol"] = {
          [1] = {
            ["y"] = -109;
            ["x"] = 311.1;
          };
          [2] = {
            ["y"] = -105;
            ["x"] = 302.9;
          };
          [3] = {
            ["y"] = -105.1;
            ["x"] = 290.7;
          };
          [4] = {
            ["y"] = -110.7;
            ["x"] = 280.6;
          };
          [5] = {
            ["y"] = -121.7;
            ["x"] = 277.5;
          };
          [6] = {
            ["y"] = -132.4;
            ["x"] = 279.1;
          };
          [7] = {
            ["y"] = -139.6;
            ["x"] = 285.7;
          };
          [8] = {
            ["y"] = -140.9;
            ["x"] = 300;
          };
          [9] = {
            ["y"] = -137.1;
            ["x"] = 310;
          };
          [10] = {
            ["y"] = -125.5;
            ["x"] = 315.5;
          };
          [11] = {
            ["y"] = -113.3;
            ["x"] = 314.5;
          };
        };
      };
      [12] = {
        ["sublevel"] = 2;
        ["y"] = -111;
        ["x"] = 311.7;
        ["g"] = 23;
      };
    };
  };
  [18] = {
    ["name"] = "Dread Creeper";
    ["id"] = 15974;
    ["count"] = 0;
    ["health"] = 195495;
    ["scale"] = 1;
    ["displayId"] = 15937;
    ["creatureType"] = "Beast";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 2;
        ["y"] = -428.4;
        ["x"] = 312.6;
        ["g"] = 16;
      };
      [2] = {
        ["sublevel"] = 2;
        ["y"] = -428.2;
        ["x"] = 302.8;
        ["g"] = 16;
      };
      [3] = {
        ["sublevel"] = 2;
        ["y"] = -349;
        ["x"] = 296.7;
        ["g"] = 17;
      };
      [4] = {
        ["sublevel"] = 2;
        ["y"] = -349.1;
        ["x"] = 305.3;
        ["g"] = 17;
      };
      [5] = {
        ["sublevel"] = 2;
        ["y"] = -323.1;
        ["x"] = 259.3;
        ["g"] = 18;
      };
      [6] = {
        ["sublevel"] = 2;
        ["y"] = -325.6;
        ["x"] = 253;
        ["g"] = 18;
      };
      [7] = {
        ["sublevel"] = 2;
        ["y"] = -296.7;
        ["x"] = 506;
        ["g"] = 24;
      };
      [8] = {
        ["sublevel"] = 2;
        ["y"] = -299.6;
        ["x"] = 510.5;
        ["g"] = 24;
      };
      [9] = {
        ["sublevel"] = 2;
        ["y"] = -303.1;
        ["x"] = 507.6;
        ["g"] = 24;
      };
      [10] = {
        ["sublevel"] = 2;
        ["y"] = -300.7;
        ["x"] = 502.9;
        ["g"] = 24;
      };
      [11] = {
        ["sublevel"] = 2;
        ["y"] = -370.3;
        ["x"] = 492.7;
        ["g"] = 25;
      };
      [12] = {
        ["sublevel"] = 2;
        ["y"] = -367.4;
        ["x"] = 488.2;
        ["g"] = 25;
      };
      [13] = {
        ["sublevel"] = 2;
        ["y"] = -366.6;
        ["x"] = 495;
        ["g"] = 25;
      };
      [14] = {
        ["sublevel"] = 2;
        ["y"] = -363.6;
        ["x"] = 490.9;
        ["g"] = 25;
      };
      [15] = {
        ["sublevel"] = 2;
        ["y"] = -399.5;
        ["x"] = 561.9;
        ["g"] = 26;
      };
      [16] = {
        ["sublevel"] = 2;
        ["y"] = -399.4;
        ["x"] = 568.3;
        ["g"] = 26;
      };
      [17] = {
        ["sublevel"] = 2;
        ["y"] = -399.7;
        ["x"] = 574.9;
        ["g"] = 26;
      };
      [18] = {
        ["sublevel"] = 2;
        ["y"] = -235.2;
        ["x"] = 576.8;
        ["g"] = 27;
      };
      [19] = {
        ["sublevel"] = 2;
        ["y"] = -235.5;
        ["x"] = 569.6;
        ["g"] = 27;
      };
      [20] = {
        ["sublevel"] = 2;
        ["y"] = -235.2;
        ["x"] = 562.7;
        ["g"] = 27;
      };
      [21] = {
        ["sublevel"] = 2;
        ["y"] = -150.5;
        ["x"] = 530.4;
        ["g"] = 21;
      };
      [22] = {
        ["sublevel"] = 2;
        ["y"] = -156.1;
        ["x"] = 536.3;
        ["g"] = 21;
      };
      [23] = {
        ["sublevel"] = 2;
        ["y"] = -125;
        ["x"] = 465.6;
        ["g"] = 28;
      };
      [24] = {
        ["sublevel"] = 2;
        ["y"] = -125.9;
        ["x"] = 458.7;
        ["g"] = 28;
      };
      [25] = {
        ["sublevel"] = 2;
        ["y"] = -126.3;
        ["x"] = 452.4;
        ["g"] = 28;
      };
      [26] = {
        ["sublevel"] = 2;
        ["y"] = -126.2;
        ["x"] = 290.3;
        ["g"] = 29;
      };
      [27] = {
        ["sublevel"] = 2;
        ["y"] = -126.5;
        ["x"] = 296.9;
        ["g"] = 29;
      };
      [28] = {
        ["sublevel"] = 2;
        ["y"] = -127.1;
        ["x"] = 303.6;
        ["g"] = 29;
      };
    };
  };
  [19] = {
    ["name"] = "Carrion Spinner";
    ["id"] = 15975;
    ["count"] = 0;
    ["health"] = 234594;
    ["scale"] = 1;
    ["displayId"] = 15938;
    ["creatureType"] = "Beast";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 2;
        ["y"] = -423.5;
        ["x"] = 317.1;
        ["g"] = 16;
      };
      [2] = {
        ["sublevel"] = 2;
        ["y"] = -423.1;
        ["x"] = 307.7;
        ["g"] = 16;
      };
      [3] = {
        ["sublevel"] = 2;
        ["y"] = -423;
        ["x"] = 298.4;
        ["g"] = 16;
      };
      [4] = {
        ["sublevel"] = 2;
        ["y"] = -353.5;
        ["x"] = 292.7;
        ["g"] = 17;
      };
      [5] = {
        ["sublevel"] = 2;
        ["y"] = -353.6;
        ["x"] = 301.1;
        ["g"] = 17;
      };
      [6] = {
        ["sublevel"] = 2;
        ["y"] = -354.2;
        ["x"] = 308.5;
        ["g"] = 17;
      };
      [7] = {
        ["sublevel"] = 2;
        ["y"] = -325.6;
        ["x"] = 264.6;
        ["g"] = 18;
      };
      [8] = {
        ["sublevel"] = 2;
        ["y"] = -329.4;
        ["x"] = 258.4;
        ["g"] = 18;
      };
      [9] = {
        ["sublevel"] = 2;
        ["y"] = -331.9;
        ["x"] = 251.1;
        ["g"] = 18;
      };
      [10] = {
        ["sublevel"] = 2;
        ["y"] = -306.9;
        ["x"] = 338.3;
        ["g"] = 30;
      };
      [11] = {
        ["sublevel"] = 2;
        ["y"] = -311.8;
        ["x"] = 331.4;
        ["g"] = 30;
      };
      [12] = {
        ["sublevel"] = 2;
        ["y"] = -309.1;
        ["x"] = 342.9;
        ["g"] = 30;
      };
      [13] = {
        ["sublevel"] = 2;
        ["y"] = -312.1;
        ["x"] = 337.4;
        ["g"] = 30;
      };
      [14] = {
        ["sublevel"] = 2;
        ["y"] = -317.8;
        ["x"] = 332.5;
        ["g"] = 30;
      };
      [15] = {
        ["sublevel"] = 2;
        ["y"] = -326.3;
        ["x"] = 393.4;
        ["g"] = 31;
      };
      [16] = {
        ["sublevel"] = 2;
        ["y"] = -333.6;
        ["x"] = 392.9;
        ["g"] = 31;
      };
      [17] = {
        ["sublevel"] = 2;
        ["y"] = -324.9;
        ["x"] = 389.3;
        ["g"] = 31;
      };
      [18] = {
        ["sublevel"] = 2;
        ["y"] = -330.1;
        ["x"] = 389.3;
        ["g"] = 31;
      };
      [19] = {
        ["sublevel"] = 2;
        ["y"] = -335.5;
        ["x"] = 388;
        ["g"] = 31;
      };
      [20] = {
        ["sublevel"] = 2;
        ["y"] = -393.7;
        ["x"] = 565.2;
        ["g"] = 26;
      };
      [21] = {
        ["sublevel"] = 2;
        ["y"] = -393.7;
        ["x"] = 572.8;
        ["g"] = 26;
      };
      [22] = {
        ["sublevel"] = 2;
        ["y"] = -229.8;
        ["x"] = 565.5;
        ["g"] = 27;
      };
      [23] = {
        ["sublevel"] = 2;
        ["y"] = -229.8;
        ["x"] = 573.7;
        ["g"] = 27;
      };
      [24] = {
        ["sublevel"] = 2;
        ["y"] = -153.9;
        ["x"] = 523.8;
        ["g"] = 21;
      };
      [25] = {
        ["sublevel"] = 2;
        ["y"] = -157.4;
        ["x"] = 528.8;
        ["g"] = 21;
      };
      [26] = {
        ["sublevel"] = 2;
        ["y"] = -162.7;
        ["x"] = 534.5;
        ["g"] = 21;
      };
      [27] = {
        ["sublevel"] = 2;
        ["y"] = -120.6;
        ["x"] = 455.2;
        ["g"] = 28;
      };
      [28] = {
        ["sublevel"] = 2;
        ["y"] = -120.3;
        ["x"] = 462.8;
        ["g"] = 28;
      };
      [29] = {
        ["sublevel"] = 2;
        ["y"] = -121.7;
        ["x"] = 293.2;
        ["g"] = 29;
      };
      [30] = {
        ["sublevel"] = 2;
        ["y"] = -121.3;
        ["x"] = 300.9;
        ["g"] = 29;
      };
    };
  };
  [20] = {
    ["name"] = "Poisonous Skitterer";
    ["id"] = 15977;
    ["count"] = 0;
    ["health"] = 65165;
    ["scale"] = 1;
    ["displayId"] = 958;
    ["creatureType"] = "Beast";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 2;
        ["y"] = -385.9;
        ["x"] = 347.8;
        ["g"] = 32;
      };
      [2] = {
        ["sublevel"] = 2;
        ["y"] = -390.9;
        ["x"] = 348.1;
        ["g"] = 32;
      };
      [3] = {
        ["sublevel"] = 2;
        ["y"] = -396.8;
        ["x"] = 347.5;
        ["g"] = 32;
      };
      [4] = {
        ["sublevel"] = 2;
        ["y"] = -382.1;
        ["x"] = 342.4;
        ["g"] = 32;
      };
      [5] = {
        ["sublevel"] = 2;
        ["y"] = -388;
        ["x"] = 342.1;
        ["g"] = 32;
      };
      [6] = {
        ["sublevel"] = 2;
        ["y"] = -394.3;
        ["x"] = 342.9;
        ["g"] = 32;
      };
      [7] = {
        ["sublevel"] = 2;
        ["y"] = -400.6;
        ["x"] = 342;
        ["g"] = 32;
      };
      [8] = {
        ["sublevel"] = 2;
        ["y"] = -385.9;
        ["x"] = 337;
        ["g"] = 32;
      };
      [9] = {
        ["sublevel"] = 2;
        ["y"] = -391.5;
        ["x"] = 337;
        ["g"] = 32;
      };
      [10] = {
        ["sublevel"] = 2;
        ["y"] = -397.2;
        ["x"] = 337;
        ["g"] = 32;
      };
      [11] = {
        ["sublevel"] = 2;
        ["y"] = -375.8;
        ["x"] = 266.4;
        ["g"] = 33;
      };
      [12] = {
        ["sublevel"] = 2;
        ["y"] = -382.6;
        ["x"] = 265.9;
        ["g"] = 33;
      };
      [13] = {
        ["sublevel"] = 2;
        ["y"] = -389.5;
        ["x"] = 265.6;
        ["g"] = 33;
      };
      [14] = {
        ["sublevel"] = 2;
        ["y"] = -396.6;
        ["x"] = 265.1;
        ["g"] = 33;
      };
      [15] = {
        ["sublevel"] = 2;
        ["y"] = -378.8;
        ["x"] = 261.5;
        ["g"] = 33;
      };
      [16] = {
        ["sublevel"] = 2;
        ["y"] = -385.7;
        ["x"] = 260.7;
        ["g"] = 33;
      };
      [17] = {
        ["sublevel"] = 2;
        ["y"] = -392.2;
        ["x"] = 261;
        ["g"] = 33;
      };
      [18] = {
        ["sublevel"] = 2;
        ["y"] = -379.6;
        ["x"] = 270.3;
        ["g"] = 33;
      };
      [19] = {
        ["sublevel"] = 2;
        ["y"] = -386.5;
        ["x"] = 270;
        ["g"] = 33;
      };
      [20] = {
        ["sublevel"] = 2;
        ["y"] = -393.8;
        ["x"] = 270;
        ["g"] = 33;
      };
      [21] = {
        ["sublevel"] = 2;
        ["y"] = -369.4;
        ["x"] = 315.9;
        ["g"] = 34;
        ["patrol"] = {
          [1] = {
            ["y"] = -406;
            ["x"] = 327.8;
          };
          [2] = {
            ["y"] = -386.6;
            ["x"] = 330.3;
          };
          [3] = {
            ["y"] = -360.7;
            ["x"] = 301.4;
          };
          [4] = {
            ["y"] = -365.8;
            ["x"] = 282.3;
          };
          [5] = {
            ["y"] = -341.6;
            ["x"] = 255.9;
          };
          [6] = {
            ["y"] = -365.7;
            ["x"] = 282.1;
          };
          [7] = {
            ["y"] = -385;
            ["x"] = 275.1;
          };
          [8] = {
            ["y"] = -417.9;
            ["x"] = 311.1;
          };
        };
      };
      [22] = {
        ["sublevel"] = 2;
        ["y"] = -371.3;
        ["x"] = 312.6;
        ["g"] = 34;
      };
      [23] = {
        ["sublevel"] = 2;
        ["y"] = -373.8;
        ["x"] = 309.3;
        ["g"] = 34;
      };
      [24] = {
        ["sublevel"] = 2;
        ["y"] = -370.8;
        ["x"] = 320.8;
        ["g"] = 34;
      };
      [25] = {
        ["sublevel"] = 2;
        ["y"] = -374.3;
        ["x"] = 317;
        ["g"] = 34;
      };
      [26] = {
        ["sublevel"] = 2;
        ["y"] = -377.1;
        ["x"] = 313.1;
        ["g"] = 34;
      };
      [27] = {
        ["sublevel"] = 2;
        ["y"] = -380.1;
        ["x"] = 309.9;
        ["g"] = 34;
      };
      [28] = {
        ["sublevel"] = 2;
        ["y"] = -376.2;
        ["x"] = 321.9;
        ["g"] = 34;
      };
      [29] = {
        ["sublevel"] = 2;
        ["y"] = -379.8;
        ["x"] = 318.1;
        ["g"] = 34;
      };
      [30] = {
        ["sublevel"] = 2;
        ["y"] = -382.2;
        ["x"] = 314.8;
        ["g"] = 34;
      };
      [31] = {
        ["sublevel"] = 2;
        ["y"] = -317.9;
        ["x"] = 373.5;
        ["g"] = 35;
        ["patrol"] = {
          [1] = {
            ["y"] = -311.2;
            ["x"] = 370;
          };
          [2] = {
            ["y"] = -305.8;
            ["x"] = 362.8;
          };
          [3] = {
            ["y"] = -337.5;
            ["x"] = 330.9;
          };
          [4] = {
            ["y"] = -361.9;
            ["x"] = 354.9;
          };
          [5] = {
            ["y"] = -330.6;
            ["x"] = 385.9;
          };
          [6] = {
            ["y"] = -318.6;
            ["x"] = 374.7;
          };
          [7] = {
            ["y"] = -288;
            ["x"] = 407.3;
          };
        };
      };
      [32] = {
        ["sublevel"] = 2;
        ["y"] = -315.3;
        ["x"] = 377;
        ["g"] = 35;
      };
      [33] = {
        ["sublevel"] = 2;
        ["y"] = -321.3;
        ["x"] = 370.5;
        ["g"] = 35;
      };
      [34] = {
        ["sublevel"] = 2;
        ["y"] = -311.8;
        ["x"] = 380.9;
        ["g"] = 35;
      };
      [35] = {
        ["sublevel"] = 2;
        ["y"] = -310.8;
        ["x"] = 375.8;
        ["g"] = 35;
      };
      [36] = {
        ["sublevel"] = 2;
        ["y"] = -313.7;
        ["x"] = 371.9;
        ["g"] = 35;
      };
      [37] = {
        ["sublevel"] = 2;
        ["y"] = -317.1;
        ["x"] = 368.8;
        ["g"] = 35;
      };
      [38] = {
        ["sublevel"] = 2;
        ["y"] = -316.4;
        ["x"] = 382;
        ["g"] = 35;
      };
      [39] = {
        ["sublevel"] = 2;
        ["y"] = -319.5;
        ["x"] = 377.9;
        ["g"] = 35;
      };
      [40] = {
        ["sublevel"] = 2;
        ["y"] = -322.7;
        ["x"] = 375.2;
        ["g"] = 35;
      };
      [41] = {
        ["sublevel"] = 2;
        ["y"] = -287.5;
        ["x"] = 427.3;
        ["g"] = 36;
      };
      [42] = {
        ["sublevel"] = 2;
        ["y"] = -287.1;
        ["x"] = 422.6;
        ["g"] = 36;
      };
      [43] = {
        ["sublevel"] = 2;
        ["y"] = -287;
        ["x"] = 418;
        ["g"] = 36;
      };
      [44] = {
        ["sublevel"] = 2;
        ["y"] = -292.4;
        ["x"] = 427.3;
        ["g"] = 36;
      };
      [45] = {
        ["sublevel"] = 2;
        ["y"] = -291.8;
        ["x"] = 422.8;
        ["g"] = 36;
      };
      [46] = {
        ["sublevel"] = 2;
        ["y"] = -292.2;
        ["x"] = 418.1;
        ["g"] = 36;
      };
      [47] = {
        ["sublevel"] = 2;
        ["y"] = -297;
        ["x"] = 427.5;
        ["g"] = 36;
      };
      [48] = {
        ["sublevel"] = 2;
        ["y"] = -296.9;
        ["x"] = 422.8;
        ["g"] = 36;
      };
      [49] = {
        ["sublevel"] = 2;
        ["y"] = -297.2;
        ["x"] = 418.1;
        ["g"] = 36;
      };
      [50] = {
        ["sublevel"] = 2;
        ["y"] = -292;
        ["x"] = 414.4;
        ["g"] = 36;
      };
      [51] = {
        ["sublevel"] = 2;
        ["y"] = -240.7;
        ["x"] = 450;
        ["g"] = 37;
      };
      [52] = {
        ["sublevel"] = 2;
        ["y"] = -240.7;
        ["x"] = 446.5;
        ["g"] = 37;
      };
      [53] = {
        ["sublevel"] = 2;
        ["y"] = -240.3;
        ["x"] = 443.5;
        ["g"] = 37;
      };
      [54] = {
        ["sublevel"] = 2;
        ["y"] = -239.8;
        ["x"] = 440.6;
        ["g"] = 37;
      };
      [55] = {
        ["sublevel"] = 2;
        ["y"] = -238.1;
        ["x"] = 447.9;
        ["g"] = 37;
      };
      [56] = {
        ["sublevel"] = 2;
        ["y"] = -237.4;
        ["x"] = 445.4;
        ["g"] = 37;
      };
      [57] = {
        ["sublevel"] = 2;
        ["y"] = -237;
        ["x"] = 442.1;
        ["g"] = 37;
      };
      [58] = {
        ["sublevel"] = 2;
        ["y"] = -243.7;
        ["x"] = 447.9;
        ["g"] = 37;
      };
      [59] = {
        ["sublevel"] = 2;
        ["y"] = -243.4;
        ["x"] = 444.8;
        ["g"] = 37;
      };
      [60] = {
        ["sublevel"] = 2;
        ["y"] = -242.8;
        ["x"] = 442;
        ["g"] = 37;
      };
      [61] = {
        ["sublevel"] = 2;
        ["y"] = -322.3;
        ["x"] = 514.9;
        ["g"] = 38;
        ["patrol"] = {
          [1] = {
            ["y"] = -349.7;
            ["x"] = 509.1;
          };
          [2] = {
            ["y"] = -313.3;
            ["x"] = 509.9;
          };
          [3] = {
            ["y"] = -303.9;
            ["x"] = 496.5;
          };
          [4] = {
            ["y"] = -314.3;
            ["x"] = 483.4;
          };
          [5] = {
            ["y"] = -349.9;
            ["x"] = 483.8;
          };
          [6] = {
            ["y"] = -358.2;
            ["x"] = 496.3;
          };
          [7] = {
            ["y"] = -350.2;
            ["x"] = 509.2;
          };
        };
      };
      [62] = {
        ["sublevel"] = 2;
        ["y"] = -327.5;
        ["x"] = 515.1;
        ["g"] = 38;
      };
      [63] = {
        ["sublevel"] = 2;
        ["y"] = -332.2;
        ["x"] = 514.9;
        ["g"] = 38;
      };
      [64] = {
        ["sublevel"] = 2;
        ["y"] = -319;
        ["x"] = 510.1;
        ["g"] = 38;
      };
      [65] = {
        ["sublevel"] = 2;
        ["y"] = -324.4;
        ["x"] = 510.1;
        ["g"] = 38;
      };
      [66] = {
        ["sublevel"] = 2;
        ["y"] = -329.5;
        ["x"] = 510.1;
        ["g"] = 38;
      };
      [67] = {
        ["sublevel"] = 2;
        ["y"] = -335.3;
        ["x"] = 510.1;
        ["g"] = 38;
      };
      [68] = {
        ["sublevel"] = 2;
        ["y"] = -323.1;
        ["x"] = 505.6;
        ["g"] = 38;
      };
      [69] = {
        ["sublevel"] = 2;
        ["y"] = -327.9;
        ["x"] = 505.8;
        ["g"] = 38;
      };
      [70] = {
        ["sublevel"] = 2;
        ["y"] = -332.4;
        ["x"] = 505.6;
        ["g"] = 38;
      };
      [71] = {
        ["sublevel"] = 2;
        ["y"] = -190.3;
        ["x"] = 430.4;
        ["g"] = 39;
        ["patrol"] = {
          [1] = {
            ["y"] = -180.1;
            ["x"] = 426.3;
          };
          [2] = {
            ["y"] = -198.6;
            ["x"] = 431.4;
          };
          [3] = {
            ["y"] = -206.9;
            ["x"] = 410;
          };
          [4] = {
            ["y"] = -209.9;
            ["x"] = 404;
          };
          [5] = {
            ["y"] = -224.8;
            ["x"] = 399.7;
          };
          [6] = {
            ["y"] = -210.7;
            ["x"] = 372.5;
          };
          [7] = {
            ["y"] = -222.2;
            ["x"] = 372.2;
          };
          [8] = {
            ["y"] = -220.8;
            ["x"] = 364;
          };
          [9] = {
            ["y"] = -213.8;
            ["x"] = 352.4;
          };
          [10] = {
            ["y"] = -204.1;
            ["x"] = 348.2;
          };
          [11] = {
            ["y"] = -197.6;
            ["x"] = 347.3;
          };
          [12] = {
            ["y"] = -193.6;
            ["x"] = 348.8;
          };
          [13] = {
            ["y"] = -184.6;
            ["x"] = 355.3;
          };
          [14] = {
            ["y"] = -179.4;
            ["x"] = 372.9;
          };
          [15] = {
            ["y"] = -188.7;
            ["x"] = 372.1;
          };
          [16] = {
            ["y"] = -189;
            ["x"] = 389.3;
          };
          [17] = {
            ["y"] = -185.2;
            ["x"] = 399.7;
          };
          [18] = {
            ["y"] = -172.9;
            ["x"] = 419.7;
          };
        };
      };
      [72] = {
        ["sublevel"] = 2;
        ["y"] = -194.5;
        ["x"] = 430.6;
        ["g"] = 39;
      };
      [73] = {
        ["sublevel"] = 2;
        ["y"] = -198.4;
        ["x"] = 430.4;
        ["g"] = 39;
      };
      [74] = {
        ["sublevel"] = 2;
        ["y"] = -201.6;
        ["x"] = 430.6;
        ["g"] = 39;
      };
      [75] = {
        ["sublevel"] = 2;
        ["y"] = -192.3;
        ["x"] = 433.7;
        ["g"] = 39;
      };
      [76] = {
        ["sublevel"] = 2;
        ["y"] = -196.4;
        ["x"] = 433.7;
        ["g"] = 39;
      };
      [77] = {
        ["sublevel"] = 2;
        ["y"] = -200.3;
        ["x"] = 433.9;
        ["g"] = 39;
      };
      [78] = {
        ["sublevel"] = 2;
        ["y"] = -192.9;
        ["x"] = 427;
        ["g"] = 39;
      };
      [79] = {
        ["sublevel"] = 2;
        ["y"] = -196.7;
        ["x"] = 427.2;
        ["g"] = 39;
      };
      [80] = {
        ["sublevel"] = 2;
        ["y"] = -199.8;
        ["x"] = 427.5;
        ["g"] = 39;
      };
      [81] = {
        ["sublevel"] = 2;
        ["y"] = -388.1;
        ["x"] = 594.1;
        ["g"] = 40;
        ["patrol"] = {
          [1] = {
            ["y"] = -263.2;
            ["x"] = 563.6;
          };
          [2] = {
            ["y"] = -364.5;
            ["x"] = 563.3;
          };
          [3] = {
            ["y"] = -367.3;
            ["x"] = 556.1;
          };
          [4] = {
            ["y"] = -372.3;
            ["x"] = 549.5;
          };
          [5] = {
            ["y"] = -382.1;
            ["x"] = 542.3;
          };
          [6] = {
            ["y"] = -391.2;
            ["x"] = 539.5;
          };
          [7] = {
            ["y"] = -400.9;
            ["x"] = 540.4;
          };
          [8] = {
            ["y"] = -407.2;
            ["x"] = 542.3;
          };
          [9] = {
            ["y"] = -415;
            ["x"] = 547.3;
          };
          [10] = {
            ["y"] = -421.6;
            ["x"] = 554.8;
          };
          [11] = {
            ["y"] = -425;
            ["x"] = 565.2;
          };
          [12] = {
            ["y"] = -425.3;
            ["x"] = 575.6;
          };
          [13] = {
            ["y"] = -421.3;
            ["x"] = 585;
          };
          [14] = {
            ["y"] = -415;
            ["x"] = 593.1;
          };
          [15] = {
            ["y"] = -405.3;
            ["x"] = 598.8;
          };
          [16] = {
            ["y"] = -394;
            ["x"] = 601;
          };
          [17] = {
            ["y"] = -385.2;
            ["x"] = 599.4;
          };
          [18] = {
            ["y"] = -376.4;
            ["x"] = 595;
          };
          [19] = {
            ["y"] = -367.9;
            ["x"] = 585.3;
          };
          [20] = {
            ["y"] = -364.2;
            ["x"] = 576.8;
          };
          [21] = {
            ["y"] = -363.6;
            ["x"] = 567.1;
          };
          [22] = {
            ["y"] = -363.6;
            ["x"] = 564.6;
          };
        };
      };
      [82] = {
        ["sublevel"] = 2;
        ["y"] = -382.4;
        ["x"] = 592.2;
        ["g"] = 40;
      };
      [83] = {
        ["sublevel"] = 2;
        ["y"] = -377.7;
        ["x"] = 589.4;
        ["g"] = 40;
      };
      [84] = {
        ["sublevel"] = 2;
        ["y"] = -372.7;
        ["x"] = 586.5;
        ["g"] = 40;
      };
      [85] = {
        ["sublevel"] = 2;
        ["y"] = -372.4;
        ["x"] = 592.2;
        ["g"] = 40;
      };
      [86] = {
        ["sublevel"] = 2;
        ["y"] = -378.2;
        ["x"] = 594.7;
        ["g"] = 40;
      };
      [87] = {
        ["sublevel"] = 2;
        ["y"] = -383.5;
        ["x"] = 598.1;
        ["g"] = 40;
      };
      [88] = {
        ["sublevel"] = 2;
        ["y"] = -377.2;
        ["x"] = 583.7;
        ["g"] = 40;
      };
      [89] = {
        ["sublevel"] = 2;
        ["y"] = -382.6;
        ["x"] = 586.5;
        ["g"] = 40;
      };
      [90] = {
        ["sublevel"] = 2;
        ["y"] = -387.9;
        ["x"] = 588.4;
        ["g"] = 40;
      };
      [91] = {
        ["sublevel"] = 2;
        ["y"] = -306.4;
        ["x"] = 590.4;
        ["g"] = 41;
        ["patrol"] = {
          [1] = {
            ["y"] = -261;
            ["x"] = 582.8;
          };
          [2] = {
            ["y"] = -256.3;
            ["x"] = 590.9;
          };
          [3] = {
            ["y"] = -247.8;
            ["x"] = 596.6;
          };
          [4] = {
            ["y"] = -240.6;
            ["x"] = 599.1;
          };
          [5] = {
            ["y"] = -230.6;
            ["x"] = 601;
          };
          [6] = {
            ["y"] = -219.6;
            ["x"] = 597.5;
          };
          [7] = {
            ["y"] = -211.7;
            ["x"] = 592.2;
          };
          [8] = {
            ["y"] = -206.1;
            ["x"] = 584.3;
          };
          [9] = {
            ["y"] = -202.6;
            ["x"] = 574.6;
          };
          [10] = {
            ["y"] = -202.3;
            ["x"] = 565.5;
          };
          [11] = {
            ["y"] = -204.8;
            ["x"] = 556.4;
          };
          [12] = {
            ["y"] = -210.5;
            ["x"] = 547.9;
          };
          [13] = {
            ["y"] = -219;
            ["x"] = 542.9;
          };
          [14] = {
            ["y"] = -228;
            ["x"] = 539.8;
          };
          [15] = {
            ["y"] = -239.7;
            ["x"] = 540.1;
          };
          [16] = {
            ["y"] = -248.1;
            ["x"] = 543.6;
          };
          [17] = {
            ["y"] = -255.3;
            ["x"] = 549.2;
          };
          [18] = {
            ["y"] = -261;
            ["x"] = 557;
          };
          [19] = {
            ["y"] = -263.5;
            ["x"] = 565.2;
          };
          [20] = {
            ["y"] = -263.2;
            ["x"] = 576.5;
          };
          [21] = {
            ["y"] = -261.9;
            ["x"] = 579.3;
          };
          [22] = {
            ["y"] = -297.1;
            ["x"] = 579.3;
          };
          [23] = {
            ["y"] = -297.1;
            ["x"] = 587.2;
          };
          [24] = {
            ["y"] = -338.1;
            ["x"] = 587.5;
          };
          [25] = {
            ["y"] = -337.8;
            ["x"] = 552.3;
          };
          [26] = {
            ["y"] = -297.4;
            ["x"] = 552.6;
          };
          [27] = {
            ["y"] = -296.7;
            ["x"] = 577.4;
          };
        };
      };
      [92] = {
        ["sublevel"] = 2;
        ["y"] = -309.8;
        ["x"] = 589.9;
        ["g"] = 41;
      };
      [93] = {
        ["sublevel"] = 2;
        ["y"] = -313.4;
        ["x"] = 589.9;
        ["g"] = 41;
      };
      [94] = {
        ["sublevel"] = 2;
        ["y"] = -315.5;
        ["x"] = 587;
        ["g"] = 41;
      };
      [95] = {
        ["sublevel"] = 2;
        ["y"] = -306.2;
        ["x"] = 583.5;
        ["g"] = 41;
      };
      [96] = {
        ["sublevel"] = 2;
        ["y"] = -309.7;
        ["x"] = 583.3;
        ["g"] = 41;
      };
      [97] = {
        ["sublevel"] = 2;
        ["y"] = -313.5;
        ["x"] = 583.3;
        ["g"] = 41;
      };
      [98] = {
        ["sublevel"] = 2;
        ["y"] = -304.3;
        ["x"] = 587;
        ["g"] = 41;
      };
      [99] = {
        ["sublevel"] = 2;
        ["y"] = -308.1;
        ["x"] = 587.1;
        ["g"] = 41;
      };
      [100] = {
        ["sublevel"] = 2;
        ["y"] = -311.9;
        ["x"] = 586.8;
        ["g"] = 41;
      };
      [101] = {
        ["sublevel"] = 2;
        ["y"] = -174.5;
        ["x"] = 499.3;
        ["g"] = 42;
        ["patrol"] = {
          [1] = {
            ["y"] = -150.7;
            ["x"] = 475.1;
          };
          [2] = {
            ["y"] = -217.2;
            ["x"] = 542.6;
          };
          [3] = {
            ["y"] = -150.7;
            ["x"] = 475.1;
          };
        };
      };
      [102] = {
        ["sublevel"] = 2;
        ["y"] = -177.7;
        ["x"] = 506.1;
        ["g"] = 42;
      };
      [103] = {
        ["sublevel"] = 2;
        ["y"] = -181.4;
        ["x"] = 502.4;
        ["g"] = 42;
      };
      [104] = {
        ["sublevel"] = 2;
        ["y"] = -180.9;
        ["x"] = 509.7;
        ["g"] = 42;
      };
      [105] = {
        ["sublevel"] = 2;
        ["y"] = -174;
        ["x"] = 502.8;
        ["g"] = 42;
      };
      [106] = {
        ["sublevel"] = 2;
        ["y"] = -178;
        ["x"] = 498.9;
        ["g"] = 42;
      };
      [107] = {
        ["sublevel"] = 2;
        ["y"] = -184.8;
        ["x"] = 505.9;
        ["g"] = 42;
      };
      [108] = {
        ["sublevel"] = 2;
        ["y"] = -177.7;
        ["x"] = 502.5;
        ["g"] = 42;
      };
      [109] = {
        ["sublevel"] = 2;
        ["y"] = -181.2;
        ["x"] = 506;
        ["g"] = 42;
      };
      [110] = {
        ["sublevel"] = 2;
        ["y"] = -184.6;
        ["x"] = 509.4;
        ["g"] = 42;
      };
      [111] = {
        ["sublevel"] = 2;
        ["y"] = -152.8;
        ["x"] = 301.5;
        ["g"] = 43;
        ["patrol"] = {
          [1] = {
            ["y"] = -116.9;
            ["x"] = 429.9;
          };
          [2] = {
            ["y"] = -116;
            ["x"] = 327.5;
          };
          [3] = {
            ["y"] = -108.7;
            ["x"] = 324.5;
          };
          [4] = {
            ["y"] = -100.7;
            ["x"] = 318.7;
          };
          [5] = {
            ["y"] = -95.6;
            ["x"] = 310.5;
          };
          [6] = {
            ["y"] = -92.6;
            ["x"] = 299.3;
          };
          [7] = {
            ["y"] = -95.3;
            ["x"] = 286.8;
          };
          [8] = {
            ["y"] = -101;
            ["x"] = 277.5;
          };
          [9] = {
            ["y"] = -108.9;
            ["x"] = 270.9;
          };
          [10] = {
            ["y"] = -117.1;
            ["x"] = 267.9;
          };
          [11] = {
            ["y"] = -127;
            ["x"] = 267.4;
          };
          [12] = {
            ["y"] = -136;
            ["x"] = 270.1;
          };
          [13] = {
            ["y"] = -143.3;
            ["x"] = 274.5;
          };
          [14] = {
            ["y"] = -149.1;
            ["x"] = 281.3;
          };
          [15] = {
            ["y"] = -152.4;
            ["x"] = 290.9;
          };
          [16] = {
            ["y"] = -153.7;
            ["x"] = 298.5;
          };
          [17] = {
            ["y"] = -151.8;
            ["x"] = 308.9;
          };
          [18] = {
            ["y"] = -145.8;
            ["x"] = 318.7;
          };
          [19] = {
            ["y"] = -137.9;
            ["x"] = 325;
          };
          [20] = {
            ["y"] = -128.9;
            ["x"] = 328;
          };
          [21] = {
            ["y"] = -121.5;
            ["x"] = 328.3;
          };
          [22] = {
            ["y"] = -116.6;
            ["x"] = 327.8;
          };
        };
      };
      [112] = {
        ["sublevel"] = 2;
        ["y"] = -152.4;
        ["x"] = 295.2;
        ["g"] = 43;
      };
      [113] = {
        ["sublevel"] = 2;
        ["y"] = -152.4;
        ["x"] = 289.3;
        ["g"] = 43;
      };
      [114] = {
        ["sublevel"] = 2;
        ["y"] = -148.9;
        ["x"] = 304.7;
        ["g"] = 43;
      };
      [115] = {
        ["sublevel"] = 2;
        ["y"] = -148.1;
        ["x"] = 298.3;
        ["g"] = 43;
      };
      [116] = {
        ["sublevel"] = 2;
        ["y"] = -148.1;
        ["x"] = 292.3;
        ["g"] = 43;
      };
      [117] = {
        ["sublevel"] = 2;
        ["y"] = -148.1;
        ["x"] = 286.1;
        ["g"] = 43;
      };
      [118] = {
        ["sublevel"] = 2;
        ["y"] = -145.2;
        ["x"] = 302.4;
        ["g"] = 43;
      };
      [119] = {
        ["sublevel"] = 2;
        ["y"] = -144.4;
        ["x"] = 295;
        ["g"] = 43;
      };
      [120] = {
        ["sublevel"] = 2;
        ["y"] = -144.6;
        ["x"] = 289;
        ["g"] = 43;
      };
      [121] = {
        ["sublevel"] = 2;
        ["y"] = -135.5;
        ["x"] = 385;
        ["g"] = 44;
        ["patrol"] = {
          [1] = {
            ["y"] = -130.5;
            ["x"] = 429.7;
          };
          [2] = {
            ["y"] = -136.9;
            ["x"] = 431.6;
          };
          [3] = {
            ["y"] = -143.1;
            ["x"] = 435.3;
          };
          [4] = {
            ["y"] = -148.7;
            ["x"] = 441.1;
          };
          [5] = {
            ["y"] = -152.8;
            ["x"] = 447.7;
          };
          [6] = {
            ["y"] = -154.9;
            ["x"] = 455.2;
          };
          [7] = {
            ["y"] = -154.9;
            ["x"] = 464.7;
          };
          [8] = {
            ["y"] = -151.8;
            ["x"] = 473.4;
          };
          [9] = {
            ["y"] = -147.7;
            ["x"] = 480.2;
          };
          [10] = {
            ["y"] = -140.4;
            ["x"] = 485.8;
          };
          [11] = {
            ["y"] = -131.7;
            ["x"] = 489.5;
          };
          [12] = {
            ["y"] = -119.5;
            ["x"] = 489.9;
          };
          [13] = {
            ["y"] = -110.8;
            ["x"] = 486.8;
          };
          [14] = {
            ["y"] = -103.4;
            ["x"] = 481.9;
          };
          [15] = {
            ["y"] = -98.2;
            ["x"] = 474.6;
          };
          [16] = {
            ["y"] = -94.5;
            ["x"] = 466.3;
          };
          [17] = {
            ["y"] = -93.9;
            ["x"] = 455.6;
          };
          [18] = {
            ["y"] = -96.6;
            ["x"] = 446.9;
          };
          [19] = {
            ["y"] = -100.7;
            ["x"] = 439.6;
          };
          [20] = {
            ["y"] = -107.1;
            ["x"] = 434.5;
          };
          [21] = {
            ["y"] = -113.5;
            ["x"] = 431;
          };
          [22] = {
            ["y"] = -120.6;
            ["x"] = 429.1;
          };
          [23] = {
            ["y"] = -128.8;
            ["x"] = 429.3;
          };
          [24] = {
            ["y"] = -129.9;
            ["x"] = 394.3;
          };
          [25] = {
            ["y"] = -139.4;
            ["x"] = 394.3;
          };
          [26] = {
            ["y"] = -139.6;
            ["x"] = 354.4;
          };
          [27] = {
            ["y"] = -104.8;
            ["x"] = 355;
          };
          [28] = {
            ["y"] = -104.4;
            ["x"] = 394.5;
          };
          [29] = {
            ["y"] = -129;
            ["x"] = 394.1;
          };
        };
      };
      [122] = {
        ["sublevel"] = 2;
        ["y"] = -135.5;
        ["x"] = 381.8;
        ["g"] = 44;
      };
      [123] = {
        ["sublevel"] = 2;
        ["y"] = -135.3;
        ["x"] = 378.3;
        ["g"] = 44;
      };
      [124] = {
        ["sublevel"] = 2;
        ["y"] = -139;
        ["x"] = 386.9;
        ["g"] = 44;
      };
      [125] = {
        ["sublevel"] = 2;
        ["y"] = -142;
        ["x"] = 385.1;
        ["g"] = 44;
      };
      [126] = {
        ["sublevel"] = 2;
        ["y"] = -142.1;
        ["x"] = 381.3;
        ["g"] = 44;
      };
      [127] = {
        ["sublevel"] = 2;
        ["y"] = -142.1;
        ["x"] = 377.5;
        ["g"] = 44;
      };
      [128] = {
        ["sublevel"] = 2;
        ["y"] = -139;
        ["x"] = 383.5;
        ["g"] = 44;
      };
      [129] = {
        ["sublevel"] = 2;
        ["y"] = -138.9;
        ["x"] = 380.1;
        ["g"] = 44;
      };
      [130] = {
        ["sublevel"] = 2;
        ["y"] = -138.9;
        ["x"] = 376.5;
        ["g"] = 44;
      };
    };
  };
  [21] = {
    ["name"] = "Crypt Reaver";
    ["id"] = 15978;
    ["count"] = 0;
    ["health"] = 586485;
    ["scale"] = 1;
    ["displayId"] = 15941;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 2;
        ["y"] = -306.3;
        ["x"] = 332.3;
        ["g"] = 30;
      };
      [2] = {
        ["sublevel"] = 2;
        ["y"] = -330.4;
        ["x"] = 396.7;
        ["g"] = 31;
      };
    };
  };
  [22] = {
    ["name"] = "Tomb Horror";
    ["id"] = 15979;
    ["count"] = 0;
    ["health"] = 456155;
    ["scale"] = 1;
    ["displayId"] = 15942;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 2;
        ["y"] = -294.8;
        ["x"] = 510.5;
        ["g"] = 24;
      };
      [2] = {
        ["sublevel"] = 2;
        ["y"] = -371.7;
        ["x"] = 487.8;
        ["g"] = 25;
      };
      [3] = {
        ["sublevel"] = 2;
        ["y"] = -387.5;
        ["x"] = 569.5;
        ["g"] = 26;
      };
      [4] = {
        ["sublevel"] = 2;
        ["y"] = -224.8;
        ["x"] = 569.6;
        ["g"] = 27;
      };
      [5] = {
        ["sublevel"] = 2;
        ["y"] = -116.2;
        ["x"] = 459;
        ["g"] = 28;
      };
      [6] = {
        ["sublevel"] = 2;
        ["y"] = -117.1;
        ["x"] = 297.5;
        ["g"] = 29;
      };
    };
  };
  [23] = {
    ["name"] = "Anub'Rekhan";
    ["id"] = 15956;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 15931;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 2;
        ["y"] = -236.9;
        ["x"] = 257;
      };
    };
  };
  [24] = {
    ["name"] = "Naxxramas Cultist";
    ["id"] = 15980;
    ["count"] = 0;
    ["health"] = 52130;
    ["scale"] = 1;
    ["displayId"] = 16594;
    ["creatureType"] = "Humanoid";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 2;
        ["y"] = -182.9;
        ["x"] = 392.3;
        ["g"] = 45;
      };
      [2] = {
        ["sublevel"] = 2;
        ["y"] = -182;
        ["x"] = 395.8;
        ["g"] = 45;
      };
      [3] = {
        ["sublevel"] = 2;
        ["y"] = -186.5;
        ["x"] = 393;
        ["g"] = 45;
      };
      [4] = {
        ["sublevel"] = 2;
        ["y"] = -191.1;
        ["x"] = 393.1;
        ["g"] = 45;
      };
      [5] = {
        ["sublevel"] = 2;
        ["y"] = -189.8;
        ["x"] = 396.6;
        ["g"] = 45;
      };
      [6] = {
        ["sublevel"] = 2;
        ["y"] = -178.4;
        ["x"] = 406.3;
        ["g"] = 46;
      };
      [7] = {
        ["sublevel"] = 2;
        ["y"] = -182.9;
        ["x"] = 404.4;
        ["g"] = 46;
      };
      [8] = {
        ["sublevel"] = 2;
        ["y"] = -185.7;
        ["x"] = 408.6;
        ["g"] = 46;
      };
      [9] = {
        ["sublevel"] = 2;
        ["y"] = -190.4;
        ["x"] = 405.8;
        ["g"] = 46;
      };
      [10] = {
        ["sublevel"] = 2;
        ["y"] = -210.8;
        ["x"] = 396.6;
        ["g"] = 47;
      };
      [11] = {
        ["sublevel"] = 2;
        ["y"] = -213.6;
        ["x"] = 395.6;
        ["g"] = 47;
      };
      [12] = {
        ["sublevel"] = 2;
        ["y"] = -221.2;
        ["x"] = 396.7;
        ["g"] = 47;
      };
      [13] = {
        ["sublevel"] = 2;
        ["y"] = -212.2;
        ["x"] = 410.5;
        ["g"] = 48;
      };
      [14] = {
        ["sublevel"] = 2;
        ["y"] = -215.1;
        ["x"] = 407.2;
        ["g"] = 48;
      };
      [15] = {
        ["sublevel"] = 2;
        ["y"] = -215.7;
        ["x"] = 410.4;
        ["g"] = 48;
      };
      [16] = {
        ["sublevel"] = 2;
        ["y"] = -218.8;
        ["x"] = 406.1;
        ["g"] = 48;
      };
      [17] = {
        ["sublevel"] = 2;
        ["y"] = -223.7;
        ["x"] = 408.6;
        ["g"] = 48;
      };
    };
  };
  [25] = {
    ["name"] = "Naxxramas Acolyte";
    ["id"] = 15981;
    ["count"] = 0;
    ["health"] = 52130;
    ["scale"] = 1;
    ["displayId"] = 16598;
    ["creatureType"] = "Humanoid";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 2;
        ["y"] = -185.7;
        ["x"] = 396.4;
        ["g"] = 45;
      };
      [2] = {
        ["sublevel"] = 2;
        ["y"] = -194.7;
        ["x"] = 394.2;
        ["g"] = 45;
      };
      [3] = {
        ["sublevel"] = 2;
        ["y"] = -193.1;
        ["x"] = 397.3;
        ["g"] = 45;
      };
      [4] = {
        ["sublevel"] = 2;
        ["y"] = -179.5;
        ["x"] = 403.2;
        ["g"] = 46;
      };
      [5] = {
        ["sublevel"] = 2;
        ["y"] = -181.6;
        ["x"] = 407.4;
        ["g"] = 46;
      };
      [6] = {
        ["sublevel"] = 2;
        ["y"] = -186.2;
        ["x"] = 405.3;
        ["g"] = 46;
      };
      [7] = {
        ["sublevel"] = 2;
        ["y"] = -189.8;
        ["x"] = 409;
        ["g"] = 46;
      };
      [8] = {
        ["sublevel"] = 2;
        ["y"] = -216.5;
        ["x"] = 394.8;
        ["g"] = 47;
      };
      [9] = {
        ["sublevel"] = 2;
        ["y"] = -219.6;
        ["x"] = 393.9;
        ["g"] = 47;
      };
      [10] = {
        ["sublevel"] = 2;
        ["y"] = -211.4;
        ["x"] = 400;
        ["g"] = 47;
      };
      [11] = {
        ["sublevel"] = 2;
        ["y"] = -214.7;
        ["x"] = 398.9;
        ["g"] = 47;
      };
      [12] = {
        ["sublevel"] = 2;
        ["y"] = -218;
        ["x"] = 397.8;
        ["g"] = 47;
      };
      [13] = {
        ["sublevel"] = 2;
        ["y"] = -211.8;
        ["x"] = 407.7;
        ["g"] = 48;
      };
      [14] = {
        ["sublevel"] = 2;
        ["y"] = -219.4;
        ["x"] = 409.9;
        ["g"] = 48;
      };
      [15] = {
        ["sublevel"] = 2;
        ["y"] = -222.9;
        ["x"] = 404.4;
        ["g"] = 48;
      };
    };
  };
  [26] = {
    ["name"] = "Grand Widow Faerlina";
    ["id"] = 15953;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 15940;
    ["creatureType"] = "Humanoid";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 2;
        ["y"] = -199.1;
        ["x"] = 358.6;
      };
    };
  };
  [27] = {
    ["name"] = "Maexxna";
    ["id"] = 15952;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 15928;
    ["creatureType"] = "Beast";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 2;
        ["y"] = -84.6;
        ["x"] = 598.6;
      };
    };
  };
  [28] = {
    ["name"] = "Stoneskin Gargoyle";
    ["id"] = 16168;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 14710;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -176;
        ["x"] = 300;
        ["patrol"] = {
          [1] = {
            ["y"] = -190.5;
            ["x"] = 265.7;
          };
          [2] = {
            ["y"] = -179;
            ["x"] = 298.6;
          };
          [3] = {
            ["y"] = -173.4;
            ["x"] = 302.1;
          };
          [4] = {
            ["y"] = -162;
            ["x"] = 304.4;
          };
          [5] = {
            ["y"] = -154.7;
            ["x"] = 301.3;
          };
          [6] = {
            ["y"] = -143.5;
            ["x"] = 294.9;
          };
          [7] = {
            ["y"] = -137.5;
            ["x"] = 289.9;
          };
          [8] = {
            ["y"] = -137.5;
            ["x"] = 290.3;
          };
        };
      };
      [2] = {
        ["sublevel"] = 4;
        ["y"] = -203.1;
        ["x"] = 287.3;
        ["g"] = 49;
      };
      [3] = {
        ["sublevel"] = 4;
        ["y"] = -203.2;
        ["x"] = 275.5;
        ["g"] = 49;
      };
      [4] = {
        ["sublevel"] = 4;
        ["y"] = -239.9;
        ["x"] = 288.4;
        ["g"] = 50;
      };
      [5] = {
        ["sublevel"] = 4;
        ["y"] = -240.1;
        ["x"] = 276.3;
        ["g"] = 50;
      };
      [6] = {
        ["sublevel"] = 4;
        ["y"] = -264.3;
        ["x"] = 282.1;
        ["patrol"] = {
          [1] = {
            ["y"] = -264.8;
            ["x"] = 282.4;
          };
          [2] = {
            ["y"] = -184.1;
            ["x"] = 281.4;
          };
        };
      };
    };
  };
  [29] = {
    ["name"] = "Plague Slime";
    ["id"] = 16243;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 11140;
    ["creatureType"] = "Aberration";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -162.4;
        ["x"] = 268.2;
        ["g"] = 51;
      };
      [2] = {
        ["sublevel"] = 4;
        ["y"] = -162.8;
        ["x"] = 273.5;
        ["g"] = 51;
      };
      [3] = {
        ["sublevel"] = 4;
        ["y"] = -140.2;
        ["x"] = 306.9;
        ["g"] = 52;
      };
      [4] = {
        ["sublevel"] = 4;
        ["y"] = -143.5;
        ["x"] = 311.2;
        ["g"] = 52;
      };
      [5] = {
        ["sublevel"] = 4;
        ["y"] = -190.1;
        ["x"] = 330.9;
        ["g"] = 53;
      };
      [6] = {
        ["sublevel"] = 4;
        ["y"] = -189.9;
        ["x"] = 325.7;
        ["g"] = 53;
      };
    };
  };
  [30] = {
    ["name"] = "Infectious Ghoul";
    ["id"] = 16244;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 26329;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -167.8;
        ["x"] = 275.6;
        ["g"] = 51;
      };
      [2] = {
        ["sublevel"] = 4;
        ["y"] = -167.8;
        ["x"] = 270.4;
        ["g"] = 51;
      };
      [3] = {
        ["sublevel"] = 4;
        ["y"] = -167.6;
        ["x"] = 265.9;
        ["g"] = 51;
      };
      [4] = {
        ["sublevel"] = 4;
        ["y"] = -144.8;
        ["x"] = 306.4;
        ["g"] = 52;
      };
      [5] = {
        ["sublevel"] = 4;
        ["y"] = -142.5;
        ["x"] = 302.5;
        ["g"] = 52;
      };
      [6] = {
        ["sublevel"] = 4;
        ["y"] = -148.1;
        ["x"] = 310.4;
        ["g"] = 52;
      };
      [7] = {
        ["sublevel"] = 4;
        ["y"] = -194.7;
        ["x"] = 333.4;
        ["g"] = 53;
      };
      [8] = {
        ["sublevel"] = 4;
        ["y"] = -194.7;
        ["x"] = 328.8;
        ["g"] = 53;
      };
      [9] = {
        ["sublevel"] = 4;
        ["y"] = -194.4;
        ["x"] = 324;
        ["g"] = 53;
      };
    };
  };
  [31] = {
    ["name"] = "Death Knight";
    ["id"] = 16146;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16508;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -147.9;
        ["x"] = 551.6;
        ["g"] = 54;
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -132.7;
        ["x"] = 534.5;
        ["g"] = 54;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -171;
        ["x"] = 513.7;
        ["g"] = 55;
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -166.6;
        ["x"] = 509;
        ["g"] = 55;
      };
      [5] = {
        ["sublevel"] = 3;
        ["y"] = -173;
        ["x"] = 434.7;
        ["g"] = 56;
      };
      [6] = {
        ["sublevel"] = 3;
        ["y"] = -223.8;
        ["x"] = 444.6;
        ["g"] = 57;
      };
      [7] = {
        ["sublevel"] = 3;
        ["y"] = -223.8;
        ["x"] = 438.9;
        ["g"] = 57;
      };
      [8] = {
        ["sublevel"] = 3;
        ["y"] = -249.4;
        ["x"] = 403.3;
        ["g"] = 58;
      };
      [9] = {
        ["sublevel"] = 3;
        ["y"] = -204.9;
        ["x"] = 401.3;
        ["g"] = 59;
      };
      [10] = {
        ["sublevel"] = 3;
        ["y"] = -205.3;
        ["x"] = 407.8;
        ["g"] = 59;
      };
      [11] = {
        ["sublevel"] = 3;
        ["y"] = -220.8;
        ["x"] = 406.1;
        ["g"] = 60;
        ["patrol"] = {
          [1] = {
            ["y"] = -244.1;
            ["x"] = 409;
          };
          [2] = {
            ["y"] = -221.5;
            ["x"] = 409.3;
          };
          [3] = {
            ["y"] = -199.2;
            ["x"] = 432.8;
          };
          [4] = {
            ["y"] = -191.7;
            ["x"] = 438.1;
          };
          [5] = {
            ["y"] = -180.1;
            ["x"] = 441.6;
          };
        };
      };
      [12] = {
        ["sublevel"] = 3;
        ["y"] = -193.6;
        ["x"] = 374.7;
        ["g"] = 61;
      };
      [13] = {
        ["sublevel"] = 3;
        ["y"] = -198;
        ["x"] = 369.5;
        ["g"] = 61;
      };
      [14] = {
        ["sublevel"] = 3;
        ["y"] = -239.4;
        ["x"] = 564.7;
        ["g"] = 62;
      };
      [15] = {
        ["sublevel"] = 3;
        ["y"] = -401.4;
        ["x"] = 520.5;
        ["g"] = 63;
        ["patrol"] = {
          [1] = {
            ["y"] = -403.1;
            ["x"] = 523.2;
          };
          [2] = {
            ["y"] = -403.8;
            ["x"] = 384.9;
          };
          [3] = {
            ["y"] = -403.2;
            ["x"] = 523.2;
          };
        };
      };
      [16] = {
        ["sublevel"] = 3;
        ["y"] = -405.6;
        ["x"] = 520.5;
        ["g"] = 63;
      };
      [17] = {
        ["sublevel"] = 3;
        ["y"] = -370.3;
        ["x"] = 300.3;
        ["g"] = 64;
      };
      [18] = {
        ["sublevel"] = 3;
        ["y"] = -380.3;
        ["x"] = 312.3;
        ["g"] = 64;
      };
      [19] = {
        ["sublevel"] = 3;
        ["y"] = -395.1;
        ["x"] = 371.1;
        ["g"] = 65;
        ["patrol"] = {
          [1] = {
            ["y"] = -402.7;
            ["x"] = 375.9;
          };
          [2] = {
            ["y"] = -309.2;
            ["x"] = 281.1;
          };
          [3] = {
            ["y"] = -402.7;
            ["x"] = 375.9;
          };
        };
      };
      [20] = {
        ["sublevel"] = 3;
        ["y"] = -398.4;
        ["x"] = 367.8;
        ["g"] = 65;
      };
      [21] = {
        ["sublevel"] = 3;
        ["y"] = -234.1;
        ["x"] = 278.4;
        ["g"] = 66;
        ["patrol"] = {
          [1] = {
            ["y"] = -326.5;
            ["x"] = 325.4;
          };
          [2] = {
            ["y"] = -332.2;
            ["x"] = 331.3;
          };
          [3] = {
            ["y"] = -356.6;
            ["x"] = 306.5;
          };
          [4] = {
            ["y"] = -351.4;
            ["x"] = 301.5;
          };
          [5] = {
            ["y"] = -346.7;
            ["x"] = 306.5;
          };
          [6] = {
            ["y"] = -330.4;
            ["x"] = 290.8;
          };
          [7] = {
            ["y"] = -332.2;
            ["x"] = 285.5;
          };
          [8] = {
            ["y"] = -333.2;
            ["x"] = 279.9;
          };
          [9] = {
            ["y"] = -332.6;
            ["x"] = 273.3;
          };
          [10] = {
            ["y"] = -330.7;
            ["x"] = 266.1;
          };
          [11] = {
            ["y"] = -326.6;
            ["x"] = 259.1;
          };
          [12] = {
            ["y"] = -321.6;
            ["x"] = 255.1;
          };
          [13] = {
            ["y"] = -315.6;
            ["x"] = 251.9;
          };
          [14] = {
            ["y"] = -308.1;
            ["x"] = 249.4;
          };
          [15] = {
            ["y"] = -299.9;
            ["x"] = 250;
          };
          [16] = {
            ["y"] = -291.8;
            ["x"] = 252.6;
          };
          [17] = {
            ["y"] = -286.1;
            ["x"] = 256.6;
          };
          [18] = {
            ["y"] = -281.7;
            ["x"] = 261.7;
          };
          [19] = {
            ["y"] = -278.9;
            ["x"] = 266.7;
          };
          [20] = {
            ["y"] = -278.3;
            ["x"] = 269.8;
          };
          [21] = {
            ["y"] = -235.9;
            ["x"] = 270.1;
          };
          [22] = {
            ["y"] = -235.9;
            ["x"] = 286.8;
          };
          [23] = {
            ["y"] = -278;
            ["x"] = 286.1;
          };
          [24] = {
            ["y"] = -279.5;
            ["x"] = 288.6;
          };
          [25] = {
            ["y"] = -281.1;
            ["x"] = 292.7;
          };
          [26] = {
            ["y"] = -283.6;
            ["x"] = 296.2;
          };
          [27] = {
            ["y"] = -288.3;
            ["x"] = 300.2;
          };
          [28] = {
            ["y"] = -293.3;
            ["x"] = 303.4;
          };
          [29] = {
            ["y"] = -297.7;
            ["x"] = 305;
          };
          [30] = {
            ["y"] = -306.2;
            ["x"] = 305.9;
          };
          [31] = {
            ["y"] = -311.5;
            ["x"] = 305.3;
          };
          [32] = {
            ["y"] = -316.6;
            ["x"] = 303.7;
          };
          [33] = {
            ["y"] = -331.7;
            ["x"] = 319.7;
          };
          [34] = {
            ["y"] = -326.4;
            ["x"] = 325.3;
          };
        };
      };
      [22] = {
        ["sublevel"] = 3;
        ["y"] = -238;
        ["x"] = 278.5;
        ["g"] = 66;
      };
      [23] = {
        ["sublevel"] = 3;
        ["y"] = -159.6;
        ["x"] = 280.4;
        ["g"] = 67;
        ["patrol"] = {
          [1] = {
            ["y"] = -157.7;
            ["x"] = 278.2;
          };
          [2] = {
            ["y"] = -303.7;
            ["x"] = 277.9;
          };
          [3] = {
            ["y"] = -157.7;
            ["x"] = 278.3;
          };
        };
      };
      [24] = {
        ["sublevel"] = 3;
        ["y"] = -159.6;
        ["x"] = 275.5;
        ["g"] = 67;
      };
      [25] = {
        ["sublevel"] = 3;
        ["y"] = -415.3;
        ["x"] = 440;
        ["g"] = 68;
        ["patrol"] = {
          [1] = {
            ["y"] = -387.5;
            ["x"] = 429.2;
          };
          [2] = {
            ["y"] = -387.6;
            ["x"] = 438.1;
          };
          [3] = {
            ["y"] = -418.7;
            ["x"] = 438.1;
          };
          [4] = {
            ["y"] = -421.8;
            ["x"] = 438.1;
          };
          [5] = {
            ["y"] = -421.8;
            ["x"] = 429.4;
          };
          [6] = {
            ["y"] = -419.6;
            ["x"] = 429.4;
          };
          [7] = {
            ["y"] = -413;
            ["x"] = 429;
          };
          [8] = {
            ["y"] = -412.7;
            ["x"] = 405.5;
          };
          [9] = {
            ["y"] = -417.7;
            ["x"] = 403.6;
          };
          [10] = {
            ["y"] = -423.1;
            ["x"] = 399.5;
          };
          [11] = {
            ["y"] = -427.8;
            ["x"] = 394.5;
          };
          [12] = {
            ["y"] = -430.6;
            ["x"] = 389.2;
          };
          [13] = {
            ["y"] = -432.5;
            ["x"] = 381.3;
          };
          [14] = {
            ["y"] = -432.5;
            ["x"] = 374.8;
          };
          [15] = {
            ["y"] = -430.6;
            ["x"] = 368.2;
          };
          [16] = {
            ["y"] = -426.8;
            ["x"] = 361;
          };
          [17] = {
            ["y"] = -420.9;
            ["x"] = 355.3;
          };
          [18] = {
            ["y"] = -415.2;
            ["x"] = 351.9;
          };
          [19] = {
            ["y"] = -406.1;
            ["x"] = 350.3;
          };
          [20] = {
            ["y"] = -398.9;
            ["x"] = 350.6;
          };
          [21] = {
            ["y"] = -393.6;
            ["x"] = 352.5;
          };
          [22] = {
            ["y"] = -360.4;
            ["x"] = 318.2;
          };
          [23] = {
            ["y"] = -345;
            ["x"] = 333.9;
          };
          [24] = {
            ["y"] = -378.8;
            ["x"] = 366.9;
          };
          [25] = {
            ["y"] = -377;
            ["x"] = 372.9;
          };
          [26] = {
            ["y"] = -377;
            ["x"] = 380.1;
          };
          [27] = {
            ["y"] = -378.8;
            ["x"] = 388.6;
          };
          [28] = {
            ["y"] = -382.3;
            ["x"] = 395.2;
          };
          [29] = {
            ["y"] = -387;
            ["x"] = 399.9;
          };
          [30] = {
            ["y"] = -390.8;
            ["x"] = 403;
          };
          [31] = {
            ["y"] = -395.2;
            ["x"] = 404.3;
          };
          [32] = {
            ["y"] = -396.1;
            ["x"] = 404.6;
          };
          [33] = {
            ["y"] = -396.1;
            ["x"] = 428.4;
          };
          [34] = {
            ["y"] = -387.6;
            ["x"] = 428.7;
          };
        };
      };
      [26] = {
        ["sublevel"] = 3;
        ["y"] = -415.7;
        ["x"] = 436.6;
        ["g"] = 68;
      };
    };
  };
  [32] = {
    ["name"] = "Skeletal Smith";
    ["id"] = 16193;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 26563;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -142.6;
        ["x"] = 497.9;
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -154.5;
        ["x"] = 493.6;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -161.2;
        ["x"] = 485.5;
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -166.4;
        ["x"] = 468.9;
      };
    };
  };
  [33] = {
    ["name"] = "Necro Knight";
    ["id"] = 16165;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 27105;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -153.4;
        ["x"] = 524.1;
        ["g"] = 69;
        ["patrol"] = {
          [1] = {
            ["y"] = -142.3;
            ["x"] = 540.2;
          };
          [2] = {
            ["y"] = -159.6;
            ["x"] = 521.8;
          };
          [3] = {
            ["y"] = -142.3;
            ["x"] = 540.2;
          };
        };
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -158.3;
        ["x"] = 528.2;
        ["g"] = 69;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -245.2;
        ["x"] = 475.9;
        ["g"] = 70;
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -245.2;
        ["x"] = 481.5;
        ["g"] = 70;
      };
      [5] = {
        ["sublevel"] = 3;
        ["y"] = -242.1;
        ["x"] = 569.4;
        ["g"] = 62;
      };
      [6] = {
        ["sublevel"] = 3;
        ["y"] = -242.1;
        ["x"] = 559.3;
        ["g"] = 62;
      };
    };
  };
  [34] = {
    ["name"] = "Shade of Naxxramas";
    ["id"] = 16164;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 10553;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -148;
        ["x"] = 529.1;
        ["g"] = 69;
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -153.4;
        ["x"] = 533.2;
        ["g"] = 69;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -187.1;
        ["x"] = 529.9;
        ["patrol"] = {
          [1] = {
            ["y"] = -183.1;
            ["x"] = 533;
          };
          [2] = {
            ["y"] = -190;
            ["x"] = 526.2;
          };
          [3] = {
            ["y"] = -193.8;
            ["x"] = 511.2;
          };
          [4] = {
            ["y"] = -194.1;
            ["x"] = 505.1;
          };
          [5] = {
            ["y"] = -191.3;
            ["x"] = 496.7;
          };
          [6] = {
            ["y"] = -186.1;
            ["x"] = 492.6;
          };
          [7] = {
            ["y"] = -180.7;
            ["x"] = 491.5;
          };
          [8] = {
            ["y"] = -171.1;
            ["x"] = 493.4;
          };
          [9] = {
            ["y"] = -163.5;
            ["x"] = 495.6;
          };
          [10] = {
            ["y"] = -156.1;
            ["x"] = 498.3;
          };
          [11] = {
            ["y"] = -152;
            ["x"] = 498;
          };
        };
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -239;
        ["x"] = 475.7;
        ["g"] = 70;
      };
      [5] = {
        ["sublevel"] = 3;
        ["y"] = -239;
        ["x"] = 481.5;
        ["g"] = 70;
      };
    };
  };
  [35] = {
    ["name"] = "Bony Construct";
    ["id"] = 16167;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 21305;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -203.4;
        ["x"] = 529.5;
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -209.2;
        ["x"] = 524.9;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -213.8;
        ["x"] = 520;
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -218.3;
        ["x"] = 514.2;
      };
      [5] = {
        ["sublevel"] = 3;
        ["y"] = -219.2;
        ["x"] = 506.7;
      };
      [6] = {
        ["sublevel"] = 3;
        ["y"] = -220;
        ["x"] = 498.4;
      };
    };
  };
  [36] = {
    ["name"] = "Death Knight Captain";
    ["id"] = 16145;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 26546;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -192.5;
        ["x"] = 497.6;
        ["g"] = 71;
        ["patrol"] = {
          [1] = {
            ["y"] = -172.5;
            ["x"] = 526.2;
          };
          [2] = {
            ["y"] = -180.9;
            ["x"] = 523.4;
          };
          [3] = {
            ["y"] = -188;
            ["x"] = 518.5;
          };
          [4] = {
            ["y"] = -192.4;
            ["x"] = 509.5;
          };
          [5] = {
            ["y"] = -194.3;
            ["x"] = 499.7;
          };
          [6] = {
            ["y"] = -193.5;
            ["x"] = 486.3;
          };
          [7] = {
            ["y"] = -187.8;
            ["x"] = 475.9;
          };
          [8] = {
            ["y"] = -185;
            ["x"] = 473.5;
          };
        };
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -196.1;
        ["x"] = 497.2;
        ["g"] = 71;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -165;
        ["x"] = 515.6;
        ["g"] = 55;
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -173.3;
        ["x"] = 428.7;
        ["g"] = 56;
      };
      [5] = {
        ["sublevel"] = 3;
        ["y"] = -218.9;
        ["x"] = 441.6;
        ["g"] = 57;
      };
      [6] = {
        ["sublevel"] = 3;
        ["y"] = -249.6;
        ["x"] = 396.7;
        ["g"] = 58;
      };
      [7] = {
        ["sublevel"] = 3;
        ["y"] = -199.5;
        ["x"] = 404.5;
        ["g"] = 59;
      };
      [8] = {
        ["sublevel"] = 3;
        ["y"] = -220;
        ["x"] = 411.6;
        ["g"] = 60;
      };
      [9] = {
        ["sublevel"] = 3;
        ["y"] = -235.9;
        ["x"] = 569;
        ["g"] = 62;
      };
      [10] = {
        ["sublevel"] = 3;
        ["y"] = -403.2;
        ["x"] = 516.1;
        ["g"] = 63;
      };
      [11] = {
        ["sublevel"] = 3;
        ["y"] = -373.4;
        ["x"] = 304.3;
        ["g"] = 64;
      };
      [12] = {
        ["sublevel"] = 3;
        ["y"] = -377;
        ["x"] = 308.5;
        ["g"] = 64;
      };
      [13] = {
        ["sublevel"] = 3;
        ["y"] = -394.6;
        ["x"] = 367.4;
        ["g"] = 65;
      };
      [14] = {
        ["sublevel"] = 3;
        ["y"] = -236;
        ["x"] = 281.9;
        ["g"] = 66;
      };
      [15] = {
        ["sublevel"] = 3;
        ["y"] = -164;
        ["x"] = 278;
        ["g"] = 67;
      };
      [16] = {
        ["sublevel"] = 3;
        ["y"] = -418.6;
        ["x"] = 438.2;
        ["g"] = 68;
      };
    };
  };
  [37] = {
    ["name"] = "Dark Touched Warrior";
    ["id"] = 16156;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 26569;
    ["creatureType"] = "Humanoid";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -173;
        ["x"] = 507.2;
        ["g"] = 55;
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -168.7;
        ["x"] = 503;
        ["g"] = 55;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -176.5;
        ["x"] = 512.3;
        ["g"] = 55;
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -178.5;
        ["x"] = 428.7;
        ["g"] = 56;
      };
      [5] = {
        ["sublevel"] = 3;
        ["y"] = -178.5;
        ["x"] = 435;
        ["g"] = 56;
      };
      [6] = {
        ["sublevel"] = 3;
        ["y"] = -256.2;
        ["x"] = 397.5;
        ["g"] = 58;
      };
      [7] = {
        ["sublevel"] = 3;
        ["y"] = -256.2;
        ["x"] = 403.8;
        ["g"] = 58;
      };
      [8] = {
        ["sublevel"] = 3;
        ["y"] = -227.4;
        ["x"] = 406.4;
        ["g"] = 60;
      };
      [9] = {
        ["sublevel"] = 3;
        ["y"] = -225.5;
        ["x"] = 411.6;
        ["g"] = 60;
      };
      [10] = {
        ["sublevel"] = 3;
        ["y"] = -197.6;
        ["x"] = 379.8;
        ["g"] = 61;
      };
      [11] = {
        ["sublevel"] = 3;
        ["y"] = -204;
        ["x"] = 370.5;
        ["g"] = 61;
      };
      [12] = {
        ["sublevel"] = 3;
        ["y"] = -203.6;
        ["x"] = 378.8;
        ["g"] = 61;
      };
      [13] = {
        ["sublevel"] = 3;
        ["y"] = -248.5;
        ["x"] = 569.4;
        ["g"] = 62;
      };
      [14] = {
        ["sublevel"] = 3;
        ["y"] = -244.4;
        ["x"] = 564.7;
        ["g"] = 62;
      };
      [15] = {
        ["sublevel"] = 3;
        ["y"] = -401.4;
        ["x"] = 525.2;
        ["g"] = 63;
      };
      [16] = {
        ["sublevel"] = 3;
        ["y"] = -406.1;
        ["x"] = 525.2;
        ["g"] = 63;
      };
      [17] = {
        ["sublevel"] = 3;
        ["y"] = -400.1;
        ["x"] = 370.7;
        ["g"] = 65;
      };
      [18] = {
        ["sublevel"] = 3;
        ["y"] = -397.5;
        ["x"] = 373.8;
        ["g"] = 65;
      };
      [19] = {
        ["sublevel"] = 3;
        ["y"] = -234.4;
        ["x"] = 275.2;
        ["g"] = 66;
      };
      [20] = {
        ["sublevel"] = 3;
        ["y"] = -238.4;
        ["x"] = 275.4;
        ["g"] = 66;
      };
      [21] = {
        ["sublevel"] = 3;
        ["y"] = -154.7;
        ["x"] = 275.4;
        ["g"] = 67;
      };
      [22] = {
        ["sublevel"] = 3;
        ["y"] = -154.8;
        ["x"] = 280.7;
        ["g"] = 67;
      };
      [23] = {
        ["sublevel"] = 3;
        ["y"] = -411.9;
        ["x"] = 439.7;
        ["g"] = 68;
      };
      [24] = {
        ["sublevel"] = 3;
        ["y"] = -411.9;
        ["x"] = 436.5;
        ["g"] = 68;
      };
    };
  };
  [38] = {
    ["name"] = "Deathcharger Steed";
    ["id"] = 16067;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 26539;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -180.4;
        ["x"] = 393.4;
        ["g"] = 72;
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -184.1;
        ["x"] = 393.5;
        ["g"] = 72;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -132.3;
        ["x"] = 401.2;
        ["g"] = 73;
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -134.4;
        ["x"] = 398.4;
        ["g"] = 73;
      };
      [5] = {
        ["sublevel"] = 3;
        ["y"] = -139.3;
        ["x"] = 442.6;
        ["g"] = 74;
      };
      [6] = {
        ["sublevel"] = 3;
        ["y"] = -143;
        ["x"] = 444;
        ["g"] = 74;
      };
    };
  };
  [39] = {
    ["name"] = "Risen Squire";
    ["id"] = 16154;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16927;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -180.3;
        ["x"] = 396.8;
        ["g"] = 72;
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -184.1;
        ["x"] = 396.9;
        ["g"] = 72;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -135.7;
        ["x"] = 401.8;
        ["g"] = 73;
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -142.6;
        ["x"] = 440.1;
        ["g"] = 74;
      };
    };
  };
  [40] = {
    ["name"] = "Death Knight Cavalier";
    ["id"] = 16163;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 26571;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -157.2;
        ["x"] = 429.8;
        ["g"] = 75;
        ["patrol"] = {
          [1] = {
            ["y"] = -153.1;
            ["x"] = 433.9;
          };
          [2] = {
            ["y"] = -147.1;
            ["x"] = 433.6;
          };
          [3] = {
            ["y"] = -142.1;
            ["x"] = 431.7;
          };
          [4] = {
            ["y"] = -136.8;
            ["x"] = 425.4;
          };
          [5] = {
            ["y"] = -134.9;
            ["x"] = 419.8;
          };
          [6] = {
            ["y"] = -136.8;
            ["x"] = 410.1;
          };
          [7] = {
            ["y"] = -143.1;
            ["x"] = 404.7;
          };
          [8] = {
            ["y"] = -150;
            ["x"] = 402.5;
          };
          [9] = {
            ["y"] = -163.5;
            ["x"] = 401.6;
          };
          [10] = {
            ["y"] = -177.9;
            ["x"] = 401.9;
          };
          [11] = {
            ["y"] = -183.2;
            ["x"] = 404.4;
          };
          [12] = {
            ["y"] = -186.4;
            ["x"] = 415.7;
          };
          [13] = {
            ["y"] = -187.3;
            ["x"] = 424.8;
          };
          [14] = {
            ["y"] = -182.9;
            ["x"] = 432;
          };
          [15] = {
            ["y"] = -173.8;
            ["x"] = 433.9;
          };
          [16] = {
            ["y"] = -162.2;
            ["x"] = 434.2;
          };
          [17] = {
            ["y"] = -158.1;
            ["x"] = 434.2;
          };
        };
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -157;
        ["x"] = 433.6;
        ["g"] = 75;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -157;
        ["x"] = 437.1;
        ["g"] = 75;
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -199.4;
        ["x"] = 374.7;
        ["g"] = 61;
      };
      [5] = {
        ["sublevel"] = 3;
        ["y"] = -206.3;
        ["x"] = 350.2;
        ["g"] = 76;
        ["patrol"] = {
          [1] = {
            ["y"] = -210.4;
            ["x"] = 342.2;
          };
          [2] = {
            ["y"] = -209.8;
            ["x"] = 391.2;
          };
          [3] = {
            ["y"] = -210.6;
            ["x"] = 407.4;
          };
          [4] = {
            ["y"] = -207.5;
            ["x"] = 412.9;
          };
          [5] = {
            ["y"] = -201.5;
            ["x"] = 416;
          };
          [6] = {
            ["y"] = -196.3;
            ["x"] = 416;
          };
          [7] = {
            ["y"] = -193.8;
            ["x"] = 413.6;
          };
          [8] = {
            ["y"] = -193.8;
            ["x"] = 407.1;
          };
          [9] = {
            ["y"] = -195.3;
            ["x"] = 401.1;
          };
          [10] = {
            ["y"] = -198.6;
            ["x"] = 396.2;
          };
          [11] = {
            ["y"] = -203.8;
            ["x"] = 393.9;
          };
          [12] = {
            ["y"] = -209.7;
            ["x"] = 391.1;
          };
          [13] = {
            ["y"] = -210.5;
            ["x"] = 342.1;
          };
        };
      };
      [6] = {
        ["sublevel"] = 3;
        ["y"] = -211;
        ["x"] = 350;
        ["g"] = 76;
      };
      [7] = {
        ["sublevel"] = 3;
        ["y"] = -215.8;
        ["x"] = 350;
        ["g"] = 76;
      };
      [8] = {
        ["sublevel"] = 3;
        ["y"] = -239.6;
        ["x"] = 522.2;
        ["g"] = 77;
        ["patrol"] = {
          [1] = {
            ["y"] = -242.1;
            ["x"] = 553.2;
          };
          [2] = {
            ["y"] = -242.3;
            ["x"] = 486.3;
          };
          [3] = {
            ["y"] = -242.1;
            ["x"] = 553.1;
          };
        };
      };
      [9] = {
        ["sublevel"] = 3;
        ["y"] = -244.6;
        ["x"] = 522.4;
        ["g"] = 77;
      };
      [10] = {
        ["sublevel"] = 3;
        ["y"] = -402.2;
        ["x"] = 549.8;
        ["g"] = 78;
        ["patrol"] = {
          [1] = {
            ["y"] = -401.1;
            ["x"] = 505.3;
          };
          [2] = {
            ["y"] = -406.4;
            ["x"] = 505.4;
          };
          [3] = {
            ["y"] = -411.7;
            ["x"] = 506.3;
          };
          [4] = {
            ["y"] = -417.3;
            ["x"] = 507.8;
          };
          [5] = {
            ["y"] = -421.6;
            ["x"] = 512;
          };
          [6] = {
            ["y"] = -425.7;
            ["x"] = 518.2;
          };
          [7] = {
            ["y"] = -426.2;
            ["x"] = 523.1;
          };
          [8] = {
            ["y"] = -425.7;
            ["x"] = 529.7;
          };
          [9] = {
            ["y"] = -424.7;
            ["x"] = 534.7;
          };
          [10] = {
            ["y"] = -421.3;
            ["x"] = 540.7;
          };
          [11] = {
            ["y"] = -414.1;
            ["x"] = 545.4;
          };
          [12] = {
            ["y"] = -408.7;
            ["x"] = 546.7;
          };
          [13] = {
            ["y"] = -403.5;
            ["x"] = 546.7;
          };
          [14] = {
            ["y"] = -395.5;
            ["x"] = 546;
          };
          [15] = {
            ["y"] = -389.8;
            ["x"] = 541.3;
          };
          [16] = {
            ["y"] = -385.8;
            ["x"] = 535.2;
          };
          [17] = {
            ["y"] = -383.3;
            ["x"] = 526.9;
          };
          [18] = {
            ["y"] = -385.1;
            ["x"] = 517.2;
          };
          [19] = {
            ["y"] = -389.4;
            ["x"] = 510.3;
          };
          [20] = {
            ["y"] = -395.2;
            ["x"] = 506.7;
          };
          [21] = {
            ["y"] = -399.5;
            ["x"] = 505.6;
          };
          [22] = {
            ["y"] = -400.6;
            ["x"] = 399;
          };
          [23] = {
            ["y"] = -394.4;
            ["x"] = 396.8;
          };
          [24] = {
            ["y"] = -388.9;
            ["x"] = 392.3;
          };
          [25] = {
            ["y"] = -385;
            ["x"] = 385.2;
          };
          [26] = {
            ["y"] = -384.7;
            ["x"] = 373.7;
          };
          [27] = {
            ["y"] = -387.1;
            ["x"] = 367.5;
          };
          [28] = {
            ["y"] = -389.4;
            ["x"] = 364;
          };
          [29] = {
            ["y"] = -395.7;
            ["x"] = 359.4;
          };
          [30] = {
            ["y"] = -402;
            ["x"] = 357.5;
          };
          [31] = {
            ["y"] = -409.2;
            ["x"] = 357.9;
          };
          [32] = {
            ["y"] = -415.4;
            ["x"] = 360.8;
          };
          [33] = {
            ["y"] = -419.7;
            ["x"] = 363.6;
          };
          [34] = {
            ["y"] = -423.6;
            ["x"] = 369.4;
          };
          [35] = {
            ["y"] = -425.4;
            ["x"] = 378;
          };
          [36] = {
            ["y"] = -424.6;
            ["x"] = 385.4;
          };
          [37] = {
            ["y"] = -421;
            ["x"] = 392.5;
          };
          [38] = {
            ["y"] = -414.3;
            ["x"] = 396.4;
          };
          [39] = {
            ["y"] = -407.1;
            ["x"] = 398.7;
          };
          [40] = {
            ["y"] = -400.7;
            ["x"] = 398.9;
          };
          [41] = {
            ["y"] = -399.4;
            ["x"] = 505.6;
          };
        };
      };
      [11] = {
        ["sublevel"] = 3;
        ["y"] = -402.2;
        ["x"] = 545;
        ["g"] = 78;
      };
      [12] = {
        ["sublevel"] = 3;
        ["y"] = -277.4;
        ["x"] = 278;
        ["g"] = 79;
        ["patrol"] = {
          [1] = {
            ["y"] = -382.6;
            ["x"] = 365.7;
          };
          [2] = {
            ["y"] = -316.6;
            ["x"] = 299.6;
          };
          [3] = {
            ["y"] = -310.4;
            ["x"] = 301.9;
          };
          [4] = {
            ["y"] = -304.3;
            ["x"] = 302.9;
          };
          [5] = {
            ["y"] = -298;
            ["x"] = 302.2;
          };
          [6] = {
            ["y"] = -293.5;
            ["x"] = 300;
          };
          [7] = {
            ["y"] = -289.8;
            ["x"] = 297.4;
          };
          [8] = {
            ["y"] = -286.1;
            ["x"] = 293.9;
          };
          [9] = {
            ["y"] = -283.2;
            ["x"] = 289.9;
          };
          [10] = {
            ["y"] = -281.5;
            ["x"] = 285.6;
          };
          [11] = {
            ["y"] = -280.5;
            ["x"] = 279.8;
          };
          [12] = {
            ["y"] = -280.8;
            ["x"] = 275;
          };
          [13] = {
            ["y"] = -281.9;
            ["x"] = 268.5;
          };
          [14] = {
            ["y"] = -284.9;
            ["x"] = 262.7;
          };
          [15] = {
            ["y"] = -289.2;
            ["x"] = 259.5;
          };
          [16] = {
            ["y"] = -294.2;
            ["x"] = 256.1;
          };
          [17] = {
            ["y"] = -299.6;
            ["x"] = 254.3;
          };
          [18] = {
            ["y"] = -305.6;
            ["x"] = 253.5;
          };
          [19] = {
            ["y"] = -311.9;
            ["x"] = 254.3;
          };
          [20] = {
            ["y"] = -317.1;
            ["x"] = 255.9;
          };
          [21] = {
            ["y"] = -320.6;
            ["x"] = 258.9;
          };
          [22] = {
            ["y"] = -324.5;
            ["x"] = 263.3;
          };
          [23] = {
            ["y"] = -326.7;
            ["x"] = 267.7;
          };
          [24] = {
            ["y"] = -328.8;
            ["x"] = 273.9;
          };
          [25] = {
            ["y"] = -329.1;
            ["x"] = 280.5;
          };
          [26] = {
            ["y"] = -327.5;
            ["x"] = 288.4;
          };
          [27] = {
            ["y"] = -324.7;
            ["x"] = 292.5;
          };
          [28] = {
            ["y"] = -319.6;
            ["x"] = 298;
          };
          [29] = {
            ["y"] = -316.3;
            ["x"] = 299.6;
          };
          [30] = {
            ["y"] = -382.5;
            ["x"] = 365.7;
          };
          [31] = {
            ["y"] = -385.4;
            ["x"] = 362.2;
          };
          [32] = {
            ["y"] = -387.8;
            ["x"] = 359.2;
          };
          [33] = {
            ["y"] = -391.1;
            ["x"] = 356.7;
          };
          [34] = {
            ["y"] = -394.4;
            ["x"] = 354.2;
          };
          [35] = {
            ["y"] = -399;
            ["x"] = 353.4;
          };
          [36] = {
            ["y"] = -402.6;
            ["x"] = 353.2;
          };
          [37] = {
            ["y"] = -407.5;
            ["x"] = 353.2;
          };
          [38] = {
            ["y"] = -412.4;
            ["x"] = 354.5;
          };
          [39] = {
            ["y"] = -417.6;
            ["x"] = 357;
          };
          [40] = {
            ["y"] = -421.2;
            ["x"] = 359.4;
          };
          [41] = {
            ["y"] = -423.6;
            ["x"] = 361.9;
          };
          [42] = {
            ["y"] = -425.3;
            ["x"] = 364.6;
          };
          [43] = {
            ["y"] = -427.2;
            ["x"] = 368.4;
          };
          [44] = {
            ["y"] = -428.3;
            ["x"] = 373.1;
          };
          [45] = {
            ["y"] = -429.4;
            ["x"] = 376.9;
          };
          [46] = {
            ["y"] = -429.1;
            ["x"] = 383.7;
          };
          [47] = {
            ["y"] = -428;
            ["x"] = 388.7;
          };
          [48] = {
            ["y"] = -425.5;
            ["x"] = 392.2;
          };
          [49] = {
            ["y"] = -421.4;
            ["x"] = 396.3;
          };
          [50] = {
            ["y"] = -416.8;
            ["x"] = 399.6;
          };
          [51] = {
            ["y"] = -412.4;
            ["x"] = 401.2;
          };
          [52] = {
            ["y"] = -406.7;
            ["x"] = 402.9;
          };
          [53] = {
            ["y"] = -402.3;
            ["x"] = 402.9;
          };
          [54] = {
            ["y"] = -396.6;
            ["x"] = 402.3;
          };
          [55] = {
            ["y"] = -391.9;
            ["x"] = 400.9;
          };
          [56] = {
            ["y"] = -387;
            ["x"] = 397.4;
          };
          [57] = {
            ["y"] = -383.2;
            ["x"] = 392.8;
          };
          [58] = {
            ["y"] = -381.3;
            ["x"] = 386.7;
          };
          [59] = {
            ["y"] = -379.6;
            ["x"] = 379.4;
          };
          [60] = {
            ["y"] = -380.2;
            ["x"] = 372;
          };
          [61] = {
            ["y"] = -382.6;
            ["x"] = 365.7;
          };
        };
      };
      [13] = {
        ["sublevel"] = 3;
        ["y"] = -282.7;
        ["x"] = 278;
        ["g"] = 79;
      };
      [14] = {
        ["sublevel"] = 3;
        ["y"] = -133.5;
        ["x"] = 278.4;
        ["g"] = 80;
        ["patrol"] = {
          [1] = {
            ["y"] = -176;
            ["x"] = 282.9;
          };
          [2] = {
            ["y"] = -286.4;
            ["x"] = 282.2;
          };
          [3] = {
            ["y"] = -287.5;
            ["x"] = 287;
          };
          [4] = {
            ["y"] = -289.4;
            ["x"] = 290.5;
          };
          [5] = {
            ["y"] = -291.7;
            ["x"] = 292.7;
          };
          [6] = {
            ["y"] = -294;
            ["x"] = 295;
          };
          [7] = {
            ["y"] = -296.3;
            ["x"] = 296.1;
          };
          [8] = {
            ["y"] = -298.6;
            ["x"] = 297.2;
          };
          [9] = {
            ["y"] = -303.8;
            ["x"] = 298.3;
          };
          [10] = {
            ["y"] = -307.9;
            ["x"] = 297.9;
          };
          [11] = {
            ["y"] = -311.8;
            ["x"] = 297.5;
          };
          [12] = {
            ["y"] = -315.8;
            ["x"] = 295.7;
          };
          [13] = {
            ["y"] = -318.9;
            ["x"] = 293.3;
          };
          [14] = {
            ["y"] = -322.1;
            ["x"] = 289.9;
          };
          [15] = {
            ["y"] = -323.2;
            ["x"] = 286.6;
          };
          [16] = {
            ["y"] = -324.7;
            ["x"] = 279.5;
          };
          [17] = {
            ["y"] = -324.3;
            ["x"] = 274.6;
          };
          [18] = {
            ["y"] = -323;
            ["x"] = 270;
          };
          [19] = {
            ["y"] = -321.1;
            ["x"] = 266.4;
          };
          [20] = {
            ["y"] = -318.5;
            ["x"] = 263;
          };
          [21] = {
            ["y"] = -315.5;
            ["x"] = 261;
          };
          [22] = {
            ["y"] = -311.6;
            ["x"] = 259.6;
          };
          [23] = {
            ["y"] = -307.5;
            ["x"] = 258.6;
          };
          [24] = {
            ["y"] = -303.4;
            ["x"] = 258.4;
          };
          [25] = {
            ["y"] = -297.3;
            ["x"] = 259.6;
          };
          [26] = {
            ["y"] = -292.3;
            ["x"] = 262.7;
          };
          [27] = {
            ["y"] = -288.4;
            ["x"] = 267.9;
          };
          [28] = {
            ["y"] = -286.8;
            ["x"] = 273.3;
          };
          [29] = {
            ["y"] = -286.6;
            ["x"] = 277.2;
          };
          [30] = {
            ["y"] = -286.5;
            ["x"] = 282.2;
          };
          [31] = {
            ["y"] = -175.5;
            ["x"] = 282.8;
          };
          [32] = {
            ["y"] = -173.7;
            ["x"] = 288.6;
          };
          [33] = {
            ["y"] = -169.4;
            ["x"] = 293.7;
          };
          [34] = {
            ["y"] = -164.1;
            ["x"] = 297.2;
          };
          [35] = {
            ["y"] = -157.5;
            ["x"] = 298.4;
          };
          [36] = {
            ["y"] = -149.7;
            ["x"] = 298;
          };
          [37] = {
            ["y"] = -142;
            ["x"] = 294.4;
          };
          [38] = {
            ["y"] = -137;
            ["x"] = 287.5;
          };
          [39] = {
            ["y"] = -135.5;
            ["x"] = 279.3;
          };
          [40] = {
            ["y"] = -136.1;
            ["x"] = 270.7;
          };
          [41] = {
            ["y"] = -139.5;
            ["x"] = 262;
          };
          [42] = {
            ["y"] = -144.9;
            ["x"] = 258.5;
          };
          [43] = {
            ["y"] = -151.7;
            ["x"] = 256.2;
          };
          [44] = {
            ["y"] = -160.8;
            ["x"] = 256.8;
          };
          [45] = {
            ["y"] = -168.3;
            ["x"] = 260.2;
          };
          [46] = {
            ["y"] = -172.5;
            ["x"] = 264.1;
          };
          [47] = {
            ["y"] = -175.1;
            ["x"] = 269.6;
          };
          [48] = {
            ["y"] = -176.3;
            ["x"] = 275.9;
          };
          [49] = {
            ["y"] = -175.9;
            ["x"] = 283;
          };
        };
      };
      [15] = {
        ["sublevel"] = 3;
        ["y"] = -140.1;
        ["x"] = 278.4;
        ["g"] = 80;
      };
    };
  };
  [41] = {
    ["name"] = "Unholy Staff";
    ["id"] = 16215;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 24723;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -297;
        ["x"] = 457.5;
        ["g"] = 81;
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -306.9;
        ["x"] = 441.1;
        ["g"] = 82;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -326.1;
        ["x"] = 422.1;
        ["g"] = 83;
        ["patrol"] = {
          [1] = {
            ["y"] = -322;
            ["x"] = 450.9;
          };
          [2] = {
            ["y"] = -326.9;
            ["x"] = 440.4;
          };
          [3] = {
            ["y"] = -329.2;
            ["x"] = 428.6;
          };
          [4] = {
            ["y"] = -329.2;
            ["x"] = 414.9;
          };
          [5] = {
            ["y"] = -327.8;
            ["x"] = 404.8;
          };
          [6] = {
            ["y"] = -325.1;
            ["x"] = 396.3;
          };
          [7] = {
            ["y"] = -321.6;
            ["x"] = 389;
          };
        };
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -331.7;
        ["x"] = 422.1;
        ["g"] = 83;
      };
      [5] = {
        ["sublevel"] = 3;
        ["y"] = -277.6;
        ["x"] = 397.6;
        ["g"] = 84;
        ["patrol"] = {
          [1] = {
            ["y"] = -276.8;
            ["x"] = 409.6;
          };
          [2] = {
            ["y"] = -277.1;
            ["x"] = 402.8;
          };
          [3] = {
            ["y"] = -279.7;
            ["x"] = 396.4;
          };
          [4] = {
            ["y"] = -282.9;
            ["x"] = 390.2;
          };
        };
      };
      [6] = {
        ["sublevel"] = 3;
        ["y"] = -280.9;
        ["x"] = 397.9;
        ["g"] = 84;
      };
    };
  };
  [42] = {
    ["name"] = "Unholy Axe";
    ["id"] = 16194;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 24722;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -297.1;
        ["x"] = 452.5;
        ["g"] = 81;
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -297.5;
        ["x"] = 413.8;
        ["g"] = 85;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -306.9;
        ["x"] = 436.3;
        ["g"] = 82;
      };
      [4] = {
        ["sublevel"] = 3;
        ["y"] = -267;
        ["x"] = 425.4;
        ["g"] = 86;
        ["patrol"] = {
          [1] = {
            ["y"] = -272.5;
            ["x"] = 443;
          };
          [2] = {
            ["y"] = -270.4;
            ["x"] = 430.8;
          };
          [3] = {
            ["y"] = -270.4;
            ["x"] = 417.6;
          };
          [4] = {
            ["y"] = -271.3;
            ["x"] = 404.6;
          };
          [5] = {
            ["y"] = -273.1;
            ["x"] = 397.1;
          };
          [6] = {
            ["y"] = -279.6;
            ["x"] = 385.5;
          };
        };
      };
      [5] = {
        ["sublevel"] = 3;
        ["y"] = -271.9;
        ["x"] = 425.4;
        ["g"] = 86;
      };
      [6] = {
        ["sublevel"] = 3;
        ["y"] = -296.7;
        ["x"] = 385.6;
        ["g"] = 87;
        ["patrol"] = {
          [1] = {
            ["y"] = -293.1;
            ["x"] = 384.2;
          };
          [2] = {
            ["y"] = -289.7;
            ["x"] = 386.1;
          };
          [3] = {
            ["y"] = -287.6;
            ["x"] = 390.4;
          };
          [4] = {
            ["y"] = -288.3;
            ["x"] = 395.4;
          };
          [5] = {
            ["y"] = -291.3;
            ["x"] = 398.4;
          };
          [6] = {
            ["y"] = -295.6;
            ["x"] = 399.2;
          };
          [7] = {
            ["y"] = -299.8;
            ["x"] = 397.6;
          };
          [8] = {
            ["y"] = -301.8;
            ["x"] = 393.6;
          };
          [9] = {
            ["y"] = -301.5;
            ["x"] = 389.4;
          };
          [10] = {
            ["y"] = -300.6;
            ["x"] = 386.1;
          };
          [11] = {
            ["y"] = -298.1;
            ["x"] = 384.3;
          };
          [12] = {
            ["y"] = -294;
            ["x"] = 383.9;
          };
        };
      };
      [7] = {
        ["sublevel"] = 3;
        ["y"] = -296.5;
        ["x"] = 382.1;
        ["g"] = 87;
      };
    };
  };
  [43] = {
    ["name"] = "Unholy Swords";
    ["id"] = 16216;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 24724;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -287.8;
        ["x"] = 440.5;
        ["g"] = 88;
      };
      [2] = {
        ["sublevel"] = 3;
        ["y"] = -287.8;
        ["x"] = 434.7;
        ["g"] = 88;
      };
      [3] = {
        ["sublevel"] = 3;
        ["y"] = -297.3;
        ["x"] = 419.6;
        ["g"] = 85;
      };
    };
  };
  [44] = {
    ["name"] = "Plague Beast";
    ["id"] = 16034;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 23136;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -259.3;
        ["x"] = 343.3;
        ["patrol"] = {
          [1] = {
            ["y"] = -255.5;
            ["x"] = 336.8;
          };
          [2] = {
            ["y"] = -261.8;
            ["x"] = 346.8;
          };
          [3] = {
            ["y"] = -273.7;
            ["x"] = 367.9;
          };
        };
      };
      [2] = {
        ["sublevel"] = 4;
        ["y"] = -224.9;
        ["x"] = 330.4;
        ["patrol"] = {
          [1] = {
            ["y"] = -215;
            ["x"] = 347.8;
          };
          [2] = {
            ["y"] = -215;
            ["x"] = 342.4;
          };
          [3] = {
            ["y"] = -217.2;
            ["x"] = 335.5;
          };
          [4] = {
            ["y"] = -218.8;
            ["x"] = 331.5;
          };
          [5] = {
            ["y"] = -223.8;
            ["x"] = 330.2;
          };
          [6] = {
            ["y"] = -228.5;
            ["x"] = 329.6;
          };
          [7] = {
            ["y"] = -232.6;
            ["x"] = 332.1;
          };
          [8] = {
            ["y"] = -233.9;
            ["x"] = 335.5;
          };
          [9] = {
            ["y"] = -235.1;
            ["x"] = 340.9;
          };
          [10] = {
            ["y"] = -235.4;
            ["x"] = 344;
          };
        };
      };
      [3] = {
        ["sublevel"] = 4;
        ["y"] = -170.1;
        ["x"] = 356.1;
        ["patrol"] = {
          [1] = {
            ["y"] = -173.3;
            ["x"] = 375.9;
          };
          [2] = {
            ["y"] = -169.9;
            ["x"] = 372.4;
          };
          [3] = {
            ["y"] = -168.6;
            ["x"] = 367.7;
          };
          [4] = {
            ["y"] = -167.7;
            ["x"] = 361.1;
          };
          [5] = {
            ["y"] = -168.6;
            ["x"] = 354.8;
          };
          [6] = {
            ["y"] = -174;
            ["x"] = 352.6;
          };
          [7] = {
            ["y"] = -178.7;
            ["x"] = 352.3;
          };
          [8] = {
            ["y"] = -182.4;
            ["x"] = 354.1;
          };
          [9] = {
            ["y"] = -187.4;
            ["x"] = 357.8;
          };
        };
      };
      [4] = {
        ["sublevel"] = 4;
        ["y"] = -172.6;
        ["x"] = 437;
        ["patrol"] = {
          [1] = {
            ["y"] = -192.3;
            ["x"] = 431.7;
          };
          [2] = {
            ["y"] = -186.4;
            ["x"] = 435.5;
          };
          [3] = {
            ["y"] = -179.1;
            ["x"] = 438;
          };
          [4] = {
            ["y"] = -172.4;
            ["x"] = 438;
          };
          [5] = {
            ["y"] = -168;
            ["x"] = 432.6;
          };
          [6] = {
            ["y"] = -168;
            ["x"] = 426.7;
          };
          [7] = {
            ["y"] = -168.6;
            ["x"] = 419.8;
          };
          [8] = {
            ["y"] = -171.8;
            ["x"] = 414.1;
          };
        };
      };
    };
  };
  [45] = {
    ["name"] = "Noth the Plaguebringer";
    ["id"] = 15954;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16590;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -328.6;
        ["x"] = 289.1;
      };
    };
  };
  [46] = {
    ["name"] = "Frenzied Bat";
    ["id"] = 16036;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 7896;
    ["creatureType"] = "Beast";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -291.8;
        ["x"] = 368.5;
        ["g"] = 89;
      };
      [2] = {
        ["sublevel"] = 4;
        ["y"] = -278.5;
        ["x"] = 368.1;
        ["g"] = 89;
      };
      [3] = {
        ["sublevel"] = 4;
        ["y"] = -266.6;
        ["x"] = 368.5;
        ["g"] = 89;
      };
      [4] = {
        ["sublevel"] = 4;
        ["y"] = -253.3;
        ["x"] = 368.9;
        ["g"] = 89;
      };
      [5] = {
        ["sublevel"] = 4;
        ["y"] = -240.7;
        ["x"] = 368.5;
        ["g"] = 89;
      };
      [6] = {
        ["sublevel"] = 4;
        ["y"] = -225.2;
        ["x"] = 368.1;
        ["g"] = 90;
      };
      [7] = {
        ["sublevel"] = 4;
        ["y"] = -212.6;
        ["x"] = 369.6;
        ["g"] = 90;
      };
      [8] = {
        ["sublevel"] = 4;
        ["y"] = -199.6;
        ["x"] = 377.1;
        ["g"] = 90;
      };
      [9] = {
        ["sublevel"] = 4;
        ["y"] = -199.6;
        ["x"] = 393;
        ["g"] = 91;
      };
      [10] = {
        ["sublevel"] = 4;
        ["y"] = -199.3;
        ["x"] = 406.3;
        ["g"] = 91;
      };
    };
  };
  [47] = {
    ["name"] = "Plagued Bat";
    ["id"] = 16037;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 1954;
    ["creatureType"] = "Beast";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -284.6;
        ["x"] = 360.2;
        ["g"] = 89;
      };
      [2] = {
        ["sublevel"] = 4;
        ["y"] = -271.7;
        ["x"] = 359.9;
        ["g"] = 89;
      };
      [3] = {
        ["sublevel"] = 4;
        ["y"] = -259.1;
        ["x"] = 360.9;
        ["g"] = 89;
      };
      [4] = {
        ["sublevel"] = 4;
        ["y"] = -247.2;
        ["x"] = 360.2;
        ["g"] = 89;
      };
      [5] = {
        ["sublevel"] = 4;
        ["y"] = -231.7;
        ["x"] = 360.2;
        ["g"] = 90;
      };
      [6] = {
        ["sublevel"] = 4;
        ["y"] = -218.7;
        ["x"] = 360.6;
        ["g"] = 90;
      };
      [7] = {
        ["sublevel"] = 4;
        ["y"] = -205.4;
        ["x"] = 360.6;
        ["g"] = 90;
      };
      [8] = {
        ["sublevel"] = 4;
        ["y"] = -194.2;
        ["x"] = 370.7;
        ["g"] = 90;
      };
      [9] = {
        ["sublevel"] = 4;
        ["y"] = -192.4;
        ["x"] = 385.1;
        ["g"] = 91;
      };
      [10] = {
        ["sublevel"] = 4;
        ["y"] = -191.4;
        ["x"] = 399.5;
        ["g"] = 91;
      };
    };
  };
  [48] = {
    ["name"] = "Heigan the Unclean";
    ["id"] = 15936;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16309;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -239.2;
        ["x"] = 432.8;
      };
    };
  };
  [49] = {
    ["name"] = "Eye Stalk";
    ["id"] = 16236;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 15788;
    ["creatureType"] = "Aberration";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -243.2;
        ["x"] = 467;
        ["g"] = 92;
      };
      [2] = {
        ["sublevel"] = 4;
        ["y"] = -232.6;
        ["x"] = 468.4;
        ["g"] = 92;
      };
      [3] = {
        ["sublevel"] = 4;
        ["y"] = -215.5;
        ["x"] = 468.4;
        ["g"] = 92;
      };
      [4] = {
        ["sublevel"] = 4;
        ["y"] = -241.1;
        ["x"] = 474.3;
        ["g"] = 92;
      };
      [5] = {
        ["sublevel"] = 4;
        ["y"] = -208.9;
        ["x"] = 465.8;
        ["g"] = 92;
      };
      [6] = {
        ["sublevel"] = 4;
        ["y"] = -200.8;
        ["x"] = 475.8;
        ["g"] = 92;
      };
      [7] = {
        ["sublevel"] = 4;
        ["y"] = -185.9;
        ["x"] = 469.6;
        ["g"] = 92;
      };
      [8] = {
        ["sublevel"] = 4;
        ["y"] = -175.1;
        ["x"] = 473.3;
        ["g"] = 92;
      };
      [9] = {
        ["sublevel"] = 4;
        ["y"] = -163.9;
        ["x"] = 469.8;
        ["g"] = 92;
      };
      [10] = {
        ["sublevel"] = 4;
        ["y"] = -165.2;
        ["x"] = 484;
        ["g"] = 92;
      };
      [11] = {
        ["sublevel"] = 4;
        ["y"] = -176.1;
        ["x"] = 486.1;
        ["g"] = 92;
      };
      [12] = {
        ["sublevel"] = 4;
        ["y"] = -186.5;
        ["x"] = 484.5;
        ["g"] = 92;
      };
    };
  };
  [50] = {
    ["name"] = "Rotting Maggot";
    ["id"] = 16057;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 15554;
    ["creatureType"] = "Beast";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -225.6;
        ["x"] = 470.2;
        ["g"] = 92;
      };
      [2] = {
        ["sublevel"] = 4;
        ["y"] = -207;
        ["x"] = 473.1;
        ["g"] = 92;
      };
      [3] = {
        ["sublevel"] = 4;
        ["y"] = -191.9;
        ["x"] = 470.8;
        ["g"] = 92;
      };
      [4] = {
        ["sublevel"] = 4;
        ["y"] = -168.5;
        ["x"] = 471.2;
        ["g"] = 92;
      };
    };
  };
  [51] = {
    ["name"] = "Diseased Maggot";
    ["id"] = 16056;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 15978;
    ["creatureType"] = "Beast";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -220;
        ["x"] = 472.2;
        ["g"] = 92;
      };
      [2] = {
        ["sublevel"] = 4;
        ["y"] = -199.3;
        ["x"] = 468.3;
        ["g"] = 92;
      };
      [3] = {
        ["sublevel"] = 4;
        ["y"] = -180.3;
        ["x"] = 473.5;
        ["g"] = 92;
      };
      [4] = {
        ["sublevel"] = 4;
        ["y"] = -162.3;
        ["x"] = 476.8;
        ["g"] = 92;
      };
    };
  };
  [52] = {
    ["name"] = "Loatheb";
    ["id"] = 16011;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16110;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 4;
        ["y"] = -157.8;
        ["x"] = 646.5;
      };
    };
  };
  [53] = {
    ["name"] = "Gothik the Harvester";
    ["id"] = 16060;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16279;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -344.1;
        ["x"] = 565.5;
      };
    };
  };
  [54] = {
    ["name"] = "Instructor Razuvious";
    ["id"] = 16061;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16582;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -268.8;
        ["x"] = 358.6;
      };
    };
  };
  [55] = {
    ["name"] = "Thane Korth'azz";
    ["id"] = 16064;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16155;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -429.8;
        ["x"] = 259.8;
      };
    };
  };
  [56] = {
    ["name"] = "Baron Rivendare";
    ["id"] = 30549;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 10729;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -424.8;
        ["x"] = 254.9;
      };
    };
  };
  [57] = {
    ["name"] = "Lady Blaumeux";
    ["id"] = 16065;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16153;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -433.9;
        ["x"] = 263.7;
      };
    };
  };
  [58] = {
    ["name"] = "Sir Zeliek";
    ["id"] = 16063;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16154;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 3;
        ["y"] = -420.8;
        ["x"] = 250.4;
      };
    };
  };
  [59] = {
    ["name"] = "Sapphiron";
    ["id"] = 15989;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 16033;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 6;
        ["y"] = -377.3;
        ["x"] = 475;
      };
    };
  };
  [60] = {
    ["name"] = "Kel'Thuzad";
    ["id"] = 15990;
    ["count"] = 0;
    ["health"] = 12345;
    ["scale"] = 1;
    ["displayId"] = 15945;
    ["creatureType"] = "Undead";
    ["level"] = 60;
    ["clones"] = {
      [1] = {
        ["sublevel"] = 6;
        ["y"] = -128.3;
        ["x"] = 307.1;
      };
    };
  };
};
